/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.util;

import com.sun.enterprise.util.i18n.StringManager;
import com.sun.gjc.monitoring.StatementLeakProbeProvider;
import com.sun.gjc.util.StatementLeakListener;
import com.sun.logging.LogDomains;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.resource.common.PoolInfo;

public class StatementLeakDetector {
    private HashMap<Statement, StackTraceElement[]> statementLeakThreadStackHashMap;
    private HashMap<Statement, StatementLeakTask> statementLeakTimerTaskHashMap;
    private PoolInfo poolInfo;
    private boolean statementLeakTracing;
    private long statementLeakTimeoutInMillis;
    private boolean statementLeakReclaim;
    private final Object statementLeakLock;
    private Map<Statement, StatementLeakListener> listeners;
    private static final Logger _logger = LogDomains.getLogger(StatementLeakDetector.class, (String)"javax.enterprise.resource.resourceadapter");
    private static final StringManager localStrings = StringManager.getManager(StatementLeakDetector.class);
    private Timer timer;
    private StatementLeakProbeProvider stmtLeakProbeProvider = null;

    public StatementLeakDetector(PoolInfo poolInfo, boolean leakTracing, long leakTimeoutInMillis, boolean leakReclaim, Timer timer) {
        this.poolInfo = poolInfo;
        this.statementLeakThreadStackHashMap = new HashMap();
        this.statementLeakTimerTaskHashMap = new HashMap();
        this.listeners = new HashMap<Statement, StatementLeakListener>();
        this.statementLeakLock = new Object();
        this.statementLeakTracing = leakTracing;
        this.statementLeakTimeoutInMillis = leakTimeoutInMillis;
        this.statementLeakReclaim = leakReclaim;
        this.timer = timer;
        if (this.stmtLeakProbeProvider == null) {
            this.stmtLeakProbeProvider = new StatementLeakProbeProvider();
        }
    }

    public void reset(boolean leakTracing, long leakTimeoutInMillis, boolean leakReclaim) {
        if (!this.statementLeakTracing && leakTracing) {
            this.clearAllStatementLeakTasks();
        }
        this.statementLeakTracing = leakTracing;
        this.statementLeakTimeoutInMillis = leakTimeoutInMillis;
        this.statementLeakReclaim = leakReclaim;
    }

    private void registerListener(Statement stmt, StatementLeakListener listener) {
        this.listeners.put(stmt, listener);
    }

    private void unRegisterListener(Statement stmt) {
        this.listeners.remove(stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startStatementLeakTracing(Statement stmt, StatementLeakListener listener) {
        Object object = this.statementLeakLock;
        synchronized (object) {
            if (!this.statementLeakThreadStackHashMap.containsKey(stmt)) {
                this.statementLeakThreadStackHashMap.put(stmt, Thread.currentThread().getStackTrace());
                StatementLeakTask statementLeakTask = new StatementLeakTask(stmt);
                this.statementLeakTimerTaskHashMap.put(stmt, statementLeakTask);
                this.registerListener(stmt, listener);
                if (this.timer != null) {
                    this.timer.schedule((TimerTask)statementLeakTask, this.statementLeakTimeoutInMillis);
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.finest("Scheduled Statement leak tracing timer task");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopStatementLeakTracing(Statement stmt, StatementLeakListener listener) {
        Object object = this.statementLeakLock;
        synchronized (object) {
            if (this.statementLeakThreadStackHashMap.containsKey(stmt)) {
                this.statementLeakThreadStackHashMap.remove(stmt);
                StatementLeakTask statementLeakTask = this.statementLeakTimerTaskHashMap.remove(stmt);
                statementLeakTask.cancel();
                this.timer.purge();
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("Stopped Statement leak tracing timer task");
                }
                this.unRegisterListener(stmt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void potentialStatementLeakFound(Statement stmt) {
        Object object = this.statementLeakLock;
        synchronized (object) {
            if (this.statementLeakThreadStackHashMap.containsKey(stmt)) {
                StackTraceElement[] threadStack = this.statementLeakThreadStackHashMap.remove(stmt);
                StatementLeakListener stmtLeakListener = this.listeners.get(stmt);
                this.stmtLeakProbeProvider.potentialStatementLeakEvent(this.poolInfo.getName(), this.poolInfo.getApplicationName(), this.poolInfo.getModuleName());
                this.printStatementLeakTrace(threadStack);
                this.statementLeakTimerTaskHashMap.remove(stmt);
                if (this.statementLeakReclaim) {
                    try {
                        stmtLeakListener.reclaimStatement();
                    }
                    catch (SQLException ex) {
                        Object[] params = new Object[]{this.poolInfo, ex};
                        _logger.log(Level.WARNING, "statement.leak.detector_reclaim_statement_failure", params);
                    }
                }
                this.unRegisterListener(stmt);
            }
        }
    }

    private void printStatementLeakTrace(StackTraceElement[] threadStackTrace) {
        StringBuffer stackTrace = new StringBuffer();
        String msg = localStrings.getStringWithDefault("potential.statement.leak.msg", "A potential statement leak detected for connection pool " + this.poolInfo + ". The stack trace of the thread is provided below : ", new Object[]{this.poolInfo});
        stackTrace.append(msg);
        stackTrace.append("\n");
        for (int i = 2; i < threadStackTrace.length; ++i) {
            stackTrace.append(threadStackTrace[i].toString());
            stackTrace.append("\n");
        }
        _logger.log(Level.WARNING, stackTrace.toString(), "ConnectionPoolName=" + this.poolInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllStatementLeakTasks() {
        Object object = this.statementLeakLock;
        synchronized (object) {
            for (Statement stmt : this.statementLeakTimerTaskHashMap.keySet()) {
                StatementLeakTask statementLeakTask = this.statementLeakTimerTaskHashMap.get(stmt);
                statementLeakTask.cancel();
            }
            if (this.timer != null) {
                this.timer.purge();
            }
            this.statementLeakThreadStackHashMap.clear();
            this.statementLeakTimerTaskHashMap.clear();
        }
    }

    private class StatementLeakTask
    extends TimerTask {
        private Statement statement;

        StatementLeakTask(Statement stmt) {
            this.statement = stmt;
        }

        @Override
        public void run() {
            StatementLeakDetector.this.potentialStatementLeakFound(this.statement);
        }
    }
}

