/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.common;

import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.logging.LogService;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class UpgradeUtils {
    private final StringManager stringManager = StringManager.getManager(UpgradeUtils.class);
    private static final Logger logger = LogService.getLogger();
    private static UpgradeUtils upgradeUtils;
    private static CommonInfoModel common;

    private UpgradeUtils(CommonInfoModel common) {
        UpgradeUtils.common = common;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UpgradeUtils getUpgradeUtils(CommonInfoModel cim) {
        Class<UpgradeUtils> clazz = UpgradeUtils.class;
        synchronized (UpgradeUtils.class) {
            if (upgradeUtils == null) {
                upgradeUtils = new UpgradeUtils(cim);
            } else {
                common = cim;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return upgradeUtils;
        }
    }

    public void cloneDomain(String original, String destination) {
        File domainDir = new File(original);
        try {
            File cloneDirLoc = new File(destination);
            cloneDirLoc.mkdirs();
            UpgradeUtils.copyDirectory(domainDir, cloneDirLoc);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, this.stringManager.getString("upgrade.common.copy_directory_failed", domainDir.getAbsolutePath(), destination), e);
            System.exit(1);
        }
    }

    public static void copyFile(String source, String target) throws IOException {
        FileUtils.copy(source, target);
    }

    public static void copyDirectory(File sourceDir, File targetDir) throws IOException {
        File[] srcFiles = sourceDir.listFiles();
        if (srcFiles != null) {
            for (int i = 0; i < srcFiles.length; ++i) {
                File dest = new File(targetDir, srcFiles[i].getName());
                if (srcFiles[i].isDirectory() && FileUtils.safeIsRealDirectory(srcFiles[i])) {
                    if (!dest.exists()) {
                        dest.mkdirs();
                    }
                    UpgradeUtils.copyDirectory(srcFiles[i], dest);
                    continue;
                }
                if (!dest.exists()) {
                    dest.createNewFile();
                }
                UpgradeUtils.copyFile(srcFiles[i].getAbsolutePath(), new File(targetDir, srcFiles[i].getName()).getAbsolutePath());
            }
        }
    }

    public Document getDomainDocumentElement(String domainFileName) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document resultDoc = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            resultDoc = builder.parse(new File(domainFileName));
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, this.stringManager.getString("upgrade.common.could_not_create_doc", new Object[]{domainFileName, ex.toString()}));
        }
        return resultDoc;
    }

    public void rename(File dir) {
        assert (dir.exists());
        File tempFile = new File(dir.getAbsolutePath() + ".original");
        if (tempFile.exists()) {
            String baseName = tempFile.getAbsolutePath();
            int count = 0;
            while (tempFile.exists()) {
                tempFile = new File(baseName + "." + count++);
            }
        }
        if (common.getSource().getDomainRoot().equals(common.getTarget().getInstallDir())) {
            logger.info(this.stringManager.getString("enterprise.tools.upgrade.util.copyDir", dir, tempFile));
            this.cloneDomain(dir.getAbsolutePath(), tempFile.getAbsolutePath());
            common.setAlreadyCloned(true);
        } else {
            logger.info(this.stringManager.getString("enterprise.tools.upgrade.util.moveDir", dir, tempFile));
            dir.renameTo(tempFile);
        }
    }

    public void parseStoreMasterPassword(File file) {
        try {
            Properties props = new Properties();
            props.load(new FileInputStream(file));
            if (props.getProperty("AS_ADMIN_MASTERPASSWORD") != null) {
                common.getSource().setMasterPassword(props.getProperty("AS_ADMIN_MASTERPASSWORD").toCharArray());
            }
        }
        catch (FileNotFoundException fnfe) {
        }
        catch (IOException ioe) {
            logger.warning(this.stringManager.getString("could.not.parse.password", ioe.getLocalizedMessage()));
        }
    }
}

