/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming.impl;

import com.sun.corba.ee.spi.folb.ClusterInstanceInfo;
import com.sun.corba.ee.spi.folb.SocketInfo;
import com.sun.jndi.cosnaming.IiopUrl;
import com.sun.logging.LogDomains;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoundRobinPolicy {
    private static final String SSL = "SSL";
    private static final String CLEAR_TEXT = "CLEAR_TEXT";
    private static final Logger _logger = LogDomains.getLogger(RoundRobinPolicy.class, (String)"javax.enterprise.system.core.naming");
    private static Random rand = new Random();
    private List<ClusterInstanceInfo> endpointsList = new LinkedList<ClusterInstanceInfo>();
    private int totalWeight = 0;
    private List<String> resolvedEndpoints;
    private static final int default_weight = 10;

    private static void warnLog(String fmt, Object ... args) {
        RoundRobinPolicy.doLog(Level.WARNING, fmt, args);
    }

    private static void infoLog(String fmt, Object ... args) {
        RoundRobinPolicy.doLog(Level.INFO, fmt, args);
    }

    private static void fineLog(String fmt, Object ... args) {
        RoundRobinPolicy.doLog(Level.FINE, fmt, args);
    }

    private static void doLog(Level level, String fmt, Object ... args) {
        if (_logger.isLoggable(level)) {
            _logger.log(level, fmt, args);
        }
    }

    public RoundRobinPolicy(List<String> list) {
        this.setClusterInstanceInfoFromString(list);
    }

    private List<SocketInfo> filterSocketInfos(List<SocketInfo> sis) {
        ArrayList<SocketInfo> result = new ArrayList<SocketInfo>();
        for (SocketInfo si : sis) {
            String newType = si.type().startsWith(SSL) ? si.type() : CLEAR_TEXT;
            SocketInfo siCopy = new SocketInfo(newType, si.host(), si.port());
            result.add(siCopy);
        }
        return result;
    }

    final synchronized void setClusterInstanceInfo(List<ClusterInstanceInfo> list) {
        RoundRobinPolicy.fineLog("setClusterInstanceInfo: list={0}", list);
        this.totalWeight = 0;
        String policy = System.getProperty("com.sun.appserv.iiop.loadbalancingpolicy", "ic-based");
        boolean isWeighted = false;
        if (policy.equals("ic-based-weighted")) {
            isWeighted = true;
        } else if (!policy.equals("ic-based")) {
            RoundRobinPolicy.warnLog("loadbalancing.policy.incorrect", new Object[0]);
        }
        ArrayList<ClusterInstanceInfo> newList = new ArrayList<ClusterInstanceInfo>();
        for (ClusterInstanceInfo clinfo : list) {
            int newWeight = isWeighted ? clinfo.weight() : 10;
            List<SocketInfo> newEndpoints = this.filterSocketInfos(clinfo.endpoints());
            ClusterInstanceInfo newClinfo = new ClusterInstanceInfo(clinfo.name(), newWeight, newEndpoints);
            newList.add(newClinfo);
            this.totalWeight += newWeight;
        }
        this.endpointsList = newList;
    }

    final synchronized void setClusterInstanceInfoFromString(List<String> list) {
        RoundRobinPolicy.fineLog("setClusterInstanceInfoFromString: list={0}", list);
        List<String> newList = null;
        newList = !list.isEmpty() ? this.getAddressPortList(list) : this.getEndpointForProviderURL(System.getProperty("java.naming.provider.url"));
        if (!newList.isEmpty()) {
            List<String> newList2 = this.randomize(newList);
            this.resolvedEndpoints = new ArrayList<String>(newList2);
            LinkedList<ClusterInstanceInfo> targetServerList = new LinkedList<ClusterInstanceInfo>();
            for (String elem : newList2) {
                if (!this.notDuplicate(elem)) continue;
                targetServerList.add(this.makeClusterInstanceInfo(elem, 10));
            }
            if (!targetServerList.isEmpty()) {
                targetServerList.addAll(this.endpointsList);
                this.setClusterInstanceInfo(targetServerList);
            }
        } else {
            RoundRobinPolicy.fineLog("no.endpoints", new Object[0]);
        }
    }

    private ClusterInstanceInfo makeClusterInstanceInfo(String str, int weight) {
        String[] host_port = str.split(":");
        String server_identifier = "";
        String type = CLEAR_TEXT;
        SocketInfo socketInfo = new SocketInfo(type, host_port[0], Integer.parseInt(host_port[1]));
        ArrayList<SocketInfo> sil = new ArrayList<SocketInfo>(1);
        sil.add(socketInfo);
        ClusterInstanceInfo instanceInfo = new ClusterInstanceInfo(server_identifier, weight, sil);
        return instanceInfo;
    }

    private synchronized boolean notDuplicate(String str) {
        String[] host_port = str.split(":");
        for (ClusterInstanceInfo cinfo : this.endpointsList) {
            for (SocketInfo sinfo : cinfo.endpoints()) {
                if (!sinfo.host().equals(host_port[0]) && sinfo.port() != Integer.parseInt(host_port[1])) continue;
                return false;
            }
        }
        return true;
    }

    public List<String> getEndpointForProviderURL(String providerURLString) {
        if (providerURLString != null) {
            try {
                IiopUrl providerURL = new IiopUrl(providerURLString);
                List<String> newList = this.getAddressPortList(providerURL);
                RoundRobinPolicy.warnLog("no.endpoints.selected.provider", providerURLString);
                return newList;
            }
            catch (MalformedURLException me) {
                RoundRobinPolicy.warnLog("provider.exception", me.getMessage(), providerURLString);
            }
        }
        return new ArrayList<String>();
    }

    private List<String> randomize(List<String> list) {
        ArrayList<String> result = new ArrayList<String>(list.size());
        while (!list.isEmpty()) {
            int random = rand.nextInt(list.size());
            String elem = list.remove(random);
            result.add(elem);
        }
        RoundRobinPolicy.fineLog("Randomized list {0}", result);
        return result;
    }

    public synchronized List<String> getNextRotation() {
        int lowerLimit = 0;
        int random = 0;
        while (random == 0 && (random = rand.nextInt(this.totalWeight)) == 0) {
        }
        int i = 0;
        for (ClusterInstanceInfo endpoint : this.endpointsList) {
            int upperLimit = lowerLimit + endpoint.weight();
            if (random > lowerLimit && random <= upperLimit) {
                LinkedList<ClusterInstanceInfo> instanceInfo = new LinkedList<ClusterInstanceInfo>();
                instanceInfo.addAll(0, this.endpointsList.subList(i, this.endpointsList.size()));
                instanceInfo.addAll(this.endpointsList.subList(0, i));
                this.endpointsList = instanceInfo;
                RoundRobinPolicy.fineLog("getNextRotation: result={0}", ((Object)instanceInfo).toString());
                return this.convertIntoCorbaloc(instanceInfo);
            }
            lowerLimit = upperLimit;
            ++i;
        }
        RoundRobinPolicy.warnLog("Could not find an endpoint to send request to!", new Object[0]);
        return new ArrayList<String>();
    }

    private List<String> convertIntoCorbaloc(List<ClusterInstanceInfo> list) {
        ArrayList<String> host_port = new ArrayList<String>();
        for (ClusterInstanceInfo endpoint : list) {
            List sinfos = endpoint.endpoints();
            for (SocketInfo si : sinfos) {
                String element;
                if (!si.type().equals(CLEAR_TEXT) || host_port.contains(element = si.host().trim() + ":" + si.port())) continue;
                host_port.add(element);
            }
        }
        return host_port;
    }

    private List<String> getAddressPortList(List<String> hostPortList) {
        ArrayList<String> addressPortVector = new ArrayList<String>();
        for (String str : hostPortList) {
            try {
                IiopUrl url = new IiopUrl("iiop://" + str);
                List<String> apList = this.getAddressPortList(url);
                addressPortVector.addAll(apList);
            }
            catch (MalformedURLException me) {
                RoundRobinPolicy.warnLog("bad.host.port", str, me.getMessage());
            }
        }
        return addressPortVector;
    }

    private List<String> getAddressPortList(IiopUrl iiopUrl) {
        IiopUrl.Address iiopUrlAddress = (IiopUrl.Address)iiopUrl.getAddresses().elementAt(0);
        String host = iiopUrlAddress.host;
        int portNumber = iiopUrlAddress.port;
        String port = Integer.toString(portNumber);
        return this.getAddressPortList(host, port);
    }

    public List<String> getAddressPortList(String host, String port) {
        try {
            InetAddress[] addresses = InetAddress.getAllByName(host);
            ArrayList<InetAddress> addrs = new ArrayList<InetAddress>();
            for (InetAddress addr : addresses) {
                if (!(addr instanceof Inet4Address)) continue;
                addrs.add(addr);
            }
            ArrayList<String> ret = new ArrayList<String>();
            for (InetAddress addr : addrs) {
                ret.add(addr.getHostAddress() + ":" + port);
            }
            return ret;
        }
        catch (UnknownHostException ukhe) {
            RoundRobinPolicy.warnLog("unknown.host", host, ukhe.getMessage());
            return new ArrayList<String>();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RoundRobinPolicy[");
        boolean first = true;
        for (ClusterInstanceInfo endpoint : this.endpointsList) {
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            sb.append(endpoint.toString());
        }
        sb.append(']');
        return sb.toString();
    }

    public List<String> getHostPortList() {
        return this.resolvedEndpoints;
    }
}

