/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.annotations.Contract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Contract
public abstract class ActionReport {
    Properties extraProperties;
    private Map resultTypes = new ConcurrentHashMap();

    public abstract void setActionDescription(String var1);

    public abstract void setFailureCause(Throwable var1);

    public abstract Throwable getFailureCause();

    public abstract void setMessage(String var1);

    public abstract void appendMessage(String var1);

    public abstract void writeReport(OutputStream var1) throws IOException;

    public abstract void setMessage(InputStream var1);

    public abstract String getMessage();

    public abstract MessagePart getTopMessagePart();

    public abstract ActionReport addSubActionsReport();

    public abstract void setActionExitCode(ExitCode var1);

    public abstract ExitCode getActionExitCode();

    public abstract String getContentType();

    public abstract void setContentType(String var1);

    public final void failure(Logger logger, String message, Throwable e) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, message, e);
        }
        logger.log(Level.SEVERE, message);
        if (e != null) {
            this.setMessage(message + " : " + e.toString());
            this.setFailureCause(e);
        } else {
            this.setMessage(message);
        }
        this.setActionExitCode(ExitCode.FAILURE);
    }

    public final void failure(Logger logger, String message) {
        this.failure(logger, message, null);
    }

    public abstract boolean hasSuccesses();

    public abstract boolean hasWarnings();

    public abstract boolean hasFailures();

    public final Properties getExtraProperties() {
        return this.extraProperties;
    }

    public void setExtraProperties(Properties properties) {
        this.extraProperties = properties;
    }

    public <T> T getResultType(Class<T> resultType) {
        return (T)this.resultTypes.get(resultType);
    }

    public <T> void setResultType(Class<T> resultType, T resultTypeInstance) {
        this.resultTypes.put(resultType, resultTypeInstance);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExitCode {
        SUCCESS,
        WARNING,
        FAILURE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MessagePart {
        Properties props = new Properties();
        String message;
        String childrenType;
        List<MessagePart> children = new ArrayList<MessagePart>();

        public MessagePart addChild() {
            MessagePart newPart = new MessagePart();
            this.children.add(newPart);
            return newPart;
        }

        public void setChildrenType(String type) {
            this.childrenType = type;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public void appendMessage(String message) {
            if (this.message == null) {
                this.message = message;
            } else {
                StringBuilder sb = new StringBuilder(this.message);
                sb.append(message);
                this.message = sb.toString();
            }
        }

        public void addProperty(String key, String value) {
            this.props.put(key, value);
        }

        public Properties getProps() {
            return this.props;
        }

        public String getMessage() {
            return this.message;
        }

        public String getChildrenType() {
            return this.childrenType;
        }

        public List<MessagePart> getChildren() {
            return this.children;
        }
    }
}

