/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.ha.session.management;

import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Session;
import org.glassfish.gms.bootstrap.GMSAdapterService;
import org.glassfish.ha.common.GlassFishHAReplicaPredictor;
import org.glassfish.ha.common.HACookieInfo;
import org.glassfish.ha.common.HACookieManager;
import org.glassfish.ha.common.NoopHAReplicaPredictor;
import org.glassfish.ha.store.api.BackingStoreConfiguration;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.ha.store.api.BackingStoreFactory;
import org.glassfish.web.ha.session.management.ReplicationManagerBase;
import org.glassfish.web.ha.session.management.ReplicationStore;
import org.glassfish.web.ha.session.management.WebEventPersistentManager;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=PerLookup.class)
public class ReplicationWebEventPersistentManager
extends ReplicationManagerBase
implements WebEventPersistentManager {
    @Inject
    private Habitat habitat;
    @Inject
    private GMSAdapterService gmsAdapterService;
    private GlassFishHAReplicaPredictor predictor;
    private String clusterName = "";
    private String instanceName = "";
    private static final Logger _logger = LogDomains.getLogger(ReplicationWebEventPersistentManager.class, (String)"javax.enterprise.system.container.web");
    private static final String info = "ReplicationWebEventPersistentManager/1.0";
    private static final String name = "ReplicationWebEventPersistentManager";
    private static int NUMBER_OF_REQUESTS_BEFORE_FLUSH = 1000;
    volatile Map<String, String> removedKeysMap = new ConcurrentHashMap<String, String>();
    private static AtomicInteger requestCounter = new AtomicInteger(0);
    private static int _messageIDCounter = 0;
    private AtomicBoolean timeToChange = new AtomicBoolean(false);

    public String getInfo() {
        return info;
    }

    public ReplicationWebEventPersistentManager() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationWebEventPersistentManager created");
        }
    }

    @Override
    public void doValveSave(Session session) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("in doValveSave");
        }
        try {
            ReplicationStore replicationStore = (ReplicationStore)this.getStore();
            replicationStore.doValveSave(session);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("FINISHED repStore.valveSave");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            _logger.log(Level.FINE, "exception occurred in doValveSave id=" + session.getIdInternal(), ex);
        }
    }

    public void postRequestDispatcherProcess(ServletRequest request, ServletResponse response) {
        Context context = (Context)this.getContainer();
        Session sess = this.getSession(request);
        if (sess != null) {
            this.doValveSave(sess);
        }
    }

    private Session getSession(ServletRequest request) {
        HttpServletRequest httpReq = (HttpServletRequest)request;
        HttpSession httpSess = httpReq.getSession(false);
        if (httpSess == null) {
            return null;
        }
        String id = httpSess.getId();
        Session sess = null;
        try {
            sess = this.findSession(id);
        }
        catch (IOException ex) {
            // empty catch block
        }
        return sess;
    }

    public String getName() {
        return name;
    }

    protected void processMaxIdleBackups() {
    }

    protected void processMaxActiveSwaps() {
    }

    protected void processMaxIdleSwaps() {
    }

    @Override
    public String getReplicaFromPredictor(String sessionId, String oldJreplicaValue) {
        HACookieInfo cookieInfo = this.predictor.makeCookie(this.gmsAdapterService.getGMSAdapter().getClusterName(), (Object)sessionId, oldJreplicaValue);
        HACookieManager.setCurrrent((HACookieInfo)cookieInfo);
        return cookieInfo.getNewReplicaCookie();
    }

    public void stop() throws LifecycleException {
        super.stop();
    }

    @Override
    public <T extends Serializable> void createBackingStore(String persistenceType, String storeName, Class<T> metadataClass, HashMap vendorMap) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Create backing store invoked with persistence type " + persistenceType + " and store name " + storeName);
        }
        BackingStoreFactory factory = (BackingStoreFactory)this.habitat.getComponent(BackingStoreFactory.class, persistenceType);
        BackingStoreConfiguration conf = new BackingStoreConfiguration();
        if (this.gmsAdapterService.isGmsEnabled()) {
            this.clusterName = this.gmsAdapterService.getGMSAdapter().getClusterName();
            this.instanceName = this.gmsAdapterService.getGMSAdapter().getModule().getInstanceName();
        }
        conf.setStoreName(storeName).setClusterName(this.clusterName).setInstanceName(this.instanceName).setStoreType(persistenceType).setKeyClazz(String.class).setValueClazz(metadataClass).setClassLoader(this.getClass().getClassLoader());
        if (vendorMap != null) {
            conf.getVendorSpecificSettings().putAll(vendorMap);
        }
        try {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("About to create backing store " + conf);
            }
            this.backingStore = factory.createBackingStore(conf);
        }
        catch (BackingStoreException e) {
            _logger.log(Level.WARNING, "Could not create backing store", e);
        }
        Object obj = conf.getVendorSpecificSettings().get("key.mapper");
        if (obj != null && obj instanceof GlassFishHAReplicaPredictor) {
            this.predictor = (GlassFishHAReplicaPredictor)obj;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("ReplicatedManager.keymapper is " + this.predictor);
            }
        } else {
            this.predictor = new NoopHAReplicaPredictor();
        }
    }
}

