/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.cli.resources;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TargetType(value={CommandTarget.DAS, CommandTarget.CLUSTER, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTERED_INSTANCE})
@ExecuteOn(value={RuntimeType.DAS})
@Service(name="list-resource-refs")
@Scoped(value=PerLookup.class)
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="list.resource.refs")
public class ListResourceRefs
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListResourceRefs.class);
    @Param(optional=true, primary=true)
    private String target = "server";
    @Inject
    private Server[] servers;
    @Inject
    private Clusters clusters;

    public void execute(AdminCommandContext context) {
        ActionReport report;
        block4: {
            report = context.getActionReport();
            try {
                Server targetServer = ConfigBeansUtilities.getServerNamed((String)this.target);
                if (targetServer != null) {
                    List resourceRefs = targetServer.getResourceRef();
                    this.processResourceRefs(report, resourceRefs);
                    break block4;
                }
                List clusterList = this.clusters.getCluster();
                if (clusterList == null) break block4;
                for (Cluster cl : clusterList) {
                    if (!cl.getName().equals(this.target)) continue;
                    List resourceRefs = cl.getResourceRef();
                    this.processResourceRefs(report, resourceRefs);
                    break;
                }
            }
            catch (Exception e) {
                report.setMessage(localStrings.getLocalString("list.resource.refs.failed", "list-resource-refs failed"));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause((Throwable)e);
                return;
            }
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private void processResourceRefs(ActionReport report, List<ResourceRef> resourceRefs) {
        if (resourceRefs.isEmpty()) {
            ActionReport.MessagePart part = report.getTopMessagePart().addChild();
            part.setMessage(localStrings.getLocalString("NothingToList", "Nothing to List."));
        } else {
            for (ResourceRef ref : resourceRefs) {
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage(ref.getRef());
            }
        }
    }
}

