/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.embeddable;

import com.sun.enterprise.admin.cli.Parser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.embeddable.CommandResult;
import org.jvnet.hk2.annotations.ContractProvided;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service
@Scoped(value=PerLookup.class)
@ContractProvided(value=org.glassfish.embeddable.CommandRunner.class)
public class CommandExecutorImpl
implements org.glassfish.embeddable.CommandRunner {
    @Inject
    CommandRunner commandRunner;
    @Inject
    Habitat habitat;
    private boolean terse;
    private Logger logger = Logger.getAnonymousLogger();

    public CommandResult run(String command, String ... args) {
        try {
            ActionReport actionReport = this.executeCommand(command, args);
            return this.convert(actionReport);
        }
        catch (Exception e) {
            return this.convert(e);
        }
    }

    private ParameterMap getParameters(String command, String[] args) throws CommandException {
        CommandModel commandModel = this.commandRunner.getModel(command, this.logger);
        if (command == null) {
            throw new CommandException("No command called " + command);
        }
        Parser parser = new Parser(args, 0, commandModel.getParameters(), false);
        ParameterMap options = parser.getOptions();
        List<String> operands = parser.getOperands();
        options.set((Object)"DEFAULT", operands);
        if (commandModel.getModelFor("terse") != null) {
            options.set((Object)"terse", (Object)Boolean.toString(this.terse));
        }
        return options;
    }

    public void setTerse(boolean terse) {
        this.terse = terse;
    }

    ActionReport executeCommand(String command, String ... args) throws CommandException {
        ParameterMap commandParams = this.getParameters(command, args);
        ActionReport actionReport = this.createActionReport();
        CommandRunner.CommandInvocation inv = this.commandRunner.getCommandInvocation(command, actionReport);
        inv.parameters(commandParams).execute();
        return actionReport;
    }

    private CommandResult convert(final ActionReport actionReport) {
        return new CommandResult(){

            public CommandResult.ExitStatus getExitStatus() {
                ActionReport.ExitCode actionExitCode = actionReport.getActionExitCode();
                switch (actionExitCode) {
                    case SUCCESS: {
                        return CommandResult.ExitStatus.SUCCESS;
                    }
                    case WARNING: {
                        return CommandResult.ExitStatus.WARNING;
                    }
                    case FAILURE: {
                        return CommandResult.ExitStatus.FAILURE;
                    }
                }
                throw new RuntimeException("Unknown exit code: " + actionExitCode);
            }

            public String getOutput() {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                try {
                    actionReport.writeReport((OutputStream)os);
                    String string = os.toString();
                    return string;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    try {
                        os.close();
                    }
                    catch (IOException e) {}
                }
            }

            public Throwable getFailureCause() {
                return actionReport.getFailureCause();
            }
        };
    }

    private CommandResult convert(final Exception e) {
        return new CommandResult(){

            public CommandResult.ExitStatus getExitStatus() {
                return CommandResult.ExitStatus.FAILURE;
            }

            public String getOutput() {
                return "Exception while executing command.";
            }

            public Throwable getFailureCause() {
                return e;
            }
        };
    }

    private ActionReport createActionReport() {
        return (ActionReport)this.habitat.getComponent(ActionReport.class, "plain");
    }
}

