/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.eventadmin.impl;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.felix.eventadmin.impl.EventAdminImpl;
import org.apache.felix.eventadmin.impl.MetaTypeProviderImpl;
import org.apache.felix.eventadmin.impl.adapter.AbstractAdapter;
import org.apache.felix.eventadmin.impl.adapter.BundleEventAdapter;
import org.apache.felix.eventadmin.impl.adapter.FrameworkEventAdapter;
import org.apache.felix.eventadmin.impl.adapter.LogEventAdapter;
import org.apache.felix.eventadmin.impl.adapter.ServiceEventAdapter;
import org.apache.felix.eventadmin.impl.dispatch.DefaultThreadPool;
import org.apache.felix.eventadmin.impl.handler.BlacklistingHandlerTasks;
import org.apache.felix.eventadmin.impl.handler.CacheFilters;
import org.apache.felix.eventadmin.impl.handler.CacheTopicHandlerFilters;
import org.apache.felix.eventadmin.impl.handler.CleanBlackList;
import org.apache.felix.eventadmin.impl.security.SecureEventAdminFactory;
import org.apache.felix.eventadmin.impl.util.LeastRecentlyUsedCacheMap;
import org.apache.felix.eventadmin.impl.util.LogWrapper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.event.EventAdmin;

public class Configuration {
    static final String PID = "org.apache.felix.eventadmin.impl.EventAdmin";
    static final String PROP_CACHE_SIZE = "org.apache.felix.eventadmin.CacheSize";
    static final String PROP_THREAD_POOL_SIZE = "org.apache.felix.eventadmin.ThreadPoolSize";
    static final String PROP_TIMEOUT = "org.apache.felix.eventadmin.Timeout";
    static final String PROP_REQUIRE_TOPIC = "org.apache.felix.eventadmin.RequireTopic";
    static final String PROP_IGNORE_TIMEOUT = "org.apache.felix.eventadmin.IgnoreTimeout";
    static final String PROP_LOG_LEVEL = "org.apache.felix.eventadmin.LogLevel";
    private final BundleContext m_bundleContext;
    private int m_cacheSize;
    private int m_threadPoolSize;
    private int m_timeout;
    private boolean m_requireTopic;
    private String[] m_ignoreTimeout;
    private int m_logLevel;
    private volatile DefaultThreadPool m_sync_pool;
    private volatile DefaultThreadPool m_async_pool;
    private volatile EventAdminImpl m_admin;
    private volatile ServiceRegistration m_registration;
    private AbstractAdapter[] m_adapters;
    private ServiceRegistration m_managedServiceReg;
    static /* synthetic */ Class class$org$osgi$service$cm$ManagedService;
    static /* synthetic */ Class class$org$osgi$service$metatype$MetaTypeProvider;
    static /* synthetic */ Class class$org$osgi$service$event$EventAdmin;

    public Configuration(BundleContext bundleContext) {
        this.m_bundleContext = bundleContext;
        this.configure(null);
        this.startOrUpdate();
        try {
            Object service = this.tryToCreateManagedService();
            if (service != null) {
                String[] interfaceNames;
                Object enhancedService = this.tryToCreateMetaTypeProvider(service);
                if (enhancedService == null) {
                    interfaceNames = new String[]{(class$org$osgi$service$cm$ManagedService == null ? (class$org$osgi$service$cm$ManagedService = Configuration.class$("org.osgi.service.cm.ManagedService")) : class$org$osgi$service$cm$ManagedService).getName()};
                } else {
                    interfaceNames = new String[]{(class$org$osgi$service$cm$ManagedService == null ? (class$org$osgi$service$cm$ManagedService = Configuration.class$("org.osgi.service.cm.ManagedService")) : class$org$osgi$service$cm$ManagedService).getName(), (class$org$osgi$service$metatype$MetaTypeProvider == null ? (class$org$osgi$service$metatype$MetaTypeProvider = Configuration.class$("org.osgi.service.metatype.MetaTypeProvider")) : class$org$osgi$service$metatype$MetaTypeProvider).getName()};
                    service = enhancedService;
                }
                Hashtable<String, String> props = new Hashtable<String, String>();
                ((Dictionary)props).put("service.pid", PID);
                this.m_managedServiceReg = this.m_bundleContext.registerService(interfaceNames, service, props);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void updateFromConfigAdmin(final Dictionary config) {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Configuration configuration = Configuration.this;
                synchronized (configuration) {
                    Configuration.this.configure(config);
                    Configuration.this.startOrUpdate();
                }
            }
        }.start();
    }

    void configure(Dictionary config) {
        if (config == null) {
            this.m_cacheSize = this.getIntProperty(PROP_CACHE_SIZE, this.m_bundleContext.getProperty(PROP_CACHE_SIZE), 30, 10);
            this.m_threadPoolSize = this.getIntProperty(PROP_THREAD_POOL_SIZE, this.m_bundleContext.getProperty(PROP_THREAD_POOL_SIZE), 20, 2);
            this.m_timeout = this.getIntProperty(PROP_TIMEOUT, this.m_bundleContext.getProperty(PROP_TIMEOUT), 5000, Integer.MIN_VALUE);
            this.m_requireTopic = this.getBooleanProperty(this.m_bundleContext.getProperty(PROP_REQUIRE_TOPIC), true);
            String value = this.m_bundleContext.getProperty(PROP_IGNORE_TIMEOUT);
            if (value == null) {
                this.m_ignoreTimeout = null;
            } else {
                StringTokenizer st = new StringTokenizer(value, ",");
                this.m_ignoreTimeout = new String[st.countTokens()];
                for (int i = 0; i < this.m_ignoreTimeout.length; ++i) {
                    this.m_ignoreTimeout[i] = st.nextToken();
                }
            }
            this.m_logLevel = this.getIntProperty(PROP_LOG_LEVEL, this.m_bundleContext.getProperty(PROP_LOG_LEVEL), 2, 1);
        } else {
            this.m_cacheSize = this.getIntProperty(PROP_CACHE_SIZE, config.get(PROP_CACHE_SIZE), 30, 10);
            this.m_threadPoolSize = this.getIntProperty(PROP_THREAD_POOL_SIZE, config.get(PROP_THREAD_POOL_SIZE), 20, 2);
            this.m_timeout = this.getIntProperty(PROP_TIMEOUT, config.get(PROP_TIMEOUT), 5000, Integer.MIN_VALUE);
            this.m_requireTopic = this.getBooleanProperty(config.get(PROP_REQUIRE_TOPIC), true);
            this.m_ignoreTimeout = null;
            Object value = config.get(PROP_IGNORE_TIMEOUT);
            if (value instanceof String) {
                this.m_ignoreTimeout = new String[]{(String)value};
            } else if (value instanceof String[]) {
                this.m_ignoreTimeout = (String[])value;
            } else {
                LogWrapper.getLogger().log(2, "Value for property: org.apache.felix.eventadmin.IgnoreTimeout is neither a string nor a string array - Using default");
            }
            this.m_logLevel = this.getIntProperty(PROP_LOG_LEVEL, config.get(PROP_LOG_LEVEL), 2, 1);
        }
        if (this.m_timeout <= 100) {
            this.m_timeout = 0;
        }
    }

    private void startOrUpdate() {
        int asyncThreadPoolSize;
        LogWrapper.getLogger().setLogLevel(this.m_logLevel);
        LogWrapper.getLogger().log(4, "org.apache.felix.eventadmin.LogLevel=" + this.m_logLevel);
        LogWrapper.getLogger().log(4, "org.apache.felix.eventadmin.CacheSize=" + this.m_cacheSize);
        LogWrapper.getLogger().log(4, "org.apache.felix.eventadmin.ThreadPoolSize=" + this.m_threadPoolSize);
        LogWrapper.getLogger().log(4, "org.apache.felix.eventadmin.Timeout=" + this.m_timeout);
        LogWrapper.getLogger().log(4, "org.apache.felix.eventadmin.RequireTopic=" + this.m_requireTopic);
        CacheTopicHandlerFilters topicHandlerFilters = new CacheTopicHandlerFilters(new LeastRecentlyUsedCacheMap(this.m_cacheSize), this.m_requireTopic);
        CacheFilters filters = new CacheFilters(new LeastRecentlyUsedCacheMap(this.m_cacheSize), this.m_bundleContext);
        if (this.m_sync_pool == null) {
            this.m_sync_pool = new DefaultThreadPool(this.m_threadPoolSize, true);
        } else {
            this.m_sync_pool.configure(this.m_threadPoolSize);
        }
        int n = asyncThreadPoolSize = this.m_threadPoolSize > 5 ? this.m_threadPoolSize / 2 : 2;
        if (this.m_async_pool == null) {
            this.m_async_pool = new DefaultThreadPool(asyncThreadPoolSize, false);
        } else {
            this.m_async_pool.configure(asyncThreadPoolSize);
        }
        BlacklistingHandlerTasks handlerTasks = new BlacklistingHandlerTasks(this.m_bundleContext, new CleanBlackList(), topicHandlerFilters, filters);
        if (this.m_admin == null) {
            this.m_admin = new EventAdminImpl(handlerTasks, this.m_sync_pool, this.m_async_pool, this.m_timeout, this.m_ignoreTimeout);
            this.adaptEvents(this.m_admin);
            this.m_registration = this.m_bundleContext.registerService((class$org$osgi$service$event$EventAdmin == null ? (class$org$osgi$service$event$EventAdmin = Configuration.class$("org.osgi.service.event.EventAdmin")) : class$org$osgi$service$event$EventAdmin).getName(), (Object)new SecureEventAdminFactory(this.m_admin), null);
        } else {
            this.m_admin.update(handlerTasks, this.m_timeout, this.m_ignoreTimeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Configuration configuration = this;
        synchronized (configuration) {
            if (this.m_adapters != null) {
                for (int i = 0; i < this.m_adapters.length; ++i) {
                    this.m_adapters[i].destroy(this.m_bundleContext);
                }
                this.m_adapters = null;
            }
            if (this.m_managedServiceReg != null) {
                this.m_managedServiceReg.unregister();
                this.m_managedServiceReg = null;
            }
            if (this.m_registration != null) {
                this.m_registration.unregister();
                this.m_registration = null;
            }
            if (this.m_admin != null) {
                this.m_admin.stop();
                this.m_admin = null;
            }
            if (this.m_async_pool != null) {
                this.m_async_pool.close();
                this.m_async_pool = null;
            }
            if (this.m_sync_pool != null) {
                this.m_sync_pool.close();
                this.m_sync_pool = null;
            }
        }
    }

    private void adaptEvents(EventAdmin admin) {
        this.m_adapters = new AbstractAdapter[4];
        this.m_adapters[0] = new FrameworkEventAdapter(this.m_bundleContext, admin);
        this.m_adapters[1] = new BundleEventAdapter(this.m_bundleContext, admin);
        this.m_adapters[2] = new ServiceEventAdapter(this.m_bundleContext, admin);
        this.m_adapters[3] = new LogEventAdapter(this.m_bundleContext, admin);
    }

    private Object tryToCreateMetaTypeProvider(Object managedService) {
        try {
            return new MetaTypeProviderImpl((ManagedService)managedService, this.m_cacheSize, this.m_threadPoolSize, this.m_timeout, this.m_requireTopic, this.m_ignoreTimeout);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private Object tryToCreateManagedService() {
        try {
            return new ManagedService(){

                public void updated(Dictionary properties) throws ConfigurationException {
                    Configuration.this.updateFromConfigAdmin(properties);
                }
            };
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private int getIntProperty(String key, Object value, int defaultValue, int min) {
        if (null != value) {
            int result;
            if (value instanceof Integer) {
                result = (Integer)value;
            } else {
                try {
                    result = Integer.parseInt(value.toString());
                }
                catch (NumberFormatException e) {
                    LogWrapper.getLogger().log(2, "Unable to parse property: " + key + " - Using default", e);
                    return defaultValue;
                }
            }
            if (result >= min) {
                return result;
            }
            LogWrapper.getLogger().log(2, "Value for property: " + key + " is to low - Using default");
        }
        return defaultValue;
    }

    private boolean getBooleanProperty(Object obj, boolean defaultValue) {
        if (null != obj) {
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            String value = obj.toString().trim().toLowerCase();
            if (0 < value.length() && ("0".equals(value) || "false".equals(value) || "no".equals(value))) {
                return false;
            }
            if (0 < value.length() && ("1".equals(value) || "true".equals(value) || "yes".equals(value))) {
                return true;
            }
        }
        return defaultValue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

