/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.common;

import com.sun.enterprise.ee.cms.core.DistributedStateCache;
import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.enterprise.ee.cms.core.JoinNotificationSignal;
import com.sun.enterprise.ee.cms.core.RejoinSubevent;
import com.sun.enterprise.ee.cms.core.SignalAcquireException;
import com.sun.enterprise.ee.cms.core.SignalReleaseException;
import com.sun.enterprise.ee.cms.impl.common.GMSContext;
import com.sun.enterprise.ee.cms.impl.common.GMSContextFactory;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import com.sun.enterprise.ee.cms.spi.GroupCommunicationProvider;
import com.sun.enterprise.ee.cms.spi.MemberStates;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JoinNotificationSignalImpl
implements JoinNotificationSignal {
    private String memberToken;
    private String groupName;
    private List<String> currentCoreMembers;
    private List<String> allCurrentMembers;
    private static final String MEMBER_DETAILS = "MEMBERDETAILS";
    private GMSContext ctx;
    private final GMSConstants.startupType startupKind;
    private long startTime;
    private RejoinSubevent rs;
    protected static final Logger logger = GMSLogDomain.getLogger("ShoalLogger");

    public JoinNotificationSignalImpl(String memberToken, List<String> currentCoreMembers, List<String> allCurrentMembers, String groupName, long startTime, GMSConstants.startupType startupKind) {
        this.memberToken = memberToken;
        this.currentCoreMembers = currentCoreMembers;
        this.allCurrentMembers = allCurrentMembers;
        this.groupName = groupName;
        this.startTime = startTime;
        this.ctx = GMSContextFactory.getGMSContext(groupName);
        this.startupKind = startupKind;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JoinNotificationSignalImpl ctor: member=" + memberToken + " group=" + groupName + " startupKind=" + startupKind.toString());
        }
    }

    JoinNotificationSignalImpl(JoinNotificationSignal signal) {
        this(signal.getMemberToken(), signal.getCurrentCoreMembers(), signal.getAllCurrentMembers(), signal.getGroupName(), signal.getStartTime(), signal.getEventSubType());
    }

    public void acquire() throws SignalAcquireException {
    }

    public void release() throws SignalReleaseException {
        this.memberToken = null;
        this.currentCoreMembers = null;
        this.allCurrentMembers = null;
    }

    public String getMemberToken() {
        return this.memberToken;
    }

    public List<String> getCurrentCoreMembers() {
        return this.currentCoreMembers;
    }

    public List<String> getAllCurrentMembers() {
        return this.allCurrentMembers;
    }

    public MemberStates getMemberState() {
        if (this.ctx == null) {
            this.ctx = GMSContextFactory.getGMSContext(this.groupName);
        }
        GroupCommunicationProvider gcp = this.ctx.getGroupCommunicationProvider();
        return gcp.getMemberState(this.memberToken);
    }

    public Map<Serializable, Serializable> getMemberDetails() {
        DistributedStateCache dsc;
        HashMap<Serializable, Serializable> ret = new HashMap();
        if (this.ctx == null) {
            this.ctx = GMSContextFactory.getGMSContext(this.groupName);
        }
        if ((dsc = this.ctx.getDistributedStateCache()) != null) {
            ret = dsc.getFromCacheForPattern(MEMBER_DETAILS, this.memberToken);
        } else {
            logger.log(Level.WARNING, "no.instance.dsc", new Object[]{this.memberToken});
        }
        return ret;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public GMSConstants.startupType getEventSubType() {
        return this.startupKind;
    }

    public RejoinSubevent getRejoinSubevent() {
        return this.rs;
    }

    public void setRs(RejoinSubevent rs) {
        this.rs = rs;
    }
}

