/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.data;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Engine;
import com.sun.enterprise.config.serverbeans.Module;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.glassfish.api.container.Container;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.internal.data.EngineInfo;
import org.glassfish.internal.data.EngineRef;
import org.glassfish.internal.data.ModuleInfo;
import org.glassfish.internal.data.ProgressTracker;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.DeploymentTracing;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.config.TransactionFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationInfo
extends ModuleInfo {
    private final Collection<ModuleInfo> modules = new ArrayList<ModuleInfo>();
    private final ReadableArchive source;
    private final Map<String, Object> transientAppMetaData = new HashMap<String, Object>();
    private String libraries;
    private boolean isJavaEEApp = false;
    private ClassLoader appClassLoader;
    private boolean isLoaded = false;

    public ApplicationInfo(Events events, ReadableArchive source, String name) {
        super(events, name, new LinkedHashSet<EngineRef>(), null);
        this.source = source;
    }

    public void add(EngineRef ref) {
        this.engines.add(ref);
    }

    public void addTransientAppMetaData(String metaDataKey, Object metaDataValue) {
        if (metaDataValue != null) {
            this.transientAppMetaData.put(metaDataKey, metaDataValue);
        }
    }

    public <T> T getTransientAppMetaData(String key, Class<T> metadataType) {
        Object metaDataValue = this.transientAppMetaData.get(key);
        if (metaDataValue != null) {
            return metadataType.cast(metaDataValue);
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getLibraries() {
        return this.libraries;
    }

    public void setLibraries(String libraries) {
        this.libraries = libraries;
    }

    public boolean isJavaEEApp() {
        return this.isJavaEEApp;
    }

    public void setIsJavaEEApp(List<EngineInfo> engineInfos) {
        for (EngineInfo engineInfo : engineInfos) {
            String moduleType = engineInfo.getSniffer().getModuleType();
            if (!moduleType.equals("web") && !moduleType.equals("ejb") && !moduleType.equals("appclient") && !moduleType.equals("connector") && !moduleType.equals("ear")) continue;
            this.isJavaEEApp = true;
            break;
        }
    }

    public ReadableArchive getSource() {
        return this.source;
    }

    public Collection<ModuleInfo> getModuleInfos() {
        return this.modules;
    }

    @Override
    public Collection<Sniffer> getSniffers() {
        ArrayList<Sniffer> sniffers = new ArrayList<Sniffer>();
        for (EngineRef ref : this.engines) {
            sniffers.add(ref.getContainerInfo().getSniffer());
        }
        for (ModuleInfo module : this.modules) {
            sniffers.addAll(module.getSniffers());
        }
        return sniffers;
    }

    public <T extends Container> Collection<EngineRef> getEngineRefsForContainer(Class<T> type2) {
        LinkedHashSet<EngineRef> refs = new LinkedHashSet<EngineRef>();
        for (ModuleInfo info : this.modules) {
            EngineRef ref = null;
            try {
                ref = info.getEngineRefForContainer(type2);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (ref == null) continue;
            refs.add(ref);
        }
        return refs;
    }

    protected ExtendedDeploymentContext getSubContext(ModuleInfo info, ExtendedDeploymentContext context) {
        return context;
    }

    @Override
    public void load(ExtendedDeploymentContext context, ProgressTracker tracker) throws Exception {
        Logger logger = context.getLogger();
        if (this.isLoaded) {
            logger.fine("Application is already loaded.");
            return;
        }
        context.setPhase(ExtendedDeploymentContext.Phase.LOAD);
        DeploymentTracing tracing = (DeploymentTracing)context.getModuleMetaData(DeploymentTracing.class);
        if (tracing != null) {
            tracing.addMark(DeploymentTracing.Mark.LOAD);
        }
        super.load(context, tracker);
        this.appClassLoader = context.getClassLoader();
        for (ModuleInfo module : this.modules) {
            if (tracing != null) {
                tracing.addModuleMark(DeploymentTracing.ModuleMark.LOAD, module.getName());
            }
            module.load(this.getSubContext(module, context), tracker);
            if (tracing == null) continue;
            tracing.addModuleMark(DeploymentTracing.ModuleMark.LOADED, module.getName());
        }
        this.isLoaded = true;
        if (tracing != null) {
            tracing.addMark(DeploymentTracing.Mark.LOAD_EVENTS);
        }
        if (this.events != null) {
            this.events.send(new EventListener.Event(Deployment.APPLICATION_LOADED, (Object)this), false);
        }
        if (tracing != null) {
            tracing.addMark(DeploymentTracing.Mark.LOADED);
        }
    }

    public void start(ExtendedDeploymentContext context, ProgressTracker tracker) throws Exception {
        DeploymentTracing tracing = (DeploymentTracing)context.getModuleMetaData(DeploymentTracing.class);
        if (tracing != null) {
            tracing.addMark(DeploymentTracing.Mark.START);
        }
        super.start(context, tracker);
        for (ModuleInfo module : this.getModuleInfos()) {
            if (tracing != null) {
                tracing.addModuleMark(DeploymentTracing.ModuleMark.START, module.getName());
            }
            module.start(this.getSubContext(module, context), tracker);
            if (tracing == null) continue;
            tracing.addModuleMark(DeploymentTracing.ModuleMark.STARTED, module.getName());
        }
        if (tracing != null) {
            tracing.addMark(DeploymentTracing.Mark.START_EVENTS);
        }
        if (this.events != null) {
            this.events.send(new EventListener.Event(Deployment.APPLICATION_STARTED, (Object)this), false);
        }
        if (tracing != null) {
            tracing.addMark(DeploymentTracing.Mark.STARTED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(ExtendedDeploymentContext context, Logger logger) {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.appClassLoader);
            context.setClassLoader(this.appClassLoader);
            super.stop(context, logger);
            for (ModuleInfo module : this.getModuleInfos()) {
                module.stop(this.getSubContext(module, context), logger);
            }
            if (this.events != null) {
                this.events.send(new EventListener.Event(Deployment.APPLICATION_STOPPED, (Object)this), false);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unload(ExtendedDeploymentContext context) {
        Logger logger = context.getLogger();
        if (!this.isLoaded) {
            logger.fine("Application is already unloaded.");
            return;
        }
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.appClassLoader);
            context.setClassLoader(this.appClassLoader);
            super.unload(context);
            for (ModuleInfo module : this.getModuleInfos()) {
                module.unload(this.getSubContext(module, context));
            }
            this.isLoaded = false;
            if (this.events != null) {
                this.events.send(new EventListener.Event(Deployment.APPLICATION_UNLOADED, (Object)this), false);
            }
            for (ModuleInfo module : this.getModuleInfos()) {
                if (module.getClassLoaders() == null) continue;
                for (ClassLoader cloader : module.getClassLoaders()) {
                    try {
                        ((PreDestroy)PreDestroy.class.cast(cloader)).preDestroy();
                    }
                    catch (Exception e) {}
                }
                module.cleanClassLoaders();
            }
            try {
                ((PreDestroy)PreDestroy.class.cast(this.appClassLoader)).preDestroy();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.appClassLoader = null;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
            context.setClassLoader(null);
        }
    }

    @Override
    public boolean suspend(Logger logger) {
        boolean isSuccess = super.suspend(logger);
        for (ModuleInfo module : this.modules) {
            if (module.suspend(logger)) continue;
            isSuccess = false;
        }
        return isSuccess;
    }

    @Override
    public boolean resume(Logger logger) {
        boolean isSuccess = super.resume(logger);
        for (ModuleInfo module : this.modules) {
            if (module.resume(logger)) continue;
            isSuccess = false;
        }
        return isSuccess;
    }

    @Override
    public void clean(ExtendedDeploymentContext context) throws Exception {
        Logger logger = context.getLogger();
        super.clean(context);
        for (ModuleInfo info : this.modules) {
            info.clean(this.getSubContext(info, context));
            info = null;
        }
        if (this.events != null) {
            this.events.send(new EventListener.Event(Deployment.APPLICATION_CLEANED, (Object)context), false);
        }
    }

    public void save(Application app) throws TransactionFailure, PropertyVetoException {
        for (EngineRef ref : this.engines) {
            Engine engine = (Engine)app.createChild(Engine.class);
            app.getEngine().add(engine);
            ref.save(engine);
        }
        for (ModuleInfo module : this.modules) {
            Module modConfig = app.getModule(module.getName());
            if (modConfig == null) {
                modConfig = (Module)app.createChild(Module.class);
                modConfig.setName(module.getName());
                app.getModule().add(modConfig);
            }
            module.save(modConfig);
        }
    }

    public void addModule(ModuleInfo info) {
        this.modules.add(info);
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }
}

