/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.remote.RemoteAdminCommand;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.Console;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="change-admin-password")
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS})
public class ChangeAdminPasswordCommand
extends CLICommand {
    private ParameterMap params;
    private static final LocalStringsImpl strings = new LocalStringsImpl(ChangeAdminPasswordCommand.class);

    protected void validate() throws CommandException, CommandValidationException {
        if (this.programOpts.getUser() == null) {
            Console cons = System.console();
            if (cons != null && this.programOpts.isInteractive()) {
                cons.printf("%s", strings.get("AdminUserDefaultPrompt", new Object[]{"admin"}));
                String val = cons.readLine();
                if (ChangeAdminPasswordCommand.ok(val)) {
                    this.programOpts.setUser(val);
                } else {
                    this.programOpts.setUser("admin");
                }
            } else {
                throw new CommandValidationException(strings.get("AdminUserRequired"));
            }
        }
        try {
            String password = this.getPasswords();
            this.programOpts.setPassword(password, ProgramOptions.PasswordLocation.USER);
        }
        catch (CommandValidationException cve) {
            throw new CommandException((Throwable)cve);
        }
        this.params = new ParameterMap();
        this.params.set((Object)"DEFAULT", (Object)this.programOpts.getUser());
        this.params.set((Object)"AS_ADMIN_PASSWORD", this.passwords.get("AS_ADMIN_PASSWORD"));
        this.params.set((Object)"AS_ADMIN_NEWPASSWORD", this.passwords.get("AS_ADMIN_NEWPASSWORD"));
    }

    protected int executeCommand() throws CommandException {
        RemoteAdminCommand rac = new RemoteAdminCommand(this.name, this.programOpts.getHost(), this.programOpts.getPort(), this.programOpts.isSecure(), this.programOpts.getUser(), this.programOpts.getPassword(), logger);
        rac.executeCommand(this.params);
        return 0;
    }

    private String getPasswords() throws CommandValidationException {
        String newpasswordAgain;
        String oldpassword = this.readPassword(strings.get("AdminPasswordPrompt"));
        String newpassword = this.readPassword(strings.get("AdminNewPasswordPrompt"));
        if (!newpassword.equals(newpasswordAgain = this.readPassword(strings.get("AdminNewPasswordConfirmationPrompt")))) {
            throw new CommandValidationException(strings.get("OptionsDoNotMatch", new Object[]{"Admin Password"}));
        }
        this.passwords.put("AS_ADMIN_PASSWORD", oldpassword);
        this.passwords.put("AS_ADMIN_NEWPASSWORD", newpassword);
        return oldpassword;
    }
}

