/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.Payload;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.deployment.admin.DeployCommandSupplementalInfo;
import org.glassfish.deployment.common.ApplicationConfigInfo;
import org.glassfish.deployment.common.Artifacts;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.versioning.VersioningService;
import org.glassfish.deployment.versioning.VersioningSyntaxException;
import org.glassfish.deployment.versioning.VersioningUtils;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.DeploymentTracing;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.internal.deployment.SnifferManager;
import org.glassfish.internal.deployment.Verifier;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.tracing.TracingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="deploy")
@I18n(value="deploy.command")
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DOMAIN, CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
public class DeployCommand
extends DeployCommandParameters
implements AdminCommand,
EventListener {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeployCommand.class);
    private static final String COPY_IN_PLACE_ARCHIVE_PROP_NAME = "copy.inplace.archive";
    @Inject
    Applications apps;
    @Inject
    ServerEnvironment env;
    @Inject
    Habitat habitat;
    @Inject
    CommandRunner commandRunner;
    @Inject
    Deployment deployment;
    @Inject
    SnifferManager snifferManager;
    @Inject
    ArchiveFactory archiveFactory;
    @Inject
    Domain domain;
    @Inject
    Events events;
    @Inject
    VersioningService versioningService;
    private File safeCopyOfApp = null;
    private File safeCopyOfDeploymentPlan = null;
    private File originalPathValue;
    private List<String> previousTargets = new ArrayList<String>();
    private Properties previousVirtualServers = new Properties();
    private Properties previousEnabledAttributes = new Properties();

    public DeployCommand() {
        this.origin = OpsParams.Origin.deploy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void execute(AdminCommandContext context) {
        block98: {
            boolean isDirectoryDeployed;
            Properties undeployProps;
            ApplicationConfigInfo savedAppConfig;
            DeploymentContextImpl initialContext;
            ArchiveHandler archiveHandler;
            File expansionDir;
            ReadableArchive archive;
            Logger logger;
            ActionReport report;
            DeploymentTracing tracing;
            DeploymentTracing timing;
            DeployCommandSupplementalInfo suppInfo;
            block95: {
                block88: {
                    block87: {
                        this.events.register((EventListener)this);
                        suppInfo = new DeployCommandSupplementalInfo();
                        context.getActionReport().setResultType(DeployCommandSupplementalInfo.class, (Object)suppInfo);
                        try {
                            timing = new DeploymentTracing();
                            tracing = null;
                            if (System.getProperty("org.glassfish.deployment.trace") != null) {
                                tracing = new DeploymentTracing();
                            }
                            report = context.getActionReport();
                            logger = context.getLogger();
                            this.originalPathValue = this.path;
                            if (this.path.exists()) break block87;
                            report.setMessage(localStrings.getLocalString("fnf", "File not found", new Object[]{this.path.getAbsolutePath()}));
                            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                        }
                        catch (Throwable throwable) {
                            Object var32_42 = null;
                            this.events.unregister((EventListener)this);
                            throw throwable;
                        }
                        this.events.unregister((EventListener)this);
                        return;
                    }
                    if (!this.snifferManager.hasNoSniffers()) break block88;
                    String msg = localStrings.getLocalString("nocontainer", "No container services registered, done...");
                    report.failure(logger, msg);
                    this.events.unregister((EventListener)this);
                    return;
                }
                try {
                    archive = this.archiveFactory.openArchive(this.path, (DeployCommandParameters)this);
                    if (tracing != null) {
                        tracing.addMark(DeploymentTracing.Mark.ARCHIVE_OPENED);
                    }
                }
                catch (IOException e) {
                    String msg = localStrings.getLocalString("deploy.errOpeningArtifact", "deploy.errOpeningArtifact", new Object[]{this.path.getAbsolutePath()});
                    if (this.logReportedErrors.booleanValue()) {
                        report.failure(logger, msg, (Throwable)e);
                    } else {
                        report.setMessage(msg + this.path.getAbsolutePath() + e.toString());
                        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    }
                    this.events.unregister((EventListener)this);
                    return;
                }
                expansionDir = null;
                archiveHandler = this.deployment.getArchiveHandler(archive, this.type);
                if (tracing != null) {
                    tracing.addMark(DeploymentTracing.Mark.ARCHIVE_HANDLER_OBTAINED);
                }
                if (archiveHandler != null) break block89;
                report.failure(logger, localStrings.getLocalString("deploy.unknownarchivetype", "Archive type of {0} was not recognized", new Object[]{this.path.getName()}));
                Object var27_14 = null;
                try {
                    archive.close();
                }
                catch (IOException e2) {
                    logger.log(Level.FINE, localStrings.getLocalString("errClosingArtifact", "Error while closing deployable artifact : ", new Object[]{this.path.getAbsolutePath()}), e2);
                }
                if (tracing != null) {
                    tracing.print(System.out);
                    TracingUtilities.dump((String)"org.glassfish.javaee.core.deployment.DolProvider", (PrintStream)System.out);
                }
                if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                    report.setResultType(String.class, (Object)this.name);
                    report.setMessage(localStrings.getLocalString("deploy.command.success", "Application deployed with name {0}", new Object[]{this.name}));
                    logger.info(localStrings.getLocalString("deploy.done", "Deployment of {0} done is {1} ms", new Object[]{this.name, timing.elapsed()}));
                } else if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
                    String errorMessage = report.getMessage();
                    Throwable cause = report.getFailureCause();
                    if (cause != null) {
                        String causeMessage = cause.getMessage();
                        if (causeMessage != null && !causeMessage.equals(errorMessage)) {
                            errorMessage = errorMessage + " : " + cause.getMessage();
                        }
                        logger.log(Level.SEVERE, errorMessage, cause.getCause());
                    }
                    report.setMessage(localStrings.getLocalString("deploy.errDuringDepl", "Error occur during deployment: {0}.", new Object[]{errorMessage}));
                    report.setFailureCause(null);
                    if (expansionDir != null) {
                        FileUtils.whack(expansionDir);
                    }
                }
                Object var32_38 = null;
                this.events.unregister((EventListener)this);
                {
                    block91: {
                        boolean isRegistered;
                        String versionIdentifier;
                        block89: {
                            return;
                        }
                        initialContext = new DeploymentContextImpl(report, logger, archive, (OpsParams)this, this.env);
                        if (tracing != null) {
                            initialContext.addModuleMetaData((Object)tracing);
                            tracing.addMark(DeploymentTracing.Mark.INITIAL_CONTEXT_CREATED);
                        }
                        if (this.name == null) {
                            this.name = archiveHandler.getDefaultApplicationName(archive, (DeploymentContext)initialContext);
                        } else {
                            DeploymentUtils.validateApplicationName((String)this.name);
                        }
                        if (tracing != null) {
                            tracing.addMark(DeploymentTracing.Mark.APPNAME_DETERMINED);
                        }
                        boolean isUntagged = VersioningUtils.isUntagged((String)this.name);
                        if (this.name != null && !isUntagged && this.type != null && this.type.equals("osgi")) {
                            ActionReport.MessagePart msgPart = context.getActionReport().getTopMessagePart();
                            msgPart.setChildrenType("WARNING");
                            ActionReport.MessagePart childPart = msgPart.addChild();
                            childPart.setMessage(VersioningUtils.LOCALSTRINGS.getLocalString("versioning.deployment.osgi.warning", "OSGi bundles will not use the GlassFish versioning, any version information embedded as part of the name option will be ignored"));
                            this.name = VersioningUtils.getUntaggedName((String)this.name);
                        }
                        if (isUntagged && (versionIdentifier = archiveHandler.getVersionIdentifier(archive)) != null && !versionIdentifier.isEmpty()) {
                            StringBuilder sb = new StringBuilder(this.name).append(":").append(versionIdentifier);
                            this.name = sb.toString();
                        }
                        this.isredeploy = (isRegistered = this.deployment.isRegistered(this.name)) && this.force != false;
                        this.deployment.validateDeploymentTarget(this.target, this.name, this.isredeploy.booleanValue());
                        if (tracing != null) {
                            tracing.addMark(DeploymentTracing.Mark.TARGET_VALIDATED);
                        }
                        ActionReport.MessagePart part = report.getTopMessagePart();
                        part.addProperty("name", this.name);
                        savedAppConfig = new ApplicationConfigInfo((Application)this.apps.getModule(Application.class, this.name));
                        undeployProps = this.handleRedeploy(this.name, report);
                        if (this.enabled == null) {
                            this.enabled = Boolean.TRUE;
                        }
                        if (!this.keepreposdir.booleanValue()) {
                            FileUtils.whack((File)new File(this.env.getApplicationRepositoryPath(), VersioningUtils.getRepositoryName((String)this.name)));
                        }
                        if (DeploymentUtils.isDomainTarget((String)this.target) || !this.enabled.booleanValue()) break block91;
                        try {
                            this.versioningService.handleDisable(this.name, this.target, report);
                        }
                        catch (VersioningSyntaxException e) {
                            report.failure(logger, e.getMessage());
                            Object var27_15 = null;
                            try {
                                archive.close();
                            }
                            catch (IOException e2) {
                                logger.log(Level.FINE, localStrings.getLocalString("errClosingArtifact", "Error while closing deployable artifact : ", new Object[]{this.path.getAbsolutePath()}), e2);
                            }
                            if (tracing != null) {
                                tracing.print(System.out);
                                TracingUtilities.dump((String)"org.glassfish.javaee.core.deployment.DolProvider", (PrintStream)System.out);
                            }
                            if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                                report.setResultType(String.class, (Object)this.name);
                                report.setMessage(localStrings.getLocalString("deploy.command.success", "Application deployed with name {0}", new Object[]{this.name}));
                                logger.info(localStrings.getLocalString("deploy.done", "Deployment of {0} done is {1} ms", new Object[]{this.name, timing.elapsed()}));
                            } else if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
                                String errorMessage = report.getMessage();
                                Throwable cause = report.getFailureCause();
                                if (cause != null) {
                                    String causeMessage = cause.getMessage();
                                    if (causeMessage != null && !causeMessage.equals(errorMessage)) {
                                        errorMessage = errorMessage + " : " + cause.getMessage();
                                    }
                                    logger.log(Level.SEVERE, errorMessage, cause.getCause());
                                }
                                report.setMessage(localStrings.getLocalString("deploy.errDuringDepl", "Error occur during deployment: {0}.", new Object[]{errorMessage}));
                                report.setFailureCause(null);
                                if (expansionDir != null) {
                                    FileUtils.whack((File)expansionDir);
                                }
                            }
                            Object var32_39 = null;
                            this.events.unregister((EventListener)this);
                            return;
                        }
                    }
                    File source = new File(archive.getURI().getSchemeSpecificPart());
                    isDirectoryDeployed = true;
                    if (!source.isDirectory()) {
                        isDirectoryDeployed = false;
                        this.path = expansionDir = new File(this.domain.getApplicationRoot(), this.name);
                        break block93;
                    }
                    String versionFromSameDir = this.versioningService.getVersionFromSameDir(source);
                    if (this.force.booleanValue() || versionFromSameDir == null) break block93;
                    report.failure(logger, VersioningUtils.LOCALSTRINGS.getLocalString("versioning.deployment.dual.inplace", "GlassFish do not support versioning for directory deployment when using the same directory. The directory {0} is already assigned to the version {1}.", new Object[]{source.getPath(), versionFromSameDir}));
                    Object var27_16 = null;
                    try {
                        archive.close();
                    }
                    catch (IOException e2) {
                        logger.log(Level.FINE, localStrings.getLocalString("errClosingArtifact", "Error while closing deployable artifact : ", new Object[]{this.path.getAbsolutePath()}), e2);
                    }
                    if (tracing != null) {
                        tracing.print(System.out);
                        TracingUtilities.dump((String)"org.glassfish.javaee.core.deployment.DolProvider", (PrintStream)System.out);
                    }
                    if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                        report.setResultType(String.class, (Object)this.name);
                        report.setMessage(localStrings.getLocalString("deploy.command.success", "Application deployed with name {0}", new Object[]{this.name}));
                        logger.info(localStrings.getLocalString("deploy.done", "Deployment of {0} done is {1} ms", new Object[]{this.name, timing.elapsed()}));
                        break block95;
                    }
                    if (!report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) break block95;
                    String errorMessage = report.getMessage();
                    Throwable cause = report.getFailureCause();
                    if (cause != null) {
                        String causeMessage = cause.getMessage();
                        if (causeMessage != null && !causeMessage.equals(errorMessage)) {
                            errorMessage = errorMessage + " : " + cause.getMessage();
                        }
                        logger.log(Level.SEVERE, errorMessage, cause.getCause());
                    }
                    report.setMessage(localStrings.getLocalString("deploy.errDuringDepl", "Error occur during deployment: {0}.", new Object[]{errorMessage}));
                    report.setFailureCause(null);
                    if (expansionDir == null) break block95;
                    FileUtils.whack((File)expansionDir);
                }
            }
            Object var32_40 = null;
            this.events.unregister((EventListener)this);
            {
                block96: {
                    block93: {
                        return;
                    }
                    ExtendedDeploymentContext deploymentContext = this.deployment.getBuilder(logger, (OpsParams)this, report).source(archive).archiveHandler(archiveHandler).build((ExtendedDeploymentContext)initialContext);
                    if (tracing != null) {
                        tracing.addMark(DeploymentTracing.Mark.CONTEXT_CREATED);
                        deploymentContext.addModuleMetaData((Object)tracing);
                    }
                    if (undeployProps != null) {
                        deploymentContext.getAppProps().putAll((Map<?, ?>)undeployProps);
                    }
                    if (this.properties != null || this.property != null) {
                        if (this.properties == null) {
                            this.properties = new Properties();
                        }
                        if (this.property != null) {
                            this.properties.putAll((Map<?, ?>)this.property);
                        }
                    }
                    if (this.properties != null) {
                        deploymentContext.getAppProps().putAll((Map<?, ?>)this.properties);
                        this.validateDeploymentProperties(this.properties, (DeploymentContext)deploymentContext);
                    }
                    deploymentContext.clean();
                    Properties appProps = deploymentContext.getAppProps();
                    String appLocation = DeploymentUtils.relativizeWithinDomainIfPossible((URI)deploymentContext.getSource().getURI());
                    appProps.setProperty("location", appLocation);
                    appProps.setProperty("object-type", "user");
                    if (this.contextroot != null) {
                        appProps.setProperty("context-root", this.contextroot);
                    }
                    appProps.setProperty("directory-deployed", String.valueOf(isDirectoryDeployed));
                    savedAppConfig.store(appProps);
                    deploymentContext.addTransientAppMetaData("previousTargets", this.previousTargets);
                    deploymentContext.addTransientAppMetaData("previousVirtualServers", (Object)this.previousVirtualServers);
                    deploymentContext.addTransientAppMetaData("previousEnabledAttributes", (Object)this.previousEnabledAttributes);
                    Transaction t = this.deployment.prepareAppConfigChanges((DeploymentContext)deploymentContext);
                    if (tracing != null) {
                        tracing.addMark(DeploymentTracing.Mark.DEPLOY);
                    }
                    ApplicationInfo appInfo = this.type == null ? this.deployment.deploy(deploymentContext) : this.deployment.deploy((Collection)this.deployment.prepareSniffersForOSGiDeployment(this.type, (DeploymentContext)deploymentContext), deploymentContext);
                    Artifacts downloadableArtifacts = DeploymentUtils.downloadableArtifacts((DeploymentContext)deploymentContext);
                    Artifacts generatedArtifacts = DeploymentUtils.generatedArtifacts((DeploymentContext)deploymentContext);
                    if (report.getActionExitCode() == ActionReport.ExitCode.SUCCESS) {
                        try {
                            this.moveAppFilesToPermanentLocation(deploymentContext, logger);
                            this.recordFileLocations(appProps);
                            downloadableArtifacts.record(appProps);
                            generatedArtifacts.record(appProps);
                            this.deployment.registerAppInDomainXML(appInfo, (DeploymentContext)deploymentContext, t);
                            suppInfo.setDeploymentContext((DeploymentContext)deploymentContext);
                        }
                        catch (Exception e) {
                            this.deployment.undeploy(this.name, deploymentContext);
                            deploymentContext.clean();
                            throw e;
                        }
                    }
                    if (tracing != null) {
                        tracing.addMark(DeploymentTracing.Mark.REGISTRATION);
                    }
                    if (this.retrieve == null) break block96;
                    DeployCommand.retrieveArtifacts(context, downloadableArtifacts.getArtifacts(), this.retrieve, false);
                }
                Object var27_17 = null;
                try {
                    archive.close();
                }
                catch (IOException e2) {
                    logger.log(Level.FINE, localStrings.getLocalString("errClosingArtifact", "Error while closing deployable artifact : ", new Object[]{this.path.getAbsolutePath()}), e2);
                }
                if (tracing != null) {
                    tracing.print(System.out);
                    TracingUtilities.dump((String)"org.glassfish.javaee.core.deployment.DolProvider", (PrintStream)System.out);
                }
                if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                    report.setResultType(String.class, (Object)this.name);
                    report.setMessage(localStrings.getLocalString("deploy.command.success", "Application deployed with name {0}", new Object[]{this.name}));
                    logger.info(localStrings.getLocalString("deploy.done", "Deployment of {0} done is {1} ms", new Object[]{this.name, timing.elapsed()}));
                    break block98;
                }
                if (!report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) break block98;
                String errorMessage = report.getMessage();
                Throwable cause = report.getFailureCause();
                if (cause != null) {
                    String causeMessage = cause.getMessage();
                    if (causeMessage != null && !causeMessage.equals(errorMessage)) {
                        errorMessage = errorMessage + " : " + cause.getMessage();
                    }
                    logger.log(Level.SEVERE, errorMessage, cause.getCause());
                }
                report.setMessage(localStrings.getLocalString("deploy.errDuringDepl", "Error occur during deployment: {0}.", new Object[]{errorMessage}));
                report.setFailureCause(null);
                if (expansionDir != null) {
                    FileUtils.whack((File)expansionDir);
                }
                break block98;
                {
                    catch (Throwable e) {
                        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                        report.setMessage(e.getMessage());
                        report.setFailureCause(e);
                        Object var27_18 = null;
                        try {
                            archive.close();
                        }
                        catch (IOException e2) {
                            logger.log(Level.FINE, localStrings.getLocalString("errClosingArtifact", "Error while closing deployable artifact : ", new Object[]{this.path.getAbsolutePath()}), e2);
                        }
                        if (tracing != null) {
                            tracing.print(System.out);
                            TracingUtilities.dump((String)"org.glassfish.javaee.core.deployment.DolProvider", (PrintStream)System.out);
                        }
                        if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                            report.setResultType(String.class, (Object)this.name);
                            report.setMessage(localStrings.getLocalString("deploy.command.success", "Application deployed with name {0}", new Object[]{this.name}));
                            logger.info(localStrings.getLocalString("deploy.done", "Deployment of {0} done is {1} ms", new Object[]{this.name, timing.elapsed()}));
                        } else if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
                            errorMessage = report.getMessage();
                            cause = report.getFailureCause();
                            if (cause != null) {
                                String causeMessage = cause.getMessage();
                                if (causeMessage != null && !causeMessage.equals(errorMessage)) {
                                    errorMessage = errorMessage + " : " + cause.getMessage();
                                }
                                logger.log(Level.SEVERE, errorMessage, cause.getCause());
                            }
                            report.setMessage(localStrings.getLocalString("deploy.errDuringDepl", "Error occur during deployment: {0}.", new Object[]{errorMessage}));
                            report.setFailureCause(null);
                            if (expansionDir != null) {
                                FileUtils.whack(expansionDir);
                            }
                        }
                        break block98;
                    }
                }
                catch (Throwable throwable) {
                    Object var27_19 = null;
                    try {
                        archive.close();
                    }
                    catch (IOException e2) {
                        logger.log(Level.FINE, localStrings.getLocalString("errClosingArtifact", "Error while closing deployable artifact : ", new Object[]{this.path.getAbsolutePath()}), e2);
                    }
                    if (tracing != null) {
                        tracing.print(System.out);
                        TracingUtilities.dump((String)"org.glassfish.javaee.core.deployment.DolProvider", (PrintStream)System.out);
                    }
                    if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                        report.setResultType(String.class, (Object)this.name);
                        report.setMessage(localStrings.getLocalString("deploy.command.success", "Application deployed with name {0}", new Object[]{this.name}));
                        logger.info(localStrings.getLocalString("deploy.done", "Deployment of {0} done is {1} ms", new Object[]{this.name, timing.elapsed()}));
                    } else if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
                        errorMessage = report.getMessage();
                        cause = report.getFailureCause();
                        if (cause != null) {
                            String causeMessage = cause.getMessage();
                            if (causeMessage != null && !causeMessage.equals(errorMessage)) {
                                errorMessage = errorMessage + " : " + cause.getMessage();
                            }
                            logger.log(Level.SEVERE, errorMessage, cause.getCause());
                        }
                        report.setMessage(localStrings.getLocalString("deploy.errDuringDepl", "Error occur during deployment: {0}.", new Object[]{errorMessage}));
                        report.setFailureCause(null);
                        if (expansionDir != null) {
                            FileUtils.whack(expansionDir);
                        }
                    }
                    throw throwable;
                }
            }
        }
        Object var32_41 = null;
        this.events.unregister((EventListener)this);
    }

    private void moveAppFilesToPermanentLocation(ExtendedDeploymentContext deploymentContext, Logger logger) throws IOException {
        File finalUploadDir = deploymentContext.getAppInternalDir();
        finalUploadDir.mkdirs();
        this.safeCopyOfApp = this.renameUploadedFileOrCopyInPlaceFile(finalUploadDir, this.originalPathValue, logger);
        this.safeCopyOfDeploymentPlan = this.renameUploadedFileOrCopyInPlaceFile(finalUploadDir, this.deploymentplan, logger);
    }

    private File renameUploadedFileOrCopyInPlaceFile(File finalUploadDir, File fileParam, Logger logger) throws IOException {
        if (fileParam == null) {
            return null;
        }
        File appsDir = this.env.getApplicationRepositoryPath();
        File result = fileParam;
        if (!fileParam.isDirectory() && !appsDir.toURI().relativize(fileParam.toURI()).isAbsolute()) {
            result = new File(finalUploadDir, fileParam.getName());
            FileUtils.renameFile((File)fileParam, (File)result);
            result.setLastModified(fileParam.lastModified());
        } else {
            boolean copyInPlaceArchive = Boolean.valueOf(System.getProperty(COPY_IN_PLACE_ARCHIVE_PROP_NAME, "true"));
            if (!fileParam.isDirectory() && copyInPlaceArchive) {
                long startTime = System.currentTimeMillis();
                result = new File(finalUploadDir, fileParam.getName());
                FileUtils.copy((File)fileParam, (File)result);
                result.setLastModified(fileParam.lastModified());
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "*** In-place archive copy of {0} took {1} ms", new Object[]{fileParam.getAbsolutePath(), System.currentTimeMillis() - startTime});
                }
            }
        }
        return result;
    }

    private void recordFileLocations(Properties appProps) throws URISyntaxException {
        if (this.safeCopyOfApp != null) {
            appProps.setProperty("appLocation", DeploymentUtils.relativizeWithinDomainIfPossible((URI)this.safeCopyOfApp.toURI()));
        }
        if (this.safeCopyOfDeploymentPlan != null) {
            appProps.setProperty("deploymentPlanLocation", DeploymentUtils.relativizeWithinDomainIfPossible((URI)this.safeCopyOfDeploymentPlan.toURI()));
        }
    }

    private Properties handleRedeploy(String name, ActionReport report) throws Exception {
        if (this.isredeploy.booleanValue()) {
            Application app = (Application)this.apps.getModule(Application.class, name);
            this.settingsFromDomainXML(app);
            ParameterMap parameters = new ParameterMap();
            parameters.add((Object)"DEFAULT", (Object)name);
            parameters.add((Object)"target", (Object)this.target);
            parameters.add((Object)"keepreposdir", (Object)this.keepreposdir.toString());
            parameters.add((Object)"isredeploy", (Object)this.isredeploy.toString());
            if (this.dropandcreatetables != null) {
                parameters.add((Object)"droptables", (Object)this.dropandcreatetables.toString());
            }
            parameters.add((Object)"_ignoreCascade", (Object)this.force.toString());
            if (this.keepstate != null) {
                parameters.add((Object)"keepstate", (Object)this.keepstate.toString());
            }
            ActionReport subReport = report.addSubActionsReport();
            subReport.setExtraProperties(new Properties());
            ArrayList<String> propertyNames = new ArrayList<String>();
            propertyNames.add("keepSessions");
            propertyNames.add("preserveAppScopedResources");
            this.populatePropertiesToParameterMap(parameters, propertyNames);
            CommandRunner.CommandInvocation inv = this.commandRunner.getCommandInvocation("undeploy", subReport);
            inv.parameters(parameters).execute();
            return subReport.getExtraProperties();
        }
        return null;
    }

    private void populatePropertiesToParameterMap(ParameterMap parameters, List<String> propertyNamesList) {
        Properties props = new Properties();
        if (this.properties != null) {
            for (String propertyName : propertyNamesList) {
                if (!this.properties.containsKey(propertyName)) continue;
                props.put(propertyName, this.properties.getProperty(propertyName));
            }
        }
        parameters.add((Object)"properties", (Object)DeploymentUtils.propertiesValue((Properties)props, (char)':'));
    }

    public static void retrieveArtifacts(AdminCommandContext context, Application app, String targetLocalDir) {
        DeployCommand.retrieveArtifacts(context, app, targetLocalDir, true);
    }

    public static void retrieveArtifacts(AdminCommandContext context, Application app, String targetLocalDir, boolean reportErrorsInTopReport) {
        DeployCommand.retrieveArtifacts(context, DeploymentUtils.downloadableArtifacts((Application)app).getArtifacts(), targetLocalDir, reportErrorsInTopReport);
    }

    private static void retrieveArtifacts(AdminCommandContext context, Collection<Artifacts.FullAndPartURIs> artifactInfo, String targetLocalDir, boolean reportErrorsInTopReport) {
        Logger logger = context.getLogger();
        try {
            Payload.Outbound outboundPayload = context.getOutboundPayload();
            Properties props = new Properties();
            props.setProperty("file-xfer-root", targetLocalDir.replace('\\', '/'));
            for (Artifacts.FullAndPartURIs uriPair : artifactInfo) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "About to download artifact {0}", uriPair.getFull());
                }
                outboundPayload.attachFile("application/octet-stream", uriPair.getPart(), "files", props, new File(uriPair.getFull().getSchemeSpecificPart()));
            }
        }
        catch (Exception e) {
            String errorMsg = localStrings.getLocalString("download.errDownloading", "Error while downloading generated files");
            logger.log(Level.SEVERE, errorMsg, e);
            ActionReport report = context.getActionReport();
            if (!reportErrorsInTopReport) {
                report = report.addSubActionsReport();
                report.setActionExitCode(ActionReport.ExitCode.WARNING);
            } else {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            }
            report.setMessage(errorMsg);
            report.setFailureCause((Throwable)e);
        }
    }

    private void settingsFromDomainXML(Application app) {
        if (this.name != null) {
            String compatProp;
            if (this.contextroot == null && app.getContextRoot() != null) {
                this.previousContextRoot = app.getContextRoot();
            }
            if (this.libraries == null) {
                this.libraries = app.getLibraries();
            }
            this.previousTargets = this.domain.getAllReferencedTargetsForApplication(this.name);
            if (this.virtualservers == null) {
                if (DeploymentUtils.isDomainTarget((String)this.target)) {
                    for (String tgt : this.previousTargets) {
                        String vs = this.domain.getVirtualServersForApplication(tgt, this.name);
                        if (vs == null) continue;
                        this.previousVirtualServers.put(tgt, vs);
                    }
                } else {
                    this.virtualservers = this.domain.getVirtualServersForApplication(this.target, this.name);
                }
            }
            if (this.enabled == null) {
                if (DeploymentUtils.isDomainTarget((String)this.target)) {
                    for (String tgt : this.previousTargets) {
                        this.previousEnabledAttributes.put(tgt, this.domain.getEnabledForApplication(tgt, this.name));
                    }
                    this.previousEnabledAttributes.put("domain", app.getEnabled());
                    this.enabled = this.deployment.isAppEnabled(app);
                } else {
                    this.enabled = Boolean.valueOf(this.domain.getEnabledForApplication(this.target, this.name));
                }
            }
            if ((compatProp = app.getDeployProperties().getProperty("compatibility")) != null) {
                if (this.properties == null) {
                    this.properties = new Properties();
                }
                if (this.properties.getProperty("compatibility") == null) {
                    this.properties.setProperty("compatibility", compatProp);
                }
            }
        }
    }

    public void event(EventListener.Event event) {
        if (event.is(Deployment.DEPLOYMENT_BEFORE_CLASSLOADER_CREATION)) {
            DeploymentContext context = (DeploymentContext)event.hook();
            if (this.verify.booleanValue()) {
                Verifier verifier = (Verifier)this.habitat.getByContract(Verifier.class);
                if (verifier != null) {
                    verifier.verify(context);
                } else {
                    context.getLogger().warning("Verifier is not installed yet. Install verifier module.");
                }
            }
        }
    }

    private void validateDeploymentProperties(Properties properties, DeploymentContext context) {
        String compatProp = properties.getProperty("compatibility");
        if (compatProp != null && !compatProp.equals("v2")) {
            String warningMsg = localStrings.getLocalString("compat.value.not.supported", "{0} is not a supported value for compatibility property.", new Object[]{compatProp});
            ActionReport subReport = context.getActionReport().addSubActionsReport();
            subReport.setActionExitCode(ActionReport.ExitCode.WARNING);
            subReport.setMessage(warningMsg);
            context.getLogger().log(Level.WARNING, warningMsg);
        }
    }
}

