/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.tcp.OutputBuffer;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.http11.Constants;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.websockets.HandShake;
import com.sun.grizzly.websockets.HandshakeException;
import com.sun.grizzly.websockets.SecKey;
import java.io.IOException;

public class ServerHandShake
extends HandShake {
    private final byte[] serverSecKey;

    public ServerHandShake(boolean secure, String origin, String serverHostName, String port, String resourcePath, String subProtocol, SecKey key1, SecKey key2, byte[] key3) throws HandshakeException {
        super(secure, origin, serverHostName, port, resourcePath);
        this.setSubProtocol(subProtocol);
        this.serverSecKey = key3 == null ? null : SecKey.generateServerKey(key1, key2, key3);
    }

    public byte[] getKey() {
        return this.serverSecKey;
    }

    public void respond(Response response) throws IOException {
        response.setStatus(101);
        response.setMessage("Web Socket Protocol Handshake");
        response.setHeader("Upgrade", "WebSocket");
        response.setHeader("Connection", "Upgrade");
        if (this.serverSecKey == null) {
            response.setHeader("WebSocket-Origin", this.getOrigin());
            response.setHeader("WebSocket-Location", this.getLocation());
            if (this.getSubProtocol() != null) {
                response.setHeader("WebSocket-Protocol", this.getSubProtocol());
            }
        } else {
            response.setHeader("Sec-WebSocket-Origin", this.getOrigin());
            response.setHeader("Sec-WebSocket-Location", this.getLocation());
            if (this.getSubProtocol() != null) {
                response.setHeader("Sec-WebSocket-Protocol", this.getSubProtocol());
            }
        }
        response.sendHeaders();
        if (this.serverSecKey != null) {
            OutputBuffer buffer = response.getOutputBuffer();
            ByteChunk chunk = new ByteChunk(this.serverSecKey.length + Constants.CRLF_BYTES.length);
            chunk.append(this.serverSecKey, 0, this.serverSecKey.length);
            buffer.doWrite(chunk, response);
        }
        response.flush();
    }
}

