/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.tools.schemaframework.DatabaseObjectDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexDefinition
extends DatabaseObjectDefinition {
    protected String targetTable;
    protected List<String> fields = new ArrayList<String>();
    protected boolean isUnique;

    public boolean isUnique() {
        return this.isUnique;
    }

    public void setIsUnique(boolean isUnique) {
        this.isUnique = isUnique;
    }

    public String getTargetTable() {
        return this.targetTable;
    }

    public void setTargetTable(String targetTable) {
        this.targetTable = targetTable;
    }

    public void addField(String fieldName) {
        this.fields.add(fieldName);
    }

    @Override
    public Writer buildCreationWriter(AbstractSession session, Writer writer) throws ValidationException {
        try {
            if (this.isUnique()) {
                writer.write("CREATE UNIQUE INDEX ");
            } else {
                writer.write("CREATE INDEX ");
            }
            writer.write(this.getFullName() + " ON " + this.getTargetTable() + " (");
            Iterator<String> iterator = this.fields.iterator();
            while (iterator.hasNext()) {
                String field = iterator.next();
                writer.write(field);
                if (!iterator.hasNext()) continue;
                writer.write(", ");
            }
            writer.write(")");
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    @Override
    public Writer buildDeletionWriter(AbstractSession session, Writer writer) throws ValidationException {
        try {
            writer.write("DROP INDEX " + this.getFullName());
            if (session.getPlatform().requiresTableInIndexDropDDL()) {
                writer.write(" ON " + this.getTargetTable());
            }
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public void setFields(List<String> fields) {
        this.fields = fields;
    }
}

