/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.util;

import com.sun.appserv.connectors.internal.api.ConnectorConstants;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.logging.LogDomains;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Modifier;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class DriverLoader
implements ConnectorConstants {
    private static Logger logger = LogDomains.getLogger(DriverLoader.class, (String)"javax.enterprise.resource.resourceadapter");
    private static final String DRIVER_INTERFACE_NAME = "java.sql.Driver";
    private static final String SERVICES_DRIVER_IMPL_NAME = "META-INF/services/java.sql.Driver";
    private static final String DATABASE_VENDOR_DERBY = "DERBY";
    private static final String DATABASE_VENDOR_JAVADB = "JAVADB";
    private static final String DATABASE_VENDOR_EMBEDDED_DERBY = "EMBEDDED-DERBY";
    private static final String DATABASE_VENDOR_MSSQLSERVER = "MICROSOFTSQLSERVER";
    private String DATABASE_VENDOR_SUN_SQLSERVER = "SUN-SQLSERVER";
    private String DATABASE_VENDOR_SUN_ORACLE = "SUN-ORACLE";
    private String DATABASE_VENDOR_SUN_DB2 = "SUN-DB2";
    private String DATABASE_VENDOR_SUN_SYBASE = "SUN-SYBASE";
    private String DATABASE_VENDOR_SYBASE = "SYBASE";
    private String DATABASE_VENDOR_ORACLE = "ORACLE";
    private String DATABASE_VENDOR_DB2 = "DB2";
    private String DATABASE_VENDOR_EMBEDDED = "EMBEDDED";
    private String DATABASE_VENDOR_30 = "30";
    private String DATABASE_VENDOR_40 = "40";
    private static final String DATABASE_VENDOR_SQLSERVER = "SQLSERVER";
    private static final String DBVENDOR_MAPPINGS_ROOT = System.getProperty("com.sun.aas.installRoot") + File.separator + "lib" + File.separator + "install" + File.separator + "databases" + File.separator + "dbvendormapping" + File.separator;
    private final String DS_PROPERTIES = "ds.properties";
    private final String CPDS_PROPERTIES = "cpds.properties";
    private final String XADS_PROPERTIES = "xads.properties";
    private final String DRIVER_PROPERTIES = "driver.properties";
    private final String VENDOR_PROPERTIES = "dbvendor.properties";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getDatabaseVendorNames() {
        TreeSet<String> dbvendorNames;
        Properties fileProperties;
        block9: {
            File dbVendorFile = new File(DBVENDOR_MAPPINGS_ROOT + "dbvendor.properties");
            fileProperties = new Properties();
            dbvendorNames = new TreeSet<String>();
            if (dbVendorFile != null && dbVendorFile.exists()) {
                try {
                    FileInputStream fis = new FileInputStream(dbVendorFile);
                    try {
                        fileProperties.load(fis);
                        break block9;
                    }
                    finally {
                        fis.close();
                    }
                }
                catch (IOException ioe) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("IO Exception during properties load : " + dbVendorFile.getAbsolutePath());
                    }
                    break block9;
                }
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("File not found : " + dbVendorFile.getAbsolutePath());
            }
        }
        Enumeration<?> e = fileProperties.propertyNames();
        while (e.hasMoreElements()) {
            String vendor = (String)e.nextElement();
            dbvendorNames.add(vendor);
        }
        return dbvendorNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getImplClassNameFromMapping(String dbVendor, String resType) {
        Properties fileProperties;
        block15: {
            File mappingFile = null;
            fileProperties = new Properties();
            if ("javax.sql.DataSource".equals(resType)) {
                mappingFile = new File(DBVENDOR_MAPPINGS_ROOT + "ds.properties");
            } else if ("javax.sql.XADataSource".equals(resType)) {
                mappingFile = new File(DBVENDOR_MAPPINGS_ROOT + "xads.properties");
            } else if ("javax.sql.ConnectionPoolDataSource".equals(resType)) {
                mappingFile = new File(DBVENDOR_MAPPINGS_ROOT + "cpds.properties");
            } else if (DRIVER_INTERFACE_NAME.equals(resType)) {
                mappingFile = new File(DBVENDOR_MAPPINGS_ROOT + "driver.properties");
            }
            if (mappingFile != null && mappingFile.exists()) {
                try {
                    FileInputStream fis = new FileInputStream(mappingFile);
                    try {
                        fileProperties.load(fis);
                        break block15;
                    }
                    finally {
                        fis.close();
                    }
                }
                catch (IOException ioe) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("IO Exception during properties load : " + mappingFile.getAbsolutePath());
                    }
                    break block15;
                }
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("File not found : " + mappingFile.getAbsolutePath());
            }
        }
        return fileProperties.getProperty(dbVendor.toUpperCase());
    }

    private String getEquivalentName(String dbVendor) {
        if (dbVendor.toUpperCase().startsWith(DATABASE_VENDOR_JAVADB) || dbVendor.equalsIgnoreCase(DATABASE_VENDOR_EMBEDDED_DERBY)) {
            return DATABASE_VENDOR_DERBY;
        }
        if (dbVendor.equalsIgnoreCase(DATABASE_VENDOR_MSSQLSERVER) || dbVendor.equalsIgnoreCase(this.DATABASE_VENDOR_SUN_SQLSERVER)) {
            return DATABASE_VENDOR_SQLSERVER;
        }
        if (dbVendor.equalsIgnoreCase(this.DATABASE_VENDOR_SUN_DB2)) {
            return this.DATABASE_VENDOR_DB2;
        }
        if (dbVendor.equalsIgnoreCase(this.DATABASE_VENDOR_SUN_ORACLE)) {
            return this.DATABASE_VENDOR_ORACLE;
        }
        if (dbVendor.equalsIgnoreCase(this.DATABASE_VENDOR_SUN_SYBASE)) {
            return this.DATABASE_VENDOR_SYBASE;
        }
        return null;
    }

    public Set<String> getJdbcDriverClassNames(String dbVendor, String resType) {
        return this.getJdbcDriverClassNames(dbVendor, resType, false);
    }

    public Set<String> getJdbcDriverClassNames(String dbVendor, String resType, boolean introspect) {
        String implClass;
        Set<Object> implClassNames = new TreeSet();
        TreeSet<String> allImplClassNames = new TreeSet<String>();
        String vendor = null;
        if (dbVendor != null && (vendor = this.getEquivalentName(dbVendor = dbVendor.trim().replaceAll(" ", ""))) == null) {
            vendor = dbVendor;
        }
        if (!introspect && (implClass = this.getImplClassNameFromMapping(dbVendor, resType)) != null) {
            allImplClassNames.add(implClass);
            return allImplClassNames;
        }
        List<File> jarFileLocations = this.getJdbcDriverLocations();
        HashSet<File> allJars = new HashSet<File>();
        if (jarFileLocations != null) {
            for (File lib : jarFileLocations) {
                if (!lib.isDirectory()) continue;
                for (File file : lib.listFiles(new JarFileFilter())) {
                    allJars.add(file);
                }
            }
        }
        for (File file : allJars) {
            if (!file.isFile()) continue;
            if (vendor != null) {
                implClassNames = this.introspectAndLoadJar(file, resType, vendor, dbVendor);
            }
            if (implClassNames.isEmpty()) continue;
            for (String className : implClassNames) {
                allImplClassNames.add(className);
            }
        }
        return allImplClassNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getImplClassesByIteration(File f, String resType, String dbVendor, String origDbVendor) {
        TreeSet<String> implClassNames = new TreeSet<String>();
        String implClass = null;
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(f);
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry zipEntry = e.nextElement();
                if (zipEntry == null) continue;
                String entry = zipEntry.getName();
                if (DRIVER_INTERFACE_NAME.equals(resType) && SERVICES_DRIVER_IMPL_NAME.equals(entry)) {
                    InputStream metaInf = jarFile.getInputStream(zipEntry);
                    implClass = this.processMetaInf(metaInf);
                    if (implClass != null && this.isLoaded(implClass, resType) && this.isVendorSpecific(f, dbVendor, implClass, origDbVendor)) {
                        implClassNames.add(implClass);
                    }
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("Driver loader : implClass = " + implClass);
                    }
                }
                if (!entry.endsWith(".class") || entry.toUpperCase().indexOf("DATASOURCE") == -1 && entry.toUpperCase().indexOf("DRIVER") == -1 || (implClass = this.getClassName(entry)) == null || !this.isLoaded(implClass, resType) || !this.isVendorSpecific(f, dbVendor, implClass, origDbVendor)) continue;
                implClassNames.add(implClass);
            }
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Error while getting Jdbc driver classnames ", ex);
        }
        finally {
            block17: {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException ex) {
                        if (!logger.isLoggable(Level.FINE)) break block17;
                        logger.log(Level.FINE, "Exception while closing JarFile '" + jarFile.getName() + "' :", ex);
                    }
                }
            }
        }
        return implClassNames;
    }

    private Vector getLibExtDirs() {
        String extDirStr = System.getProperty("java.ext.dirs");
        logger.log(Level.FINE, "lib/ext dirs : " + extDirStr);
        Vector<String> extDirs = new Vector<String>();
        StringTokenizer st = new StringTokenizer(extDirStr, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Ext Dir : " + token);
            }
            extDirs.addElement(token);
        }
        return extDirs;
    }

    private Set<String> introspectAndLoadJar(File f, String resType, String dbVendor, String origDbVendor) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("DriverLoader : introspectAndLoadJar ");
        }
        return this.getImplClassesByIteration(f, resType, dbVendor, origDbVendor);
    }

    private boolean isNotAbstract(Class cls) {
        int modifier = cls.getModifiers();
        return !Modifier.isAbstract(modifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String processMetaInf(InputStream metaInf) {
        String driverClassName = null;
        InputStreamReader reader = null;
        BufferedReader buffReader = null;
        try {
            String line;
            reader = new InputStreamReader(metaInf);
            buffReader = new BufferedReader(reader);
            while ((line = buffReader.readLine()) != null) {
                driverClassName = line;
            }
        }
        catch (IOException ioex) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("DriverLoader : exception while processing META-INF directory for DriverClassName " + ioex);
            }
        }
        finally {
            block23: {
                block22: {
                    try {
                        if (buffReader != null) {
                            buffReader.close();
                        }
                    }
                    catch (IOException ex) {
                        if (!logger.isLoggable(Level.FINE)) break block22;
                        logger.log(Level.FINE, "Error while closing File handles after reading META-INF files : ", ex);
                    }
                }
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException ex) {
                    if (!logger.isLoggable(Level.FINE)) break block23;
                    logger.log(Level.FINE, "Error while closing File handles after reading META-INF files : ", ex);
                }
            }
        }
        return driverClassName;
    }

    private boolean isLoaded(String classname, String resType) {
        Class cls = null;
        try {
            cls = ConnectorRuntime.getRuntime().getConnectorClassLoader().loadClass(classname);
        }
        catch (Exception ex) {
            cls = null;
        }
        catch (Throwable t) {
            cls = null;
        }
        return this.isResType(cls, resType);
    }

    private boolean isResType(Class cls, String resType) {
        boolean isResType = false;
        if (cls != null) {
            if ("javax.sql.DataSource".equals(resType)) {
                if (DataSource.class.isAssignableFrom(cls)) {
                    isResType = this.isNotAbstract(cls);
                }
            } else if ("javax.sql.ConnectionPoolDataSource".equals(resType)) {
                if (ConnectionPoolDataSource.class.isAssignableFrom(cls)) {
                    isResType = this.isNotAbstract(cls);
                }
            } else if ("javax.sql.XADataSource".equals(resType)) {
                if (XADataSource.class.isAssignableFrom(cls)) {
                    isResType = this.isNotAbstract(cls);
                }
            } else if (DRIVER_INTERFACE_NAME.equals(resType) && Driver.class.isAssignableFrom(cls)) {
                isResType = this.isNotAbstract(cls);
            }
        }
        return isResType;
    }

    private String getClassName(String classname) {
        classname = classname.replaceAll("/", ".");
        classname = classname.substring(0, classname.lastIndexOf(".class"));
        return classname;
    }

    private boolean isVendorSpecific(File f, String dbVendor, String className, String origDbVendor) {
        String vendor;
        boolean isVendorSpecific = false;
        if (origDbVendor != null) {
            if (origDbVendor.equalsIgnoreCase(DATABASE_VENDOR_EMBEDDED_DERBY)) {
                return className.toUpperCase().indexOf(this.DATABASE_VENDOR_EMBEDDED) != -1;
            }
            if (origDbVendor.endsWith(this.DATABASE_VENDOR_30)) {
                return !className.toUpperCase().endsWith(this.DATABASE_VENDOR_40);
            }
        }
        if ((vendor = this.getVendorFromManifest(f)) == null) {
            if (this.isVendorSpecific(dbVendor, className)) {
                isVendorSpecific = true;
            }
        } else if (vendor.equalsIgnoreCase(dbVendor) || vendor.toUpperCase().indexOf(dbVendor.toUpperCase()) != -1) {
            isVendorSpecific = true;
        }
        return isVendorSpecific;
    }

    private List<File> getJdbcDriverLocations() {
        ArrayList<File> jarFileLocations = new ArrayList<File>();
        jarFileLocations.add(this.getLocation("com.sun.aas.derbyRoot"));
        jarFileLocations.add(this.getLocation("com.sun.aas.installRoot"));
        jarFileLocations.add(this.getLocation("com.sun.aas.instanceRoot"));
        Vector extLibDirs = this.getLibExtDirs();
        for (int i = 0; i < extLibDirs.size(); ++i) {
            jarFileLocations.add(new File((String)extLibDirs.elementAt(i)));
        }
        return jarFileLocations;
    }

    private File getLocation(String property) {
        return new File(System.getProperty(property) + File.separator + "lib");
    }

    private boolean isVendorSpecific(String dbVendor, String className) {
        return className.toUpperCase().indexOf(dbVendor.toUpperCase()) != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getVendorFromManifest(File f) {
        String vendor = null;
        JarFile jarFile = null;
        try {
            Attributes mainAttributes;
            jarFile = new JarFile(f);
            Manifest manifest = jarFile.getManifest();
            if (manifest != null && (mainAttributes = manifest.getMainAttributes()) != null && (vendor = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR.toString())) == null) {
                vendor = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR_ID.toString());
            }
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Exception while reading manifest file : ", ex);
        }
        finally {
            block14: {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException ex) {
                        if (!logger.isLoggable(Level.FINE)) break block14;
                        logger.log(Level.FINE, "Exception while closing JarFile '" + jarFile.getName() + "' :", ex);
                    }
                }
            }
        }
        return vendor;
    }

    private static class JarFileFilter
    implements FilenameFilter {
        private final String JAR_EXT = ".jar";

        private JarFileFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(".jar");
        }
    }
}

