/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.cli;

import com.sun.enterprise.config.serverbeans.Config;
import java.beans.PropertyVetoException;
import org.glassfish.admin.rest.RestConfig;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="_set-rest-admin-config")
@Scoped(value=PerLookup.class)
public class SetRestConfig
implements AdminCommand {
    @Inject(name="default-instance-name")
    Config config;
    @Inject
    private Habitat habitat;
    @Param(optional=true)
    private String debug;
    @Param(optional=true, defaultValue="-100")
    private int indentLevel;
    @Param(optional=true)
    private String wadlGeneration;
    @Param(optional=true)
    private String showHiddenCommands;
    @Param(optional=true)
    private String showDeprecatedItems;
    @Param(optional=true)
    private String logOutput;
    @Param(optional=true)
    private String logInput;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        RestConfig restConfig = (RestConfig)this.config.getExtensionByType(RestConfig.class);
        if (restConfig == null) {
            try {
                ConfigSupport.apply(new SingleConfigCode<Config>(){

                    @Override
                    public Object run(Config parent) throws TransactionFailure {
                        RestConfig child = (RestConfig)((Object)parent.createChild(RestConfig.class));
                        parent.getContainers().add(child);
                        return child;
                    }
                }, this.config);
            }
            catch (TransactionFailure e) {
                report.setMessage("TransactionFailure failure while creating the REST config");
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause((Throwable)e);
                return;
            }
            restConfig = (RestConfig)this.config.getExtensionByType(RestConfig.class);
            if (restConfig == null) {
                report.setMessage("Rest Config is NULL...");
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        try {
            ConfigSupport.apply(new SingleConfigCode<RestConfig>(){

                @Override
                public Object run(RestConfig param) throws TransactionFailure, PropertyVetoException {
                    if (SetRestConfig.this.debug != null) {
                        param.setDebug(SetRestConfig.this.debug);
                    }
                    if (SetRestConfig.this.indentLevel != -100) {
                        param.setIndentLevel("" + SetRestConfig.this.indentLevel);
                    }
                    if (SetRestConfig.this.showHiddenCommands != null) {
                        param.setShowHiddenCommands(SetRestConfig.this.showHiddenCommands);
                    }
                    if (SetRestConfig.this.showDeprecatedItems != null) {
                        param.setShowDeprecatedItems(SetRestConfig.this.showDeprecatedItems);
                    }
                    if (SetRestConfig.this.wadlGeneration != null) {
                        param.setWadlGeneration(SetRestConfig.this.wadlGeneration);
                    }
                    if (SetRestConfig.this.logOutput != null) {
                        param.setLogOutput(SetRestConfig.this.logOutput);
                    }
                    if (SetRestConfig.this.logInput != null) {
                        param.setLogInput(SetRestConfig.this.logInput);
                    }
                    return param;
                }
            }, restConfig);
        }
        catch (TransactionFailure e) {
            report.setMessage("TransactionFailure while changing the REST config");
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

