/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.payload;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.Payload;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PayloadFilesManager {
    private static final String XFER_DIR_PREFIX = "xfer-";
    public static final LocalStringManagerImpl strings = new LocalStringManagerImpl(PayloadFilesManager.class);
    private final File targetDir;
    protected final Logger logger;
    private final ActionReport report;
    private final ActionReportHandler reportHandler;
    protected final Map<File, Long> dirTimestamps = new HashMap<File, Long>();

    private PayloadFilesManager(File targetDir, ActionReport report, Logger logger, ActionReportHandler reportHandler) {
        this.targetDir = targetDir;
        this.report = report;
        this.logger = logger;
        this.reportHandler = reportHandler;
    }

    private PayloadFilesManager(File targetDir, ActionReport report, Logger logger) {
        this(targetDir, report, logger, (ActionReportHandler)null);
    }

    protected File getTargetDir() {
        return this.targetDir;
    }

    protected URI getParentURI(Payload.Part part) throws UnsupportedEncodingException {
        File parentFile = this.getTargetDir();
        URI parentFileURI = parentFile.toURI();
        Properties partProps = part.getProperties();
        String parentPathFromPart = partProps.getProperty("file-xfer-root");
        if (parentPathFromPart != null) {
            File xferRootFile;
            if (!parentPathFromPart.endsWith(File.separator)) {
                parentPathFromPart = parentPathFromPart + File.separator;
            }
            parentFile = (xferRootFile = new File(parentPathFromPart)).isAbsolute() ? xferRootFile : new File(parentFile, parentPathFromPart);
            parentFileURI = URI.create(parentFile.toURI().toASCIIString() + (parentFile.exists() ? "" : "/"));
        }
        return parentFileURI;
    }

    protected abstract void postExtract(File var1);

    protected URI getOutputFileURI(Payload.Part part, String name) throws IOException {
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        URI targetURI = this.getParentURI(part).resolve(name);
        return targetURI;
    }

    private File removeFile(Payload.Part part) throws IOException {
        File result = this.removeFileWithoutConsumingPartBody(part);
        this.consumePartBody(part);
        return result;
    }

    private File removeFileWithoutConsumingPartBody(Payload.Part part) throws IOException {
        boolean isFine = this.logger.isLoggable(Level.FINE);
        File targetFile = new File(this.getOutputFileURI(part, part.getName()));
        if (targetFile.exists()) {
            boolean isRemovalRecursive;
            boolean bl = isRemovalRecursive = targetFile.isDirectory() && part.isRecursive();
            if (isRemovalRecursive ? FileUtils.whack(targetFile) : targetFile.delete()) {
                if (isFine) {
                    this.logger.finer("Deleted " + targetFile.getAbsolutePath() + (isRemovalRecursive ? " recursively" : "") + " as requested");
                }
                this.reportDeletionSuccess();
            } else {
                if (isFine) {
                    this.logger.finer("File " + part.getName() + " (" + targetFile.getAbsolutePath() + ") requested for deletion exists but was not able to be deleted");
                }
                this.reportDeletionFailure(part.getName(), strings.getLocalString("payload.deleteFailedOnFile", "Requested deletion of {0} failed; the file was found but the deletion attempt failed - no reason is available"));
            }
        } else {
            if (isFine) {
                this.logger.finer("File " + part.getName() + " (" + targetFile.getAbsolutePath() + ") requested for deletion does not exist.");
            }
            this.reportDeletionFailure(part.getName(), new FileNotFoundException(targetFile.getAbsolutePath()));
        }
        return targetFile;
    }

    private File replaceFile(Payload.Part part) throws IOException {
        boolean isFine = this.logger.isLoggable(Level.FINE);
        this.removeFileWithoutConsumingPartBody(part);
        return this.extractFile(part, part.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consumePartBody(Payload.Part part) throws FileNotFoundException, IOException {
        InputStream is = null;
        try {
            is = part.getInputStream();
            byte[] buffer = new byte[65536];
            while (is.read(buffer) != -1) {
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    private void processReport(Payload.Part part) throws Exception {
        if (this.reportHandler != null) {
            this.reportHandler.handleReport(part.getInputStream());
        } else {
            this.consumePartBody(part);
        }
    }

    private File extractFile(Payload.Part part, String outputName) throws IOException {
        boolean isFine = this.logger.isLoggable(Level.FINE);
        OutputStream os = null;
        InputStream is = null;
        try {
            String lastModifiedString;
            int bytesRead;
            boolean isDir;
            File extractedFile = new File(this.getOutputFileURI(part, outputName));
            File immediateParent = extractedFile.getParentFile();
            immediateParent.mkdirs();
            if (extractedFile.exists()) {
                if (!extractedFile.delete() && !extractedFile.isDirectory()) {
                    this.logger.warning(strings.getLocalString("payload.overwrite", "Overwriting previously-uploaded file because the attempt to delete it failed: {0}", extractedFile.getAbsolutePath()));
                } else if (isFine) {
                    this.logger.finer("Deleted pre-existing file " + extractedFile.getAbsolutePath() + " before extracting transferred file");
                }
            }
            if (outputName.endsWith("/")) {
                extractedFile.mkdir();
            }
            os = (isDir = extractedFile.isDirectory()) ? null : new BufferedOutputStream(new FileOutputStream(extractedFile));
            is = part.getInputStream();
            byte[] buffer = new byte[65536];
            while ((bytesRead = is.read(buffer)) != -1) {
                if (os == null) continue;
                os.write(buffer, 0, bytesRead);
            }
            if (os != null) {
                os.close();
            }
            long lastModified = (lastModifiedString = part.getProperties().getProperty("last-modified")) != null ? Long.parseLong(lastModifiedString) : System.currentTimeMillis();
            extractedFile.setLastModified(lastModified);
            if (extractedFile.isDirectory()) {
                this.dirTimestamps.put(extractedFile, lastModified);
            }
            this.postExtract(extractedFile);
            this.logger.finer("Extracted transferred entry " + part.getName() + " to " + extractedFile.getAbsolutePath());
            this.reportExtractionSuccess();
            File file = extractedFile;
            return file;
        }
        catch (Exception e) {
            this.reportExtractionFailure(part.getName(), e);
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            if (os != null) {
                os.close();
                os = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<File, Properties> processPartsExtended(Payload.Inbound inboundPayload) throws Exception {
        if (inboundPayload == null) {
            return Collections.EMPTY_MAP;
        }
        LinkedHashMap<File, Properties> result = new LinkedHashMap<File, Properties>();
        Object os = null;
        InputStream is = null;
        boolean isReportProcessed = false;
        Payload.Part possibleUnrecognizedReportPart = null;
        try {
            StringBuilder uploadedEntryNames = new StringBuilder();
            Iterator partIt = inboundPayload.parts();
            while (partIt.hasNext()) {
                Payload.Part part = (Payload.Part)partIt.next();
                DataRequestType drt = DataRequestType.getType(part);
                if (drt != null) {
                    result.put(drt.processPart(this, part, part.getName()), part.getProperties());
                    isReportProcessed |= drt == DataRequestType.REPORT;
                    uploadedEntryNames.append(part.getName()).append(" ");
                    continue;
                }
                if (isReportProcessed || possibleUnrecognizedReportPart != null) continue;
                possibleUnrecognizedReportPart = part;
            }
            if (!isReportProcessed && possibleUnrecognizedReportPart != null) {
                DataRequestType.REPORT.processPart(this, possibleUnrecognizedReportPart, possibleUnrecognizedReportPart.getName());
                isReportProcessed = true;
            }
            this.postProcessParts();
            LinkedHashMap<File, Properties> linkedHashMap = result;
            return linkedHashMap;
        }
        finally {
            if (is != null) {
                is.close();
                is = null;
            }
        }
    }

    public List<File> processParts(Payload.Inbound inboundPayload) throws Exception {
        return new ArrayList<File>(this.processPartsExtended(inboundPayload).keySet());
    }

    protected abstract void postProcessParts();

    private void reportExtractionSuccess() {
        this.reportSuccess();
    }

    private void reportSuccess() {
        if (this.report != null) {
            this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
    }

    private void reportDeletionSuccess() {
        this.reportSuccess();
    }

    private void reportDeletionFailure(String partName, String msg) {
        this.reportFailure(partName, msg, null);
    }

    private void reportDeletionFailure(String partName, Exception e) {
        this.reportFailure(partName, strings.getLocalString("payload.errDeleting", "Error deleting file {0}", partName), e);
    }

    private void reportFailure(String partName, String formattedMessage, Exception e) {
        if (this.report != null) {
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(formattedMessage);
            this.report.setFailureCause((Throwable)e);
        }
    }

    private void reportExtractionFailure(String partName, Exception e) {
        this.reportFailure(partName, strings.getLocalString("payload.errExtracting", "Error extracting transferred file {0}", partName), e);
    }

    private static File createTempFolder(File parent, String prefix, Logger logger) throws IOException {
        File result = File.createTempFile(prefix, "", parent);
        try {
            if (!result.delete()) {
                throw new IOException(strings.getLocalString("payload.command.errorDeletingTempFile", "Unknown error deleting temporary file {0}", result.getAbsolutePath()));
            }
            if (!result.mkdir()) {
                throw new IOException(strings.getLocalString("payload.command.errorCreatingDir", "Unknown error creating directory {0}", result.getAbsolutePath()));
            }
            logger.finer("Created temporary upload folder " + result.getAbsolutePath());
            return result;
        }
        catch (Exception e) {
            IOException ioe = new IOException(strings.getLocalString("payload.command.errorCreatingXferFolder", "Error creating temporary file transfer folder"));
            ioe.initCause(e);
            throw ioe;
        }
    }

    private static File createTempFolder(File parent, Logger logger) throws IOException {
        return PayloadFilesManager.createTempFolder(parent, XFER_DIR_PREFIX, logger);
    }

    public static interface ActionReportHandler {
        public void handleReport(InputStream var1) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DataRequestType {
        FILE_TRANSFER("file-xfer"){

            protected File processPart(PayloadFilesManager pfm, Payload.Part part, String partName) throws Exception {
                return pfm.extractFile(part, partName);
            }
        }
        ,
        FILE_REMOVAL("file-remove"){

            protected File processPart(PayloadFilesManager pfm, Payload.Part part, String partName) throws Exception {
                return pfm.removeFile(part);
            }
        }
        ,
        FILE_REPLACEMENT("file-replace"){

            protected File processPart(PayloadFilesManager pfm, Payload.Part part, String partName) throws Exception {
                return pfm.replaceFile(part);
            }
        }
        ,
        REPORT("report"){

            protected File processPart(PayloadFilesManager pfm, Payload.Part part, String partName) throws Exception {
                pfm.processReport(part);
                return null;
            }
        };

        private final String dataRequestType;

        private DataRequestType(String type) {
            this.dataRequestType = type;
        }

        protected abstract File processPart(PayloadFilesManager var1, Payload.Part var2, String var3) throws Exception;

        private static DataRequestType getType(Payload.Part part) {
            String targetDataRequestType = part.getProperties().getProperty("data-request-type");
            for (DataRequestType candidateType : DataRequestType.values()) {
                if (!candidateType.dataRequestType.equals(targetDataRequestType)) continue;
                return candidateType;
            }
            return null;
        }
    }

    public static class Perm
    extends PayloadFilesManager {
        public Perm(File targetDir, ActionReport report, Logger logger) {
            this(targetDir, report, logger, (ActionReportHandler)null);
        }

        public Perm(File targetDir, ActionReport report, Logger logger, ActionReportHandler reportHandler) {
            super(targetDir != null ? targetDir : new File(System.getProperty("user.dir")), report, logger, reportHandler);
        }

        public Perm(ActionReport report, Logger logger) {
            this(report, logger, null);
        }

        public Perm(ActionReport report, Logger logger, ActionReportHandler reportHandler) {
            super(new File(System.getProperty("user.dir")), report, logger, reportHandler);
        }

        public Perm(Logger logger) {
            this(null, logger);
        }

        public Perm() {
            this((ActionReportHandler)null);
        }

        public Perm(ActionReportHandler reportHandler) {
            this(null, Logger.getLogger(Perm.class.getName()), reportHandler);
        }

        protected void postExtract(File extractedFile) {
        }

        protected void postProcessParts() {
            boolean isFine = this.logger.isLoggable(Level.FINE);
            for (Map.Entry entry : this.dirTimestamps.entrySet()) {
                if (isFine) {
                    Date when = new Date((Long)entry.getValue());
                    this.logger.finer("Setting lastModified for " + ((File)entry.getKey()).getAbsolutePath() + " explicitly to " + when);
                }
                ((File)entry.getKey()).setLastModified((Long)entry.getValue());
            }
        }
    }

    public static class Temp
    extends PayloadFilesManager {
        private boolean isCleanedUp = false;

        public Temp(File parentDir, ActionReport report, Logger logger) throws IOException {
            super(PayloadFilesManager.createTempFolder(parentDir, logger), report, logger);
        }

        public Temp(ActionReport report, Logger logger) throws IOException {
            this(new File(System.getProperty("java.io.tmpdir")), report, logger);
        }

        public Temp(Logger logger) throws IOException {
            this(null, logger);
        }

        public void cleanup() {
            if (!this.isCleanedUp) {
                FileUtils.whack(((PayloadFilesManager)this).targetDir);
                this.isCleanedUp = true;
            }
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.cleanup();
        }

        protected void postExtract(File extractedFile) {
            extractedFile.deleteOnExit();
        }

        protected void postProcessParts() {
        }
    }
}

