/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.IiopListener;
import com.sun.enterprise.config.serverbeans.IiopService;
import com.sun.enterprise.config.serverbeans.JmxConnector;
import com.sun.enterprise.config.serverbeans.SslClientConfig;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.Protocols;
import com.sun.grizzly.config.dom.Ssl;
import java.beans.PropertyVetoException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-ssl")
@Scoped(value=PerLookup.class)
@I18n(value="create.ssl")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class CreateSsl
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateSsl.class);
    @Param(name="certname", alias="certNickname")
    String certName;
    @Param(name="type", acceptableValues="network-listener, http-listener, iiop-listener, iiop-service, jmx-connector")
    String type;
    @Param(name="ssl2Enabled", optional=true, defaultValue="false")
    Boolean ssl2Enabled;
    @Param(name="ssl2Ciphers", optional=true)
    String ssl2ciphers;
    @Param(name="ssl3Enabled", optional=true, defaultValue="true")
    Boolean ssl3Enabled;
    @Param(name="ssl3TlsCiphers", optional=true)
    String ssl3tlsciphers;
    @Param(name="tlsEnabled", optional=true, defaultValue="true")
    Boolean tlsenabled;
    @Param(name="tlsRollbackEnabled", optional=true, defaultValue="true")
    Boolean tlsrollbackenabled;
    @Param(name="clientAuthEnabled", optional=true, defaultValue="false")
    Boolean clientauthenabled;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Param(name="listener_id", primary=true, optional=true)
    String listenerId;
    @Inject(name="default-instance-name")
    Config config;
    @Inject
    Domain domain;
    @Inject
    Habitat habitat;
    private static final String GF_SSL_IMPL_NAME = "com.sun.enterprise.security.ssl.GlassfishSSLImpl";

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Target targetUtil = (Target)this.habitat.getComponent(Target.class);
        Config newConfig = targetUtil.getConfig(this.target);
        if (newConfig != null) {
            this.config = newConfig;
        }
        if (!"iiop-service".equals(this.type) && this.listenerId == null) {
            report.setMessage(localStrings.getLocalString("create.ssl.listenerid.missing", "Listener id needs to be specified"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if ("http-listener".equals(this.type) || "network-listener".equals(this.type)) {
            this.addSslToNetworkListener(this.config, report);
        } else if ("iiop-listener".equals(this.type)) {
            this.addSslToIIOPListener(this.config, report);
        } else if ("iiop-service".equals(this.type)) {
            this.addSslToIIOPService(this.config, report);
        } else if ("jmx-connector".equals(this.type)) {
            this.addSslToJMXConnector(this.config, report);
        }
    }

    private void addSslToIIOPListener(Config config, ActionReport report) {
        IiopService iiopService = config.getIiopService();
        IiopListener iiopListener = null;
        for (IiopListener listener : iiopService.getIiopListener()) {
            if (!listener.getId().equals(this.listenerId)) continue;
            iiopListener = listener;
        }
        if (iiopListener == null) {
            report.setMessage(localStrings.getLocalString("create.ssl.iiop.notfound", "IIOP Listener named {0} to which this ssl element is being added does not exist.", new Object[]{this.listenerId}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (iiopListener.getSsl() != null) {
            report.setMessage(localStrings.getLocalString("create.ssl.iiop.alreadyExists", "IIOP Listener named {0} to which this ssl element is being added already has an ssl element.", new Object[]{this.listenerId}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<IiopListener>(){

                public Object run(IiopListener param) throws PropertyVetoException, TransactionFailure {
                    Ssl newSsl = (Ssl)param.createChild(Ssl.class);
                    CreateSsl.this.populateSslElement(newSsl);
                    param.setSsl(newSsl);
                    return newSsl;
                }
            }, (ConfigBeanProxy)iiopListener);
        }
        catch (TransactionFailure e) {
            this.reportError(report, e);
        }
        this.reportSuccess(report);
    }

    private void addSslToIIOPService(Config config, ActionReport report) {
        IiopService iiopSvc = config.getIiopService();
        if (iiopSvc.getSslClientConfig() != null) {
            report.setMessage(localStrings.getLocalString("create.ssl.iiopsvc.alreadyExists", "IIOP Service already has been configured with SSL configuration."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<IiopService>(){

                public Object run(IiopService param) throws PropertyVetoException, TransactionFailure {
                    SslClientConfig newSslClientCfg = (SslClientConfig)param.createChild(SslClientConfig.class);
                    Ssl newSsl = (Ssl)newSslClientCfg.createChild(Ssl.class);
                    CreateSsl.this.populateSslElement(newSsl);
                    newSslClientCfg.setSsl(newSsl);
                    param.setSslClientConfig(newSslClientCfg);
                    return newSsl;
                }
            }, (ConfigBeanProxy)iiopSvc);
        }
        catch (TransactionFailure e) {
            this.reportError(report, e);
        }
    }

    private void addSslToNetworkListener(Config config, ActionReport report) {
        NetworkConfig netConfig = config.getNetworkConfig();
        NetworkListener listener = netConfig.getNetworkListener(this.listenerId);
        try {
            Protocol httpProtocol;
            if (listener == null) {
                report.setMessage(localStrings.getLocalString("create.ssl.http.notfound", "Network Listener named {0} does not exist.  Creating or using the named protocol element instead.", new Object[]{this.listenerId}));
                httpProtocol = this.findOrCreateProtocol(this.listenerId);
            } else {
                httpProtocol = listener.findHttpProtocol();
                Ssl ssl = httpProtocol.getSsl();
                if (ssl != null) {
                    report.setMessage(localStrings.getLocalString("create.ssl.http.alreadyExists", "Network Listener named {0} to which this ssl element is being added already has an ssl element.", new Object[]{this.listenerId}));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
            }
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Protocol>(){

                public Object run(Protocol param) throws TransactionFailure {
                    Ssl newSsl = (Ssl)param.createChild(Ssl.class);
                    CreateSsl.this.populateSslElement(newSsl);
                    param.setSsl(newSsl);
                    return newSsl;
                }
            }, (ConfigBeanProxy)httpProtocol);
        }
        catch (TransactionFailure e) {
            this.reportError(report, e);
        }
        this.reportSuccess(report);
    }

    private void reportError(ActionReport report, TransactionFailure e) {
        report.setMessage(localStrings.getLocalString("create.ssl.fail", "Creation of Ssl in {0} failed", new Object[]{this.listenerId}));
        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        report.setFailureCause(e);
    }

    private void reportSuccess(ActionReport report) {
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private void populateSslElement(Ssl newSsl) {
        newSsl.setCertNickname(this.certName);
        newSsl.setClientAuthEnabled(this.clientauthenabled.toString());
        newSsl.setSsl2Ciphers(this.ssl2ciphers);
        newSsl.setSsl2Enabled(this.ssl2Enabled.toString());
        newSsl.setSsl3Enabled(this.ssl3Enabled.toString());
        newSsl.setSsl3TlsCiphers(this.ssl3tlsciphers);
        newSsl.setClassname(GF_SSL_IMPL_NAME);
        newSsl.setTlsEnabled(this.tlsenabled.toString());
        newSsl.setTlsRollbackEnabled(this.tlsrollbackenabled.toString());
    }

    private Protocol findOrCreateProtocol(final String name) throws TransactionFailure {
        NetworkConfig networkConfig = this.config.getNetworkConfig();
        Protocol protocol = networkConfig.findProtocol(name);
        if (protocol == null) {
            protocol = (Protocol)ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Protocols>(){

                public Object run(Protocols param) throws TransactionFailure {
                    Protocol newProtocol = (Protocol)param.createChild(Protocol.class);
                    newProtocol.setName(name);
                    newProtocol.setSecurityEnabled("true");
                    param.getProtocol().add(newProtocol);
                    return newProtocol;
                }
            }, (ConfigBeanProxy)((ConfigBeanProxy)this.habitat.getComponent(Protocols.class)));
        }
        return protocol;
    }

    private void addSslToJMXConnector(Config config, ActionReport report) {
        AdminService adminService = config.getAdminService();
        JmxConnector jmxConnector = null;
        for (JmxConnector jmxConn : adminService.getJmxConnector()) {
            if (!jmxConn.getName().equals(this.listenerId)) continue;
            jmxConnector = jmxConn;
        }
        if (jmxConnector == null) {
            report.setMessage(localStrings.getLocalString("create.ssl.jmx.notfound", "JMX Connector named {0} to which this ssl element is being added does not exist.", new Object[]{this.listenerId}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (jmxConnector.getSsl() != null) {
            report.setMessage(localStrings.getLocalString("create.ssl.jmx.alreadyExists", "IIOP Listener named {0} to which this ssl element is being added already has an ssl element.", new Object[]{this.listenerId}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<JmxConnector>(){

                public Object run(JmxConnector param) throws PropertyVetoException, TransactionFailure {
                    Ssl newSsl = (Ssl)param.createChild(Ssl.class);
                    CreateSsl.this.populateSslElement(newSsl);
                    param.setSsl(newSsl);
                    return newSsl;
                }
            }, (ConfigBeanProxy)jmxConnector);
        }
        catch (TransactionFailure e) {
            this.reportError(report, e);
        }
        this.reportSuccess(report);
    }
}

