/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.grizzly.tcp.Adapter;
import com.sun.logging.LogDomains;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.container.EndpointRegistrationException;
import org.glassfish.api.container.RequestDispatcher;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.webservices.EjbWSAdapter;
import org.glassfish.webservices.WsUtil;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServicesApplication
implements ApplicationContainer {
    private ArrayList<EjbEndpoint> ejbendpoints;
    private Adapter adapter;
    private final RequestDispatcher dispatcher;
    private final ServerEnvironment serverEnvironment;
    private DeploymentContext deploymentCtx;
    protected Logger logger = LogDomains.getLogger(this.getClass(), (String)"javax.enterprise.webservices");
    private ResourceBundle rb = this.logger.getResourceBundle();
    private Config config = null;
    private Habitat habitat = null;
    private ClassLoader cl;
    private Application app;
    private Set<String> publishedFiles;

    public WebServicesApplication(DeploymentContext context, ServerEnvironment env, RequestDispatcher dispatcherString, Config config, Habitat habitat, Set<String> publishedFiles) {
        this.deploymentCtx = context;
        this.dispatcher = dispatcherString;
        this.serverEnvironment = env;
        this.ejbendpoints = this.getEjbEndpoints();
        this.adapter = new EjbWSAdapter();
        this.config = config;
        this.habitat = habitat;
        this.publishedFiles = publishedFiles;
    }

    public Object getDescriptor() {
        return null;
    }

    public boolean start(ApplicationContext startupContext) throws Exception {
        this.cl = startupContext.getClassLoader();
        try {
            this.app = (Application)this.deploymentCtx.getModuleMetaData(Application.class);
            Iterator<EjbEndpoint> iter = this.ejbendpoints.iterator();
            EjbEndpoint ejbendpoint = null;
            while (iter.hasNext()) {
                ejbendpoint = iter.next();
                String contextRoot = ejbendpoint.contextRoot;
                this.dispatcher.registerEndpoint(contextRoot, this.adapter, (ApplicationContainer)this);
                this.logger.info(this.format(this.rb.getString("enterprise.deployment.ejbendpoint.registration"), this.app.getAppName(), new WsUtil().getWebServerInfoForDAS().getWebServerRootURL(ejbendpoint.isSecure).toString() + contextRoot));
            }
        }
        catch (EndpointRegistrationException e) {
            this.logger.log(Level.SEVERE, this.format(this.rb.getString("error.registering.endpoint"), e.toString()));
        }
        return true;
    }

    private ArrayList<EjbEndpoint> getEjbEndpoints() {
        this.ejbendpoints = new ArrayList();
        Application app = (Application)this.deploymentCtx.getModuleMetaData(Application.class);
        Set bundles = app.getBundleDescriptors();
        for (BundleDescriptor bundle : bundles) {
            this.collectEjbEndpoints(bundle);
        }
        return this.ejbendpoints;
    }

    private void collectEjbEndpoints(BundleDescriptor bundleDesc) {
        WebServicesDescriptor wsDesc = bundleDesc.getWebServices();
        for (WebService ws : wsDesc.getWebServices()) {
            for (WebServiceEndpoint endpoint : ws.getEndpoints()) {
                if (!endpoint.implementedByEjbComponent()) continue;
                this.ejbendpoints.add(new EjbEndpoint(endpoint.getEndpointAddressUri(), endpoint.isSecure()));
            }
        }
        for (EjbBundleDescriptor ejbD : bundleDesc.getExtensionsDescriptors(EjbBundleDescriptor.class)) {
            this.collectEjbEndpoints((BundleDescriptor)ejbD);
        }
    }

    public boolean stop(ApplicationContext stopContext) {
        try {
            Iterator<EjbEndpoint> iter = this.ejbendpoints.iterator();
            String contextRoot = null;
            EjbEndpoint endpoint = null;
            while (iter.hasNext()) {
                endpoint = iter.next();
                contextRoot = endpoint.contextRoot;
                this.dispatcher.unregisterEndpoint(contextRoot);
            }
        }
        catch (EndpointRegistrationException e) {
            this.logger.log(Level.SEVERE, this.format(this.rb.getString("error.unregistering.endpoint"), e.toString()));
            return false;
        }
        return true;
    }

    public boolean suspend() {
        return false;
    }

    public boolean resume() throws Exception {
        return false;
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    Application getApplication() {
        return this.app;
    }

    private String format(String key, String ... values) {
        return MessageFormat.format(key, values);
    }

    Set<String> getPublishedFiles() {
        return this.publishedFiles;
    }

    class EjbEndpoint {
        private final String contextRoot;
        private boolean isSecure;

        EjbEndpoint(String contextRoot, boolean secure) {
            this.contextRoot = contextRoot;
            this.isSecure = secure;
        }
    }
}

