/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices.annotation.handlers;

import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.annotation.context.EjbContext;
import com.sun.enterprise.deployment.annotation.context.WebBundleContext;
import com.sun.enterprise.deployment.annotation.context.WebComponentContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractHandler;
import com.sun.enterprise.deployment.util.XModuleType;
import com.sun.logging.LogDomains;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.ejb.Singleton;
import javax.ejb.Stateless;
import javax.jws.HandlerChain;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingType;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.apf.ResultType;
import org.glassfish.apf.impl.HandlerProcessingResultImpl;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.webservices.annotation.handlers.HandlerChainHandler;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class WebServiceHandler
extends AbstractHandler {
    private Logger logger = LogDomains.getLogger(((Object)((Object)this)).getClass(), (String)"javax.enterprise.webservices");
    private ResourceBundle rb = this.logger.getResourceBundle();

    public Class<? extends Annotation> getAnnotationType() {
        return WebService.class;
    }

    public Class<? extends Annotation>[] getTypeDependencies() {
        return this.getEjbAndWebAnnotationTypes();
    }

    public HandlerProcessingResult processAnnotation(AnnotationInfo annInfo) throws AnnotationProcessorException {
        com.sun.enterprise.deployment.WebService newWS;
        WebServiceEndpoint endpoint;
        WebServiceEndpoint wep;
        AnnotatedElementHandler annCtx = annInfo.getProcessingContext().getHandler();
        AnnotatedElement annElem = annInfo.getAnnotatedElement();
        Class<?> origAnnElem = annElem;
        boolean ejbInWar = this.ignoreWebserviceAnnotations(annElem, annCtx);
        if (ejbInWar) {
            return HandlerProcessingResultImpl.getDefaultResult(this.getAnnotationType(), (ResultType)ResultType.PROCESSED);
        }
        if (!(annElem instanceof Class)) {
            AnnotationProcessorException ape = new AnnotationProcessorException(this.rb.getString("enterprise.deployment.annotation.handlers.wrongannotationlocation"), annInfo);
            annInfo.getProcessingContext().getErrorHandler().error(ape);
            return HandlerProcessingResultImpl.getDefaultResult(this.getAnnotationType(), (ResultType)ResultType.FAILED);
        }
        if (((Class)annElem).isInterface()) {
            return HandlerProcessingResultImpl.getDefaultResult(this.getAnnotationType(), (ResultType)ResultType.PROCESSED);
        }
        if (this.isJaxwsRIDeployment(annInfo)) {
            this.logger.info(this.format(this.rb.getString("enterprise.webservice.deployment.disabled"), annInfo.getProcessingContext().getArchive().getName(), "WEB-INF/sun-jaxws.xml"));
            return HandlerProcessingResultImpl.getDefaultResult(this.getAnnotationType(), (ResultType)ResultType.PROCESSED);
        }
        WebService ann = (WebService)annInfo.getAnnotation();
        WebBundleDescriptor bundleDesc = null;
        try {
            if (this.ejbProvider != null && this.ejbProvider.getType("javax.ejb.Stateless") != null && annCtx instanceof EjbContext) {
                EjbContext ctx = (EjbContext)annCtx;
                bundleDesc = ctx.getDescriptor().getEjbBundleDescriptor();
                bundleDesc.setSpecVersion("3.0");
            } else {
                if (annCtx instanceof WebComponentContext) {
                    bundleDesc = ((WebComponentContext)annCtx).getDescriptor().getWebBundleDescriptor();
                } else if (!(annCtx instanceof WebBundleContext)) {
                    return this.getInvalidAnnotatedElementHandlerResult(annInfo.getProcessingContext().getHandler(), annInfo);
                }
                bundleDesc = ((WebBundleContext)annCtx).getDescriptor();
                bundleDesc.setSpecVersion("2.5");
            }
        }
        catch (Exception e) {
            throw new AnnotationProcessorException(this.rb.getString("webservice.annotation.exception") + e.getMessage());
        }
        String portComponentName = ann.name();
        String svcNameFromImplClass = ann.serviceName();
        String implClassName = ((Class)annElem).getSimpleName();
        String implClassFullName = ((Class)annElem).getName();
        String targetNameSpace = ann.targetNamespace();
        String portNameFromImplClass = ann.portName();
        if (portNameFromImplClass == null || portNameFromImplClass.length() == 0) {
            portNameFromImplClass = portComponentName != null && portComponentName.length() != 0 ? portComponentName + "Port" : implClassName + "Port";
        }
        String userSpecifiedBinding = null;
        BindingType bindingAnn = ((Class)annElem).getAnnotation(BindingType.class);
        if (bindingAnn != null) {
            userSpecifiedBinding = bindingAnn.value();
        }
        String wsdlLocation = null;
        if (ann.wsdlLocation() != null && ann.wsdlLocation().length() != 0) {
            wsdlLocation = ann.wsdlLocation();
        }
        boolean sibAnnotationOverriden = false;
        if (ann.endpointInterface() != null && ann.endpointInterface().length() > 0) {
            Class<?> endpointIntf;
            try {
                endpointIntf = ((Class)annElem).getClassLoader().loadClass(ann.endpointInterface());
            }
            catch (ClassNotFoundException cfne) {
                throw new AnnotationProcessorException(this.rb.getString("enterprise.deployment.annotation.handlers.classnotfound"), annInfo);
            }
            annElem = endpointIntf;
            ann = annElem.getAnnotation(WebService.class);
            if (ann == null) {
                throw new AnnotationProcessorException(this.format(this.rb.getString("no.webservice.annotation"), ((WebService)annInfo.getAnnotation()).endpointInterface(), ((Class)annElem).getName()));
            }
            sibAnnotationOverriden = true;
            if (annElem.getAnnotation(BindingType.class) != null) {
                throw new AnnotationProcessorException(this.format(this.rb.getString("cannot.have.bindingtype"), ((WebService)annInfo.getAnnotation()).endpointInterface()));
            }
        }
        WebServicesDescriptor wsDesc = bundleDesc.getWebServices();
        if (portComponentName == null || portComponentName.length() == 0) {
            portComponentName = implClassName;
        }
        if ((wep = wsDesc.getEndpointByName(portComponentName)) != null && wep.getServiceEndpointInterface() != null && wep.getServiceEndpointInterface().length() != 0 && !((Class)annElem).getName().equals(wep.getServiceEndpointInterface())) {
            portComponentName = implClassFullName;
        }
        if ((endpoint = wsDesc.getEndpointByName(portComponentName)) == null) {
            newWS = svcNameFromImplClass != null && svcNameFromImplClass.length() != 0 ? wsDesc.getWebServiceByName(svcNameFromImplClass) : wsDesc.getWebServiceByName(implClassName + "Service");
            if (newWS == null) {
                newWS = new com.sun.enterprise.deployment.WebService();
                if (svcNameFromImplClass != null && svcNameFromImplClass.length() != 0) {
                    newWS.setName(svcNameFromImplClass);
                } else {
                    newWS.setName(implClassName + "Service");
                }
                wsDesc.addWebService(newWS);
            }
            endpoint = new WebServiceEndpoint();
            if (portComponentName != null && portComponentName.length() != 0) {
                endpoint.setEndpointName(portComponentName);
            } else {
                endpoint.setEndpointName(((Class)annElem).getName());
            }
            newWS.addEndpoint(endpoint);
            wsDesc.setSpecVersion("1.3");
        } else {
            newWS = endpoint.getWebService();
        }
        if (endpoint.getWsdlService() != null) {
            if (targetNameSpace != null && targetNameSpace.length() != 0 && !endpoint.getWsdlService().getNamespaceURI().equals(targetNameSpace)) {
                AnnotationProcessorException ape = new AnnotationProcessorException(this.rb.getString("mismatch.targetnamespace"), annInfo);
                annInfo.getProcessingContext().getErrorHandler().error(ape);
                return HandlerProcessingResultImpl.getDefaultResult(this.getAnnotationType(), (ResultType)ResultType.FAILED);
            }
            targetNameSpace = endpoint.getWsdlService().getNamespaceURI();
        }
        if (endpoint.getWsdlService() != null && endpoint.getWsdlPort() != null && !endpoint.getWsdlService().getNamespaceURI().equals(endpoint.getWsdlPort().getNamespaceURI())) {
            AnnotationProcessorException ape = new AnnotationProcessorException(this.rb.getString("mismatch.port.targetnamespace"), annInfo);
            annInfo.getProcessingContext().getErrorHandler().error(ape);
            return HandlerProcessingResultImpl.getDefaultResult(this.getAnnotationType(), (ResultType)ResultType.FAILED);
        }
        if (newWS.getWsdlFileUri() == null) {
            if (wsdlLocation != null) {
                newWS.setWsdlFileUri(wsdlLocation);
            } else if (ann.wsdlLocation() != null && ann.wsdlLocation().length() != 0) {
                newWS.setWsdlFileUri(ann.wsdlLocation());
            }
        }
        if (!endpoint.hasUserSpecifiedProtocolBinding() && userSpecifiedBinding != null && userSpecifiedBinding.length() != 0) {
            endpoint.setProtocolBinding(userSpecifiedBinding);
        }
        if (endpoint.getServiceEndpointInterface() == null) {
            if (ann.endpointInterface() != null && ann.endpointInterface().length() != 0) {
                endpoint.setServiceEndpointInterface(ann.endpointInterface());
            } else {
                endpoint.setServiceEndpointInterface(((Class)annElem).getName());
            }
        }
        annElem = annInfo.getAnnotatedElement();
        if (XModuleType.WAR.equals((Object)bundleDesc.getModuleType())) {
            if (endpoint.getServletImplClass() == null) {
                endpoint.setServletImplClass(((Class)annElem).getName());
            }
            WebBundleDescriptor webBundle = bundleDesc;
            if (endpoint.getWebComponentLink() == null) {
                endpoint.setWebComponentLink(implClassFullName);
            }
            if (endpoint.getWebComponentImpl() == null) {
                WebComponentDescriptor webComponent = webBundle.getWebComponentByCanonicalName(endpoint.getWebComponentLink());
                if (webComponent == null) {
                    webComponent = new WebComponentDescriptor();
                    webComponent.setServlet(true);
                    webComponent.setWebComponentImplementation(((Class)annElem).getCanonicalName());
                    webComponent.setName(endpoint.getEndpointName());
                    webComponent.addUrlPattern("/" + newWS.getName());
                    webBundle.addWebComponentDescriptor(webComponent);
                }
                endpoint.setWebComponentImpl(webComponent);
            }
        } else {
            Stateless stateless = null;
            try {
                stateless = annElem.getAnnotation(Stateless.class);
            }
            catch (Exception e) {
                this.logger.fine(this.rb.getString("exception.thrown") + e.getMessage());
            }
            Singleton singleton = null;
            try {
                singleton = annElem.getAnnotation(Singleton.class);
            }
            catch (Exception e) {
                this.logger.fine(this.rb.getString("exception.thrown") + e.getMessage());
            }
            String name = stateless != null && (stateless.name() == null || stateless.name().length() > 0) ? stateless.name() : (singleton != null && (singleton.name() == null || singleton.name().length() > 0) ? singleton.name() : ((Class)annElem).getSimpleName());
            EjbDescriptor ejb = ((EjbBundleDescriptor)bundleDesc).getEjbByName(name);
            endpoint.setEjbComponentImpl(ejb);
            ejb.setWebServiceEndpointInterfaceName(endpoint.getServiceEndpointInterface());
            if (endpoint.getEjbLink() == null) {
                endpoint.setEjbLink(ejb.getName());
            }
        }
        if (endpoint.getWsdlPort() == null) {
            if (targetNameSpace == null || targetNameSpace.length() == 0) {
                if (((Class)annElem).getPackage() != null) {
                    StringTokenizer tokens = new StringTokenizer(((Class)annElem).getPackage().getName(), ".", false);
                    if (tokens.hasMoreElements()) {
                        while (tokens.hasMoreElements()) {
                            if (targetNameSpace == null || targetNameSpace.length() == 0) {
                                targetNameSpace = tokens.nextElement().toString();
                                continue;
                            }
                            targetNameSpace = tokens.nextElement().toString() + "." + targetNameSpace;
                        }
                    } else {
                        targetNameSpace = ((Class)annElem).getPackage().getName();
                    }
                } else {
                    throw new AnnotationProcessorException(this.rb.getString("missing.targetnamespace"));
                }
                targetNameSpace = "http://" + (targetNameSpace == null ? "" : targetNameSpace + "/");
            }
            endpoint.setWsdlPort(new QName(targetNameSpace, portNameFromImplClass, "ns1"));
        }
        if (endpoint.getWsdlService() == null) {
            String serviceNameSpace = endpoint.getWsdlPort().getNamespaceURI();
            String serviceName = null;
            serviceName = svcNameFromImplClass != null && svcNameFromImplClass.length() != 0 ? svcNameFromImplClass : newWS.getName();
            endpoint.setWsdlService(new QName(serviceNameSpace, serviceName, "ns1"));
        }
        if (origAnnElem.getAnnotation(HandlerChain.class) == null) {
            return new HandlerChainHandler().processHandlerChainAnnotation(annInfo, annCtx, origAnnElem, origAnnElem, true);
        }
        return HandlerProcessingResultImpl.getDefaultResult(this.getAnnotationType(), (ResultType)ResultType.PROCESSED);
    }

    private String format(String key, String ... values) {
        return MessageFormat.format(key, values);
    }

    private boolean ignoreWebserviceAnnotations(AnnotatedElement annElem, AnnotatedElementHandler annCtx) {
        Stateless stateless = annElem.getAnnotation(Stateless.class);
        WebService webservice = annElem.getAnnotation(WebService.class);
        return stateless != null && webservice != null && (annCtx instanceof WebBundleContext || annCtx instanceof WebComponentContext);
    }

    private boolean isJaxwsRIDeployment(AnnotationInfo annInfo) {
        boolean riDeployment = false;
        AnnotatedElementHandler annCtx = annInfo.getProcessingContext().getHandler();
        try {
            ReadableArchive moduleArchive = annInfo.getProcessingContext().getArchive();
            if (moduleArchive != null && moduleArchive.exists("WEB-INF/sun-jaxws.xml") && !((Class)annInfo.getAnnotatedElement()).isInterface() && (annCtx instanceof WebBundleContext || annCtx instanceof WebComponentContext)) {
                riDeployment = true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return riDeployment;
    }
}

