/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices.annotation.handlers;

import com.sun.enterprise.deployment.Addressing;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.RespectBinding;
import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.annotation.context.AppClientContext;
import com.sun.enterprise.deployment.annotation.context.ServiceReferenceContainerContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractHandler;
import com.sun.enterprise.deployment.types.ServiceReferenceContainer;
import com.sun.enterprise.util.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.jws.HandlerChain;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceRef;
import javax.xml.ws.soap.MTOM;
import javax.xml.ws.spi.WebServiceFeatureAnnotation;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.apf.ResultType;
import org.glassfish.apf.impl.HandlerProcessingResultImpl;
import org.glassfish.webservices.annotation.handlers.HandlerChainHandler;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class WebServiceRefHandler
extends AbstractHandler {
    public Class<? extends Annotation> getAnnotationType() {
        return WebServiceRef.class;
    }

    public Class<? extends Annotation>[] getTypeDependencies() {
        return this.getEjbAndWebAnnotationTypes();
    }

    protected HandlerProcessingResult processAWsRef(AnnotationInfo annInfo, WebServiceRef annotation) throws AnnotationProcessorException {
        AnnotatedElementHandler annCtx = annInfo.getProcessingContext().getHandler();
        AnnotatedElement annElem = annInfo.getAnnotatedElement();
        Class<?> annotatedType = null;
        Class declaringClass = null;
        InjectionTarget target = null;
        String defaultServiceRefName = null;
        if (annInfo.getElementType().equals((Object)ElementType.FIELD)) {
            Field annotatedField = (Field)annElem;
            if (annCtx instanceof AppClientContext && !Modifier.isStatic(annotatedField.getModifiers())) {
                throw new AnnotationProcessorException(localStrings.getLocalString("enterprise.deployment.annotation.handlers.injectionfieldnotstatic", "Injection fields for application clients must be declared STATIC"), annInfo);
            }
            annotatedType = annotatedField.getType();
            declaringClass = annotatedField.getDeclaringClass();
            defaultServiceRefName = declaringClass.getName() + "/" + annotatedField.getName();
            target = new InjectionTarget();
            target.setFieldName(annotatedField.getName());
            target.setClassName(annotatedField.getDeclaringClass().getName());
        } else if (annInfo.getElementType().equals((Object)ElementType.METHOD)) {
            Method annotatedMethod = (Method)annElem;
            this.validateInjectionMethod(annotatedMethod, annInfo);
            if (annCtx instanceof AppClientContext && !Modifier.isStatic(annotatedMethod.getModifiers())) {
                throw new AnnotationProcessorException(localStrings.getLocalString("enterprise.deployment.annotation.handlers.injectionmethodnotstatic", "Injection methods for application clients must be declared STATIC"), annInfo);
            }
            annotatedType = annotatedMethod.getParameterTypes()[0];
            declaringClass = annotatedMethod.getDeclaringClass();
            String propertyName = this.getInjectionMethodPropertyName(annotatedMethod, annInfo);
            defaultServiceRefName = declaringClass.getName() + "/" + propertyName;
            target = new InjectionTarget();
            target.setMethodName(annotatedMethod.getName());
            target.setClassName(annotatedMethod.getDeclaringClass().getName());
        } else if (annInfo.getElementType().equals((Object)ElementType.TYPE)) {
            if (!StringUtils.ok((String)annotation.name())) {
                throw new AnnotationProcessorException(localStrings.getLocalString("enterprise.deployment.annotation.handlers.nonametypelevel", "TYPE-Level annotation  must specify name member."), annInfo);
            }
            annotatedType = annotation.type();
            if (annotatedType == null || annotatedType == Object.class) {
                throw new AnnotationProcessorException(localStrings.getLocalString("enterprise.deployment.annotation.handlers.typenotfound", "TYPE-level annotation symbol must specify type member."), annInfo);
            }
            declaringClass = (Class)annElem;
        } else {
            throw new AnnotationProcessorException(localStrings.getLocalString("enterprise.deployment.annotation.handlers.invalidtype", "annotation not allowed on this element."), annInfo);
        }
        MTOM mtom = null;
        javax.xml.ws.soap.Addressing addressing = null;
        javax.xml.ws.RespectBinding respectBinding = null;
        HashMap otherAnnotations = new HashMap();
        for (Annotation a : annElem.getAnnotations()) {
            if (!a.annotationType().isAnnotationPresent(WebServiceFeatureAnnotation.class)) continue;
            if (a instanceof MTOM) {
                mtom = (MTOM)a;
                continue;
            }
            if (a instanceof javax.xml.ws.soap.Addressing) {
                addressing = (javax.xml.ws.soap.Addressing)a;
                continue;
            }
            if (a instanceof javax.xml.ws.RespectBinding) {
                respectBinding = (javax.xml.ws.RespectBinding)a;
                continue;
            }
            if (otherAnnotations.containsKey(a.getClass())) continue;
            otherAnnotations.put(a.getClass(), a);
        }
        String serviceRefName = !StringUtils.ok((String)annotation.name()) ? defaultServiceRefName : annotation.name();
        ServiceReferenceContainer[] containers = null;
        if (annCtx instanceof ServiceReferenceContainerContext) {
            containers = ((ServiceReferenceContainerContext)annCtx).getServiceRefContainers();
        }
        if (containers == null || containers.length == 0) {
            annInfo.getProcessingContext().getErrorHandler().fine(new AnnotationProcessorException(localStrings.getLocalString("enterprise.deployment.annotation.handlers.invalidannotationforthisclass", "Illegal annotation symbol for this class will be ignored"), annInfo));
            return HandlerProcessingResultImpl.getDefaultResult(this.getAnnotationType(), (ResultType)ResultType.PROCESSED);
        }
        for (ServiceReferenceContainer container : containers) {
            WebServiceClient wsclientAnn;
            Map oa;
            ServiceReferenceDescriptor aRef = null;
            try {
                aRef = container.getServiceReferenceByName(serviceRefName);
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (aRef == null) {
                aRef = new ServiceReferenceDescriptor();
                aRef.setName(serviceRefName);
                container.addServiceReferenceDescriptor(aRef);
            }
            if ((oa = aRef.getOtherAnnotations()) == null) {
                aRef.setOtherAnnotations(otherAnnotations);
            } else {
                for (Map.Entry entry : otherAnnotations.entrySet()) {
                    if (oa.containsKey(entry.getKey())) continue;
                    oa.put(entry.getKey(), entry.getValue());
                }
            }
            if (!StringUtils.ok((String)aRef.getWsdlFileUri()) && StringUtils.ok((String)annotation.wsdlLocation())) {
                aRef.setWsdlFileUri(annotation.wsdlLocation());
            }
            if (!aRef.hasMtomEnabled() && mtom != null) {
                aRef.setMtomEnabled(mtom.enabled());
                aRef.setMtomThreshold(mtom.threshold());
            }
            if (aRef.getAddressing() == null && addressing != null) {
                aRef.setAddressing(new Addressing(addressing.enabled(), addressing.required(), addressing.responses().toString()));
            }
            if (aRef.getRespectBinding() == null && respectBinding != null) {
                aRef.setRespectBinding(new RespectBinding(respectBinding.enabled()));
            }
            if (!StringUtils.ok((String)aRef.getMappedName()) && StringUtils.ok((String)annotation.mappedName())) {
                aRef.setMappedName(annotation.mappedName());
            }
            if (!aRef.hasLookupName() && StringUtils.ok((String)this.getLookupValue(annotation, annInfo))) {
                aRef.setLookupName(this.getLookupValue(annotation, annInfo));
            }
            aRef.setInjectResourceType("javax.jws.WebServiceRef");
            if (target != null) {
                aRef.addInjectionTarget(target);
            }
            if (!Object.class.equals((Object)annotation.value()) && !javax.xml.ws.Service.class.equals((Object)annotation.value())) {
                if (aRef.getServiceInterface() == null) {
                    aRef.setServiceInterface(annotation.value().getName());
                }
                if (aRef.getPortInfoBySEI(annotatedType.getName()) == null) {
                    ServiceRefPortInfo portInfo = new ServiceRefPortInfo();
                    portInfo.setServiceEndpointInterface(annotatedType.getName());
                    aRef.addPortInfo(portInfo);
                }
                if (aRef.getInjectionTargetType() == null) {
                    aRef.setInjectionTargetType(annotatedType.getName());
                }
                wsclientAnn = annotation.value().getAnnotation(WebServiceClient.class);
            } else {
                wsclientAnn = annotatedType.getAnnotation(WebServiceClient.class);
            }
            if (wsclientAnn == null) {
                throw new AnnotationProcessorException(localStrings.getLocalString("enterprise.deployment.annotation.handlers.classnotannotated", "Class must be annotated with a {1} annotation\n symbol : {1}\n location: {0}", new Object[]{annotatedType.toString(), WebServiceClient.class.toString()}));
            }
            if (aRef.getWsdlFileUri() == null) {
                aRef.setWsdlFileUri(wsclientAnn.wsdlLocation());
            }
            if (aRef.getServiceName() == null) {
                aRef.setServiceNamespaceUri(wsclientAnn.targetNamespace());
                aRef.setServiceLocalPart(wsclientAnn.name());
            }
            if (aRef.getServiceInterface() != null) continue;
            aRef.setServiceInterface(annotatedType.getName());
        }
        if (annElem.getAnnotation(HandlerChain.class) == null) {
            return new HandlerChainHandler().processHandlerChainAnnotation(annInfo, annCtx, annotatedType, declaringClass, false);
        }
        return HandlerProcessingResultImpl.getDefaultResult(this.getAnnotationType(), (ResultType)ResultType.PROCESSED);
    }

    public HandlerProcessingResult processAnnotation(AnnotationInfo annInfo) throws AnnotationProcessorException {
        WebServiceRef annotation = (WebServiceRef)annInfo.getAnnotation();
        return this.processAWsRef(annInfo, annotation);
    }

    private String getLookupValue(WebServiceRef annotation, AnnotationInfo ainfo) {
        String lookupValue = "";
        try {
            lookupValue = annotation.lookup();
        }
        catch (NoSuchMethodError nsme) {
            try {
                this.log(Level.WARNING, ainfo, localStrings.getLocalString("enterprise.deployment.annotation.handlers.wrongresourceclass", "Incorrect @Resource annotation class definition - missing lookup attribute"));
            }
            catch (AnnotationProcessorException ex) {
                // empty catch block
            }
        }
        return lookupValue;
    }
}

