/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterManagerImpl;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.admin.MessageType;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;

public class UpdateClusterBrokerListHandler
extends AdminCmdHandler {
    private static boolean DEBUG = UpdateClusterBrokerListHandler.getDEBUG();

    public UpdateClusterBrokerListHandler(AdminDataHandler adminDataHandler) {
        super(adminDataHandler);
    }

    public boolean handle(IMQConnection iMQConnection, Packet packet, Hashtable hashtable) {
        ClusterManager clusterManager;
        int n = 200;
        String string = null;
        if (DEBUG) {
            this.logger.log(8, this.getClass().getName() + ": " + hashtable);
        }
        if (Globals.getHAEnabled()) {
            n = 500;
            string = this.rb.getKString("B3262", MessageType.getString((int)94));
            this.logger.log(32, string);
        } else if (!Globals.isJMSRAManagedBroker()) {
            n = 500;
            string = this.rb.getKString("B3264", MessageType.getString((int)94));
            this.logger.log(32, string);
            string = "BAD REQUEST";
        } else {
            try {
                clusterManager = Globals.getClusterManager();
                MQAddress mQAddress = clusterManager.getMQAddress();
                String string2 = (String)hashtable.get("JMQClusterBrokerList");
                Set set = ClusterManagerImpl.parseBrokerList(string2);
                MQAddress mQAddress2 = clusterManager.getMasterBroker() == null ? null : clusterManager.getMasterBroker().getBrokerURL();
                this.logger.log(8, this.rb.getKString("B1368", mQAddress + (mQAddress2 == null ? "]" : "(imq.cluster.masterbroker=" + mQAddress2 + ")"), "[" + string2 + "]"));
                if (mQAddress2 != null && !set.contains(mQAddress2)) {
                    string = this.rb.getKString("B4323", mQAddress2.toString(), set.toString() + "[" + string2 + "]");
                    throw new BrokerException(string);
                }
                if (!set.contains(mQAddress)) {
                    string2 = "";
                }
                Properties properties = new Properties();
                properties.put("imq.cluster.brokerlist", string2);
                BrokerConfig brokerConfig = Globals.getConfig();
                brokerConfig.updateProperties(properties, true);
            }
            catch (PropertyUpdateException propertyUpdateException) {
                n = 400;
                string = propertyUpdateException.getMessage();
                this.logger.log(16, string);
            }
            catch (Exception exception) {
                n = 500;
                string = exception.toString();
                this.logger.log(16, string);
            }
        }
        clusterManager = new Packet(iMQConnection.useDirectBuffers());
        clusterManager.setPacketType(5);
        UpdateClusterBrokerListHandler.setProperties((Packet)clusterManager, 95, n, string);
        this.parent.sendReply(iMQConnection, packet, (Packet)clusterManager);
        return true;
    }
}

