/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.module.bootstrap.StartupContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;

public final class StartupContextUtil {
    private StartupContextUtil() {
    }

    public static File getInstallRoot(Properties p) {
        return StartupContextUtil.absolutize(new File(p.getProperty("com.sun.aas.installRoot")));
    }

    public static File getInstallRoot(StartupContext sc) {
        return StartupContextUtil.getInstallRoot(sc.getArguments());
    }

    public static File getInstanceRoot(Properties p) {
        return StartupContextUtil.absolutize(new File(p.getProperty("com.sun.aas.instanceRoot")));
    }

    public static File getInstanceRoot(StartupContext sc) {
        return StartupContextUtil.getInstanceRoot(sc.getArguments());
    }

    public static String[] getOriginalArguments(StartupContext sc) {
        Properties args = sc.getArguments();
        String s = args.getProperty("-startup-args");
        if (s == null) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(s, ",,,", false);
        ArrayList<String> result = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            result.add(st.nextToken());
        }
        return result.toArray(new String[0]);
    }

    private static File absolutize(File f) {
        try {
            return f.getCanonicalFile();
        }
        catch (Exception e) {
            return f.getAbsoluteFile();
        }
    }
}

