/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.mgmt.transport.grizzly;

import com.sun.enterprise.ee.cms.impl.base.PeerID;
import com.sun.enterprise.mgmt.transport.AbstractMessageSender;
import com.sun.enterprise.mgmt.transport.AbstractNetworkManager;
import com.sun.enterprise.mgmt.transport.Message;
import com.sun.enterprise.mgmt.transport.grizzly.GrizzlyPeerID;
import com.sun.enterprise.mgmt.transport.grizzly.GrizzlyUtil;
import com.sun.grizzly.AbstractConnectorHandler;
import com.sun.grizzly.CallbackHandler;
import com.sun.grizzly.ConnectorHandler;
import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.IOEvent;
import com.sun.grizzly.connectioncache.client.CacheableConnectorHandler;
import com.sun.grizzly.util.OutputWriter;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GrizzlyTCPConnectorWrapper
extends AbstractMessageSender {
    private static final Logger LOG = GrizzlyUtil.getLogger();
    private final Controller controller;
    private final long writeTimeout;
    private final InetSocketAddress localSocketAddress;

    public GrizzlyTCPConnectorWrapper(Controller controller, long writeTimeout, String host, int port, PeerID<GrizzlyPeerID> localPeerID) {
        this.controller = controller;
        this.writeTimeout = writeTimeout;
        this.localSocketAddress = host != null ? new InetSocketAddress(host, port) : null;
        this.localPeerID = localPeerID;
    }

    @Override
    protected boolean doSend(PeerID peerID, Message message) throws IOException {
        if (peerID == null) {
            throw new IOException("peer ID can not be null");
        }
        Object uniqueID = peerID.getUniqueID();
        if (!(uniqueID instanceof GrizzlyPeerID)) {
            throw new IOException("peer ID must be GrizzlyPeerID type");
        }
        GrizzlyPeerID grizzlyPeerID = (GrizzlyPeerID)uniqueID;
        InetSocketAddress remoteSocketAddress = new InetSocketAddress(grizzlyPeerID.getHost(), grizzlyPeerID.getTcpPort());
        return this.send(remoteSocketAddress, null, message, peerID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean send(SocketAddress remoteAddress, SocketAddress localAddress, Message message, PeerID target) throws IOException {
        if (this.controller == null) {
            throw new IOException("grizzly controller must be initialized");
        }
        if (remoteAddress == null) {
            throw new IOException("remote address can not be null");
        }
        if (message == null) {
            throw new IOException("message can not be null");
        }
        ConnectorHandler connectorHandler = null;
        try {
            long startGetConnectorHandler = System.currentTimeMillis();
            connectorHandler = this.controller.acquireConnectorHandler(Controller.Protocol.TCP);
            long durationGetConnectorHandler = System.currentTimeMillis() - startGetConnectorHandler;
            if (durationGetConnectorHandler > 1000L) {
                AbstractNetworkManager.getLogger().log(Level.WARNING, "grizzlytcpconnectorwrapper.wait.for.getconnector", durationGetConnectorHandler);
            }
            int attemptNo = 1;
            while (true) {
                try {
                    connectorHandler.connect(remoteAddress, localAddress, (CallbackHandler)new CloseControlCallbackHandler(connectorHandler));
                }
                catch (Throwable t) {
                    try {
                        connectorHandler.close();
                    }
                    catch (Throwable tt) {
                        // empty catch block
                    }
                    IOException localIOE = new IOException("failed to connect to " + target.toString(), t);
                    throw localIOE;
                }
                try {
                    OutputWriter.flushChannel((SelectableChannel)connectorHandler.getUnderlyingChannel(), (ByteBuffer)message.getPlainByteBuffer(), (long)this.writeTimeout);
                    connectorHandler.close();
                }
                catch (Exception e) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "exception during the flushChannel call. Retrying with another connection #" + attemptNo, e);
                    }
                    this.forceClose(connectorHandler);
                    ++attemptNo;
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            this.controller.releaseConnectorHandler(connectorHandler);
            throw throwable;
        }
        this.controller.releaseConnectorHandler(connectorHandler);
        return true;
    }

    private void forceClose(ConnectorHandler connectorHandler) throws IOException {
        if (connectorHandler instanceof CacheableConnectorHandler) {
            ((CacheableConnectorHandler)connectorHandler).forceClose();
        }
    }

    private static final class CloseControlCallbackHandler
    implements CallbackHandler<Context> {
        private final ConnectorHandler connectorHandler;

        public CloseControlCallbackHandler(ConnectorHandler connectorHandler) {
            this.connectorHandler = connectorHandler;
        }

        public void onConnect(IOEvent<Context> ioEvent) {
            SelectionKey key = ((Context)ioEvent.attachment()).getSelectionKey();
            if (this.connectorHandler instanceof AbstractConnectorHandler) {
                ((AbstractConnectorHandler)this.connectorHandler).setUnderlyingChannel(key.channel());
            }
            try {
                this.connectorHandler.finishConnect(key);
                ((Context)ioEvent.attachment()).getSelectorHandler().register(key, 1);
            }
            catch (IOException ex) {
                Controller.logger().severe(ex.getMessage());
            }
        }

        public void onRead(IOEvent<Context> ioEvent) {
            Context context = (Context)ioEvent.attachment();
            SelectionKey selectionKey = context.getSelectionKey();
            context.getSelectorHandler().addPendingKeyCancel(selectionKey);
        }

        public void onWrite(IOEvent<Context> ioe) {
        }
    }
}

