/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.application.ApplicationImpl;
import com.sun.faces.application.ServletContextSensitiveSingletonStore;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;

public class ApplicationFactoryImpl
extends ApplicationFactory {
    private static final Logger logger = FacesLogger.APPLICATION.getLogger();
    private static final String APPLICATION_KEY = ApplicationFactoryImpl.class.getName();

    public ApplicationFactoryImpl() {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Created ApplicationFactory ");
        }
    }

    Class getApplicationInstanceClass() {
        return ApplicationImpl.class;
    }

    public Application getApplication() {
        ServletContextSensitiveSingletonStore<Application> appStore = new ServletContextSensitiveSingletonStore<Application>(APPLICATION_KEY);
        Application application = (Application)appStore.getReferenceToSingleton();
        if (application == null) {
            application = new ApplicationImpl();
            appStore.removeSingletonOnContextDestroyed();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(MessageFormat.format("Created Application instance ''{0}''", application));
            }
            appStore.putSingletonReference(application);
        }
        return application;
    }

    public synchronized void setApplication(Application application) {
        if (application == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "application");
            throw new NullPointerException(message);
        }
        ServletContextSensitiveSingletonStore<Application> appStore = new ServletContextSensitiveSingletonStore<Application>(APPLICATION_KEY);
        appStore.removeSingletonReference();
        appStore.putSingletonReference(application);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(MessageFormat.format("set Application Instance to ''{0}''", application.getClass().getName()));
        }
    }
}

