/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.More;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service(name="help")
@Scoped(value=PerLookup.class)
public class HelpCommand
extends CLICommand {
    @Inject
    private Habitat habitat;
    private static final int DEFAULT_PAGE_LENGTH = 50;
    private static final int NO_PAGE_LENGTH = -1;
    private static final String DEFAULT_HELP_PAGE = "help";
    private static final LocalStringsImpl strings = new LocalStringsImpl(HelpCommand.class);
    @Param(name="command-name", primary=true, optional=true)
    private String cmd;

    protected int executeCommand() throws CommandException, CommandValidationException {
        try {
            new More(this.getPageLength(), this.getSource(), this.getDestination(), this.getUserInput(), this.getUserOutput(), this.getQuitChar(), this.getPrompt());
        }
        catch (IOException ioe) {
            throw new CommandException((Throwable)ioe);
        }
        return 0;
    }

    private String getCommandName() {
        return this.cmd != null ? this.cmd : DEFAULT_HELP_PAGE;
    }

    private Writer getDestination() {
        return new OutputStreamWriter(System.out);
    }

    private int getPageLength() {
        if (this.programOpts.isInteractive()) {
            return 50;
        }
        return -1;
    }

    private String getPrompt() {
        return strings.get("ManpagePrompt");
    }

    private String getQuitChar() {
        return strings.get("ManpageQuit");
    }

    private Reader getSource() throws CommandException, CommandValidationException {
        CLICommand cmd = CLICommand.getCommand(this.habitat, this.getCommandName());
        Reader r = cmd.getManPage();
        if (r == null) {
            throw new CommandException(strings.get("ManpageMissing", new Object[]{this.getCommandName()}));
        }
        return r;
    }

    private Reader getUserInput() {
        return new InputStreamReader(System.in);
    }

    private Writer getUserOutput() {
        return new OutputStreamWriter(System.err);
    }
}

