/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.CLIConstants;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.branding.Branding;
import org.glassfish.branding.GlassFishBranding;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="version")
@Scoped(value=PerLookup.class)
public class VersionCommand
extends CLICommand {
    @Param(optional=true, shortName="v")
    private boolean verbose;
    @Param(optional=true)
    private boolean local;
    @Param(optional=true)
    private boolean terse;
    private static final LocalStringsImpl strings = new LocalStringsImpl(VersionCommand.class);

    protected void validate() throws CommandException {
        if (this.terse && this.verbose) {
            throw new CommandValidationException(strings.get("version.optionerror1"));
        }
    }

    protected int executeCommand() throws CommandException {
        if (this.local) {
            this.invokeLocal();
            return 0;
        }
        try {
            RemoteCommand cmd = new RemoteCommand("version", this.programOpts, this.env);
            String version = this.verbose ? cmd.executeAndReturnOutput("version", "--verbose") : cmd.executeAndReturnOutput("version");
            version = version.trim();
            logger.info(this.terse ? version : strings.get("version.remote", new Object[]{version}));
        }
        catch (Exception e) {
            this.printRemoteException(e);
            this.invokeLocal();
        }
        return 0;
    }

    private void invokeLocal() {
        GlassFishBranding br = new GlassFishBranding();
        br.postConstruct();
        Version version = new Version();
        Version.setBranding((Branding)br);
        version.postConstruct();
        String fv = Version.getFullVersion();
        logger.info(this.terse ? fv : strings.get("version.local", new Object[]{fv}));
        if (this.verbose) {
            logger.info(strings.get("version.local.java", new Object[]{System.getProperty("java.version")}));
        }
    }

    private void printRemoteException(Exception e) {
        if (CLIConstants.debug()) {
            logger.info(strings.get("remote.version.failed.debug", new Object[]{this.programOpts.getHost(), this.programOpts.getPort() + ""}));
        } else {
            logger.info(strings.get("remote.version.failed.non-debug", new Object[]{this.programOpts.getHost(), this.programOpts.getPort() + ""}));
        }
        logger.finer(e.getMessage());
    }
}

