/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.columns;

import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.mappings.VariableOneToOneMapping;

public class DiscriminatorClassMetadata
extends ORMetadata {
    private MetadataClass m_value;
    private String m_valueName;
    private String m_discriminator;

    public DiscriminatorClassMetadata() {
        super("<discriminator-class>");
    }

    public DiscriminatorClassMetadata(MetadataAnnotation discriminatorClass, MetadataAccessibleObject accessibleObject) {
        super(discriminatorClass, accessibleObject);
        this.setDiscriminator((String)discriminatorClass.getAttribute("discriminator"));
        this.setValue(this.getMetadataClass((String)discriminatorClass.getAttribute("value")));
    }

    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof DiscriminatorClassMetadata) {
            DiscriminatorClassMetadata discriminatorClass = (DiscriminatorClassMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_valueName, discriminatorClass.getValueName())) {
                return false;
            }
            return this.valuesMatch(this.m_discriminator, discriminatorClass.getDiscriminator());
        }
        return false;
    }

    public String getDiscriminator() {
        return this.m_discriminator;
    }

    public MetadataClass getValue() {
        return this.m_value;
    }

    public String getValueName() {
        return this.m_valueName;
    }

    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.m_value = this.initXMLClassName(this.m_valueName);
    }

    public void process(VariableOneToOneMapping mapping) {
        if (mapping.getTypeIndicatorNameTranslation().containsValue(this.m_discriminator)) {
            throw ValidationException.multipleClassesForTheSameDiscriminator((String)this.m_discriminator, (String)mapping.getAttributeName());
        }
        mapping.addClassNameIndicator(this.m_value.getName(), (Object)this.m_discriminator);
    }

    public void setDiscriminator(String discriminator) {
        this.m_discriminator = discriminator;
    }

    public void setValue(MetadataClass value) {
        this.m_value = value;
    }

    public void setValueName(String valueName) {
        this.m_valueName = valueName;
    }
}

