/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc.sharecc;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.persist.ChangeRecordInfo;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBTool;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.comm.BaseDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.sharecc.ShareConfigChangeDBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.sharecc.ShareConfigRecordDAOFactory;
import com.sun.messaging.jmq.jmsserver.persist.sharecc.ShareConfigChangeStore;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.synchronizer.CloseInProgressCallback;
import com.sun.messaging.jmq.util.synchronizer.CloseInProgressSynchronizer;
import java.sql.Connection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCShareConfigChangeStore
extends ShareConfigChangeStore
implements CloseInProgressCallback {
    private static boolean DEBUG = JDBCShareConfigChangeStore.getDEBUG();
    public static final String SCHEMA_VERSION = "45";
    private static final String CLOSEWAIT_TIMEOUT_PROP = "imq.cluster.sharecc.persistCloseWaitTimeoutInSeconds";
    private static final int CLOSEWAIT_TIMEOUT_PROP_DEFAULT = 30;
    private boolean createStore = false;
    private final Logger logger = Globals.getLogger();
    private final BrokerResources br = Globals.getBrokerResources();
    private final BrokerConfig config = Globals.getConfig();
    private ShareConfigChangeDBManager dbmgr = null;
    private ShareConfigRecordDAOFactory daoFactory = null;
    private final CloseInProgressSynchronizer inprogresser = new CloseInProgressSynchronizer(this.logger);
    private int closeWaitTimeout = 30;

    public JDBCShareConfigChangeStore() throws BrokerException {
        Object object;
        String string;
        this.inprogresser.reset();
        this.closeWaitTimeout = this.config.getIntProperty(CLOSEWAIT_TIMEOUT_PROP, 30);
        this.dbmgr = ShareConfigChangeDBManager.getDBManager();
        this.daoFactory = this.dbmgr.getDAOFactory();
        String string2 = this.dbmgr.getOpenDBURL();
        if (string2 == null) {
            string2 = "not specified";
        }
        if ((string = this.dbmgr.getUser()) == null) {
            string = "not specified";
        }
        this.createStore = this.config.getBooleanProperty("imq.cluster.sharecc.persistCreate", false);
        if (this.createStore) {
            object = new String[]{this.br.getString("B1352"), String.valueOf(SCHEMA_VERSION), this.dbmgr.getClusterID(), string2, string};
            this.logger.logToAll(8, this.br.getKString("B1351", (Object[])object));
        } else {
            object = new String[]{this.br.getString("B1353"), String.valueOf(SCHEMA_VERSION), this.dbmgr.getClusterID(), string2, string};
            this.logger.logToAll(8, this.br.getKString("B1351", (Object[])object));
        }
        object = null;
        BrokerException brokerException = null;
        try {
            try {
                object = this.dbmgr.getConnection(true);
                this.checkStore((Connection)object);
            }
            catch (BrokerException brokerException2) {
                brokerException = brokerException2;
                throw brokerException2;
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.dbmgr.closeSQLObjects(null, null, (Connection)object, brokerException);
            throw throwable;
        }
        this.dbmgr.closeSQLObjects(null, null, (Connection)object, brokerException);
        this.dbmgr.setStoreInited(true);
        if (DEBUG) {
            this.logger.log(4, "JDBCShareConfigChangeStore instantiated.");
        }
    }

    private void checkStore(Connection connection) throws BrokerException {
        int n = this.dbmgr.checkStoreExists(connection);
        if (n == -1) {
            this.logger.log(32, "B3246");
            throw new BrokerException(this.br.getKString("B3246"));
        }
        if (n == 0) {
            if (!this.createStore) {
                this.logger.log(32, "B3247");
                throw new BrokerException(this.br.getKString("B3132"));
            }
            this.logger.logToAll(8, this.br.getKString("B1354", this.br.getString("B1355")));
            try {
                DBTool.createTables(connection, false, this.dbmgr);
            }
            catch (Exception exception) {
                String string = this.dbmgr.getCreateDBURL();
                if (string == null || string.length() == 0) {
                    string = this.dbmgr.getOpenDBURL();
                }
                String string2 = this.br.getKString("B3248", this.br.getString("B1355"));
                this.logger.logToAll(32, string2 + "-" + string, exception);
                throw new BrokerException(string2, exception);
            }
        }
    }

    @Override
    public Properties getStoreShareProperties() {
        if (this.dbmgr == null) {
            throw new RuntimeException("JDBShareConfigChangeStore not initialized");
        }
        Properties properties = new Properties();
        properties.setProperty(this.dbmgr.getOpenDBUrlProp(), this.dbmgr.getOpenDBUrl());
        return properties;
    }

    @Override
    public String getVendorPropertySetting() {
        return this.dbmgr.getVendorProp() + "=" + this.dbmgr.getVendor();
    }

    public final String getStoreVersion() {
        return SCHEMA_VERSION;
    }

    private void checkClosedAndSetInProgress() throws BrokerException {
        try {
            this.inprogresser.checkClosedAndSetInProgressWithWait(this.closeWaitTimeout, this.br.getKString("B1357"));
        }
        catch (IllegalStateException illegalStateException) {
            this.logger.log(32, "B3102");
            throw new BrokerException(this.br.getKString("B3102"));
        }
        catch (TimeoutException timeoutException) {
            String string = this.br.getKString("B2237", this.closeWaitTimeout);
            this.logger.log(32, string);
            throw new BrokerException(string);
        }
        catch (Exception exception) {
            String string = this.br.getKString("B3249", exception.toString());
            this.logger.log(32, string);
            throw new BrokerException(string);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ChangeRecordInfo storeChangeRecord(ChangeRecordInfo changeRecordInfo, boolean bl) throws BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCShareCCStore.storeChangeRecord called");
        }
        this.checkClosedAndSetInProgress();
        Util.RetryStrategy retryStrategy = null;
        while (true) {
            ChangeRecordInfo changeRecordInfo2;
            try {
                changeRecordInfo2 = this.daoFactory.getShareConfigRecordDAO().insert(null, changeRecordInfo);
            }
            catch (Exception exception) {
                try {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(this.dbmgr);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    this.inprogresser.setInProgress(false);
                    throw throwable;
                }
            }
            Object var6_6 = null;
            this.inprogresser.setInProgress(false);
            return changeRecordInfo2;
        }
    }

    @Override
    public void storeResetRecord(ChangeRecordInfo changeRecordInfo, boolean bl, boolean bl2) throws BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCShareCCStore.storeResetRecord called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getShareConfigRecordDAO().insertResetRecord(null, changeRecordInfo, bl);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(this.dbmgr);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var7_5 = null;
                this.inprogresser.setInProgress(false);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.inprogresser.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<ChangeRecordInfo> getChangeRecordsSince(Long l, String string, boolean bl) throws BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCShareCCStore.getChangeRecordsSince(" + l + ", " + string + ")");
        }
        this.checkClosedAndSetInProgress();
        Util.RetryStrategy retryStrategy = null;
        while (true) {
            List<ChangeRecordInfo> list;
            try {
                list = this.daoFactory.getShareConfigRecordDAO().getRecords(null, l, string, bl);
            }
            catch (Exception exception) {
                try {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(this.dbmgr);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    this.inprogresser.setInProgress(false);
                    throw throwable;
                }
            }
            Object var7_7 = null;
            this.inprogresser.setInProgress(false);
            return list;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<ChangeRecordInfo> getAllChangeRecords() throws BrokerException {
        if (Store.getDEBUG()) {
            this.logger.log(4, "JDBCShareCCStore.getAllChangeRecords() called");
        }
        this.checkClosedAndSetInProgress();
        Util.RetryStrategy retryStrategy = null;
        while (true) {
            List<ChangeRecordInfo> list;
            try {
                list = this.daoFactory.getShareConfigRecordDAO().getRecords(null, null, null, true);
            }
            catch (Exception exception) {
                try {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(this.dbmgr);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    this.inprogresser.setInProgress(false);
                    throw throwable;
                }
            }
            Object var4_4 = null;
            this.inprogresser.setInProgress(false);
            return list;
        }
    }

    @Override
    public void clearAllChangeRecords(boolean bl) throws BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCShareCCStore.clearAllChangeRecords() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getShareConfigRecordDAO().deleteAll(null);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(this.dbmgr);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var5_3 = null;
                this.inprogresser.setInProgress(false);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.inprogresser.setInProgress(false);
            throw throwable;
        }
    }

    @Override
    public void beforeWaitAfterSetClosed() {
        if (this.dbmgr != null) {
            this.dbmgr.setIsClosing();
        }
    }

    @Override
    public void close() {
        try {
            this.inprogresser.setClosedAndWaitWithTimeout(this, this.closeWaitTimeout, this.br.getKString("B1356"));
        }
        catch (Exception exception) {
            this.logger.log(16, this.br.getKString("B2238", exception.toString()));
        }
        this.dbmgr.close();
        this.dbmgr.setStoreInited(false);
        if (DEBUG) {
            this.logger.log(4, "JDBCShareConfigChangeStore.close done.");
        }
    }

    public String getStoreType() {
        return "jdbc";
    }

    public Hashtable getDebugState() throws BrokerException {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("JDBCSharedConfigChangeStore", "version:" + String.valueOf(SCHEMA_VERSION));
        Connection connection = null;
        BrokerException brokerException = null;
        try {
            try {
                connection = this.dbmgr.getConnection(true);
                Iterator iterator = this.daoFactory.getAllDAOs().iterator();
                while (iterator.hasNext()) {
                    hashtable.putAll(((BaseDAO)iterator.next()).getDebugInfo(connection));
                }
                Object var6_6 = null;
            }
            catch (BrokerException brokerException2) {
                brokerException = brokerException2;
                throw brokerException2;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.dbmgr.closeSQLObjects(null, null, connection, brokerException);
            throw throwable;
        }
        this.dbmgr.closeSQLObjects(null, null, connection, brokerException);
        hashtable.put("DBManager", this.dbmgr.getDebugState());
        return hashtable;
    }
}

