/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.policy.mls;

import com.sun.xml.ws.security.opt.impl.tokens.UsernameToken;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.policy.MLSPolicy;
import com.sun.xml.wss.impl.policy.PolicyGenerationException;
import com.sun.xml.wss.impl.policy.mls.KeyBindingBase;
import com.sun.xml.wss.impl.policy.mls.LazyKeyBinding;
import com.sun.xml.wss.impl.policy.mls.PrivateKeyBinding;
import com.sun.xml.wss.impl.policy.mls.TimestampPolicy;
import com.sun.xml.wss.impl.policy.mls.WSSFeatureBindingExtension;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Element;

public class AuthenticationTokenPolicy
extends WSSFeatureBindingExtension {
    public AuthenticationTokenPolicy() {
        this.setPolicyIdentifier("AuthenticationTokenPolicy");
    }

    public boolean equals(WSSPolicy policy) {
        boolean _assert = false;
        try {
            if (!PolicyTypeUtil.authenticationTokenPolicy(policy)) {
                return false;
            }
            AuthenticationTokenPolicy aPolicy = (AuthenticationTokenPolicy)policy;
            _assert = ((WSSPolicy)this.getFeatureBinding()).equals((WSSPolicy)aPolicy.getFeatureBinding());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return _assert;
    }

    public boolean equalsIgnoreTargets(WSSPolicy policy) {
        return this.equals(policy);
    }

    public Object clone() {
        AuthenticationTokenPolicy atPolicy = new AuthenticationTokenPolicy();
        try {
            WSSPolicy fBinding = (WSSPolicy)this.getFeatureBinding();
            WSSPolicy kBinding = (WSSPolicy)this.getKeyBinding();
            if (fBinding != null) {
                atPolicy.setFeatureBinding((MLSPolicy)fBinding.clone());
            }
            if (kBinding != null) {
                atPolicy.setKeyBinding((MLSPolicy)kBinding.clone());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return atPolicy;
    }

    public String getType() {
        return "AuthenticationTokenPolicy";
    }

    public static class KerberosTokenBinding
    extends KeyBindingBase {
        String _valueType = MessageConstants._EMPTY;
        String _encodingType = MessageConstants._EMPTY;
        String _referenceType = MessageConstants._EMPTY;
        byte[] _token = null;
        private String strId;
        String _keyAlgorithm = MessageConstants._EMPTY;
        SecretKey _secretKey = null;

        public KerberosTokenBinding() {
            this.setPolicyIdentifier("KerberosTokenBinding");
        }

        public void setValueType(String valueType) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set valueType of KerberosToken : Policy is ReadOnly");
            }
            this._valueType = valueType;
        }

        public void setReferenceType(String referenceType) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set referenceType of KerberosToken : Policy is ReadOnly");
            }
            this._referenceType = referenceType;
        }

        public void setEncodingType(String encodingType) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set EncodingType of KerberosToken : Policy is ReadOnly");
            }
            this._encodingType = encodingType;
        }

        public void setTokenValue(byte[] token) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set TokenValue of KerberosToken : Policy is ReadOnly");
            }
            this._token = token;
        }

        public void setSTRID(String id) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set STRID attribute : Policy is ReadOnly");
            }
            this.strId = id;
        }

        public String getSTRID() {
            return this.strId;
        }

        public String getValueType() {
            return this._valueType;
        }

        public String getReferenceType() {
            return this._referenceType;
        }

        public String getEncodingType() {
            return this._encodingType;
        }

        public byte[] getTokenValue() {
            return this._token;
        }

        public void setKeyAlgorithm(String keyAlgorithm) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set KeyAlgorithm : Policy is ReadOnly");
            }
            this._keyAlgorithm = keyAlgorithm;
        }

        public String getKeyAlgorithm() {
            return this._keyAlgorithm;
        }

        public void setSecretKey(SecretKey secretKey) {
            this._secretKey = secretKey;
        }

        public SecretKey getSecretKey() {
            return this._secretKey;
        }

        public Object clone() {
            KerberosTokenBinding ktBinding = new KerberosTokenBinding();
            try {
                WSSPolicy kBinding;
                ktBinding.setValueType(this._valueType);
                ktBinding.setEncodingType(this._encodingType);
                ktBinding.setTokenValue(this._token);
                ktBinding.setKeyAlgorithm(this._keyAlgorithm);
                ktBinding.setUUID(this.UUID);
                SecretKeySpec ky0 = (SecretKeySpec)this._secretKey;
                if (ky0 != null) {
                    SecretKeySpec key = new SecretKeySpec(ky0.getEncoded(), ky0.getAlgorithm());
                    ktBinding.setSecretKey(key);
                }
                if ((kBinding = (WSSPolicy)this.getKeyBinding()) != null) {
                    ktBinding.setKeyBinding((MLSPolicy)kBinding.clone());
                }
                ktBinding.setIncludeToken(this.getIncludeToken());
                ktBinding.setPolicyTokenFlag(this.policyTokenWasSet());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return ktBinding;
        }

        public boolean equals(WSSPolicy policy) {
            boolean assrt = false;
            try {
                boolean b3;
                boolean b2;
                boolean b1;
                if (!PolicyTypeUtil.kerberosTokenBinding(policy)) {
                    return false;
                }
                KerberosTokenBinding ktBinding = (KerberosTokenBinding)policy;
                boolean bl = b1 = this._valueType.equals("") ? true : this._valueType.equals(ktBinding.getValueType());
                if (!b1) {
                    return false;
                }
                boolean bl2 = b2 = this._encodingType.equals("") ? true : this._encodingType.equals(ktBinding.getEncodingType());
                if (!b2) {
                    return false;
                }
                boolean bl3 = b3 = this._keyAlgorithm.equals("") ? true : this._keyAlgorithm.equals(ktBinding.getKeyAlgorithm());
                return b3;
            }
            catch (Exception exception) {
                return false;
            }
        }

        public boolean equalsIgnoreTargets(WSSPolicy policy) {
            return this.equals(policy);
        }

        public String getType() {
            return "KerberosTokenBinding";
        }

        public void setIncludeToken(String include) {
            if (INCLUDE_ALWAYS.equals(include) || INCLUDE_ALWAYS_TO_RECIPIENT.equals(include)) {
                throw new UnsupportedOperationException("IncludeToken policy " + include + " is not supported for Kerberos Tokens, Consider using Once");
            }
            this.includeToken = include;
            this.policyToken = true;
        }
    }

    public static class KeyValueTokenBinding
    extends KeyBindingBase {
        String _valueType = MessageConstants._EMPTY;
        String _encodingType = MessageConstants._EMPTY;
        String _referenceType = MessageConstants._EMPTY;

        public KeyValueTokenBinding() {
            this.setPolicyIdentifier("RsaTokenBinding");
        }

        public MLSPolicy newPrivateKeyBinding() {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not create PrivateKeyBinding : Policy is Readonly");
            }
            this._keyBinding = new PrivateKeyBinding();
            return this._keyBinding;
        }

        public void setValueType(String valueType) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set ValueType of X509Certificate : Policy is ReadOnly");
            }
            this._valueType = valueType;
        }

        public void setEncodingType(String encodingType) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set EncodingType of X509Certificate : Policy is ReadOnly");
            }
            this._encodingType = encodingType;
        }

        public void setReferenceType(String referenceType) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set ReferenceType of X509Certificate : Policy is ReadOnly");
            }
            this._referenceType = referenceType;
        }

        public String getValueType() {
            return this._valueType;
        }

        public String getEncodingType() {
            return this._encodingType;
        }

        public String getReferenceType() {
            return this._referenceType;
        }

        public boolean equals(WSSPolicy policy) {
            boolean assrt = false;
            try {
                boolean b3;
                boolean b2;
                boolean b1;
                if (!PolicyTypeUtil.keyValueTokenBinding(policy)) {
                    return false;
                }
                KeyValueTokenBinding rsaTokenBinding = (KeyValueTokenBinding)policy;
                boolean bl = b1 = this._valueType.equals("") ? true : this._valueType.equals(rsaTokenBinding.getValueType());
                if (!b1) {
                    return false;
                }
                boolean bl2 = b2 = this._encodingType.equals("") ? true : this._encodingType.equals(rsaTokenBinding.getEncodingType());
                if (!b2) {
                    return false;
                }
                boolean bl3 = b3 = this._referenceType.equals("") ? true : this._referenceType.equals(rsaTokenBinding.getReferenceType());
                if (!b3) {
                    return false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }

        public boolean equalsIgnoreTargets(WSSPolicy policy) {
            return this.equals(policy);
        }

        public Object clone() {
            KeyValueTokenBinding rsaTokenBinding = new KeyValueTokenBinding();
            try {
                rsaTokenBinding.setValueType(this._valueType);
                rsaTokenBinding.setEncodingType(this._encodingType);
                rsaTokenBinding.setReferenceType(this._referenceType);
                rsaTokenBinding.setUUID(this.UUID);
                WSSPolicy kBinding = (WSSPolicy)this.getKeyBinding();
                if (kBinding != null) {
                    rsaTokenBinding.setKeyBinding((MLSPolicy)kBinding.clone());
                }
                rsaTokenBinding.setIncludeToken(this.getIncludeToken());
                rsaTokenBinding.setPolicyTokenFlag(this.policyTokenWasSet());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return rsaTokenBinding;
        }

        public String getType() {
            return this.getPolicyIdentifier();
        }

        public String toString() {
            return this.getPolicyIdentifier() + "::" + this._referenceType;
        }
    }

    public static class SAMLAssertionBinding
    extends KeyBindingBase
    implements LazyKeyBinding {
        String _type = "";
        String _keyAlgorithm = "";
        String _keyIdentifier = "";
        String _referenceType = "";
        String _authorityIdentifier = "";
        String strId = null;
        String assertionId = null;
        String samlVersion = null;
        public static final String V10_ASSERTION = "SAML10Assertion";
        public static final String V11_ASSERTION = "SAML11Assertion";
        public static final String V20_ASSERTION = "SAML20Assertion";
        public static final String SV_ASSERTION = "SV";
        public static final String HOK_ASSERTION = "HOK";
        Element _assertion = null;
        Element _authorityBinding = null;
        XMLStreamReader samlAssertion = null;

        public SAMLAssertionBinding() {
            this.setPolicyIdentifier("SAMLAssertionBinding");
        }

        public SAMLAssertionBinding(String type, String keyIdentifier, String authorityIdentifier, String referenceType) {
            this();
            this._type = type;
            this._keyIdentifier = keyIdentifier;
            this._authorityIdentifier = authorityIdentifier;
            this._referenceType = referenceType;
        }

        public void setAssertionType(String type) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set SAMLAssertionType : Policy is ReadOnly");
            }
            if (SV_ASSERTION.equals(type)) {
                this._type = SV_ASSERTION;
            } else if (HOK_ASSERTION.equals(type)) {
                this._type = HOK_ASSERTION;
            }
        }

        public void setSAMLVersion(String ver) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set SAMLAssertionType : Policy is ReadOnly");
            }
            this.samlVersion = ver;
        }

        public String getSAMLVersion() {
            return this.samlVersion;
        }

        public MLSPolicy newPrivateKeyBinding() {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not create PrivateKeyBinding : Policy is Readonly");
            }
            this._keyBinding = new PrivateKeyBinding();
            return this._keyBinding;
        }

        public void setKeyIdentifier(String ki) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set SAML KeyIdentifier : Policy is ReadOnly");
            }
            this._keyIdentifier = ki;
        }

        public void setAuthorityIdentifier(String uri) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set SAML AuthorityIdentifier : Policy is ReadOnly");
            }
            this._authorityIdentifier = uri;
        }

        public void setReferenceType(String rtype) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set SAML ReferenceType : Policy is ReadOnly");
            }
            this._referenceType = rtype;
        }

        public void setAuthorityBinding(Element authorityBinding) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set SAML AuthorityBinding : Policy is ReadOnly");
            }
            this._authorityBinding = authorityBinding;
        }

        public void setAssertion(Element assertion) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set SAML Assertion : Policy is ReadOnly");
            }
            this._assertion = assertion;
        }

        public void setAssertion(XMLStreamReader reader) {
            this.samlAssertion = reader;
        }

        public void setKeyAlgorithm(String algorithm) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set KeyAlgorithm : Policy is ReadOnly");
            }
            this._keyAlgorithm = algorithm;
        }

        public String getKeyAlgorithm() {
            return this._keyAlgorithm;
        }

        public String getReferenceType() {
            return this._referenceType;
        }

        public String getAssertionType() {
            return this._type;
        }

        public String getKeyIdentifier() {
            return this._keyIdentifier;
        }

        public String getAuthorityIdentifier() {
            return this._authorityIdentifier;
        }

        public Element getAuthorityBinding() {
            return this._authorityBinding;
        }

        public Element getAssertion() {
            return this._assertion;
        }

        public XMLStreamReader getAssertionReader() {
            return this.samlAssertion;
        }

        public boolean equals(WSSPolicy policy) {
            try {
                boolean b8;
                boolean b7;
                boolean b6;
                boolean b3;
                boolean b2;
                boolean b1;
                if (!PolicyTypeUtil.samlTokenPolicy(policy)) {
                    return false;
                }
                SAMLAssertionBinding sBinding = (SAMLAssertionBinding)policy;
                boolean bl = b1 = this._type.equals("") ? true : this._type.equals(sBinding.getAssertionType());
                if (!b1) {
                    return false;
                }
                boolean bl2 = b2 = this._authorityIdentifier.equals("") ? true : this._authorityIdentifier.equals(sBinding.getAuthorityIdentifier());
                if (!b2) {
                    return false;
                }
                boolean bl3 = b3 = this._referenceType.equals("") ? true : this._referenceType.equals(sBinding.getReferenceType());
                if (!b3) {
                    return false;
                }
                boolean bl4 = b6 = this._keyAlgorithm.equals("") ? true : this._keyAlgorithm.equals(sBinding.getKeyAlgorithm());
                if (!b6) {
                    return false;
                }
                boolean bl5 = b7 = this.strId == null ? true : this.strId.equals(sBinding.getSTRID());
                if (!b7) {
                    return false;
                }
                boolean bl6 = b8 = this.assertionId == null ? true : this.assertionId.equals(sBinding.getAssertionId());
                if (!b8) {
                    return false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }

        public boolean equalsIgnoreTargets(WSSPolicy binding) {
            return this.equals(binding);
        }

        public Object clone() {
            SAMLAssertionBinding samlBinding = new SAMLAssertionBinding();
            try {
                samlBinding.setAssertionType(this._type);
                samlBinding.setKeyAlgorithm(this._keyAlgorithm);
                samlBinding.setKeyIdentifier(this._keyIdentifier);
                samlBinding.setReferenceType(this._referenceType);
                samlBinding.setAuthorityIdentifier(this._authorityIdentifier);
                samlBinding.setAssertion(this._assertion);
                samlBinding.setAssertion(this.samlAssertion);
                samlBinding.setAuthorityBinding(this._authorityBinding);
                samlBinding.setSTRID(this.strId);
                samlBinding.setAssertionId(this.assertionId);
                samlBinding.setIncludeToken(this.getIncludeToken());
                samlBinding.setPolicyTokenFlag(this.policyTokenWasSet());
                samlBinding.isOptional(this._isOptional);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return samlBinding;
        }

        public String getType() {
            return "SAMLAssertionBinding";
        }

        public void setSTRID(String id) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set SAML STRID : Policy is ReadOnly");
            }
            this.strId = id;
        }

        public String getSTRID() {
            return this.strId;
        }

        public void setAssertionId(String id) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set SAML AssertionID : Policy is ReadOnly");
            }
            this.assertionId = id;
        }

        public String getAssertionId() {
            return this.assertionId;
        }

        public String toString() {
            return "SAMLAssertionBinding::" + this.getReferenceType() + "::" + this._type;
        }

        public Element get_assertion() {
            return this._assertion;
        }

        public String getRealId() {
            return this.assertionId;
        }

        public void setRealId(String realId) {
        }
    }

    public static class UsernameTokenBinding
    extends KeyBindingBase {
        String nonce = MessageConstants._EMPTY;
        String username = MessageConstants._EMPTY;
        String password = MessageConstants._EMPTY;
        String _referenceType = MessageConstants._EMPTY;
        UsernameToken usernametoken = null;
        String _valueType = MessageConstants._EMPTY;
        boolean useNonce = false;
        boolean doDigest = false;
        boolean noPasswd = false;
        long maxNonceAge = 0L;
        private String strId = null;
        String _keyAlgorithm = MessageConstants._EMPTY;
        private byte[] sKey = null;
        private SecretKey secretKey = null;
        private SecretKey Key = null;
        private boolean endorsing;
        boolean useCreated = false;

        public UsernameTokenBinding() {
            this.setPolicyIdentifier("UsernameTokenBinding");
        }

        public UsernameTokenBinding(String username, String password, String nonce, boolean doDigest, String creationTime) {
            this();
            this.username = username;
            this.password = password;
            this.nonce = nonce;
            this.doDigest = doDigest;
        }

        public String getReferenceType() {
            return this._referenceType;
        }

        public UsernameToken getUsernameToken() {
            return this.usernametoken;
        }

        public void isEndorsing(boolean flag) {
            this.endorsing = flag;
        }

        public boolean isEndorsing() {
            return this.endorsing;
        }

        public void setUsernameToken(UsernameToken token) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set UsernameToken : Policy is ReadOnly");
            }
            this.usernametoken = token;
        }

        public void setReferenceType(String referenceType) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set ReferenceType of UsernameToken : Policy is ReadOnly");
            }
            this._referenceType = referenceType;
        }

        public MLSPolicy newTimestampFeatureBinding() throws PolicyGenerationException {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not create a feature binding of Timestamp type for ReadOnly " + this._policyIdentifier);
            }
            if (this._policyIdentifier != "UsernameTokenBinding" && this._policyIdentifier != "SignaturePolicy.FeatureBinding") {
                throw new PolicyGenerationException("Can not create a feature binding of Timestamp type for " + this._policyIdentifier);
            }
            this._featureBinding = new TimestampPolicy();
            return this._featureBinding;
        }

        public void setUsername(String username) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set Username : Policy is ReadOnly");
            }
            this.username = username;
        }

        public void setPassword(String password) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set Password : Policy is ReadOnly");
            }
            this.password = password;
        }

        public void setNonce(String nonce) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set Nonce : Policy is ReadOnly");
            }
            this.nonce = nonce;
        }

        public void setUseNonce(boolean useNonce) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set useNonce flag : Policy is ReadOnly");
            }
            this.useNonce = useNonce;
        }

        public void setUseCreated(boolean useCreated) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set useCreated flag : Policy is ReadOnly");
            }
            this.useCreated = useCreated;
        }

        public void setDigestOn(boolean doDigest) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set digest flag : Policy is ReadOnly");
            }
            this.doDigest = doDigest;
        }

        public void setMaxNonceAge(long nonceAge) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set maxNonceAge flag : Policy is ReadOnly");
            }
            this.maxNonceAge = nonceAge;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public String getNonce() {
            return this.nonce;
        }

        public boolean getUseNonce() {
            return this.useNonce;
        }

        public boolean getUseCreated() {
            return this.useCreated;
        }

        public boolean getDigestOn() {
            return this.doDigest;
        }

        public long getMaxNonceAge() {
            return this.maxNonceAge;
        }

        public boolean hasNoPassword() {
            return this.noPasswd;
        }

        public void setNoPassword(boolean value) {
            this.noPasswd = value;
        }

        public void setSTRID(String id) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set STRID attribute : Policy is ReadOnly");
            }
            this.strId = id;
        }

        public String getSTRID() {
            return this.strId;
        }

        public void setValueType(String valueType) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set valueType of usernameToken : Policy is ReadOnly");
            }
            this._valueType = valueType;
        }

        public void setKeyAlgorithm(String keyAlgorithm) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set KeyAlgorithm : Policy is ReadOnly");
            }
            this._keyAlgorithm = keyAlgorithm;
        }

        public String getKeyAlgorithm() {
            return this._keyAlgorithm;
        }

        public void setSecretKey(SecretKey secretKey) {
            this.secretKey = secretKey;
        }

        public void setSecretKey(byte[] secretKey) {
            this.sKey = secretKey;
        }

        public SecretKey getSecretKey(String algorithm) {
            if (this.Key == null) {
                this.Key = new SecretKeySpec(this.sKey, algorithm);
            }
            return this.Key;
        }

        public SecretKey getSecretKey() {
            return this.secretKey;
        }

        public boolean equals(WSSPolicy policy) {
            boolean assrt = false;
            try {
                if (!PolicyTypeUtil.usernameTokenPolicy(policy)) {
                    return false;
                }
                UsernameTokenBinding utBinding = (UsernameTokenBinding)policy;
                assrt = this.useNonce == utBinding.getUseNonce() && this.doDigest == utBinding.getDigestOn() && this.useCreated == utBinding.getUseCreated();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return assrt;
        }

        public boolean equalsIgnoreTargets(WSSPolicy policy) {
            return this.equals(policy);
        }

        public Object clone() {
            UsernameTokenBinding utBinding = new UsernameTokenBinding();
            try {
                utBinding.setUsername(this.username);
                utBinding.setPassword(this.password);
                utBinding.setNonce(this.nonce);
                utBinding.setUseNonce(this.useNonce);
                utBinding.setUseCreated(this.useCreated);
                utBinding.setReferenceType(this._referenceType);
                utBinding.setDigestOn(this.doDigest);
                utBinding.setUsernameToken(this.usernametoken);
                utBinding.setUUID(this.UUID);
                WSSPolicy kBinding = (WSSPolicy)this.getKeyBinding();
                if (kBinding != null) {
                    utBinding.setKeyBinding((MLSPolicy)kBinding.clone());
                }
                utBinding.isEndorsing(this.endorsing);
                utBinding.setIncludeToken(this.getIncludeToken());
                utBinding.setPolicyTokenFlag(this.policyTokenWasSet());
                utBinding.isOptional(this._isOptional);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return utBinding;
        }

        public String getType() {
            return "UsernameTokenBinding";
        }

        public String toString() {
            return "UsernameTokenBinding::" + this.getUsername();
        }
    }

    public static class X509CertificateBinding
    extends KeyBindingBase {
        String _valueType = MessageConstants._EMPTY;
        String _encodingType = MessageConstants._EMPTY;
        String _referenceType = MessageConstants._EMPTY;
        X509Certificate _certificate = null;
        String _keyAlgorithm = MessageConstants._EMPTY;
        String _certificateIdentifier = "";
        String strId = null;

        public X509CertificateBinding() {
            this.setPolicyIdentifier("X509CertificateBinding");
        }

        public X509CertificateBinding(String certificateIdentifier, String keyAlgorithm) {
            this();
            this._certificateIdentifier = certificateIdentifier;
            this._keyAlgorithm = keyAlgorithm;
        }

        public MLSPolicy newPrivateKeyBinding() {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not create PrivateKeyBinding : Policy is Readonly");
            }
            this._keyBinding = new PrivateKeyBinding();
            return this._keyBinding;
        }

        public void setValueType(String valueType) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set ValueType of X509Certificate : Policy is ReadOnly");
            }
            this._valueType = valueType;
        }

        public void setEncodingType(String encodingType) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set EncodingType of X509Certificate : Policy is ReadOnly");
            }
            this._encodingType = encodingType;
        }

        public void setReferenceType(String referenceType) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set ReferenceType of X509Certificate : Policy is ReadOnly");
            }
            this._referenceType = referenceType;
        }

        public void setCertificateIdentifier(String certificateIdentifier) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set X509Certificate Identifier : Policy is ReadOnly");
            }
            this._certificateIdentifier = certificateIdentifier;
        }

        public void setX509Certificate(X509Certificate certificate) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set X509Certificate : Policy is ReadOnly");
            }
            this._certificate = certificate;
        }

        public String getValueType() {
            return this._valueType;
        }

        public String getEncodingType() {
            return this._encodingType;
        }

        public String getReferenceType() {
            return this._referenceType;
        }

        public String getCertificateIdentifier() {
            return this._certificateIdentifier;
        }

        public X509Certificate getX509Certificate() {
            return this._certificate;
        }

        public void setKeyAlgorithm(String keyAlgorithm) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set KeyAlgorithm : Policy is ReadOnly");
            }
            this._keyAlgorithm = keyAlgorithm;
        }

        public String getKeyAlgorithm() {
            return this._keyAlgorithm;
        }

        public void setSTRID(String id) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set STRID attribute : Policy is ReadOnly");
            }
            this.strId = id;
        }

        public String getSTRID() {
            return this.strId;
        }

        public boolean equals(WSSPolicy policy) {
            boolean assrt = false;
            try {
                boolean b4;
                boolean b3;
                boolean b2;
                boolean b1;
                if (!PolicyTypeUtil.x509CertificateBinding(policy)) {
                    return false;
                }
                X509CertificateBinding ctBinding = (X509CertificateBinding)policy;
                boolean bl = b1 = this._valueType.equals("") ? true : this._valueType.equals(ctBinding.getValueType());
                if (!b1) {
                    return false;
                }
                boolean bl2 = b2 = this._encodingType.equals("") ? true : this._encodingType.equals(ctBinding.getEncodingType());
                if (!b2) {
                    return false;
                }
                boolean bl3 = b3 = this._referenceType.equals("") ? true : this._referenceType.equals(ctBinding.getReferenceType());
                if (!b3) {
                    return false;
                }
                boolean bl4 = b4 = this._keyAlgorithm.equals("") ? true : this._keyAlgorithm.equals(ctBinding.getKeyAlgorithm());
                if (!b4) {
                    return false;
                }
                if (this.strId == null && ctBinding.getSTRID() == null) {
                    return true;
                }
                if (this.strId != null && this.strId.equals(ctBinding.getSTRID())) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }

        public boolean equalsIgnoreTargets(WSSPolicy policy) {
            return this.equals(policy);
        }

        public Object clone() {
            X509CertificateBinding x509Binding = new X509CertificateBinding();
            try {
                x509Binding.setValueType(this._valueType);
                x509Binding.setEncodingType(this._encodingType);
                x509Binding.setReferenceType(this._referenceType);
                x509Binding.setKeyAlgorithm(this._keyAlgorithm);
                x509Binding.setCertificateIdentifier(this._certificateIdentifier);
                x509Binding.setX509Certificate(this._certificate);
                x509Binding.setUUID(this.UUID);
                x509Binding.setSTRID(this.strId);
                WSSPolicy kBinding = (WSSPolicy)this.getKeyBinding();
                if (kBinding != null) {
                    x509Binding.setKeyBinding((MLSPolicy)kBinding.clone());
                }
                x509Binding.setIncludeToken(this.getIncludeToken());
                x509Binding.setPolicyTokenFlag(this.policyTokenWasSet());
                x509Binding.isOptional(this._isOptional);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return x509Binding;
        }

        public String getType() {
            return "X509CertificateBinding";
        }

        public String toString() {
            return "X509CertificateBinding::" + this.getCertificateIdentifier() + "::" + this.strId + "::" + this._referenceType;
        }
    }
}

