/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.broker;

import com.sun.messaging.jmq.admin.apps.broker.BrokerCmdException;
import com.sun.messaging.jmq.admin.apps.broker.BrokerCmdHelpPrinter;
import com.sun.messaging.jmq.admin.apps.broker.BrokerCmdOptionParser;
import com.sun.messaging.jmq.admin.apps.broker.BrokerCmdOptions;
import com.sun.messaging.jmq.admin.apps.broker.BrokerCmdPrinter;
import com.sun.messaging.jmq.admin.apps.broker.BrokerCmdProperties;
import com.sun.messaging.jmq.admin.apps.broker.CmdRunner;
import com.sun.messaging.jmq.admin.apps.broker.CommonCmdRunnerUtil;
import com.sun.messaging.jmq.admin.bkrutil.BrokerConstants;
import com.sun.messaging.jmq.admin.resources.AdminResources;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.options.OptionException;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;

public class BrokerCmd
implements BrokerCmdOptions,
BrokerConstants {
    private static AdminResources ar = Globals.getAdminResources();

    public static void main(String[] stringArray) {
        String string;
        String string2;
        Enumeration<?> enumeration;
        Properties properties;
        Object object;
        int n = 0;
        if (BrokerCmd.silentModeOptionSpecified(stringArray)) {
            Globals.setSilentMode(true);
        }
        if (BrokerCmd.shortHelpOptionSpecified(stringArray)) {
            object = new BrokerCmdHelpPrinter();
            ((BrokerCmdHelpPrinter)object).printShortHelp(0);
        } else if (BrokerCmd.longHelpOptionSpecified(stringArray)) {
            object = new BrokerCmdHelpPrinter();
            ((BrokerCmdHelpPrinter)object).printLongHelp();
        }
        if (BrokerCmd.versionOptionSpecified(stringArray)) {
            CommonCmdRunnerUtil.printBanner();
            CommonCmdRunnerUtil.printVersion();
            System.exit(0);
        }
        object = null;
        try {
            object = BrokerCmdOptionParser.parseArgs(stringArray);
        }
        catch (OptionException optionException) {
            CommonCmdRunnerUtil.handleArgsParsingExceptions(optionException, "-p", "imqcmd");
            System.exit(1);
        }
        String string3 = ((BrokerCmdProperties)object).getInputFileName();
        if (string3 != null && !string3.equals("")) {
            properties = new BrokerCmdProperties();
            try {
                enumeration = new FileInputStream(string3);
                properties.load((InputStream)((Object)enumeration));
            }
            catch (Exception exception) {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3080"), false);
                Globals.stdErrPrintln(exception.toString());
                System.exit(1);
            }
            enumeration = ((Properties)object).propertyNames();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                if (string2 == null || (string = ((Properties)object).getProperty(string2)) == null || string2.equals("inputfile")) continue;
                properties.put(string2, string);
            }
            object = properties;
        }
        try {
            BrokerCmd.checkOptions((BrokerCmdProperties)object);
        }
        catch (BrokerCmdException brokerCmdException) {
            BrokerCmd.handleCheckOptionsExceptions(brokerCmdException);
            System.exit(1);
        }
        properties = ((BrokerCmdProperties)object).getSysProps();
        if (properties != null && properties.size() > 0) {
            enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                string = properties.getProperty(string2);
                if (((BrokerCmdProperties)object).adminDebugModeSet()) {
                    Globals.stdOutPrintln("Setting system property: " + string2 + "=" + string);
                }
                try {
                    System.setProperty(string2, string);
                }
                catch (Exception exception) {
                    Globals.stdErrPrintln("Failed to set system property: " + string2 + "=" + string);
                    Globals.stdErrPrintln(exception.toString());
                }
            }
        }
        enumeration = new CmdRunner((BrokerCmdProperties)object);
        n = ((CmdRunner)((Object)enumeration)).runCommands();
        System.exit(n);
    }

    private static void checkOptions(BrokerCmdProperties brokerCmdProperties) throws BrokerCmdException {
        String string;
        if (brokerCmdProperties.debugModeSet() || brokerCmdProperties.noCheckModeSet()) {
            return;
        }
        String string2 = brokerCmdProperties.getCommand();
        if (string2 == null) {
            BrokerCmdException brokerCmdException = new BrokerCmdException(10000);
            brokerCmdException.setProperties(brokerCmdProperties);
            throw brokerCmdException;
        }
        BrokerCmd.checkWarnPassword(brokerCmdProperties);
        if (string2.equals("list")) {
            BrokerCmd.checkList(brokerCmdProperties);
        } else if (string2.equals("pause")) {
            BrokerCmd.checkPause(brokerCmdProperties);
        } else if (string2.equals("resume")) {
            BrokerCmd.checkResume(brokerCmdProperties);
        } else if (string2.equals("shutdown")) {
            BrokerCmd.checkShutdown(brokerCmdProperties);
        } else if (string2.equals("restart")) {
            BrokerCmd.checkRestart(brokerCmdProperties);
        } else if (string2.equals("create")) {
            BrokerCmd.checkCreate(brokerCmdProperties);
        } else if (string2.equals("destroy")) {
            BrokerCmd.checkDestroy(brokerCmdProperties);
        } else if (string2.equals(".destroyall")) {
            BrokerCmd.checkDestroyAll(brokerCmdProperties);
        } else if (string2.equals("purge")) {
            BrokerCmd.checkPurge(brokerCmdProperties);
        } else if (string2.equals(".purgeall")) {
            BrokerCmd.checkPurgeAll(brokerCmdProperties);
        } else if (string2.equals("update")) {
            BrokerCmd.checkUpdate(brokerCmdProperties);
        } else if (string2.equals("query")) {
            BrokerCmd.checkQuery(brokerCmdProperties);
        } else if (string2.equals("metrics")) {
            BrokerCmd.checkMetrics(brokerCmdProperties);
        } else if (string2.equals("reload")) {
            BrokerCmd.checkReload(brokerCmdProperties);
        } else if (string2.equals("changemaster")) {
            BrokerCmd.checkChangeMaster(brokerCmdProperties);
        } else if (string2.equals("commit")) {
            BrokerCmd.checkCommit(brokerCmdProperties);
        } else if (string2.equals("rollback")) {
            BrokerCmd.checkRollback(brokerCmdProperties);
        } else if (string2.equals("compact")) {
            BrokerCmd.checkCompact(brokerCmdProperties);
        } else if (string2.equals("quiesce")) {
            BrokerCmd.checkQuiesce(brokerCmdProperties);
        } else if (string2.equals("takeover")) {
            BrokerCmd.checkTakeover(brokerCmdProperties);
        } else if (string2.equals("unquiesce")) {
            BrokerCmd.checkUnquiesce(brokerCmdProperties);
        } else if (string2.equals("reset")) {
            BrokerCmd.checkReset(brokerCmdProperties);
        } else if (string2.equals("checkpoint")) {
            BrokerCmd.checkCheckpoint(brokerCmdProperties);
        } else if (string2.equals(".exists")) {
            BrokerCmd.checkExists(brokerCmdProperties);
        } else if (string2.equals(".getattr")) {
            BrokerCmd.checkGetAttr(brokerCmdProperties);
        } else if (string2.equals("._kill")) {
            BrokerCmd.checkUngracefulKill(brokerCmdProperties);
        } else {
            BrokerCmdException brokerCmdException = new BrokerCmdException(10001);
            brokerCmdException.setProperties(brokerCmdProperties);
            throw brokerCmdException;
        }
        String string3 = brokerCmdProperties.getProperty("receiveTimeout");
        if (string3 != null) {
            try {
                int n = BrokerCmd.checkIntegerValue(brokerCmdProperties, "receiveTimeout", string3);
            }
            catch (Exception exception) {
                BrokerCmdException brokerCmdException = new BrokerCmdException(10004);
                brokerCmdException.setProperties(brokerCmdProperties);
                brokerCmdException.setErrorString(string3);
                throw brokerCmdException;
            }
        }
        if ((string = brokerCmdProperties.getProperty("numRetries")) != null) {
            try {
                int n = BrokerCmd.checkIntegerValue(brokerCmdProperties, "numRetries", string);
            }
            catch (Exception exception) {
                BrokerCmdException brokerCmdException = new BrokerCmdException(10005);
                brokerCmdException.setProperties(brokerCmdProperties);
                brokerCmdException.setErrorString(string);
                throw brokerCmdException;
            }
        }
    }

    private static void checkList(BrokerCmdProperties brokerCmdProperties) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProperties, CMD_LIST_VALID_CMDARGS);
        String string = brokerCmdProperties.getCommandArg();
        if (string.equals("dst")) {
            String string2 = brokerCmdProperties.getDestType();
            if (string2 != null) {
                BrokerCmd.checkDestType(brokerCmdProperties);
            }
        } else if (string.equals("msg")) {
            BrokerCmd.checkDestType(brokerCmdProperties);
            BrokerCmd.checkTargetName(brokerCmdProperties);
        }
    }

    private static void checkCompact(BrokerCmdProperties brokerCmdProperties) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProperties, CMD_COMPACT_VALID_CMDARGS);
        String string = brokerCmdProperties.getCommandArg();
        if (string.equals("dst")) {
            String string2 = brokerCmdProperties.getDestType();
            String string3 = brokerCmdProperties.getTargetName();
            if (string2 != null) {
                BrokerCmd.checkDestType(brokerCmdProperties);
                BrokerCmd.checkTargetName(brokerCmdProperties);
            } else if (string3 != null) {
                BrokerCmd.checkDestType(brokerCmdProperties);
            }
        }
    }

    private static void checkQuiesce(BrokerCmdProperties brokerCmdProperties) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProperties, CMD_QUIESCE_VALID_CMDARGS);
    }

    private static void checkUnquiesce(BrokerCmdProperties brokerCmdProperties) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProperties, CMD_UNQUIESCE_VALID_CMDARGS);
    }

    private static void checkTakeover(BrokerCmdProperties brokerCmdProperties) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProperties, CMD_TAKEOVER_VALID_CMDARGS);
        BrokerCmd.checkTargetName(brokerCmdProperties);
    }

    private static void checkPause(BrokerCmdProperties brokerCmdProperties) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProperties, CMD_PAUSE_VALID_CMDARGS);
        String string = brokerCmdProperties.getCommandArg();
        if (string.equals("svc")) {
            BrokerCmd.checkTargetName(brokerCmdProperties);
        } else if (string.equals("dst")) {
            String string2 = brokerCmdProperties.getDestType();
            String string3 = brokerCmdProperties.getTargetName();
            if (string2 != null) {
                BrokerCmd.checkDestType(brokerCmdProperties);
                BrokerCmd.checkTargetName(brokerCmdProperties);
            } else if (string3 != null) {
                BrokerCmd.checkDestType(brokerCmdProperties);
            }
            BrokerCmd.checkPauseDstType(brokerCmdProperties);
        }
    }

    private static void checkResume(BrokerCmdProperties brokerCmdProperties) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProperties, CMD_RESUME_VALID_CMDARGS);
        String string = brokerCmdProperties.getCommandArg();
        if (string.equals("svc")) {
            BrokerCmd.checkTargetName(brokerCmdProperties);
        } else if (string.equals("dst")) {
            String string2 = brokerCmdProperties.getDestType();
            String string3 = brokerCmdProperties.getTargetName();
            if (string2 != null) {
                BrokerCmd.checkDestType(brokerCmdProperties);
                BrokerCmd.checkTargetName(brokerCmdProperties);
            } else if (string3 != null) {
                BrokerCmd.checkDestType(brokerCmdProperties);
            }
        }
    }

    private static void checkReset(BrokerCmdProperties brokerCmdProperties) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProperties, CMD_RESET_VALID_CMDARGS);
        String string = brokerCmdProperties.getCommandArg();
        if (string.equals("bkr")) {
            BrokerCmd.checkResetType(brokerCmdProperties);
        }
    }

    private static void checkCheckpoint(BrokerCmdProperties brokerCmdProperties) throws BrokerCmdException {
    }

    private static void checkShutdown(BrokerCmdProperties brokerCmdProperties) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProperties, CMD_SHUTDOWN_VALID_CMDARGS);
        BrokerCmd.checkTimeValue(brokerCmdProperties);
    }

    private static void checkRestart(BrokerCmdProperties brokerCmdProperties) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProperties, CMD_RESTART_VALID_CMDARGS);
    }

    private static void checkCreate(BrokerCmdProperties brokerCmdProperties) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProperties, CMD_CREATE_VALID_CMDARGS);
        String string = brokerCmdProperties.getCommandArg();
        if (string.equals("dst")) {
            int n = -1;
            String[] stringArray = null;
            String[] stringArray2 = null;
            BrokerCmd.checkDestType(brokerCmdProperties);
            BrokerCmd.checkTargetName(brokerCmdProperties);
            String string2 = brokerCmdProperties.getDestType();
            if (string2.equals("t")) {
                stringArray = CREATE_DST_TOPIC_VALID_ATTRS;
                n = 13;
            } else if (string2.equals("q")) {
                stringArray = CREATE_DST_QUEUE_VALID_ATTRS;
                stringArray2 = CREATE_DST_QUEUE_DEPRECATED_ATTRS;
                n = 12;
            }
            BrokerCmd.checkDeprecatedAttrs(brokerCmdProperties, stringArray2);
            BrokerCmd.checkValidAttrs(brokerCmdProperties, stringArray, n);
            Properties properties = brokerCmdProperties.getTargetAttrs();
            String string3 = properties.getProperty("maxTotalMsgBytes");
            if (string3 != null) {
                BrokerCmd.checkByteValue(brokerCmdProperties, "maxTotalMsgBytes", string3);
            }
            if ((string3 = properties.getProperty("maxBytesPerMsg")) != null) {
                BrokerCmd.checkByteValue(brokerCmdProperties, "maxBytesPerMsg", string3);
            }
            if ((string3 = properties.getProperty("maxNumMsgs")) != null) {
                BrokerCmd.checkLongValue(brokerCmdProperties, "maxNumMsgs", string3);
            }
            if ((string3 = properties.getProperty("isLocalOnly")) != null) {
                BrokerCmd.checkBooleanValue(brokerCmdProperties, "isLocalOnly", string3);
            }
            if ((string3 = properties.getProperty("limitBehavior")) != null) {
                BrokerCmd.checkLimitBehaviourValue(brokerCmdProperties, "limitBehavior", string3);
            }
            if ((string3 = properties.getProperty("consumerFlowLimit")) != null) {
                BrokerCmd.checkIntegerValue(brokerCmdProperties, "consumerFlowLimit", string3);
            }
            if ((string3 = properties.getProperty("maxNumProducers")) != null) {
                BrokerCmd.checkIntegerValue(brokerCmdProperties, "maxNumProducers", string3);
            }
            if ((string3 = properties.getProperty("useDMQ")) != null) {
                BrokerCmd.checkBooleanValue(brokerCmdProperties, "useDMQ", string3);
            }
            if ((string3 = properties.getProperty("validateXMLSchemaEnabled")) != null) {
                BrokerCmd.checkBooleanValue(brokerCmdProperties, "validateXMLSchemaEnabled", string3);
            }
            if ((string3 = properties.getProperty("reloadXMLSchemaOnFailure")) != null) {
                BrokerCmd.checkBooleanValue(brokerCmdProperties, "reloadXMLSchemaOnFailure", string3);
            }
            if (string2.equals("q")) {
                string3 = properties.getProperty("maxNumBackupConsumers");
                if (string3 != null) {
                    BrokerCmd.checkIntegerValue(brokerCmdProperties, "maxNumBackupConsumers", string3);
                }
                if ((string3 = properties.getProperty("maxNumActiveConsumers")) != null) {
                    BrokerCmd.checkIntegerValue(brokerCmdProperties, "maxNumActiveConsumers", string3);
                }
                if ((string3 = properties.getProperty("localDeliveryPreferred")) != null) {
                    BrokerCmd.checkBooleanValue(brokerCmdProperties, "localDeliveryPreferred", string3);
                }
            }
            BrokerCmd.checkUnlimitedValues(brokerCmdProperties, DEST_ATTRS_UNLIMITED_CONV);
        }
    }

    private static void checkValidAttrs(BrokerCmdProperties brokerCmdProperties, String[] stringArray, int n) throws BrokerCmdException {
        Properties properties = brokerCmdProperties.getTargetAttrs();
        BrokerCmdException brokerCmdException = null;
        if (properties == null) {
            return;
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (BrokerCmd.arrayContainsStr(stringArray, string)) continue;
            brokerCmdException = new BrokerCmdException(n);
            brokerCmdException.setProperties(brokerCmdProperties);
            brokerCmdException.setValidAttrs(stringArray);
            brokerCmdException.setBadAttr(string);
            throw brokerCmdException;
        }
    }

    private static void checkCreateOnlyAttrs(BrokerCmdProperties brokerCmdProperties, String[] stringArray, String[] stringArray2, int n) throws BrokerCmdException {
        Properties properties = brokerCmdProperties.getTargetAttrs();
        BrokerCmdException brokerCmdException = null;
        if (properties == null) {
            return;
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!BrokerCmd.arrayContainsStr(stringArray, string)) continue;
            brokerCmdException = new BrokerCmdException(n);
            brokerCmdException.setProperties(brokerCmdProperties);
            brokerCmdException.setValidAttrs(stringArray2);
            brokerCmdException.setBadAttr(string);
            throw brokerCmdException;
        }
    }

    private static void checkDeprecatedAttrs(BrokerCmdProperties brokerCmdProperties, String[] stringArray) throws BrokerCmdException {
        Properties properties = brokerCmdProperties.getTargetAttrs();
        Object var3_3 = null;
        if (properties == null || stringArray == null) {
            return;
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!BrokerCmd.arrayContainsStr(stringArray, string)) continue;
            String string2 = properties.getProperty(string);
            BrokerCmd.handleDeprecatedAttr(brokerCmdProperties, string, string2);
        }
    }

    private static void handleDeprecatedAttr(BrokerCmdProperties brokerCmdProperties, String string, String string2) throws BrokerCmdException {
        Properties properties = brokerCmdProperties.getTargetAttrs();
        if (string.equals("queueDeliveryPolicy")) {
            String string3 = string2;
            String string4 = null;
            String string5 = null;
            if (string3 == null) {
                return;
            }
            BrokerCmd.checkFlavorType(brokerCmdProperties, string3, 32);
            string4 = properties.getProperty("maxNumBackupConsumers");
            string5 = properties.getProperty("maxNumActiveConsumers");
            if (string4 == null && string5 == null) {
                if (string3.equals("s")) {
                    string5 = "1";
                    string4 = "0";
                } else if (string3.equals("f")) {
                    string5 = "1";
                    string4 = "-1";
                } else if (string3.equals("r")) {
                    string5 = "-1";
                    string4 = "0";
                }
                brokerCmdProperties.setTargetAttr("maxNumBackupConsumers", string4);
                brokerCmdProperties.setTargetAttr("maxNumActiveConsumers", string5);
                Globals.stdErrPrintln(ar.getString("A1000"), ar.getKString("A2005"));
                Object[] objectArray = new Object[]{string3, string4, string5};
                Globals.stdErrPrintln(ar.getString("A1000"), ar.getKString("A2006", objectArray));
            } else {
                Globals.stdErrPrintln(ar.getString("A1000"), ar.getKString("A2005"));
                Globals.stdErrPrintln(ar.getString("A1000"), ar.getKString("A2007", string3));
            }
            brokerCmdProperties.removeTargetAttr("queueDeliveryPolicy");
        } else if (string.equals("imq.queue.deliverypolicy")) {
            String string6 = string2;
            String string7 = null;
            String string8 = null;
            if (string6 == null) {
                return;
            }
            BrokerCmd.checkFlavorType(brokerCmdProperties, string6, 33);
            string7 = properties.getProperty("imq.autocreate.queue.maxNumBackupConsumers");
            string8 = properties.getProperty("imq.autocreate.queue.maxNumActiveConsumers");
            if (string7 == null && string8 == null) {
                if (string6.equals("s")) {
                    string8 = "1";
                    string7 = "0";
                } else if (string6.equals("f")) {
                    string8 = "1";
                    string7 = "-1";
                } else if (string6.equals("r")) {
                    string8 = "-1";
                    string7 = "0";
                }
                brokerCmdProperties.setTargetAttr("imq.autocreate.queue.maxNumBackupConsumers", string7);
                brokerCmdProperties.setTargetAttr("imq.autocreate.queue.maxNumActiveConsumers", string8);
                Globals.stdErrPrintln(ar.getString("A1000"), ar.getKString("A2008"));
                Object[] objectArray = new Object[]{string6, string7, string8};
                Globals.stdErrPrintln(ar.getString("A1000"), ar.getKString("A2009", objectArray));
            } else {
                Globals.stdErrPrintln(ar.getString("A1000"), ar.getKString("A2008"));
                Globals.stdErrPrintln(ar.getString("A1000"), ar.getKString("A2010", string6));
            }
            brokerCmdProperties.removeTargetAttr("imq.queue.deliverypolicy");
        }
    }

    private static void checkUnlimitedValues(BrokerCmdProperties brokerCmdProperties, String[] stringArray) throws BrokerCmdException {
        String string;
        String string2;
        Properties properties = brokerCmdProperties.getTargetAttrs();
        Properties properties2 = new Properties();
        Object var4_4 = null;
        if (properties == null || stringArray == null) {
            return;
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (!BrokerCmd.arrayContainsStr(stringArray, string2) || !(string = properties.getProperty(string2)).equals("0")) continue;
            properties2.setProperty(string2, string);
        }
        if (properties2.size() > 0) {
            Globals.stdErrPrintln(ar.getString("A1000"), ar.getKString("A2011", "0"));
            enumeration = properties2.propertyNames();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                string = properties.getProperty(string2);
                Globals.stdErrPrintln("\t" + string2 + "=" + string);
            }
            Globals.stdErrPrintln("");
            Globals.stdErrPrintln(ar.getString("A2012", "-1"));
            Globals.stdErrPrintln(ar.getString("A2013"));
            enumeration = properties2.propertyNames();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                string = properties.getProperty(string2);
                Globals.stdErrPrintln("\t" + string2 + "=-1");
                brokerCmdProperties.setTargetAttr(string2, "-1");
            }
            Globals.stdErrPrintln("");
        }
    }

    private static void checkValidSingleAttr(BrokerCmdProperties brokerCmdProperties, String[] stringArray) throws BrokerCmdException {
        String string = brokerCmdProperties.getSingleTargetAttr();
        BrokerCmdException brokerCmdException = null;
        if (string == null) {
            brokerCmdException = new BrokerCmdException(25);
            brokerCmdException.setProperties(brokerCmdProperties);
            throw brokerCmdException;
        }
        if (stringArray != null && !BrokerCmd.arrayContainsStr(stringArray, string)) {
            brokerCmdException = new BrokerCmdException(24);
            brokerCmdException.setProperties(brokerCmdProperties);
            brokerCmdException.setValidAttrs(stringArray);
            brokerCmdException.setBadAttr(string);
            throw brokerCmdException;
        }
    }

    private static boolean arrayContainsStr(String[] stringArray, String string) {
        if (stringArray == null || string == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private static void checkFlavorType(BrokerCmdProperties brokerCmdProperties, String string) throws BrokerCmdException {
        BrokerCmd.checkFlavorType(brokerCmdProperties, string, -1);
    }

    private static void checkFlavorType(BrokerCmdProperties brokerCmdProperties, String string, int n) throws BrokerCmdException {
        BrokerCmdException brokerCmdException = null;
        if (n == -1) {
            n = 8;
        }
        if (!("s".equals(string) || "f".equals(string) || "r".equals(string))) {
            brokerCmdException = new BrokerCmdException(n);
            brokerCmdException.setProperties(brokerCmdProperties);
            brokerCmdException.setBadValue(string);
            throw brokerCmdException;
        }
    }

    private static void checkPauseDstType(BrokerCmdProperties brokerCmdProperties) throws BrokerCmdException {
        BrokerCmdException brokerCmdException = null;
        String string = brokerCmdProperties.getPauseType();
        if (string == null) {
            return;
        }
        for (int i = 0; i < PAUSE_DST_TYPE_VALID_VALUES.length; ++i) {
            if (!string.equals(PAUSE_DST_TYPE_VALID_VALUES[i])) continue;
            return;
        }
        brokerCmdException = new BrokerCmdException(27);
        brokerCmdException.setProperties(brokerCmdProperties);
        brokerCmdException.setBadValue(string);
        throw brokerCmdException;
    }

    private static void checkResetType(BrokerCmdProperties brokerCmdProperties) throws BrokerCmdException {
        BrokerCmdException brokerCmdException = null;
        String string = brokerCmdProperties.getResetType();
        if (string == null) {
            return;
        }
        for (int i = 0; i < RESET_BKR_TYPE_VALID_VALUES.length; ++i) {
            if (!string.equals(RESET_BKR_TYPE_VALID_VALUES[i])) continue;
            return;
        }
        brokerCmdException = new BrokerCmdException(36);
        brokerCmdException.setProperties(brokerCmdProperties);
        brokerCmdException.setBadValue(string);
        throw brokerCmdException;
    }

    private static void checkMetricInterval(BrokerCmdProperties brokerCmdProperties) throws BrokerCmdException {
        String string = brokerCmdProperties.getProperty("metricInterval");
        BrokerCmdException brokerCmdException = null;
        if (string == null) {
            return;
        }
        try {
            long l = Long.parseLong(string);
            if (l < 0L) {
                brokerCmdException = new BrokerCmdException(20);
                brokerCmdException.setProperties(brokerCmdProperties);
                brokerCmdException.setBadValue(string);
                throw brokerCmdException;
            }
        }
        catch (NumberFormatException numberFormatException) {
            brokerCmdException = new BrokerCmdException(20);
            brokerCmdException.setProperties(brokerCmdProperties);
            brokerCmdException.setBadValue(string);
            throw brokerCmdException;
        }
    }

    private static void checkMetricSamples(BrokerCmdProperties brokerCmdProperties) throws BrokerCmdException {
        String string = brokerCmdProperties.getProperty("metricSamples");
        BrokerCmdException brokerCmdException = null;
        if (string == null) {
            return;
        }
        try {
            int n = Integer.parseInt(string);
            if (n < 0 && n != -1) {
                brokerCmdException = new BrokerCmdException(29);
                brokerCmdException.setProperties(brokerCmdProperties);
                brokerCmdException.setBadValue(string);
                throw brokerCmdException;
            }
        }
        catch (NumberFormatException numberFormatException) {
            brokerCmdException = new BrokerCmdException(29);
            brokerCmdException.setProperties(brokerCmdProperties);
            brokerCmdException.setBadValue(string);
            throw brokerCmdException;
        }
    }

    private static void checkMetricType(BrokerCmdProperties brokerCmdProperties) throws BrokerCmdException {
        String string = brokerCmdProperties.getMetricType();
        BrokerCmdException brokerCmdException = null;
        if (string == null) {
            return;
        }
        for (int i = 0; i < METRIC_TYPE_VALID_VALUES.length; ++i) {
            if (!string.equals(METRIC_TYPE_VALID_VALUES[i])) continue;
            return;
        }
        brokerCmdException = new BrokerCmdException(21);
        brokerCmdException.setProperties(brokerCmdProperties);
        brokerCmdException.setBadValue(string);
        throw brokerCmdException;
    }

    private static void checkMetricDstType(BrokerCmdProperties brokerCmdProperties) throws BrokerCmdException {
        String string = brokerCmdProperties.getMetricType();
        BrokerCmdException brokerCmdException = null;
        if (string == null) {
            return;
        }
        for (int i = 0; i < METRIC_DST_TYPE_VALID_VALUES.length; ++i) {
            if (!string.equals(METRIC_DST_TYPE_VALID_VALUES[i])) continue;
            return;
        }
        brokerCmdException = new BrokerCmdException(28);
        brokerCmdException.setProperties(brokerCmdProperties);
        brokerCmdException.setBadValue(string);
        throw brokerCmdException;
    }

    private static int checkIntegerValue(BrokerCmdProperties brokerCmdProperties, String string, String string2) throws BrokerCmdException {
        int n;
        BrokerCmdException brokerCmdException = null;
        try {
            n = Integer.parseInt(string2);
            if (n < -1) {
                brokerCmdException = new BrokerCmdException(10008);
                brokerCmdException.setProperties(brokerCmdProperties);
                brokerCmdException.setErrorString(string);
                throw brokerCmdException;
            }
        }
        catch (Exception exception) {
            brokerCmdException = new BrokerCmdException(10008);
            brokerCmdException.setProperties(brokerCmdProperties);
            brokerCmdException.setErrorString(string);
            throw brokerCmdException;
        }
        return n;
    }

    private static long checkLongValue(BrokerCmdProperties brokerCmdProperties, String string, String string2) throws BrokerCmdException {
        long l;
        BrokerCmdException brokerCmdException = null;
        try {
            l = Long.parseLong(string2);
            if (l < -1L) {
                brokerCmdException = new BrokerCmdException(10008);
                brokerCmdException.setProperties(brokerCmdProperties);
                brokerCmdException.setErrorString(string);
                throw brokerCmdException;
            }
        }
        catch (Exception exception) {
            brokerCmdException = new BrokerCmdException(10008);
            brokerCmdException.setProperties(brokerCmdProperties);
            brokerCmdException.setErrorString(string);
            throw brokerCmdException;
        }
        return l;
    }

    private static void checkByteValue(BrokerCmdProperties brokerCmdProperties, String string, String string2) throws BrokerCmdException {
        BrokerCmdException brokerCmdException = null;
        try {
            SizeString sizeString = new SizeString(string2);
            long l = sizeString.getBytes();
            if (l < -1L) {
                brokerCmdException = new BrokerCmdException(22);
                brokerCmdException.setProperties(brokerCmdProperties);
                brokerCmdException.setErrorString(string);
                throw brokerCmdException;
            }
        }
        catch (Exception exception) {
            brokerCmdException = new BrokerCmdException(22);
            brokerCmdException.setProperties(brokerCmdProperties);
            brokerCmdException.setErrorString(string);
            throw brokerCmdException;
        }
    }

    private static void checkBooleanValue(BrokerCmdProperties brokerCmdProperties, String string, String string2) throws BrokerCmdException {
        BrokerCmdException brokerCmdException = null;
        if (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("t") || string2.equalsIgnoreCase("false") || string2.equalsIgnoreCase("f")) {
            return;
        }
        brokerCmdException = new BrokerCmdException(18);
        brokerCmdException.setProperties(brokerCmdProperties);
        brokerCmdException.setErrorString(string);
        throw brokerCmdException;
    }

    private static void checkLogLevelValue(BrokerCmdProperties brokerCmdProperties, String string, String string2) throws BrokerCmdException {
        BrokerCmdException brokerCmdException = null;
        for (int i = 0; i < BKR_LOG_LEVEL_VALID_VALUES.length; ++i) {
            if (!string2.equals(BKR_LOG_LEVEL_VALID_VALUES[i])) continue;
            return;
        }
        brokerCmdException = new BrokerCmdException(19);
        brokerCmdException.setProperties(brokerCmdProperties);
        brokerCmdException.setErrorString(string);
        throw brokerCmdException;
    }

    private static void checkTimeValue(BrokerCmdProperties brokerCmdProperties) throws BrokerCmdException {
        String string = brokerCmdProperties.getProperty("time");
        BrokerCmdException brokerCmdException = null;
        if (string == null) {
            return;
        }
        try {
            int n = Integer.parseInt(string);
            if (n < 0) {
                brokerCmdException = new BrokerCmdException(10007);
                brokerCmdException.setProperties(brokerCmdProperties);
                brokerCmdException.setBadValue(string);
                throw brokerCmdException;
            }
        }
        catch (NumberFormatException numberFormatException) {
            brokerCmdException = new BrokerCmdException(10007);
            brokerCmdException.setProperties(brokerCmdProperties);
            brokerCmdException.setBadValue(string);
            throw brokerCmdException;
        }
    }

    private static void checkLimitBehaviourValue(BrokerCmdProperties brokerCmdProperties, String string, String string2) throws BrokerCmdException {
        BrokerCmdException brokerCmdException = null;
        for (int i = 0; i < BKR_LIMIT_BEHAV_VALID_VALUES.length; ++i) {
            if (!string2.equals(BKR_LIMIT_BEHAV_VALID_VALUES[i])) continue;
            return;
        }
        brokerCmdException = new BrokerCmdException(31);
        brokerCmdException.setProperties(brokerCmdProperties);
        brokerCmdException.setErrorString(string);
        throw brokerCmdException;
    }

    private static void checkDestroy(BrokerCmdProperties brokerCmdProperties) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProperties, CMD_DESTROY_VALID_CMDARGS);
        String string = brokerCmdProperties.getCommandArg();
        if (string.equals("dst")) {
            BrokerCmd.checkDestType(brokerCmdProperties);
            BrokerCmd.checkTargetName(brokerCmdProperties);
        } else if (string.equals("dur")) {
            BrokerCmd.checkTargetName(brokerCmdProperties);
            BrokerCmd.checkClientID(brokerCmdProperties);
        } else if (string.equals("cxn")) {
            BrokerCmd.checkTargetName(brokerCmdProperties);
        } else if (string.equals("msg")) {
            BrokerCmd.checkDestType(brokerCmdProperties);
            BrokerCmd.checkTargetName(brokerCmdProperties);
            BrokerCmd.checkMsgID(brokerCmdProperties);
        }
    }

    private static void checkPurge(BrokerCmdProperties brokerCmdProperties) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProperties, CMD_PURGE_VALID_CMDARGS);
        String string = brokerCmdProperties.getCommandArg();
        if (string.equals("dst")) {
            BrokerCmd.checkTargetName(brokerCmdProperties);
            BrokerCmd.checkDestType(brokerCmdProperties);
        } else if (string.equals("dur")) {
            BrokerCmd.checkTargetName(brokerCmdProperties);
            BrokerCmd.checkClientID(brokerCmdProperties);
        }
    }

    private static void checkDestroyAll(BrokerCmdProperties brokerCmdProperties) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProperties, CMD_DESTROYALL_VALID_CMDARGS);
    }

    private static void checkPurgeAll(BrokerCmdProperties brokerCmdProperties) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProperties, CMD_PURGEALL_VALID_CMDARGS);
    }

    private static void checkUpdate(BrokerCmdProperties brokerCmdProperties) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProperties, CMD_UPDATE_VALID_CMDARGS);
        String string = brokerCmdProperties.getCommandArg();
        if (string.equals("dst")) {
            int n = -1;
            int n2 = -1;
            String[] stringArray = null;
            String[] stringArray2 = null;
            BrokerCmd.checkDestType(brokerCmdProperties);
            BrokerCmd.checkTargetName(brokerCmdProperties);
            BrokerCmd.checkTargetAttrs(brokerCmdProperties);
            String string2 = brokerCmdProperties.getDestType();
            if (string2.equals("t")) {
                stringArray2 = CREATE_ONLY_DST_ATTRS;
                stringArray = UPDATE_DST_TOPIC_VALID_ATTRS;
                n = 16;
                n2 = 39;
            } else if (string2.equals("q")) {
                stringArray2 = CREATE_ONLY_DST_ATTRS;
                stringArray = UPDATE_DST_QUEUE_VALID_ATTRS;
                n = 15;
                n2 = 38;
            }
            BrokerCmd.checkCreateOnlyAttrs(brokerCmdProperties, stringArray2, stringArray, n2);
            BrokerCmd.checkValidAttrs(brokerCmdProperties, stringArray, n);
            Properties properties = brokerCmdProperties.getTargetAttrs();
            String string3 = properties.getProperty("maxTotalMsgBytes");
            if (string3 != null) {
                BrokerCmd.checkByteValue(brokerCmdProperties, "maxTotalMsgBytes", string3);
            }
            if ((string3 = properties.getProperty("maxBytesPerMsg")) != null) {
                BrokerCmd.checkByteValue(brokerCmdProperties, "maxBytesPerMsg", string3);
            }
            if ((string3 = properties.getProperty("maxNumMsgs")) != null) {
                BrokerCmd.checkLongValue(brokerCmdProperties, "maxNumMsgs", string3);
            }
            if ((string3 = properties.getProperty("limitBehavior")) != null) {
                BrokerCmd.checkLimitBehaviourValue(brokerCmdProperties, "limitBehavior", string3);
            }
            if ((string3 = properties.getProperty("consumerFlowLimit")) != null) {
                BrokerCmd.checkIntegerValue(brokerCmdProperties, "consumerFlowLimit", string3);
            }
            if ((string3 = properties.getProperty("maxNumProducers")) != null) {
                BrokerCmd.checkIntegerValue(brokerCmdProperties, "maxNumProducers", string3);
            }
            if ((string3 = properties.getProperty("useDMQ")) != null) {
                BrokerCmd.checkBooleanValue(brokerCmdProperties, "useDMQ", string3);
            }
            if ((string3 = properties.getProperty("validateXMLSchemaEnabled")) != null) {
                BrokerCmd.checkBooleanValue(brokerCmdProperties, "validateXMLSchemaEnabled", string3);
            }
            if ((string3 = properties.getProperty("reloadXMLSchemaOnFailure")) != null) {
                BrokerCmd.checkBooleanValue(brokerCmdProperties, "reloadXMLSchemaOnFailure", string3);
            }
            if (string2.equals("q")) {
                string3 = properties.getProperty("maxNumBackupConsumers");
                if (string3 != null) {
                    BrokerCmd.checkIntegerValue(brokerCmdProperties, "maxNumBackupConsumers", string3);
                }
                if ((string3 = properties.getProperty("maxNumActiveConsumers")) != null) {
                    BrokerCmd.checkIntegerValue(brokerCmdProperties, "maxNumActiveConsumers", string3);
                }
                if ((string3 = properties.getProperty("localDeliveryPreferred")) != null) {
                    BrokerCmd.checkBooleanValue(brokerCmdProperties, "localDeliveryPreferred", string3);
                }
            }
            BrokerCmd.checkUnlimitedValues(brokerCmdProperties, DEST_ATTRS_UNLIMITED_CONV);
        } else if (string.equals("bkr")) {
            String string4;
            String string5;
            String string6;
            String string7;
            String string8;
            int n = -1;
            String[] stringArray = null;
            BrokerCmd.checkTargetAttrs(brokerCmdProperties);
            BrokerCmd.checkDeprecatedAttrs(brokerCmdProperties, UPDATE_BKR_DEPRECATED_ATTRS);
            stringArray = UPDATE_BKR_VALID_ATTRS;
            n = 14;
            BrokerCmd.checkValidAttrs(brokerCmdProperties, stringArray, n);
            Properties properties = brokerCmdProperties.getTargetAttrs();
            String string9 = properties.getProperty("imq.portmapper.port");
            if (string9 != null) {
                BrokerCmd.checkIntegerValue(brokerCmdProperties, "imq.portmapper.port", string9);
            }
            if ((string8 = properties.getProperty("imq.autocreate.topic")) != null) {
                BrokerCmd.checkBooleanValue(brokerCmdProperties, "imq.autocreate.topic", string8);
            }
            if ((string8 = properties.getProperty("imq.autocreate.queue")) != null) {
                BrokerCmd.checkBooleanValue(brokerCmdProperties, "imq.autocreate.queue", string8);
            }
            if ((string7 = properties.getProperty("imq.queue.deliverypolicy")) != null) {
                BrokerCmd.checkFlavorType(brokerCmdProperties, string7);
            }
            if ((string6 = properties.getProperty("imq.log.level")) != null) {
                BrokerCmd.checkLogLevelValue(brokerCmdProperties, "imq.log.level", string6);
            }
            if ((string9 = properties.getProperty("imq.log.file.rolloverbytes")) != null) {
                BrokerCmd.checkIntegerValue(brokerCmdProperties, "imq.log.file.rolloverbytes", string9);
            }
            if ((string9 = properties.getProperty("imq.log.file.rolloversecs")) != null) {
                BrokerCmd.checkIntegerValue(brokerCmdProperties, "imq.log.file.rolloversecs", string9);
            }
            if ((string9 = properties.getProperty("imq.autocreate.queue.maxNumActiveConsumers")) != null) {
                BrokerCmd.checkIntegerValue(brokerCmdProperties, "imq.autocreate.queue.maxNumActiveConsumers", string9);
            }
            if ((string9 = properties.getProperty("imq.autocreate.queue.maxNumBackupConsumers")) != null) {
                BrokerCmd.checkIntegerValue(brokerCmdProperties, "imq.autocreate.queue.maxNumBackupConsumers", string9);
            }
            if ((string9 = properties.getProperty("imq.system.max_count")) != null) {
                BrokerCmd.checkLongValue(brokerCmdProperties, "imq.system.max_count", string9);
            }
            if ((string9 = properties.getProperty("imq.system.max_size")) != null) {
                BrokerCmd.checkByteValue(brokerCmdProperties, "imq.system.max_size", string9);
            }
            if ((string9 = properties.getProperty("imq.message.max_size")) != null) {
                BrokerCmd.checkByteValue(brokerCmdProperties, "imq.message.max_size", string9);
            }
            if ((string5 = properties.getProperty("imq.destination.logDeadMsgs")) != null) {
                BrokerCmd.checkBooleanValue(brokerCmdProperties, "imq.destination.logDeadMsgs", string5);
            }
            if ((string4 = properties.getProperty("imq.destination.DMQ.truncateBody")) != null) {
                BrokerCmd.checkBooleanValue(brokerCmdProperties, "imq.destination.DMQ.truncateBody", string4);
            }
            BrokerCmd.checkUnlimitedValues(brokerCmdProperties, BKR_ATTRS_UNLIMITED_CONV);
        } else if (string.equals("svc")) {
            int n = -1;
            String[] stringArray = null;
            BrokerCmd.checkTargetName(brokerCmdProperties);
            BrokerCmd.checkTargetAttrs(brokerCmdProperties);
            stringArray = UPDATE_SVC_VALID_ATTRS;
            n = 17;
            BrokerCmd.checkValidAttrs(brokerCmdProperties, stringArray, n);
            Properties properties = brokerCmdProperties.getTargetAttrs();
            String string10 = properties.getProperty("port");
            if (string10 != null) {
                BrokerCmd.checkIntegerValue(brokerCmdProperties, "port", string10);
            }
            if ((string10 = properties.getProperty("minThreads")) != null) {
                BrokerCmd.checkIntegerValue(brokerCmdProperties, "minThreads", string10);
            }
            if ((string10 = properties.getProperty("maxThreads")) != null) {
                BrokerCmd.checkIntegerValue(brokerCmdProperties, "maxThreads", string10);
            }
        }
    }

    private static void checkQuery(BrokerCmdProperties brokerCmdProperties) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProperties, CMD_QUERY_VALID_CMDARGS);
        String string = brokerCmdProperties.getCommandArg();
        if (string.equals("dst")) {
            BrokerCmd.checkDestType(brokerCmdProperties);
            BrokerCmd.checkTargetName(brokerCmdProperties);
        } else if (string.equals("svc")) {
            BrokerCmd.checkTargetName(brokerCmdProperties);
        } else if (string.equals("txn")) {
            BrokerCmd.checkTargetName(brokerCmdProperties);
        } else if (string.equals("cxn")) {
            BrokerCmd.checkTargetName(brokerCmdProperties);
        } else if (string.equals("msg")) {
            BrokerCmd.checkDestType(brokerCmdProperties);
            BrokerCmd.checkTargetName(brokerCmdProperties);
        }
    }

    private static void checkMetrics(BrokerCmdProperties brokerCmdProperties) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProperties, CMD_METRICS_VALID_CMDARGS);
        String string = brokerCmdProperties.getCommandArg();
        BrokerCmd.checkMetricInterval(brokerCmdProperties);
        BrokerCmd.checkMetricSamples(brokerCmdProperties);
        if (string.equals("bkr")) {
            BrokerCmd.checkMetricType(brokerCmdProperties);
        } else if (string.equals("svc")) {
            BrokerCmd.checkMetricType(brokerCmdProperties);
            BrokerCmd.checkTargetName(brokerCmdProperties);
        } else if (string.equals("dst")) {
            BrokerCmd.checkMetricDstType(brokerCmdProperties);
            BrokerCmd.checkDestType(brokerCmdProperties);
            BrokerCmd.checkTargetName(brokerCmdProperties);
        }
    }

    private static void checkReload(BrokerCmdProperties brokerCmdProperties) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProperties, CMD_RELOAD_VALID_CMDARGS);
    }

    private static void checkChangeMaster(BrokerCmdProperties brokerCmdProperties) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProperties, CMD_CHANGEMASTER_VALID_CMDARGS);
        int n = -1;
        String[] stringArray = null;
        BrokerCmd.checkTargetAttrs(brokerCmdProperties);
        stringArray = CHANGEMASTER_VALID_ATTRS;
        n = 40;
        BrokerCmd.checkValidAttrs(brokerCmdProperties, stringArray, n);
    }

    private static void checkCommit(BrokerCmdProperties brokerCmdProperties) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProperties, CMD_COMMIT_VALID_CMDARGS);
        String string = brokerCmdProperties.getCommandArg();
        if (string.equals("txn")) {
            BrokerCmd.checkTargetName(brokerCmdProperties);
        }
    }

    private static void checkRollback(BrokerCmdProperties brokerCmdProperties) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProperties, CMD_ROLLBACK_VALID_CMDARGS);
        String string = brokerCmdProperties.getCommandArg();
        if (string.equals("txn")) {
            BrokerCmd.checkTargetName(brokerCmdProperties);
        }
    }

    private static void checkExists(BrokerCmdProperties brokerCmdProperties) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProperties, CMD_EXISTS_VALID_CMDARGS);
        String string = brokerCmdProperties.getCommandArg();
        if (string.equals("dst")) {
            BrokerCmd.checkDestType(brokerCmdProperties);
            BrokerCmd.checkTargetName(brokerCmdProperties);
        }
    }

    private static void checkGetAttr(BrokerCmdProperties brokerCmdProperties) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProperties, CMD_GETATTR_VALID_CMDARGS);
        String string = brokerCmdProperties.getCommandArg();
        if (string.equals("dst")) {
            String[] stringArray = null;
            BrokerCmd.checkDestType(brokerCmdProperties);
            BrokerCmd.checkTargetName(brokerCmdProperties);
            String string2 = brokerCmdProperties.getDestType();
            if (string2.equals("t")) {
                stringArray = GETATTR_DST_TOPIC_VALID_ATTRS;
            } else if (string2.equals("q")) {
                stringArray = GETATTR_DST_QUEUE_VALID_ATTRS;
            }
            BrokerCmd.checkValidSingleAttr(brokerCmdProperties, stringArray);
        } else if (string.equals("svc")) {
            BrokerCmd.checkTargetName(brokerCmdProperties);
            BrokerCmd.checkValidSingleAttr(brokerCmdProperties, GETATTR_SVC_VALID_ATTRS);
        } else if (string.equals("bkr")) {
            BrokerCmd.checkValidSingleAttr(brokerCmdProperties, null);
        }
    }

    private static void checkUngracefulKill(BrokerCmdProperties brokerCmdProperties) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProperties, CMD_UNGRACEFUL_KILL_VALID_CMDARGS);
    }

    private static void checkDestName(BrokerCmdProperties brokerCmdProperties) throws BrokerCmdException {
        String string = brokerCmdProperties.getDestName();
        if (string == null) {
            BrokerCmdException brokerCmdException = new BrokerCmdException(5);
            brokerCmdException.setProperties(brokerCmdProperties);
            throw brokerCmdException;
        }
    }

    private static void checkCmdArg(BrokerCmdProperties brokerCmdProperties, String[] stringArray) throws BrokerCmdException {
        String string = brokerCmdProperties.getCommandArg();
        if (string == null) {
            BrokerCmdException brokerCmdException = new BrokerCmdException(10002);
            brokerCmdException.setProperties(brokerCmdProperties);
            throw brokerCmdException;
        }
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return;
        }
        BrokerCmdException brokerCmdException = new BrokerCmdException(10003);
        brokerCmdException.setProperties(brokerCmdProperties);
        brokerCmdException.setValidCmdArgs(stringArray);
        throw brokerCmdException;
    }

    private static void checkDestType(BrokerCmdProperties brokerCmdProperties) throws BrokerCmdException {
        BrokerCmdException brokerCmdException = null;
        String string = brokerCmdProperties.getDestType();
        if (string == null) {
            brokerCmdException = new BrokerCmdException(7);
            brokerCmdException.setProperties(brokerCmdProperties);
            throw brokerCmdException;
        }
        if (!string.equals("t") && !string.equals("q")) {
            brokerCmdException = new BrokerCmdException(10);
            brokerCmdException.setProperties(brokerCmdProperties);
            throw brokerCmdException;
        }
    }

    private static void checkTargetName(BrokerCmdProperties brokerCmdProperties) throws BrokerCmdException {
        String string = brokerCmdProperties.getTargetName();
        if (string == null) {
            BrokerCmdException brokerCmdException = new BrokerCmdException(2);
            brokerCmdException.setProperties(brokerCmdProperties);
            throw brokerCmdException;
        }
    }

    private static void checkTargetAttrs(BrokerCmdProperties brokerCmdProperties) throws BrokerCmdException {
        Properties properties = brokerCmdProperties.getTargetAttrs();
        if (properties == null || properties.isEmpty()) {
            BrokerCmdException brokerCmdException = new BrokerCmdException(6);
            brokerCmdException.setProperties(brokerCmdProperties);
            throw brokerCmdException;
        }
    }

    private static void checkClientID(BrokerCmdProperties brokerCmdProperties) throws BrokerCmdException {
        String string = brokerCmdProperties.getClientID();
        if (string == null) {
            BrokerCmdException brokerCmdException = new BrokerCmdException(11);
            brokerCmdException.setProperties(brokerCmdProperties);
            throw brokerCmdException;
        }
    }

    private static void checkMsgID(BrokerCmdProperties brokerCmdProperties) throws BrokerCmdException {
        String string = brokerCmdProperties.getMsgID();
        if (string == null) {
            BrokerCmdException brokerCmdException = new BrokerCmdException(37);
            brokerCmdException.setProperties(brokerCmdProperties);
            throw brokerCmdException;
        }
    }

    private static void checkWarnPassword(BrokerCmdProperties brokerCmdProperties) {
        String string = brokerCmdProperties.getAdminPasswd();
        if (string != null) {
            Globals.stdErrPrintln(ar.getString("A1000"), ar.getKString("A2014"));
            Globals.stdErrPrintln("");
        }
    }

    private static boolean shortHelpOptionSpecified(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-h") && !stringArray[i].equals("-help")) continue;
            return true;
        }
        return false;
    }

    private static boolean longHelpOptionSpecified(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-H") && !stringArray[i].equals("-Help")) continue;
            return true;
        }
        return false;
    }

    private static boolean versionOptionSpecified(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-v") && !stringArray[i].equals("-version")) continue;
            return true;
        }
        return false;
    }

    private static boolean silentModeOptionSpecified(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-s")) continue;
            return true;
        }
        return false;
    }

    private static void handleCheckOptionsExceptions(BrokerCmdException brokerCmdException) {
        BrokerCmdProperties brokerCmdProperties = (BrokerCmdProperties)brokerCmdException.getProperties();
        String string = brokerCmdProperties.getCommand();
        String string2 = brokerCmdProperties.getCommandArg();
        String[] stringArray = brokerCmdException.getValidCmdArgs();
        String[] stringArray2 = brokerCmdException.getValidAttrs();
        String string3 = brokerCmdException.getBadAttr();
        String string4 = brokerCmdException.getBadValue();
        String string5 = brokerCmdException.getErrorString();
        int n = brokerCmdException.getType();
        switch (n) {
            case 2: {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3100", "-n"));
                break;
            }
            case 5: {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3103", "-d"));
                break;
            }
            case 6: {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3104", "-o"));
                break;
            }
            case 7: {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3105", "-t"));
                break;
            }
            case 8: {
                Properties properties = brokerCmdProperties.getTargetAttrs();
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3106", string4));
                break;
            }
            case 32: {
                Properties properties = brokerCmdProperties.getTargetAttrs();
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3106", string4));
                Globals.stdErrPrintln(ar.getString("A1000"), ar.getKString("A2005"));
                break;
            }
            case 33: {
                Properties properties = brokerCmdProperties.getTargetAttrs();
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3106", string4));
                Globals.stdErrPrintln(ar.getString("A1000"), ar.getKString("A2008"));
                break;
            }
            case 10008: {
                Properties properties = brokerCmdProperties.getTargetAttrs();
                String string6 = properties.getProperty(string5);
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3107", string6, string5));
                break;
            }
            case 22: {
                Properties properties = brokerCmdProperties.getTargetAttrs();
                String string7 = properties.getProperty(string5);
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3117", string7, string5));
                break;
            }
            case 18: {
                Properties properties = brokerCmdProperties.getTargetAttrs();
                String string8 = properties.getProperty(string5);
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3114", string8, string5));
                break;
            }
            case 19: {
                Properties properties = brokerCmdProperties.getTargetAttrs();
                String string9 = properties.getProperty(string5);
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3115", string9, string5));
                Globals.stdErrPrintln(ar.getString("A1170", "imq.log.level"));
                Globals.stdErrPrint("\t");
                for (int i = 0; i < BKR_LOG_LEVEL_VALID_VALUES.length; ++i) {
                    Globals.stdErrPrint(BKR_LOG_LEVEL_VALID_VALUES[i]);
                    if (i + 1 >= BKR_LOG_LEVEL_VALID_VALUES.length) continue;
                    Globals.stdErrPrint(" ");
                }
                Globals.stdErrPrintln("");
                break;
            }
            case 31: {
                Properties properties = brokerCmdProperties.getTargetAttrs();
                String string10 = properties.getProperty(string5);
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3160", string10, string5));
                Globals.stdErrPrintln(ar.getString("A1170", "limitBehavior"));
                Globals.stdErrPrint("\t");
                for (int i = 0; i < BKR_LIMIT_BEHAV_VALID_VALUES.length; ++i) {
                    Globals.stdErrPrint(BKR_LIMIT_BEHAV_VALID_VALUES[i]);
                    if (i + 1 >= BKR_LIMIT_BEHAV_VALID_VALUES.length) continue;
                    Globals.stdErrPrint(" ");
                }
                Globals.stdErrPrintln("");
                break;
            }
            case 20: {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3137", string4));
                break;
            }
            case 29: {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3157", string4));
                break;
            }
            case 21: {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3138", string4));
                Globals.stdErrPrint("\t");
                for (int i = 0; i < METRIC_TYPE_VALID_VALUES.length; ++i) {
                    Globals.stdErrPrint(METRIC_TYPE_VALID_VALUES[i]);
                    if (i + 1 >= METRIC_TYPE_VALID_VALUES.length) continue;
                    Globals.stdErrPrint(" ");
                }
                Globals.stdErrPrintln("");
                break;
            }
            case 28: {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3156", string4));
                Globals.stdErrPrint("\t");
                for (int i = 0; i < METRIC_DST_TYPE_VALID_VALUES.length; ++i) {
                    Globals.stdErrPrint(METRIC_DST_TYPE_VALID_VALUES[i]);
                    if (i + 1 >= METRIC_DST_TYPE_VALID_VALUES.length) continue;
                    Globals.stdErrPrint(" ");
                }
                Globals.stdErrPrintln("");
                break;
            }
            case 10: {
                String string11 = brokerCmdProperties.getDestType();
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3108", string11));
                break;
            }
            case 27: {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3119", string4));
                Globals.stdErrPrint("\t");
                for (int i = 0; i < PAUSE_DST_TYPE_VALID_VALUES.length; ++i) {
                    Globals.stdErrPrint(PAUSE_DST_TYPE_VALID_VALUES[i]);
                    if (i + 1 >= PAUSE_DST_TYPE_VALID_VALUES.length) continue;
                    Globals.stdErrPrint(" ");
                }
                Globals.stdErrPrintln("");
                break;
            }
            case 36: {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3166", string4));
                Globals.stdErrPrint("\t");
                for (int i = 0; i < RESET_BKR_TYPE_VALID_VALUES.length; ++i) {
                    Globals.stdErrPrint(RESET_BKR_TYPE_VALID_VALUES[i]);
                    if (i + 1 >= RESET_BKR_TYPE_VALID_VALUES.length) continue;
                    Globals.stdErrPrint(" ");
                }
                Globals.stdErrPrintln("");
                break;
            }
            case 11: {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3112", "-c"));
                break;
            }
            case 37: {
                Globals.stdErrPrintln(ar.getString("A1001"), "The message ID must be specified with the -msgIDoption.");
                break;
            }
            case 25: {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3148", "-attr"));
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 24: 
            case 26: 
            case 38: 
            case 39: 
            case 40: {
                String string12;
                String string13 = "A3129";
                switch (n) {
                    case 12: {
                        string12 = "A3131";
                        break;
                    }
                    case 13: {
                        string12 = "A3132";
                        break;
                    }
                    case 14: {
                        string12 = "A3133";
                        break;
                    }
                    case 15: {
                        string12 = "A3134";
                        break;
                    }
                    case 16: {
                        string12 = "A3135";
                        break;
                    }
                    case 17: {
                        string12 = "A3136";
                        break;
                    }
                    case 26: {
                        string12 = "A3155";
                        break;
                    }
                    case 38: {
                        string13 = "A3168";
                        string12 = "A3134";
                        break;
                    }
                    case 39: {
                        string13 = "A3168";
                        string12 = "A3135";
                        break;
                    }
                    default: {
                        string12 = "A3130";
                    }
                }
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString(string13, string3));
                if (stringArray2 == null) break;
                Globals.stdErrPrintln(ar.getString(string12));
                BrokerCmdPrinter brokerCmdPrinter = new BrokerCmdPrinter(1, 4, null);
                Object[] objectArray = new String[1];
                for (int i = 0; i < stringArray2.length; ++i) {
                    objectArray[0] = stringArray2[i];
                    brokerCmdPrinter.add(objectArray);
                }
                brokerCmdPrinter.println();
                break;
            }
            default: {
                CommonCmdRunnerUtil.handleCommonCheckOptionsExceptions(brokerCmdException, string, string2, new BrokerCmdHelpPrinter());
            }
        }
    }
}

