/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.protocol;

import com.sun.corba.ee.spi.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.protocol.CorbaRequestId;

public class CorbaRequestIdImpl
implements CorbaRequestId {
    private static final ORBUtilSystemException wrapper = ORBUtilSystemException.self;
    private final int value;
    private final boolean defined;
    private static final String UNDEFINED = "?";
    public static final CorbaRequestId UNKNOWN_CORBA_REQUEST_ID = new CorbaRequestIdImpl();

    public CorbaRequestIdImpl(int requestId) {
        this.value = requestId;
        this.defined = true;
    }

    private CorbaRequestIdImpl() {
        this.defined = false;
        this.value = -1;
    }

    @Override
    public int getValue() {
        if (this.defined) {
            return this.value;
        }
        throw wrapper.undefinedCorbaRequestIdNotAllowed();
    }

    @Override
    public boolean isDefined() {
        return this.defined;
    }

    public boolean equals(Object requestId) {
        if (requestId == null || !(requestId instanceof CorbaRequestId)) {
            return false;
        }
        if (this.isDefined()) {
            if (((CorbaRequestId)requestId).isDefined()) {
                return this.value == ((CorbaRequestId)requestId).getValue();
            }
            return false;
        }
        return !((CorbaRequestId)requestId).isDefined();
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        if (this.defined) {
            return Integer.toString(this.value);
        }
        return UNDEFINED;
    }
}

