/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resourcebase.resources.admin.cli;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.TransactionFailure;

@Service
public class ResourceUtil {
    private static final String DOMAIN = "domain";
    @Inject
    private Provider<Target> targetProvider;
    @Inject
    private Domain domain;
    @Inject
    private ConfigBeansUtilities configBeansUtilities;
    @Inject
    private ConfigBeansUtilities configBeanUtilities;

    public void createResourceRef(String jndiName, String enabled, String target) throws TransactionFailure {
        Server server;
        if (target.equals(DOMAIN)) {
            return;
        }
        Config config = this.domain.getConfigNamed(target);
        if (config != null && !config.isResourceRefExists(jndiName)) {
            config.createResourceRef(enabled, jndiName);
        }
        if ((server = this.configBeansUtilities.getServerNamed(target)) != null) {
            if (!server.isResourceRefExists(jndiName)) {
                server.createResourceRef(enabled, jndiName);
            }
        } else {
            Cluster cluster = this.domain.getClusterNamed(target);
            if (cluster != null && !cluster.isResourceRefExists(jndiName)) {
                cluster.createResourceRef(enabled, jndiName);
                Target tgt = this.targetProvider.get();
                List instances = tgt.getInstances(target);
                for (Server svr : instances) {
                    if (svr.isResourceRefExists(jndiName)) continue;
                    svr.createResourceRef(enabled, jndiName);
                }
            }
        }
    }

    public String computeEnabledValueForResourceBasedOnTarget(String enabledValue, String target) {
        String result = enabledValue;
        boolean enabled = Boolean.valueOf(enabledValue);
        if (!this.isNonResourceRefTarget(target) && !enabled) {
            result = Boolean.toString(!enabled);
        }
        return result;
    }

    private boolean isNonResourceRefTarget(String target) {
        boolean isNonResourceRefTarget = false;
        if (DOMAIN.equals(target)) {
            isNonResourceRefTarget = true;
        } else if (this.domain.getConfigNamed(target) != null) {
            isNonResourceRefTarget = true;
        }
        return isNonResourceRefTarget;
    }

    public boolean isResourceRefInTarget(String refName, String target) {
        Set<String> targets = this.getTargetsReferringResourceRef(refName);
        boolean resourceRefInTarget = false;
        for (String refTarget : targets) {
            if (!refTarget.equals(target)) continue;
            resourceRefInTarget = true;
            break;
        }
        return resourceRefInTarget;
    }

    public Set<String> getTargetsReferringResourceRef(String refName) {
        HashSet<String> targets = new HashSet<String>();
        List servers = this.domain.getServers().getServer();
        for (Server server : servers) {
            if (server.getResourceRef(refName) == null) continue;
            if (server.getCluster() != null) {
                targets.add(server.getCluster().getName());
                continue;
            }
            if (server.isDas()) {
                targets.add("server");
                continue;
            }
            if (!server.isInstance()) continue;
            targets.add(server.getName());
        }
        return targets;
    }

    public void deleteResourceRef(String jndiName, String target) throws TransactionFailure {
        if (target.equals(DOMAIN)) {
            return;
        }
        Config config = this.domain.getConfigNamed(target);
        if (config != null) {
            config.deleteResourceRef(jndiName);
        } else {
            Server server = this.configBeansUtilities.getServerNamed(target);
            if (server != null) {
                if (server.isResourceRefExists(jndiName)) {
                    server.deleteResourceRef(jndiName);
                }
            } else {
                Cluster cluster = this.domain.getClusterNamed(target);
                if (cluster != null && cluster.isResourceRefExists(jndiName)) {
                    cluster.deleteResourceRef(jndiName);
                    Target tgt = this.targetProvider.get();
                    List instances = tgt.getInstances(target);
                    for (Server svr : instances) {
                        if (!svr.isResourceRefExists(jndiName)) continue;
                        svr.deleteResourceRef(jndiName);
                    }
                }
            }
        }
    }
}

