/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.tf.tools.enhancer;

import org.glassfish.pfl.basic.contain.SynchronizedHolder;
import org.glassfish.pfl.objectweb.asm.ClassVisitor;
import org.glassfish.pfl.objectweb.asm.Label;
import org.glassfish.pfl.objectweb.asm.MethodVisitor;
import org.glassfish.pfl.objectweb.asm.Type;
import org.glassfish.pfl.objectweb.asm.commons.GeneratorAdapter;
import org.glassfish.pfl.tf.spi.EnhancedClassData;
import org.glassfish.pfl.tf.spi.Util;
import org.glassfish.pfl.tf.spi.annotation.TraceEnhanceLevel;
import org.glassfish.pfl.tf.tools.enhancer.SimpleMethodTracer;
import org.glassfish.pfl.tf.tools.enhancer.StaticInitVisitor;
import org.glassfish.pfl.tf.tools.enhancer.TFEnhanceAdapter;

public class ClassEnhancer
extends TFEnhanceAdapter {
    private final Util util;
    private final EnhancedClassData ecd;
    private boolean hasStaticInitializer = false;

    public ClassEnhancer(Util util, EnhancedClassData ecd, ClassVisitor cv) {
        super(cv, TraceEnhanceLevel.NONE, TraceEnhanceLevel.PHASE1, ecd);
        this.util = util;
        this.ecd = ecd;
    }

    private void info(int level, String msg) {
        this.util.info(level, "ClassEnhancer: " + msg);
    }

    public void visitEnd() {
        this.info(2, "visitEnd");
        String desc = Type.getDescriptor(SynchronizedHolder.class);
        int acc = 10;
        String sig = null;
        for (String fname : this.ecd.getAnnotationToHolderName().values()) {
            this.info(2, "Adding field " + fname + " of type " + desc);
            this.cv.visitField(10, fname, desc, sig, null);
        }
        if (!this.hasStaticInitializer) {
            this.info(2, "creating static init");
            int siacc = 10;
            MethodVisitor mv = this.cv.visitMethod(siacc, "<clinit>", "()V", null, null);
            if (this.util.getDebug()) {
                mv = new SimpleMethodTracer(mv, this.util);
            }
            StaticInitVisitor ma = new StaticInitVisitor(siacc, "()V", mv, this.util, this.ecd);
            ma.visitCode();
            ma.visitInsn(177);
            ma.visitMaxs(0, 0);
            ma.visitEnd();
        }
        super.visitEnd();
        this.ecd.updateInfoDesc();
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String sig, String[] exceptions) {
        this.info(2, "visitMethod " + name + desc);
        String fullDesc = this.util.getFullMethodDescriptor(name, desc);
        EnhancedClassData.MethodType mtype = this.ecd.classifyMethod(fullDesc);
        switch (mtype) {
            case STATIC_INITIALIZER: {
                MethodVisitor mv = super.visitMethod(access, name, desc, sig, exceptions);
                if (this.util.getDebug()) {
                    mv = new SimpleMethodTracer(mv, this.util);
                }
                this.hasStaticInitializer = true;
                return new StaticInitVisitor(access, desc, mv, this.util, this.ecd);
            }
            case INFO_METHOD: {
                String newDesc = this.util.augmentInfoMethodDescriptor(desc);
                MethodVisitor mv = super.visitMethod(access, name, newDesc, sig, exceptions);
                if (this.util.getDebug()) {
                    mv = new SimpleMethodTracer(mv, this.util);
                }
                return new InfoMethodRewriter(mv, access, name, desc);
            }
            case MONITORED_METHOD: {
                MethodVisitor mv = super.visitMethod(access, name, desc, sig, exceptions);
                if (this.util.getDebug()) {
                    mv = new SimpleMethodTracer(mv, this.util);
                }
                return new InfoMethodCallRewriter(mv, access, name, desc);
            }
            case NORMAL_METHOD: {
                MethodVisitor mv = super.visitMethod(access, name, desc, sig, exceptions);
                if (this.util.getDebug()) {
                    mv = new SimpleMethodTracer(mv, this.util);
                }
                return new NormalMethodChecker(mv, access, name, desc);
            }
        }
        return null;
    }

    public class InfoMethodCallRewriter
    extends GeneratorAdapter {
        public InfoMethodCallRewriter(MethodVisitor mv, int acc, String name, String desc) {
            super(mv, acc, name, desc);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            ClassEnhancer.this.info(2, "InfoMethodCallRewriter: visitMethodInsn: " + owner + "." + name + desc);
            String fullDesc = ClassEnhancer.this.util.getFullMethodDescriptor(name, desc);
            if (opcode == 183 && owner.equals(ClassEnhancer.this.ecd.getClassName()) && ClassEnhancer.this.ecd.classifyMethod(fullDesc) == EnhancedClassData.MethodType.INFO_METHOD) {
                ClassEnhancer.this.info(2, "InfoMethodCallRewriter: visitMethodInsn: rewriting method call");
                this.mv.visitInsn(1);
                this.mv.visitInsn(3);
                String newDesc = ClassEnhancer.this.util.augmentInfoMethodDescriptor(desc);
                this.mv.visitMethodInsn(opcode, owner, name, newDesc);
            } else {
                this.mv.visitMethodInsn(opcode, owner, name, desc);
            }
        }
    }

    public class InfoMethodRewriter
    extends GeneratorAdapter {
        private int access;
        private String name;
        private String desc;

        public InfoMethodRewriter(MethodVisitor mv, int acc, String name, String desc) {
            super(mv, acc, name, desc);
            this.access = acc;
            this.name = name;
            this.desc = desc;
        }

        public void visitCode() {
            super.visitCode();
            ClassEnhancer.this.info(2, "InfoMethodRewriter: visitCode " + this.name + this.desc);
            boolean isStatic = ClassEnhancer.this.util.hasAccess(this.access, 8);
            Type[] argTypes = Type.getArgumentTypes((String)this.desc);
            int argSize = isStatic ? 0 : 1;
            for (Type type : argTypes) {
                argSize += type.getSize();
            }
            ClassEnhancer.this.info(2, "InfoMethodRewriter: initial arg size " + argSize);
            int mmIndex = argSize;
            int cidIndex = argSize + 1;
            Label jumpLabel = new Label();
            this.mv.visitVarInsn(25, mmIndex);
            this.mv.visitJumpInsn(198, jumpLabel);
            this.mv.visitVarInsn(25, mmIndex);
            ClassEnhancer.this.util.wrapArgs(this.mv, this.access, this.desc);
            this.mv.visitVarInsn(21, cidIndex);
            ClassEnhancer.this.util.emitIntConstant(this.mv, ClassEnhancer.this.ecd.getMethodIndex(this.name));
            this.mv.visitMethodInsn(185, EnhancedClassData.MM_NAME, "info", "([Ljava/lang/Object;II)V");
            this.mv.visitLabel(jumpLabel);
        }
    }

    public class NormalMethodChecker
    extends GeneratorAdapter {
        private final String mname;

        public NormalMethodChecker(MethodVisitor mv, int acc, String name, String desc) {
            super(mv, acc, name, desc);
            this.mname = ClassEnhancer.this.util.getFullMethodDescriptor(name, desc);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            ClassEnhancer.this.info(2, "NormalMethodChecker: visitMethodInsn: " + owner + "." + name + desc);
            String fullDesc = ClassEnhancer.this.util.getFullMethodDescriptor(name, desc);
            if (opcode == 183 && owner.equals(ClassEnhancer.this.ecd.getClassName()) && ClassEnhancer.this.ecd.classifyMethod(fullDesc) == EnhancedClassData.MethodType.INFO_METHOD) {
                ClassEnhancer.this.util.error("Method " + this.mname + " in class " + ClassEnhancer.this.ecd.getClassName() + " makes an" + " illegal call to an @InfoMethod method");
            }
            this.mv.visitMethodInsn(opcode, owner, name, desc);
        }
    }
}

