/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.descriptor;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.util.TypeUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import org.glassfish.ejb.deployment.descriptor.ConcurrentMethodDescriptor;
import org.glassfish.ejb.deployment.descriptor.ContainerTransaction;
import org.glassfish.ejb.deployment.descriptor.EjbBundleDescriptorImpl;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbInitInfo;
import org.glassfish.ejb.deployment.descriptor.EjbRemovalInfo;
import org.glassfish.ejb.deployment.descriptor.TimeoutValueDescriptor;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.deployment.AnnotationTypesProvider;

public class EjbSessionDescriptor
extends EjbDescriptor
implements com.sun.enterprise.deployment.EjbSessionDescriptor {
    private Set<LifecycleCallbackDescriptor> postActivateDescs = new HashSet<LifecycleCallbackDescriptor>();
    private Set<LifecycleCallbackDescriptor> prePassivateDescs = new HashSet<LifecycleCallbackDescriptor>();
    private Map<MethodDescriptor, EjbRemovalInfo> removeMethods = new HashMap<MethodDescriptor, EjbRemovalInfo>();
    private Set<EjbInitInfo> initMethods = new HashSet<EjbInitInfo>();
    private MethodDescriptor afterBeginMethod = null;
    private MethodDescriptor beforeCompletionMethod = null;
    private MethodDescriptor afterCompletionMethod = null;
    private Long statefulTimeoutValue = null;
    private TimeUnit statefulTimeoutUnit;
    private boolean sessionTypeIsSet = false;
    private boolean isStateless = false;
    private boolean isStateful = false;
    private boolean isSingleton = false;
    private boolean isPassivationCapable = true;
    private boolean passivationCapableIsSet = false;
    private List<MethodDescriptor> readLockMethods = new ArrayList<MethodDescriptor>();
    private List<MethodDescriptor> writeLockMethods = new ArrayList<MethodDescriptor>();
    private List<AccessTimeoutHolder> accessTimeoutMethods = new ArrayList<AccessTimeoutHolder>();
    private List<MethodDescriptor> asyncMethods = new ArrayList<MethodDescriptor>();
    private Boolean initOnStartup = null;
    private static final String[] _emptyDepends = new String[0];
    private String[] dependsOn = _emptyDepends;
    private ConcurrencyManagementType concurrencyManagementType;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EjbSessionDescriptor.class);

    @Override
    public String getEjbTypeForDisplay() {
        if (this.isStateful()) {
            return "StatefulSessionBean";
        }
        if (this.isStateless()) {
            return "StatelessSessionBean";
        }
        return "SingletonSessionBean";
    }

    public boolean isPassivationCapable() {
        return this.isPassivationCapable;
    }

    public void setPassivationCapable(boolean passivationCapable) {
        this.isPassivationCapable = passivationCapable;
        this.passivationCapableIsSet = true;
    }

    public boolean isPassivationCapableSet() {
        return this.passivationCapableIsSet;
    }

    public String getType() {
        return "Session";
    }

    public String getSessionType() {
        if (this.isStateless()) {
            return "Stateless";
        }
        if (this.isStateful()) {
            return "Stateful";
        }
        return "Singleton";
    }

    public void setSessionType(String sessionType) {
        if ("Stateless".equals(sessionType)) {
            this.isStateless = true;
        } else if ("Stateful".equals(sessionType)) {
            this.isStateful = true;
        } else if ("Singleton".equals(sessionType)) {
            this.isSingleton = true;
        } else if (this.isBoundsChecking()) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionsessiontypenotlegaltype", "{0} is not a legal session type for session ejbs. The type must be {1} or {2}", new Object[]{sessionType, "Stateful", "Stateless"}));
        }
        this.sessionTypeIsSet = true;
    }

    public boolean isSessionTypeSet() {
        return this.sessionTypeIsSet;
    }

    @Override
    public void setType(String type) {
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptioncannotsettypeofsessionbean", "Cannot set the type of a session bean"));
    }

    @Override
    public void setTransactionType(String transactionType) {
        boolean isValidType;
        boolean bl = isValidType = "Bean".equals(transactionType) || "Container".equals(transactionType);
        if (!isValidType) {
            if (this.isBoundsChecking()) {
                throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment..exceptointxtypenotlegaltype", "{0} is not a legal transaction type for session beans", new Object[]{transactionType}));
            }
        }
        this.transactionType = transactionType;
        super.setMethodContainerTransactions(new Hashtable());
    }

    public boolean isStateless() {
        return this.isStateless;
    }

    public boolean isStateful() {
        return this.isStateful;
    }

    public boolean isSingleton() {
        return this.isSingleton;
    }

    public boolean hasAsynchronousMethods() {
        return this.asyncMethods.size() > 0;
    }

    public void addAsynchronousMethod(MethodDescriptor m) {
        this.asyncMethods.add(m);
    }

    public List<MethodDescriptor> getAsynchronousMethods() {
        return new ArrayList<MethodDescriptor>(this.asyncMethods);
    }

    public boolean isAsynchronousMethod(Method m) {
        boolean async = false;
        for (MethodDescriptor next : this.asyncMethods) {
            Method nextMethod = next.getMethod((com.sun.enterprise.deployment.EjbDescriptor)this);
            if (nextMethod == null || !TypeUtil.sameMethodSignature((Method)m, (Method)nextMethod)) continue;
            async = true;
            break;
        }
        return async;
    }

    public void addStatefulTimeoutDescriptor(TimeoutValueDescriptor timeout) {
        this.statefulTimeoutValue = timeout.getValue();
        this.statefulTimeoutUnit = timeout.getUnit();
    }

    public void setStatefulTimeout(Long value, TimeUnit unit) {
        this.statefulTimeoutValue = value;
        this.statefulTimeoutUnit = unit;
    }

    public boolean hasStatefulTimeout() {
        return this.statefulTimeoutValue != null;
    }

    public Long getStatefulTimeoutValue() {
        return this.statefulTimeoutValue;
    }

    public TimeUnit getStatefulTimeoutUnit() {
        return this.statefulTimeoutUnit;
    }

    public boolean hasRemoveMethods() {
        return !this.removeMethods.isEmpty();
    }

    public EjbRemovalInfo getRemovalInfo(MethodDescriptor method) {
        for (MethodDescriptor methodDesc : this.removeMethods.keySet()) {
            if (!methodDesc.equals((Object)method)) continue;
            return this.removeMethods.get(methodDesc);
        }
        for (MethodDescriptor methodDesc : this.removeMethods.keySet()) {
            if (!methodDesc.implies((Object)method)) continue;
            return this.removeMethods.get(methodDesc);
        }
        return null;
    }

    public Set<EjbRemovalInfo> getAllRemovalInfo() {
        return new HashSet<EjbRemovalInfo>(this.removeMethods.values());
    }

    public Set<MethodDescriptor> getRemoveMethodDescriptors() {
        return new HashSet<MethodDescriptor>(this.removeMethods.keySet());
    }

    public void addRemoveMethod(EjbRemovalInfo removalInfo) {
        this.removeMethods.put(removalInfo.getRemoveMethod(), removalInfo);
    }

    public boolean hasInitMethods() {
        return !this.initMethods.isEmpty();
    }

    public Set<EjbInitInfo> getInitMethods() {
        return new HashSet<EjbInitInfo>(this.initMethods);
    }

    public void addInitMethod(EjbInitInfo initInfo) {
        this.initMethods.add(initInfo);
    }

    public Set<LifecycleCallbackDescriptor> getPostActivateDescriptors() {
        if (this.postActivateDescs == null) {
            this.postActivateDescs = new HashSet<LifecycleCallbackDescriptor>();
        }
        return this.postActivateDescs;
    }

    public void addPostActivateDescriptor(LifecycleCallbackDescriptor postActivateDesc) {
        String className = postActivateDesc.getLifecycleCallbackClass();
        boolean found = false;
        for (LifecycleCallbackDescriptor next : this.getPostActivateDescriptors()) {
            if (!next.getLifecycleCallbackClass().equals(className)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.getPostActivateDescriptors().add(postActivateDesc);
        }
    }

    public LifecycleCallbackDescriptor getPostActivateDescriptorByClass(String className) {
        for (LifecycleCallbackDescriptor next : this.getPostActivateDescriptors()) {
            if (!next.getLifecycleCallbackClass().equals(className)) continue;
            return next;
        }
        return null;
    }

    public boolean hasPostActivateMethod() {
        return this.getPostActivateDescriptors().size() > 0;
    }

    public Set<LifecycleCallbackDescriptor> getPrePassivateDescriptors() {
        if (this.prePassivateDescs == null) {
            this.prePassivateDescs = new HashSet<LifecycleCallbackDescriptor>();
        }
        return this.prePassivateDescs;
    }

    public void addPrePassivateDescriptor(LifecycleCallbackDescriptor prePassivateDesc) {
        String className = prePassivateDesc.getLifecycleCallbackClass();
        boolean found = false;
        for (LifecycleCallbackDescriptor next : this.getPrePassivateDescriptors()) {
            if (!next.getLifecycleCallbackClass().equals(className)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.getPrePassivateDescriptors().add(prePassivateDesc);
        }
    }

    public LifecycleCallbackDescriptor getPrePassivateDescriptorByClass(String className) {
        for (LifecycleCallbackDescriptor next : this.getPrePassivateDescriptors()) {
            if (!next.getLifecycleCallbackClass().equals(className)) continue;
            return next;
        }
        return null;
    }

    public boolean hasPrePassivateMethod() {
        return this.getPrePassivateDescriptors().size() > 0;
    }

    @Override
    public Vector getPossibleTransactionAttributes() {
        Vector<ContainerTransaction> txAttributes = super.getPossibleTransactionAttributes();
        if (this.isStateful()) {
            try {
                Class sessionSynchClass;
                EjbBundleDescriptorImpl ejbBundle = this.getEjbBundleDescriptor();
                ClassLoader classLoader = ejbBundle.getClassLoader();
                Class<?> ejbClass = classLoader.loadClass(this.getEjbClassName());
                AnnotationTypesProvider provider = (AnnotationTypesProvider)Globals.getDefaultHabitat().getService(AnnotationTypesProvider.class, "EJB", new Annotation[0]);
                if (provider != null && (sessionSynchClass = provider.getType("javax.ejb.SessionSynchronization")).isAssignableFrom(ejbClass)) {
                    txAttributes = new Vector<ContainerTransaction>();
                    txAttributes.add(new ContainerTransaction("Required", ""));
                    txAttributes.add(new ContainerTransaction("RequiresNew", ""));
                    txAttributes.add(new ContainerTransaction("Mandatory", ""));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return txAttributes;
    }

    @Override
    public String getContainerFactoryQualifier() {
        if (this.isStateful) {
            return "StatefulContainerFactory";
        }
        if (this.isStateless) {
            return "StatelessContainerFactory";
        }
        return "SingletonContainerFactory";
    }

    public void addAfterBeginDescriptor(MethodDescriptor m) {
        this.afterBeginMethod = m;
    }

    public void addBeforeCompletionDescriptor(MethodDescriptor m) {
        this.beforeCompletionMethod = m;
    }

    public void addAfterCompletionDescriptor(MethodDescriptor m) {
        this.afterCompletionMethod = m;
    }

    public void setAfterBeginMethodIfNotSet(MethodDescriptor m) {
        if (this.afterBeginMethod == null) {
            this.afterBeginMethod = m;
        }
    }

    public MethodDescriptor getAfterBeginMethod() {
        return this.afterBeginMethod;
    }

    public void setBeforeCompletionMethodIfNotSet(MethodDescriptor m) {
        if (this.beforeCompletionMethod == null) {
            this.beforeCompletionMethod = m;
        }
    }

    public MethodDescriptor getBeforeCompletionMethod() {
        return this.beforeCompletionMethod;
    }

    public void setAfterCompletionMethodIfNotSet(MethodDescriptor m) {
        if (this.afterCompletionMethod == null) {
            this.afterCompletionMethod = m;
        }
    }

    public MethodDescriptor getAfterCompletionMethod() {
        return this.afterCompletionMethod;
    }

    public boolean getInitOnStartup() {
        return this.initOnStartup != null && this.initOnStartup != false;
    }

    public void setInitOnStartup(boolean flag) {
        this.initOnStartup = flag;
    }

    public void setInitOnStartupIfNotAlreadySet(boolean flag) {
        if (this.initOnStartup == null) {
            this.setInitOnStartup(flag);
        }
    }

    public String[] getDependsOn() {
        return this.dependsOn;
    }

    public boolean hasDependsOn() {
        return this.dependsOn.length > 0;
    }

    public void setDependsOn(String[] dep) {
        this.dependsOn = dep == null ? _emptyDepends : dep;
    }

    public void setDependsOnIfNotSet(String[] dep) {
        if (!this.hasDependsOn()) {
            this.setDependsOn(dep);
        }
    }

    public ConcurrencyManagementType getConcurrencyManagementType() {
        return this.concurrencyManagementType != null ? this.concurrencyManagementType : ConcurrencyManagementType.Container;
    }

    public boolean hasContainerManagedConcurrency() {
        return this.getConcurrencyManagementType() == ConcurrencyManagementType.Container;
    }

    public boolean hasBeanManagedConcurrency() {
        return this.getConcurrencyManagementType() == ConcurrencyManagementType.Bean;
    }

    public void setConcurrencyManagementType(ConcurrencyManagementType type) {
        this.concurrencyManagementType = type;
    }

    public void setConcurrencyManagementTypeIfNotSet(ConcurrencyManagementType type) {
        if (this.concurrencyManagementType == null) {
            this.setConcurrencyManagementType(type);
        }
    }

    public void addConcurrentMethodFromXml(ConcurrentMethodDescriptor concMethod) {
        MethodDescriptor methodDesc = concMethod.getConcurrentMethod();
        if (concMethod.hasLockMetadata()) {
            if (concMethod.isWriteLocked()) {
                this.addWriteLockMethod(methodDesc);
            } else {
                this.addReadLockMethod(methodDesc);
            }
        }
        if (concMethod.hasAccessTimeout()) {
            this.addAccessTimeoutMethod(methodDesc, concMethod.getAccessTimeoutValue(), concMethod.getAccessTimeoutUnit());
        }
    }

    public void addReadLockMethod(MethodDescriptor methodDescriptor) {
        this.readLockMethods.add(methodDescriptor);
    }

    public void addWriteLockMethod(MethodDescriptor methodDescriptor) {
        this.writeLockMethods.add(methodDescriptor);
    }

    public List<MethodDescriptor> getReadLockMethods() {
        return new ArrayList<MethodDescriptor>(this.readLockMethods);
    }

    public List<MethodDescriptor> getWriteLockMethods() {
        return new ArrayList<MethodDescriptor>(this.writeLockMethods);
    }

    public List<MethodDescriptor> getReadAndWriteLockMethods() {
        ArrayList<MethodDescriptor> readAndWriteLockMethods = new ArrayList<MethodDescriptor>();
        readAndWriteLockMethods.addAll(this.readLockMethods);
        readAndWriteLockMethods.addAll(this.writeLockMethods);
        return readAndWriteLockMethods;
    }

    public void addAccessTimeoutMethod(MethodDescriptor methodDescriptor, long value, TimeUnit unit) {
        this.accessTimeoutMethods.add(new AccessTimeoutHolder(value, unit, methodDescriptor));
    }

    public List<MethodDescriptor> getAccessTimeoutMethods() {
        ArrayList<MethodDescriptor> methods = new ArrayList<MethodDescriptor>();
        for (AccessTimeoutHolder holder : this.accessTimeoutMethods) {
            methods.add(holder.method);
        }
        return methods;
    }

    public List<AccessTimeoutHolder> getAccessTimeoutInfo() {
        ArrayList<AccessTimeoutHolder> all = new ArrayList<AccessTimeoutHolder>();
        for (AccessTimeoutHolder holder : this.accessTimeoutMethods) {
            all.add(holder);
        }
        return all;
    }

    @Override
    public void print(StringBuffer toStringBuffer) {
        toStringBuffer.append("Session descriptor");
        toStringBuffer.append("\n sessionType ").append(this.getSessionType());
        super.print(toStringBuffer);
    }

    public String getPortableJndiName(String clientViewType) {
        String appName = null;
        Application app = this.getEjbBundleDescriptor().getApplication();
        if (!app.isVirtual()) {
            appName = app.getAppName();
        }
        String modName = this.getEjbBundleDescriptor().getModuleDescriptor().getModuleName();
        StringBuffer javaGlobalPrefix = new StringBuffer("java:global/");
        if (appName != null) {
            javaGlobalPrefix.append(appName);
            javaGlobalPrefix.append("/");
        }
        javaGlobalPrefix.append(modName);
        javaGlobalPrefix.append("/");
        javaGlobalPrefix.append(this.getName());
        javaGlobalPrefix.append("!");
        javaGlobalPrefix.append(clientViewType);
        return javaGlobalPrefix.toString();
    }

    public static class AccessTimeoutHolder {
        public long value;
        public TimeUnit unit;
        public MethodDescriptor method;

        public AccessTimeoutHolder(long v, TimeUnit u, MethodDescriptor m) {
            this.value = v;
            this.unit = u;
            this.method = m;
        }
    }

    public static enum ConcurrencyManagementType {
        Bean,
        Container;

    }
}

