/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.DefinitionException;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.PassivationCapable;
import org.jboss.weld.annotated.slim.SlimAnnotatedTypeStore;
import org.jboss.weld.bean.CustomDecoratorWrapper;
import org.jboss.weld.bean.attributes.ExternalBeanAttributesFactory;
import org.jboss.weld.bootstrap.BeanDeploymentArchiveMapping;
import org.jboss.weld.bootstrap.ContextHolder;
import org.jboss.weld.bootstrap.events.AbstractBeanDiscoveryEvent;
import org.jboss.weld.bootstrap.events.ContainerLifecycleEvents;
import org.jboss.weld.bootstrap.events.ProcessObserverMethodImpl;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.logging.ContextLogger;
import org.jboss.weld.logging.InterceptorLogger;
import org.jboss.weld.logging.MetadataLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Bindings;
import org.jboss.weld.util.Observers;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.reflection.Reflections;

public class AfterBeanDiscoveryImpl
extends AbstractBeanDiscoveryEvent
implements AfterBeanDiscovery {
    private static final String TYPE_ARGUMENT_NAME = "type";
    private final SlimAnnotatedTypeStore slimAnnotatedTypeStore;
    private final ContainerLifecycleEvents containerLifecycleEvents;
    private final List<Bean<?>> additionalBeans = new LinkedList();
    private final List<ObserverMethod<?>> additionalObservers = new LinkedList();

    public static void fire(BeanManagerImpl beanManager, Deployment deployment, BeanDeploymentArchiveMapping bdaMapping, Collection<ContextHolder<? extends Context>> contexts) {
        AfterBeanDiscoveryImpl event = new AfterBeanDiscoveryImpl(beanManager, deployment, bdaMapping, contexts);
        event.fire();
        event.finish();
    }

    private AfterBeanDiscoveryImpl(BeanManagerImpl beanManager, Deployment deployment, BeanDeploymentArchiveMapping bdaMapping, Collection<ContextHolder<? extends Context>> contexts) {
        super(beanManager, (Type)((Object)AfterBeanDiscovery.class), bdaMapping, deployment, contexts);
        this.slimAnnotatedTypeStore = beanManager.getServices().get(SlimAnnotatedTypeStore.class);
        this.containerLifecycleEvents = beanManager.getServices().get(ContainerLifecycleEvents.class);
    }

    public void addBean(Bean<?> bean) {
        this.checkWithinObserverNotification();
        Preconditions.checkArgumentNotNull(bean, "bean");
        ExternalBeanAttributesFactory.validateBeanAttributes(bean, this.getBeanManager());
        this.validateBean(bean);
        this.additionalBeans.add(bean);
    }

    protected <T> void processBean(Bean<T> bean) {
        BeanManagerImpl beanManager = this.getOrCreateBeanDeployment(bean.getBeanClass()).getBeanManager();
        if (bean instanceof Interceptor) {
            beanManager.addInterceptor((Interceptor)bean);
        } else if (bean instanceof Decorator) {
            beanManager.addDecorator(CustomDecoratorWrapper.of((Decorator)bean, beanManager));
        } else {
            beanManager.addBean(bean);
        }
        this.containerLifecycleEvents.fireProcessBean(beanManager, bean);
    }

    private void validateBean(Bean<?> bean) {
        PassivationCapable passivationCapable;
        if (bean.getBeanClass() == null) {
            throw BeanLogger.LOG.beanMethodReturnsNull("getBeanClass", bean);
        }
        if (bean.getInjectionPoints() == null) {
            throw BeanLogger.LOG.beanMethodReturnsNull("getInjectionPoints", bean);
        }
        if (bean instanceof PassivationCapable && (passivationCapable = (PassivationCapable)bean).getId() == null) {
            throw BeanLogger.LOG.passivationCapableBeanHasNullId(bean);
        }
        if (bean instanceof Interceptor) {
            this.validateInterceptor((Interceptor)bean);
        } else if (bean instanceof Decorator) {
            this.validateDecorator((Decorator)bean);
        }
    }

    private void validateInterceptor(Interceptor<?> interceptor) {
        Set bindings = interceptor.getInterceptorBindings();
        if (bindings == null) {
            throw InterceptorLogger.LOG.nullInterceptorBindings(interceptor);
        }
        for (Annotation annotation : bindings) {
            if (this.getBeanManager().isInterceptorBinding(annotation.annotationType())) continue;
            throw MetadataLogger.LOG.notAnInterceptorBinding(annotation, interceptor);
        }
    }

    private void validateDecorator(Decorator<?> decorator) {
        Set qualifiers = decorator.getDelegateQualifiers();
        if (decorator.getDelegateType() == null) {
            throw BeanLogger.LOG.decoratorMethodReturnsNull("getDelegateType", decorator);
        }
        Bindings.validateQualifiers(qualifiers, this.getBeanManager(), decorator, "Decorator.getDelegateQualifiers");
        if (decorator.getDecoratedTypes() == null) {
            throw BeanLogger.LOG.decoratorMethodReturnsNull("getDecoratedTypes", decorator);
        }
    }

    public void addContext(Context context) {
        this.checkWithinObserverNotification();
        Preconditions.checkArgumentNotNull(context, "context");
        Class scope = context.getScope();
        if (scope == null) {
            throw ContextLogger.LOG.contextHasNullScope(context);
        }
        if (!this.getBeanManager().isScope(scope)) {
            MetadataLogger.LOG.contextGetScopeIsNotAScope(scope, context);
        }
        if (scope == ApplicationScoped.class || scope == Dependent.class) {
            throw ContextLogger.LOG.cannotRegisterContext(scope, context);
        }
        this.getBeanManager().addContext(context);
    }

    public void addObserverMethod(ObserverMethod<?> observerMethod) {
        this.checkWithinObserverNotification();
        Preconditions.checkArgumentNotNull(observerMethod, "observerMethod");
        Observers.validateObserverMethod(observerMethod, this.getBeanManager());
        this.additionalObservers.add(observerMethod);
    }

    public <T> AnnotatedType<T> getAnnotatedType(Class<T> type, String id) {
        this.checkWithinObserverNotification();
        Preconditions.checkArgumentNotNull(type, TYPE_ARGUMENT_NAME);
        return this.slimAnnotatedTypeStore.get(type, id);
    }

    public <T> Iterable<AnnotatedType<T>> getAnnotatedTypes(Class<T> type) {
        this.checkWithinObserverNotification();
        Preconditions.checkArgumentNotNull(type, TYPE_ARGUMENT_NAME);
        return (Iterable)Reflections.cast(this.slimAnnotatedTypeStore.get(type));
    }

    private void finish() {
        try {
            for (Bean<?> bean : this.additionalBeans) {
                this.processBean(bean);
            }
            for (ObserverMethod observerMethod : this.additionalObservers) {
                BeanManagerImpl manager;
                if (!Observers.isObserverMethodEnabled(observerMethod, manager = this.getOrCreateBeanDeployment(observerMethod.getBeanClass()).getBeanManager())) continue;
                ProcessObserverMethodImpl.fire(manager, observerMethod);
                manager.addObserver(observerMethod);
            }
        }
        catch (Exception e) {
            throw new DefinitionException((Throwable)e);
        }
    }
}

