/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletSecurityElement;
import org.apache.catalina.core.ServletRegistrationImpl;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.core.StandardWrapper;
import org.glassfish.logging.annotation.LogMessageInfo;

public class DynamicServletRegistrationImpl
extends ServletRegistrationImpl
implements ServletRegistration.Dynamic {
    private static final ResourceBundle rb = StandardServer.log.getResourceBundle();
    @LogMessageInfo(message="Unable to configure {0} for servlet {1} of servlet context {2}, because this servlet context has already been initialized", level="WARNING")
    public static final String DYNAMIC_SERVLET_REGISTRATION_ALREADY_INIT = "AS-WEB-CORE-00116";

    public DynamicServletRegistrationImpl(StandardWrapper wrapper, StandardContext ctx) {
        super(wrapper, ctx);
    }

    @Override
    public void setLoadOnStartup(int loadOnStartup) {
        if (this.ctx.isContextInitializedCalled()) {
            String msg = MessageFormat.format(rb.getString(DYNAMIC_SERVLET_REGISTRATION_ALREADY_INIT), "load-on-startup", this.wrapper.getName(), this.ctx.getName());
            throw new IllegalStateException(msg);
        }
        this.wrapper.setLoadOnStartup(loadOnStartup);
    }

    @Override
    public void setAsyncSupported(boolean isAsyncSupported) {
        if (this.ctx.isContextInitializedCalled()) {
            String msg = MessageFormat.format(rb.getString(DYNAMIC_SERVLET_REGISTRATION_ALREADY_INIT), "load-on-startup", this.wrapper.getName(), this.ctx.getName());
            throw new IllegalStateException(msg);
        }
        this.wrapper.setIsAsyncSupported(isAsyncSupported);
    }

    @Override
    public Set<String> setServletSecurity(ServletSecurityElement constraint) {
        Set emptySet = Collections.emptySet();
        return Collections.unmodifiableSet(emptySet);
    }

    @Override
    public void setMultipartConfig(MultipartConfigElement mpConfig) {
        if (this.ctx.isContextInitializedCalled()) {
            String msg = MessageFormat.format(rb.getString(DYNAMIC_SERVLET_REGISTRATION_ALREADY_INIT), "multipart-config", this.wrapper.getName(), this.ctx.getName());
            throw new IllegalStateException(msg);
        }
        this.wrapper.setMultipartLocation(mpConfig.getLocation());
        this.wrapper.setMultipartMaxFileSize(mpConfig.getMaxFileSize());
        this.wrapper.setMultipartMaxRequestSize(mpConfig.getMaxRequestSize());
        this.wrapper.setMultipartFileSizeThreshold(mpConfig.getFileSizeThreshold());
    }

    @Override
    public void setRunAsRole(String roleName) {
        if (this.ctx.isContextInitializedCalled()) {
            String msg = MessageFormat.format(rb.getString(DYNAMIC_SERVLET_REGISTRATION_ALREADY_INIT), "run-as", this.wrapper.getName(), this.ctx.getName());
            throw new IllegalStateException(msg);
        }
        this.wrapper.setRunAs(roleName);
    }

    protected void setServletClassName(String className) {
        this.wrapper.setServletClassName(className);
    }

    protected void setServletClass(Class<? extends Servlet> clazz) {
        this.wrapper.setServletClass(clazz);
    }
}

