/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.admin.util.AdminCallbackHandler;
import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecureAdmin;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.auth.realm.file.FileRealm;
import com.sun.enterprise.security.auth.realm.file.FileRealmUser;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.net.NetUtils;
import java.io.File;
import java.io.IOException;
import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.util.Enumeration;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.management.remote.JMXAuthenticator;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.container.Sniffer;
import org.glassfish.common.util.admin.AuthTokenManager;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.AdminAccessController;
import org.glassfish.internal.api.LocalPassword;
import org.glassfish.internal.api.RemoteAdminAccessException;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.logging.annotation.LoggerInfo;
import org.glassfish.security.common.Group;
import org.glassfish.security.services.api.authentication.AuthenticationService;
import org.jvnet.hk2.annotations.ContractsProvided;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;

@Service
@ContractsProvided(value={JMXAuthenticator.class, AdminAccessController.class})
public class GenericAdminAuthenticator
implements AdminAccessController,
JMXAuthenticator,
PostConstruct {
    @LoggerInfo(subsystem="ADMSEC", description="Admin security")
    private static final String ADMSEC_LOGGER_NAME = "javax.enterprise.system.tools.admin.security";
    static final Logger ADMSEC_LOGGER = Logger.getLogger("javax.enterprise.system.tools.admin.security", "com.sun.enterprise.admin.util.LogMessages");
    @Inject
    ServiceLocator habitat;
    @Inject
    @Named(value="security")
    @Optional
    Sniffer snif;
    @Inject
    @Named(value="default-instance-name")
    volatile SecurityService ss;
    @Inject
    @Named(value="default-instance-name")
    volatile AdminService as;
    @Inject
    LocalPassword localPassword;
    @Inject
    ServerContext sc;
    @Inject
    Domain domain;
    @Inject
    private AuthTokenManager authTokenManager;
    private SecureAdmin secureAdmin;
    @Inject
    ServerEnvironment serverEnv;
    @Inject
    private AuthenticationService authService;
    private static LocalStringManagerImpl lsm = new LocalStringManagerImpl(GenericAdminAuthenticator.class);

    @Override
    public synchronized void postConstruct() {
        this.secureAdmin = this.domain.getSecureAdmin();
        if (this.as.usesFileRealm()) {
            try {
                String adminKeyFilePath;
                FileRealm fr;
                AuthRealm ar = this.as.getAssociatedAuthRealm();
                if (FileRealm.class.getName().equals(ar.getClassname()) && !(fr = new FileRealm(adminKeyFilePath = ar.getPropertyValue("file"))).hasAuthenticatableUser()) {
                    ADMSEC_LOGGER.log(Level.SEVERE, "NCLS-ADMIN-00012");
                    throw new IllegalStateException(ADMSEC_LOGGER.getResourceBundle().getString("NCLS-ADMIN-00012"));
                }
            }
            catch (Exception ex) {
                ADMSEC_LOGGER.log(Level.SEVERE, "NCLS-ADMIN-00011", ex);
                throw new RuntimeException(ex);
            }
        }
    }

    public Subject loginAsAdmin(String user, String password, String realm, String originHost) throws LoginException {
        Subject s = this.authenticate(user, password.toCharArray(), realm, originHost);
        return s;
    }

    public Subject loginAsAdmin(Request request) throws LoginException {
        return this.loginAsAdmin(request, null);
    }

    public Subject loginAsAdmin(Request request, String hostname) throws LoginException {
        try {
            Subject s = this.authenticate(request, hostname);
            return s;
        }
        catch (IOException ex) {
            LoginException lex = new LoginException();
            lex.initCause(ex);
            throw lex;
        }
    }

    private boolean isInAdminGroup(String user, String realm) {
        return this.as.getAssociatedAuthRealm().getGroupMapping() == null || this.ensureGroupMembership(user, realm);
    }

    private boolean ensureGroupMembership(String user, String realm) {
        try {
            SecurityContext secContext = SecurityContext.getCurrent();
            Set ps = secContext.getPrincipalSet();
            for (Object principal : ps) {
                Group group;
                if (!(principal instanceof Group) || !(group = (Group)principal).getName().equals("asadmin")) continue;
                return true;
            }
            ADMSEC_LOGGER.fine("User is not a member of the special admin group");
            return false;
        }
        catch (Exception e) {
            ADMSEC_LOGGER.log(Level.FINE, "User is not a member of the special admin group: {0}", e);
            return false;
        }
    }

    private Subject authenticate(Request req, String alternateHostname) throws IOException, LoginException {
        AdminCallbackHandler cbh = new AdminCallbackHandler(this.habitat, req, alternateHostname, this.getDefaultAdminUser(), this.localPassword);
        try {
            Subject s = this.authService.login((CallbackHandler)cbh, null);
            this.rejectRemoteAdminIfDisabled(cbh);
            this.consumeTokenIfPresent(req);
            if (ADMSEC_LOGGER.isLoggable(Level.FINE)) {
                ADMSEC_LOGGER.log(Level.FINE, "*** Login worked\n  user={0}\n  dn={1}\n  tkn={2}\n  admInd={3}\n  host={4}\n", new Object[]{cbh.pw().getUserName(), cbh.clientPrincipal() == null ? "null" : cbh.clientPrincipal().getName(), cbh.tkn(), cbh.adminIndicator(), cbh.remoteHost()});
            }
            return s;
        }
        catch (RemoteAdminAccessException ex) {
            String cmd = req.getContextPath();
            if (ADMSEC_LOGGER.isLoggable(Level.FINE)) {
                ADMSEC_LOGGER.log(Level.FINE, "*** RemoteAdminAccessException during auth for {5}\n  user={0}\n  dn={1}\n  tkn={2}\n  admInd={3}\n  host={4}\n", new Object[]{cbh.pw().getUserName(), cbh.clientPrincipal() == null ? "null" : cbh.clientPrincipal().getName(), cbh.tkn(), cbh.adminIndicator(), cbh.remoteHost(), cmd});
            }
            throw ex;
        }
        catch (LoginException lex) {
            String cmd = req.getContextPath();
            if (ADMSEC_LOGGER.isLoggable(Level.FINE)) {
                ADMSEC_LOGGER.log(Level.FINE, "*** LoginException during auth for {5}\n  user={0}\n  dn={1}\n  tkn={2}\n  admInd={3}\n  host={4}\n", new Object[]{cbh.pw().getUserName(), cbh.clientPrincipal() == null ? "null" : cbh.clientPrincipal().getName(), cbh.tkn(), cbh.adminIndicator(), cbh.remoteHost(), cmd});
            }
            throw lex;
        }
    }

    private void rejectRemoteAdminIfDisabled(String host) throws RemoteAdminAccessException {
        if (SecureAdmin.Util.isEnabled((SecureAdmin)this.secureAdmin) || NetUtils.isThisHostLocal((String)host)) {
            return;
        }
        throw new RemoteAdminAccessException();
    }

    private void rejectRemoteAdminIfDisabled(AdminCallbackHandler cbh) throws RemoteAdminAccessException {
        if (this.secureAdmin == null) {
            return;
        }
        if (this.secureAdmin.getSpecialAdminIndicator().equals(cbh.adminIndicator())) {
            return;
        }
        if (cbh.tkn() != null) {
            return;
        }
        this.rejectRemoteAdminIfDisabled(cbh.getRemoteHost());
    }

    private Subject consumeTokenIfPresent(Request req) {
        Subject result = null;
        String token = req.getHeader("X-GlassFish-authToken");
        if (token != null) {
            result = this.authTokenManager.consumeToken(token);
        }
        return result;
    }

    private String getDefaultAdminUser() {
        AuthRealm realm = this.as.getAssociatedAuthRealm();
        if (realm == null) {
            return null;
        }
        if (!FileRealm.class.getName().equals(realm.getClassname())) {
            ADMSEC_LOGGER.fine("CAN'T FIND DEFAULT ADMIN USER: IT'S NOT A FILE REALM");
            return null;
        }
        String pv = realm.getPropertyValue("file");
        File rf = null;
        if (pv == null || !(rf = new File(pv)).exists()) {
            ADMSEC_LOGGER.fine("CAN'T FIND DEFAULT ADMIN USER: THE KEYFILE DOES NOT EXIST");
            return null;
        }
        try {
            FileRealm fr = new FileRealm(rf.getAbsolutePath());
            String candidateDefaultAdminUser = null;
            Enumeration users = fr.getUserNames();
            while (users.hasMoreElements()) {
                String au = (String)users.nextElement();
                FileRealmUser fru = (FileRealmUser)fr.getUser(au);
                for (String group : fru.getGroups()) {
                    if (!group.equals("asadmin")) continue;
                    if (candidateDefaultAdminUser != null) {
                        ADMSEC_LOGGER.log(Level.FINE, "There are multiple admin users so we cannot use any as a default");
                        return null;
                    }
                    candidateDefaultAdminUser = au;
                }
            }
            if (candidateDefaultAdminUser == null) {
                ADMSEC_LOGGER.log(Level.FINE, "There are no admin users so we cannot use any as a default");
            } else {
                ADMSEC_LOGGER.log(Level.FINE, "Will use \"{0}\", if needed, for a default admin user", candidateDefaultAdminUser);
            }
            return candidateDefaultAdminUser;
        }
        catch (Exception e) {
            ADMSEC_LOGGER.log(Level.WARNING, "NCLS-ADMIN-00015", e);
            return null;
        }
    }

    private Subject authenticate(String user, char[] password, String realm, String host) throws LoginException {
        if (user.isEmpty()) {
            user = this.getDefaultAdminUser();
        }
        if (!this.isInAdminGroup(user, realm)) {
            throw new LoginException();
        }
        try {
            this.rejectRemoteAdminIfDisabled(host);
            Subject s = this.authService.login(user, password, null);
            if (ADMSEC_LOGGER.isLoggable(Level.FINE)) {
                ADMSEC_LOGGER.log(Level.FINE, "*** Login worked\n  user={0}\n  host={1}\n", new Object[]{user, host});
            }
            return s;
        }
        catch (RemoteAdminAccessException ex) {
            if (ADMSEC_LOGGER.isLoggable(Level.FINE)) {
                ADMSEC_LOGGER.log(Level.FINE, "*** RemoteAdminAccessException during auth\n  user={0}\n  host={1}\n  realm={2}\n", new Object[]{user, host, realm});
            }
            throw ex;
        }
        catch (LoginException lex) {
            if (ADMSEC_LOGGER.isLoggable(Level.FINE)) {
                ADMSEC_LOGGER.log(Level.FINE, "*** LoginException during auth\n  user={0}\n  host={1}\n  realm={2}", new Object[]{user, host, realm});
            }
            throw lex;
        }
    }

    @Override
    public Subject authenticate(Object credentials) {
        String realm;
        String user = "";
        String password = "";
        String host = null;
        if (credentials instanceof String[]) {
            String[] up = (String[])credentials;
            if (up.length == 1) {
                user = up[0];
            } else if (up.length >= 2) {
                user = up[0];
                password = up[1];
                if (password == null) {
                    password = "";
                }
            }
            if (up.length > 2) {
                host = up[2];
            } else {
                try {
                    host = RemoteServer.getClientHost();
                }
                catch (ServerNotActiveException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        if ((realm = this.as.getSystemJmxConnector().getAuthRealmName()) == null) {
            realm = this.as.getAuthRealmName();
        }
        try {
            this.loginAsAdmin(user, password, realm, host);
            return null;
        }
        catch (LoginException e) {
            if (ADMSEC_LOGGER.isLoggable(Level.FINE)) {
                ADMSEC_LOGGER.log(Level.FINE, "*** LoginException during JMX auth\n  user={0}\n  host={1}\n  realm={2}", new Object[]{user, host, realm});
            }
            throw new SecurityException(e);
        }
    }
}

