/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.constraintvalidation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ElementKind;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.validator.constraintvalidation.HibernateConstraintValidatorContext;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintViolationCreationContext;
import org.hibernate.validator.internal.engine.path.PathImpl;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class ConstraintValidatorContextImpl
implements HibernateConstraintValidatorContext {
    private static final Log log = LoggerFactory.make();
    private final Map<String, Object> expressionVariables = CollectionHelper.newHashMap();
    private final List<String> methodParameterNames;
    private final List<ConstraintViolationCreationContext> constraintViolationCreationContexts = CollectionHelper.newArrayList(3);
    private final PathImpl basePath;
    private final ConstraintDescriptor<?> constraintDescriptor;
    private boolean defaultDisabled;

    public ConstraintValidatorContextImpl(List<String> methodParameterNames, PathImpl propertyPath, ConstraintDescriptor<?> constraintDescriptor) {
        this.methodParameterNames = methodParameterNames;
        this.basePath = propertyPath;
        this.constraintDescriptor = constraintDescriptor;
    }

    @Override
    public final void disableDefaultConstraintViolation() {
        this.defaultDisabled = true;
    }

    @Override
    public final String getDefaultConstraintMessageTemplate() {
        return (String)this.constraintDescriptor.getAttributes().get("message");
    }

    @Override
    public final ConstraintValidatorContext.ConstraintViolationBuilder buildConstraintViolationWithTemplate(String messageTemplate) {
        return new ConstraintViolationBuilderImpl(this.methodParameterNames, messageTemplate, PathImpl.createCopy(this.basePath));
    }

    @Override
    public <T> T unwrap(Class<T> type) {
        if (type.isAssignableFrom(HibernateConstraintValidatorContext.class)) {
            return type.cast(this);
        }
        throw log.getTypeNotSupportedForUnwrappingException(type);
    }

    @Override
    public HibernateConstraintValidatorContext addExpressionVariable(String name, Object value) {
        Contracts.assertNotNull(name, "null is not a valid value");
        this.expressionVariables.put(name, value);
        return this;
    }

    public final ConstraintDescriptor<?> getConstraintDescriptor() {
        return this.constraintDescriptor;
    }

    public final List<ConstraintViolationCreationContext> getConstraintViolationCreationContexts() {
        if (this.defaultDisabled && this.constraintViolationCreationContexts.size() == 0) {
            throw log.getAtLeastOneCustomMessageMustBeCreatedException();
        }
        ArrayList<ConstraintViolationCreationContext> returnedConstraintViolationCreationContexts = new ArrayList<ConstraintViolationCreationContext>(this.constraintViolationCreationContexts);
        if (!this.defaultDisabled) {
            HashMap<String, Object> parameterMapCopy = CollectionHelper.newHashMap();
            parameterMapCopy.putAll(this.expressionVariables);
            returnedConstraintViolationCreationContexts.add(new ConstraintViolationCreationContext(this.getDefaultConstraintMessageTemplate(), this.basePath, parameterMapCopy));
        }
        return returnedConstraintViolationCreationContexts;
    }

    public List<String> getMethodParameterNames() {
        return this.methodParameterNames;
    }

    private class ConstraintViolationBuilderImpl
    extends NodeBuilderBase
    implements ConstraintValidatorContext.ConstraintViolationBuilder {
        private final List<String> methodParameterNames;

        private ConstraintViolationBuilderImpl(List<String> methodParameterNames, String template, PathImpl path) {
            super(template, path);
            this.methodParameterNames = methodParameterNames;
        }

        @Override
        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderDefinedContext addNode(String name) {
            this.dropLeafNodeIfRequired();
            this.propertyPath.addPropertyNode(name);
            return new NodeBuilder(this.messageTemplate, this.propertyPath);
        }

        @Override
        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext addPropertyNode(String name) {
            this.dropLeafNodeIfRequired();
            return new DeferredNodeBuilder(this.messageTemplate, this.propertyPath, name);
        }

        @Override
        public ConstraintValidatorContext.ConstraintViolationBuilder.LeafNodeBuilderCustomizableContext addBeanNode() {
            return new DeferredNodeBuilder(this.messageTemplate, this.propertyPath, null);
        }

        @Override
        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderDefinedContext addParameterNode(int index) {
            if (this.propertyPath.getLeafNode().getKind() != ElementKind.CROSS_PARAMETER) {
                throw log.getParameterNodeAddedForNonCrossParameterConstraintException(this.propertyPath);
            }
            this.dropLeafNodeIfRequired();
            this.propertyPath.addParameterNode(this.methodParameterNames.get(index), index);
            return new NodeBuilder(this.messageTemplate, this.propertyPath);
        }

        private void dropLeafNodeIfRequired() {
            if (this.propertyPath.getLeafNode().getKind() == ElementKind.BEAN || this.propertyPath.getLeafNode().getKind() == ElementKind.CROSS_PARAMETER) {
                this.propertyPath = this.propertyPath.getPathWithoutLeafNode();
            }
        }
    }

    private class DeferredNodeBuilder
    extends NodeBuilderBase
    implements ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext,
    ConstraintValidatorContext.ConstraintViolationBuilder.LeafNodeBuilderCustomizableContext,
    ConstraintValidatorContext.ConstraintViolationBuilder.NodeContextBuilder,
    ConstraintValidatorContext.ConstraintViolationBuilder.LeafNodeContextBuilder {
        private final String leafNodeName;

        private DeferredNodeBuilder(String template, PathImpl path, String nodeName) {
            super(template, path);
            this.leafNodeName = nodeName;
        }

        @Override
        public DeferredNodeBuilder inIterable() {
            this.propertyPath.makeLeafNodeIterable();
            return this;
        }

        @Override
        public NodeBuilder atKey(Object key) {
            this.propertyPath.setLeafNodeMapKey(key);
            this.addLeafNode();
            return new NodeBuilder(this.messageTemplate, this.propertyPath);
        }

        @Override
        public NodeBuilder atIndex(Integer index) {
            this.propertyPath.setLeafNodeIndex(index);
            this.addLeafNode();
            return new NodeBuilder(this.messageTemplate, this.propertyPath);
        }

        @Override
        @Deprecated
        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext addNode(String name) {
            return this.addPropertyNode(name);
        }

        @Override
        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext addPropertyNode(String name) {
            this.addLeafNode();
            return new DeferredNodeBuilder(this.messageTemplate, this.propertyPath, name);
        }

        @Override
        public ConstraintValidatorContext.ConstraintViolationBuilder.LeafNodeBuilderCustomizableContext addBeanNode() {
            this.addLeafNode();
            return new DeferredNodeBuilder(this.messageTemplate, this.propertyPath, null);
        }

        @Override
        public ConstraintValidatorContext addConstraintViolation() {
            this.addLeafNode();
            return super.addConstraintViolation();
        }

        private void addLeafNode() {
            if (this.leafNodeName == null) {
                this.propertyPath.addBeanNode();
            } else {
                this.propertyPath.addPropertyNode(this.leafNodeName);
            }
        }
    }

    private class NodeBuilder
    extends NodeBuilderBase
    implements ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderDefinedContext,
    ConstraintValidatorContext.ConstraintViolationBuilder.LeafNodeBuilderDefinedContext {
        private NodeBuilder(String template, PathImpl path) {
            super(template, path);
        }

        @Override
        @Deprecated
        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext addNode(String name) {
            return this.addPropertyNode(name);
        }

        @Override
        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext addPropertyNode(String name) {
            return new DeferredNodeBuilder(this.messageTemplate, this.propertyPath, name);
        }

        @Override
        public ConstraintValidatorContext.ConstraintViolationBuilder.LeafNodeBuilderCustomizableContext addBeanNode() {
            return new DeferredNodeBuilder(this.messageTemplate, this.propertyPath, null);
        }
    }

    private abstract class NodeBuilderBase {
        protected final String messageTemplate;
        protected PathImpl propertyPath;

        protected NodeBuilderBase(String template, PathImpl path) {
            this.messageTemplate = template;
            this.propertyPath = path;
        }

        public ConstraintValidatorContext addConstraintViolation() {
            HashMap<String, Object> parameterMapCopy = CollectionHelper.newHashMap();
            parameterMapCopy.putAll(ConstraintValidatorContextImpl.this.expressionVariables);
            ConstraintValidatorContextImpl.this.constraintViolationCreationContexts.add(new ConstraintViolationCreationContext(this.messageTemplate, this.propertyPath, parameterMapCopy));
            return ConstraintValidatorContextImpl.this;
        }
    }
}

