/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.interceptor;

import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.shoal.adapter.store.commands.NoOpCommand;
import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.interceptor.CommandCollector;
import org.shoal.ha.cache.impl.interceptor.ReplicationFramePayloadCommand;
import org.shoal.ha.cache.impl.util.ASyncReplicationManager;
import org.shoal.ha.group.GroupService;

public class ReplicationCommandTransmitterWithList<K, V>
implements Runnable,
CommandCollector<K, V> {
    private static final Logger _logger = Logger.getLogger("org.shoal.ha.cache.interceptor.transmit");
    private DataStoreContext<K, V> dsc;
    private volatile String targetName;
    private ScheduledFuture future;
    private static final String TRANSMITTER_FREQUECNCY_PROP_NAME = "org.shoal.cache.transmitter.frequency.in.millis";
    private static final String MAX_BATCH_SIZE_PROP_NAME = "org.shoal.cache.transmitter.max.batch.size";
    private static int TRANSMITTER_FREQUECNCY_IN_MILLIS = 100;
    private int MAX_BATCH_SIZE = 20;
    private AtomicReference<BatchedCommandListDataFrame> mapRef;
    ASyncReplicationManager asyncReplicationManager = ASyncReplicationManager._getInstance();
    private volatile long timeStamp = System.currentTimeMillis();
    ThreadPoolExecutor executor;

    @Override
    public void initialize(String targetName, DataStoreContext<K, V> rsInfo) {
        this.executor = ASyncReplicationManager._getInstance().getExecutorService();
        this.targetName = targetName;
        this.dsc = rsInfo;
        try {
            TRANSMITTER_FREQUECNCY_IN_MILLIS = Integer.getInteger(System.getProperty(TRANSMITTER_FREQUECNCY_PROP_NAME, "" + TRANSMITTER_FREQUECNCY_IN_MILLIS));
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.MAX_BATCH_SIZE = Integer.getInteger(System.getProperty(MAX_BATCH_SIZE_PROP_NAME, "" + this.MAX_BATCH_SIZE));
        }
        catch (Exception ex) {
            // empty catch block
        }
        BatchedCommandListDataFrame batch = new BatchedCommandListDataFrame();
        this.mapRef = new AtomicReference<BatchedCommandListDataFrame>(batch);
        this.future = this.asyncReplicationManager.getScheduledThreadPoolExecutor().scheduleAtFixedRate(this, TRANSMITTER_FREQUECNCY_IN_MILLIS, TRANSMITTER_FREQUECNCY_IN_MILLIS, TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() {
        try {
            this.future.cancel(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void addCommand(Command<K, V> cmd) {
        boolean done = false;
        while (!done) {
            BatchedCommandListDataFrame batch = this.mapRef.get();
            done = batch.addCommand(cmd);
            if (done) continue;
            BatchedCommandListDataFrame frame = new BatchedCommandListDataFrame();
            frame.addCommand(cmd);
            done = this.mapRef.compareAndSet(batch, frame);
        }
    }

    @Override
    public void removeCommand(Command<K, V> cmd) {
        this.addCommand(cmd);
    }

    private void sendMessage(byte[] data) {
        GroupService gs = this.dsc.getGroupService();
        gs.sendMessage(this.targetName, this.dsc.getServiceName(), data);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, this.dsc.getServiceName() + ": ReplicationCommandTransmitterWithList.onTransmit() Sent " + (this.targetName == null ? " ALL MEMBERS " : this.targetName) + "; size: " + data.length);
        }
    }

    @Override
    public void run() {
        BatchedCommandListDataFrame batch = this.mapRef.get();
        if (batch.isTimeToFlush(this.timeStamp)) {
            NoOpCommand noop = new NoOpCommand();
            while (batch.addCommand(noop)) {
            }
        }
        this.timeStamp = batch.getBatchCreationTime();
    }

    private class BatchedCommandListDataFrame
    implements Runnable {
        private AtomicInteger current = new AtomicInteger(-1);
        private transient ConcurrentLinkedQueue<Command> list = new ConcurrentLinkedQueue();
        private long batchCreationTime = System.currentTimeMillis();

        private BatchedCommandListDataFrame() {
        }

        public boolean addCommand(Command cmd) {
            int value = this.current.incrementAndGet();
            if (value < ReplicationCommandTransmitterWithList.this.MAX_BATCH_SIZE) {
                this.list.add(cmd);
                if (this.list.size() == ReplicationCommandTransmitterWithList.this.MAX_BATCH_SIZE) {
                    ReplicationCommandTransmitterWithList.this.asyncReplicationManager.getExecutorService().submit(this);
                }
            }
            return value < ReplicationCommandTransmitterWithList.this.MAX_BATCH_SIZE;
        }

        boolean isTimeToFlush(long timeStamp) {
            return this.batchCreationTime == timeStamp && this.list.size() > 0;
        }

        long getBatchCreationTime() {
            return this.batchCreationTime;
        }

        @Override
        public void run() {
            ReplicationFramePayloadCommand rfCmd = new ReplicationFramePayloadCommand();
            rfCmd.setTargetInstance(ReplicationCommandTransmitterWithList.this.targetName);
            try {
                int size = this.list.size();
                for (int i = 0; i < size; ++i) {
                    Command cmd = this.list.poll();
                    if (cmd.getOpcode() == 102) continue;
                    rfCmd.addComamnd(cmd);
                }
                ReplicationCommandTransmitterWithList.this.dsc.getCommandManager().execute(rfCmd);
            }
            catch (IOException ioEx) {
                _logger.log(Level.WARNING, "Batch operation (ASyncCommandList failed...", ioEx);
            }
        }
    }
}

