/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.ext.cdi1x.internal;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ManagedBean;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterTypeDiscovery;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedCallable;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Provider;
import javax.inject.Qualifier;
import javax.ws.rs.CookieParam;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import org.glassfish.hk2.api.ClassAnalyzer;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.binding.BindingBuilder;
import org.glassfish.hk2.utilities.binding.ScopedBindingBuilder;
import org.glassfish.hk2.utilities.binding.ServiceBindingBuilder;
import org.glassfish.hk2.utilities.cache.Cache;
import org.glassfish.hk2.utilities.cache.Computable;
import org.glassfish.jersey.ext.cdi1x.internal.AbstractCdiBeanHk2Factory;
import org.glassfish.jersey.ext.cdi1x.internal.CdiUtil;
import org.glassfish.jersey.ext.cdi1x.internal.GenericCdiBeanHk2Factory;
import org.glassfish.jersey.ext.cdi1x.internal.InjecteeSkippingAnalyzer;
import org.glassfish.jersey.ext.cdi1x.internal.JerseyVetoed;
import org.glassfish.jersey.ext.cdi1x.internal.LocalizationMessages;
import org.glassfish.jersey.ext.cdi1x.internal.RequestScopedCdiBeanHk2Factory;
import org.glassfish.jersey.ext.cdi1x.internal.spi.Hk2InjectedTarget;
import org.glassfish.jersey.ext.cdi1x.internal.spi.Hk2LocatorManager;
import org.glassfish.jersey.ext.cdi1x.internal.spi.InjectionTargetListener;
import org.glassfish.jersey.ext.cdi1x.spi.Hk2CustomBoundTypesProvider;
import org.glassfish.jersey.internal.inject.ForeignRequestScopeBridge;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.spi.ComponentProvider;
import org.glassfish.jersey.server.spi.internal.ValueFactoryProvider;

@Priority(value=200)
public class CdiComponentProvider
implements ComponentProvider,
Extension {
    private static final Logger LOGGER = Logger.getLogger(CdiComponentProvider.class.getName());
    private static final Set<Class<? extends Annotation>> JAX_RS_INJECT_ANNOTATIONS = new HashSet<Class<? extends Annotation>>(){
        {
            this.addAll(JaxRsParamProducer.JAX_RS_STRING_PARAM_ANNOTATIONS);
            this.add(Context.class);
        }
    };
    public static final String CDI_CLASS_ANALYZER = "CdiInjecteeSkippingClassAnalyzer";
    private final Set<Type> jaxrsInjectableTypes = new HashSet<Type>();
    private final Set<Type> hk2ProvidedTypes = Collections.synchronizedSet(new HashSet());
    private final Set<Type> jerseyVetoedTypes = Collections.synchronizedSet(new HashSet());
    private final Set<Class<?>> requestScopedComponents = new HashSet();
    private final Cache<Class<?>, Boolean> jaxRsComponentCache = new Cache(new Computable<Class<?>, Boolean>(){

        public Boolean compute(Class<?> clazz) {
            return Application.class.isAssignableFrom(clazz) || Providers.isJaxRsProvider(clazz) || (Boolean)CdiComponentProvider.this.jaxRsResourceCache.compute(clazz) != false;
        }
    });
    private final Cache<Class<?>, Boolean> jaxRsResourceCache = new Cache(new Computable<Class<?>, Boolean>(){

        public Boolean compute(Class<?> clazz) {
            return Resource.from(clazz) != null;
        }
    });
    private final Hk2CustomBoundTypesProvider customHk2TypesProvider;
    private final Hk2LocatorManager locatorManager;
    private volatile ServiceLocator locator;
    private volatile BeanManager beanManager;
    private volatile Map<Class<?>, Set<Method>> methodsToSkip = new HashMap();
    private volatile Map<Class<?>, Set<Field>> fieldsToSkip = new HashMap();

    public CdiComponentProvider() {
        this.customHk2TypesProvider = CdiUtil.lookupService(Hk2CustomBoundTypesProvider.class);
        this.locatorManager = CdiUtil.createHk2LocatorManager();
    }

    public void initialize(ServiceLocator locator) {
        CdiComponentProvider extension;
        this.locator = locator;
        this.beanManager = CdiUtil.getBeanManager();
        if (this.beanManager != null && (extension = (CdiComponentProvider)this.beanManager.getExtension(CdiComponentProvider.class)) != null) {
            extension.addLocator(this.locator);
            this.fieldsToSkip = extension.getFieldsToSkip();
            this.methodsToSkip = extension.getMethodsToSkip();
            this.bindHk2ClassAnalyzer();
            LOGGER.config(LocalizationMessages.CDI_PROVIDER_INITIALIZED());
        }
    }

    public boolean bind(Class<?> clazz, Set<Class<?>> providerContracts) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(LocalizationMessages.CDI_CLASS_BEING_CHECKED(clazz));
        }
        if (this.beanManager == null) {
            return false;
        }
        if (CdiComponentProvider.isJerseyOrDependencyType(clazz)) {
            return false;
        }
        boolean isCdiManaged = this.isCdiComponent(clazz);
        boolean isManagedBean = this.isManagedBean(clazz);
        boolean isJaxRsComponent = this.isJaxRsComponentType(clazz);
        if (!(isCdiManaged || isManagedBean || isJaxRsComponent)) {
            return false;
        }
        boolean isJaxRsResource = (Boolean)this.jaxRsResourceCache.compute(clazz);
        DynamicConfiguration dc = Injections.getConfiguration((ServiceLocator)this.locator);
        Class<? extends Annotation> beanScopeAnnotation = CdiUtil.getBeanScope(clazz, this.beanManager);
        boolean isRequestScoped = beanScopeAnnotation == RequestScoped.class || beanScopeAnnotation == Dependent.class && isJaxRsResource;
        AbstractCdiBeanHk2Factory beanFactory = isRequestScoped ? new RequestScopedCdiBeanHk2Factory((Class)clazz, this.locator, this.beanManager, isCdiManaged) : new GenericCdiBeanHk2Factory((Class)clazz, this.locator, this.beanManager, isCdiManaged);
        ServiceBindingBuilder bindingBuilder = Injections.newFactoryBinder((Factory)beanFactory);
        bindingBuilder.to(clazz);
        for (Class<?> contract : providerContracts) {
            bindingBuilder.to(contract);
        }
        Injections.addBinding((BindingBuilder)bindingBuilder, (DynamicConfiguration)dc);
        dc.commit();
        if (isRequestScoped) {
            this.requestScopedComponents.add(clazz);
        }
        if (LOGGER.isLoggable(Level.CONFIG)) {
            LOGGER.config(LocalizationMessages.CDI_CLASS_BOUND_WITH_CDI(clazz));
        }
        return true;
    }

    public void done() {
        if (this.requestScopedComponents.size() > 0) {
            DynamicConfiguration dc = Injections.getConfiguration((ServiceLocator)this.locator);
            Injections.addBinding((BindingBuilder)Injections.newBinder((Object)new ForeignRequestScopeBridge(){

                public Set<Class<?>> getRequestScopedComponents() {
                    return CdiComponentProvider.this.requestScopedComponents;
                }
            }).to(ForeignRequestScopeBridge.class), (DynamicConfiguration)dc);
            dc.commit();
            if (LOGGER.isLoggable(Level.CONFIG)) {
                LOGGER.config(LocalizationMessages.CDI_REQUEST_SCOPED_COMPONENTS_RECOGNIZED(this.listElements(new StringBuilder().append("\n"), this.requestScopedComponents).toString()));
            }
        }
    }

    private boolean isCdiComponent(Class<?> component) {
        Annotation[] qualifiers = CdiUtil.getQualifiers(component.getAnnotations());
        return !this.beanManager.getBeans(component, qualifiers).isEmpty();
    }

    private boolean isManagedBean(Class<?> component) {
        return component.isAnnotationPresent(ManagedBean.class);
    }

    private static AnnotatedConstructor<?> enrichedConstructor(final AnnotatedConstructor<?> ctor) {
        return new AnnotatedConstructor(){

            public Constructor getJavaMember() {
                return ctor.getJavaMember();
            }

            public List<AnnotatedParameter> getParameters() {
                ArrayList<AnnotatedParameter> parameters = new ArrayList<AnnotatedParameter>(ctor.getParameters().size());
                for (final AnnotatedParameter ap : ctor.getParameters()) {
                    parameters.add(new AnnotatedParameter(){

                        public int getPosition() {
                            return ap.getPosition();
                        }

                        public AnnotatedCallable getDeclaringCallable() {
                            return ap.getDeclaringCallable();
                        }

                        public Type getBaseType() {
                            return ap.getBaseType();
                        }

                        public Set<Type> getTypeClosure() {
                            return ap.getTypeClosure();
                        }

                        public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
                            if (annotationType == JaxRsParamProducer.JaxRsParamQualifier.class) {
                                return (T)(CdiComponentProvider.hasAnnotation((Annotated)ap, JaxRsParamProducer.JAX_RS_STRING_PARAM_ANNOTATIONS) ? JaxRsParamProducer.JaxRsParamQUALIFIER : null);
                            }
                            return (T)ap.getAnnotation(annotationType);
                        }

                        public Set<Annotation> getAnnotations() {
                            HashSet<Annotation> result = new HashSet<Annotation>();
                            for (Annotation a : ap.getAnnotations()) {
                                result.add(a);
                                Class<? extends Annotation> annotationType = a.annotationType();
                                if (!JaxRsParamProducer.JAX_RS_STRING_PARAM_ANNOTATIONS.contains(annotationType)) continue;
                                result.add(JaxRsParamProducer.JaxRsParamQUALIFIER);
                            }
                            return result;
                        }

                        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
                            return annotationType == JaxRsParamProducer.JaxRsParamQualifier.class && CdiComponentProvider.hasAnnotation((Annotated)ap, JaxRsParamProducer.JAX_RS_STRING_PARAM_ANNOTATIONS) || ap.isAnnotationPresent(annotationType);
                        }
                    });
                }
                return parameters;
            }

            public boolean isStatic() {
                return ctor.isStatic();
            }

            public AnnotatedType getDeclaringType() {
                return ctor.getDeclaringType();
            }

            public Type getBaseType() {
                return ctor.getBaseType();
            }

            public Set<Type> getTypeClosure() {
                return ctor.getTypeClosure();
            }

            public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
                return (T)ctor.getAnnotation(annotationType);
            }

            public Set<Annotation> getAnnotations() {
                return ctor.getAnnotations();
            }

            public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
                return ctor.isAnnotationPresent(annotationType);
            }
        };
    }

    private void processAnnotatedType(@Observes ProcessAnnotatedType processAnnotatedType) {
        final AnnotatedType annotatedType = processAnnotatedType.getAnnotatedType();
        if (this.containsJaxRsConstructorInjection(annotatedType) || this.containsJaxRsFieldInjection(annotatedType) || this.containsJaxRsMethodInjection(annotatedType)) {
            this.jaxrsInjectableTypes.add(annotatedType.getBaseType());
        }
        if (this.customHk2TypesProvider != null) {
            Type baseType = annotatedType.getBaseType();
            if (this.customHk2TypesProvider.getHk2Types().contains(baseType)) {
                processAnnotatedType.veto();
                this.jerseyVetoedTypes.add(baseType);
            }
        }
        if (this.containsJaxRsParameterizedCtor(annotatedType)) {
            processAnnotatedType.setAnnotatedType(new AnnotatedType(){

                public Class getJavaClass() {
                    return annotatedType.getJavaClass();
                }

                public Set<AnnotatedConstructor> getConstructors() {
                    HashSet<AnnotatedConstructor> result = new HashSet<AnnotatedConstructor>();
                    for (AnnotatedConstructor c : annotatedType.getConstructors()) {
                        result.add(CdiComponentProvider.enrichedConstructor(c));
                    }
                    return result;
                }

                public Set getMethods() {
                    return annotatedType.getMethods();
                }

                public Set getFields() {
                    return annotatedType.getFields();
                }

                public Type getBaseType() {
                    return annotatedType.getBaseType();
                }

                public Set<Type> getTypeClosure() {
                    return annotatedType.getTypeClosure();
                }

                public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
                    return (T)annotatedType.getAnnotation(annotationType);
                }

                public Set<Annotation> getAnnotations() {
                    return annotatedType.getAnnotations();
                }

                public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
                    return annotatedType.isAnnotationPresent(annotationType);
                }
            });
        }
    }

    private boolean containsJaxRsParameterizedCtor(AnnotatedType annotatedType) {
        return this.containAnnotatedParameters(annotatedType.getConstructors(), JaxRsParamProducer.JAX_RS_STRING_PARAM_ANNOTATIONS);
    }

    private boolean containsJaxRsConstructorInjection(AnnotatedType annotatedType) {
        return this.containAnnotatedParameters(annotatedType.getConstructors(), JAX_RS_INJECT_ANNOTATIONS);
    }

    private boolean containsJaxRsMethodInjection(AnnotatedType annotatedType) {
        return this.containAnnotatedParameters(annotatedType.getMethods(), JAX_RS_INJECT_ANNOTATIONS);
    }

    private boolean containsJaxRsFieldInjection(AnnotatedType annotatedType) {
        return this.containAnnotation(annotatedType.getFields(), JAX_RS_INJECT_ANNOTATIONS);
    }

    private boolean containAnnotatedParameters(Collection<AnnotatedCallable> annotatedCallables, Set<Class<? extends Annotation>> annotationSet) {
        for (AnnotatedCallable c : annotatedCallables) {
            if (!this.containAnnotation(c.getParameters(), annotationSet)) continue;
            return true;
        }
        return false;
    }

    private boolean containAnnotation(Collection<Annotated> elements, Set<Class<? extends Annotation>> annotationSet) {
        for (Annotated element : elements) {
            if (!CdiComponentProvider.hasAnnotation(element, annotationSet)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasAnnotation(Annotated element, Set<Class<? extends Annotation>> annotations) {
        for (Class<? extends Annotation> a : annotations) {
            if (!element.isAnnotationPresent(a)) continue;
            return true;
        }
        return false;
    }

    private void afterTypeDiscovery(@Observes AfterTypeDiscovery afterTypeDiscovery) {
        if (LOGGER.isLoggable(Level.CONFIG) && !this.jerseyVetoedTypes.isEmpty()) {
            LOGGER.config(LocalizationMessages.CDI_TYPE_VETOED(this.customHk2TypesProvider, this.listElements(new StringBuilder().append("\n"), this.jerseyVetoedTypes).toString()));
        }
    }

    private void beforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager beanManager) {
        beforeBeanDiscovery.addAnnotatedType(beanManager.createAnnotatedType(JaxRsParamProducer.class));
    }

    private void processInjectionTarget(@Observes ProcessInjectionTarget event) {
        InjectionTarget it = event.getInjectionTarget();
        Class componentClass = event.getAnnotatedType().getJavaClass();
        final Set<InjectionPoint> cdiInjectionPoints = this.filterHk2InjectionPointsOut(it.getInjectionPoints());
        for (InjectionPoint injectionPoint : cdiInjectionPoints) {
            Member member = injectionPoint.getMember();
            if (member instanceof Field) {
                this.addInjecteeToSkip(componentClass, this.fieldsToSkip, (Field)member);
                continue;
            }
            if (!(member instanceof Method)) continue;
            this.addInjecteeToSkip(componentClass, this.methodsToSkip, (Method)member);
        }
        Hk2InjectedCdiTarget target = null;
        if (CdiComponentProvider.isJerseyOrDependencyType(componentClass)) {
            target = new Hk2InjectedCdiTarget(componentClass, it){

                @Override
                public Set<InjectionPoint> getInjectionPoints() {
                    return Collections.emptySet();
                }
            };
        } else if (this.isJaxRsComponentType(componentClass) || this.jaxrsInjectableTypes.contains(event.getAnnotatedType().getBaseType())) {
            target = new Hk2InjectedCdiTarget(componentClass, it){

                @Override
                public Set<InjectionPoint> getInjectionPoints() {
                    return cdiInjectionPoints;
                }
            };
        }
        if (target != null) {
            this.notify(target);
            event.setInjectionTarget((InjectionTarget)target);
        }
    }

    private Set<InjectionPoint> filterHk2InjectionPointsOut(Set<InjectionPoint> originalInjectionPoints) {
        HashSet<InjectionPoint> filteredInjectionPoints = new HashSet<InjectionPoint>();
        for (InjectionPoint ip : originalInjectionPoints) {
            Type injectedType = ip.getType();
            if (this.customHk2TypesProvider != null && this.customHk2TypesProvider.getHk2Types().contains(injectedType)) {
                this.hk2ProvidedTypes.add(injectedType);
                continue;
            }
            if (injectedType instanceof Class) {
                Class injectedClass = (Class)injectedType;
                if (CdiComponentProvider.isJerseyOrDependencyType(injectedClass)) {
                    this.hk2ProvidedTypes.add(injectedType);
                    continue;
                }
                filteredInjectionPoints.add(ip);
                continue;
            }
            if (this.isInjectionProvider(injectedType) && this.isProviderOfJerseyType((ParameterizedType)injectedType)) {
                this.hk2ProvidedTypes.add(((ParameterizedType)injectedType).getActualTypeArguments()[0]);
                continue;
            }
            filteredInjectionPoints.add(ip);
        }
        return filteredInjectionPoints;
    }

    private boolean isInjectionProvider(Type injectedType) {
        return injectedType instanceof ParameterizedType && ((ParameterizedType)injectedType).getRawType() == Provider.class;
    }

    private boolean isProviderOfJerseyType(ParameterizedType provider) {
        Type firstArgumentType = provider.getActualTypeArguments()[0];
        if (firstArgumentType instanceof Class && CdiComponentProvider.isJerseyOrDependencyType((Class)firstArgumentType)) {
            return true;
        }
        return this.customHk2TypesProvider != null && this.customHk2TypesProvider.getHk2Types().contains(firstArgumentType);
    }

    private <T> void addInjecteeToSkip(Class<?> componentClass, Map<Class<?>, Set<T>> toSkip, T member) {
        if (!toSkip.containsKey(componentClass)) {
            toSkip.put(componentClass, new HashSet());
        }
        toSkip.get(componentClass).add(member);
    }

    private void afterDiscoveryObserver(@Observes AfterBeanDiscovery abd) {
        if (this.customHk2TypesProvider != null) {
            this.hk2ProvidedTypes.addAll(this.customHk2TypesProvider.getHk2Types());
        }
        for (Type t : this.hk2ProvidedTypes) {
            abd.addBean((Bean)new Hk2Bean(t));
        }
    }

    Map<Class<?>, Set<Field>> getFieldsToSkip() {
        return this.fieldsToSkip;
    }

    Map<Class<?>, Set<Method>> getMethodsToSkip() {
        return this.methodsToSkip;
    }

    ServiceLocator getEffectiveLocator() {
        return this.locatorManager.getEffectiveLocator();
    }

    void addLocator(ServiceLocator locator) {
        this.locatorManager.registerLocator(locator);
    }

    void notify(Hk2InjectedTarget target) {
        if (this.locatorManager instanceof InjectionTargetListener) {
            ((InjectionTargetListener)((Object)this.locatorManager)).notify(target);
        }
    }

    boolean isJaxRsComponentType(Class<?> clazz) {
        return (Boolean)this.jaxRsComponentCache.compute(clazz);
    }

    private static boolean isJerseyOrDependencyType(Class<?> clazz) {
        if (clazz.isPrimitive() || clazz.isSynthetic()) {
            return false;
        }
        Package pkg = clazz.getPackage();
        if (pkg == null) {
            LOGGER.warning(String.format("Class %s has null package", clazz));
            return false;
        }
        String pkgName = pkg.getName();
        return !clazz.isAnnotationPresent(JerseyVetoed.class) && (pkgName.contains("org.glassfish.hk2") || pkgName.contains("jersey.repackaged") || pkgName.contains("org.jvnet.hk2") || pkgName.startsWith("org.glassfish.jersey") && !pkgName.startsWith("org.glassfish.jersey.examples") && !pkgName.startsWith("org.glassfish.jersey.tests") || pkgName.startsWith("com.sun.jersey") && !pkgName.startsWith("com.sun.jersey.examples") && !pkgName.startsWith("com.sun.jersey.tests"));
    }

    private void bindHk2ClassAnalyzer() {
        ClassAnalyzer defaultClassAnalyzer = (ClassAnalyzer)this.locator.getService(ClassAnalyzer.class, "default", new Annotation[0]);
        int skippedElements = this.methodsToSkip.size() + this.fieldsToSkip.size();
        ClassAnalyzer customizedClassAnalyzer = skippedElements > 0 ? new InjecteeSkippingAnalyzer(defaultClassAnalyzer, this.methodsToSkip, this.fieldsToSkip) : defaultClassAnalyzer;
        DynamicConfiguration dc = Injections.getConfiguration((ServiceLocator)this.locator);
        ScopedBindingBuilder bindingBuilder = Injections.newBinder((Object)customizedClassAnalyzer);
        bindingBuilder.analyzeWith("default").to(ClassAnalyzer.class).named(CDI_CLASS_ANALYZER);
        Injections.addBinding((BindingBuilder)bindingBuilder, (DynamicConfiguration)dc);
        dc.commit();
    }

    private StringBuilder listElements(StringBuilder logMsgBuilder, Collection<? extends Object> elements) {
        for (Object object : elements) {
            logMsgBuilder.append(String.format(" - %s%n", object));
        }
        return logMsgBuilder;
    }

    public static class CdiDefaultAnnotation
    extends AnnotationLiteral<Default>
    implements Default {
        private static final long serialVersionUID = 1L;
    }

    private class Hk2Bean
    implements Bean {
        private final Type t;

        public Hk2Bean(Type t) {
            this.t = t;
        }

        public Class getBeanClass() {
            return (Class)this.t;
        }

        public Set getInjectionPoints() {
            return Collections.emptySet();
        }

        public boolean isNullable() {
            return true;
        }

        public Object create(CreationalContext creationalContext) {
            return CdiComponentProvider.this.getEffectiveLocator().getService(this.t, new Annotation[0]);
        }

        public void destroy(Object instance, CreationalContext creationalContext) {
        }

        public Set getTypes() {
            return Collections.singleton(this.t);
        }

        public Set getQualifiers() {
            return Collections.singleton(new CdiDefaultAnnotation());
        }

        public Class getScope() {
            return Dependent.class;
        }

        public String getName() {
            return this.t.toString();
        }

        public Set getStereotypes() {
            return Collections.emptySet();
        }

        public boolean isAlternative() {
            return false;
        }
    }

    private abstract class Hk2InjectedCdiTarget
    implements Hk2InjectedTarget {
        private final Class<?> componentClass;
        private final InjectionTarget delegate;
        private final ClassLoader targetClassLoader;
        private volatile ServiceLocator effectiveLocator;
        private volatile boolean multipleLocators = false;

        public Hk2InjectedCdiTarget(Class<?> componentClass, InjectionTarget delegate) {
            this.componentClass = componentClass;
            this.delegate = delegate;
            this.targetClassLoader = componentClass.getClassLoader();
        }

        public abstract Set<InjectionPoint> getInjectionPoints();

        public void inject(Object t, CreationalContext cc) {
            ServiceLocator injectingLocator;
            this.delegate.inject(t, cc);
            ServiceLocator il = this.multipleLocators ? CdiComponentProvider.this.getEffectiveLocator() : this.effectiveLocator;
            ServiceLocator serviceLocator = injectingLocator = il != null ? il : this.effectiveLocator;
            if (injectingLocator != null) {
                injectingLocator.inject(t, CdiComponentProvider.CDI_CLASS_ANALYZER);
            }
        }

        public void postConstruct(Object t) {
            this.delegate.postConstruct(t);
        }

        public void preDestroy(Object t) {
            this.delegate.preDestroy(t);
        }

        public Object produce(CreationalContext cc) {
            return this.delegate.produce(cc);
        }

        public void dispose(Object t) {
            this.delegate.dispose(t);
        }

        @Override
        public void setLocator(ServiceLocator effectiveLocator) {
            if (this.effectiveLocator != null) {
                this.multipleLocators = true;
            }
            this.effectiveLocator = effectiveLocator;
        }
    }

    @ApplicationScoped
    public static class JaxRsParamProducer {
        private static final JaxRsParamQualifier JaxRsParamQUALIFIER = new JaxRsParamQualifier(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return JaxRsParamQualifier.class;
            }
        };
        static final Set<Class<? extends Annotation>> JAX_RS_STRING_PARAM_ANNOTATIONS = new HashSet<Class<? extends Annotation>>(){
            {
                this.add(PathParam.class);
                this.add(QueryParam.class);
                this.add(CookieParam.class);
                this.add(HeaderParam.class);
                this.add(MatrixParam.class);
                this.add(FormParam.class);
            }
        };
        final Cache<InjectionPoint, Parameter> parameterCache = new Cache((Computable)new Computable<InjectionPoint, Parameter>(){

            public Parameter compute(InjectionPoint injectionPoint) {
                AnnotatedParameter annotatedParameter;
                AnnotatedCallable callable;
                Annotated annotated = injectionPoint.getAnnotated();
                Class<?> clazz = injectionPoint.getMember().getDeclaringClass();
                if (annotated instanceof AnnotatedParameter && (callable = (annotatedParameter = (AnnotatedParameter)annotated).getDeclaringCallable()) instanceof AnnotatedConstructor) {
                    AnnotatedConstructor ac = (AnnotatedConstructor)callable;
                    int position = annotatedParameter.getPosition();
                    List parameters = Parameter.create(clazz, clazz, (Constructor)ac.getJavaMember(), (boolean)false);
                    return (Parameter)parameters.get(position);
                }
                return null;
            }
        });

        @Produces
        @JaxRsParamQualifier
        public String getParameterValue(InjectionPoint injectionPoint, BeanManager beanManager) {
            Parameter parameter = (Parameter)this.parameterCache.compute((Object)injectionPoint);
            if (parameter != null) {
                ServiceLocator locator = ((CdiComponentProvider)beanManager.getExtension(CdiComponentProvider.class)).getEffectiveLocator();
                Set providers = Providers.getProviders((ServiceLocator)locator, ValueFactoryProvider.class);
                for (ValueFactoryProvider vfp : providers) {
                    Factory valueFactory = vfp.getValueFactory(parameter);
                    if (valueFactory == null) continue;
                    return (String)valueFactory.provide();
                }
            }
            return null;
        }

        @Qualifier
        @Retention(value=RetentionPolicy.RUNTIME)
        @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.TYPE})
        public static @interface JaxRsParamQualifier {
        }
    }
}

