/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.runtime;

import java.io.EOFException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.gogo.runtime.CommandNotFoundException;
import org.apache.felix.gogo.runtime.CommandSessionImpl;
import org.apache.felix.gogo.runtime.EOFError;
import org.apache.felix.gogo.runtime.Evaluate;
import org.apache.felix.gogo.runtime.Parser;
import org.apache.felix.gogo.runtime.Pipe;
import org.apache.felix.gogo.runtime.Reflective;
import org.apache.felix.gogo.runtime.SyntaxError;
import org.apache.felix.gogo.runtime.Token;
import org.apache.felix.gogo.runtime.Tokenizer;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Closure
implements Function,
Evaluate {
    public static final String LOCATION = ".location";
    private static final String DEFAULT_LOCK = ".defaultLock";
    private static final long serialVersionUID = 1L;
    private static final ThreadLocal<String> location = new ThreadLocal();
    private final CommandSessionImpl session;
    private final Closure parent;
    private final CharSequence source;
    private final List<List<List<Token>>> program;
    private final Object script;
    private Token errTok;
    private Token errTok2;
    private List<Object> parms = null;
    private List<Object> parmv = null;

    public Closure(CommandSessionImpl session, Closure parent, CharSequence source) throws Exception {
        this.session = session;
        this.parent = parent;
        this.source = source;
        this.script = session.get("0");
        try {
            this.program = new Parser(source).program();
        }
        catch (Exception e) {
            throw this.setLocation(e);
        }
    }

    public CommandSessionImpl session() {
        return this.session;
    }

    private Exception setLocation(Exception e) {
        if (this.session.get(DEFAULT_LOCK) == null) {
            String loc = location.get();
            if (null == loc) {
                String string = loc = null == this.script ? "" : this.script + ":";
                if (e instanceof SyntaxError) {
                    SyntaxError se = (SyntaxError)e;
                    loc = loc + se.line() + "." + se.column();
                } else if (null != this.errTok) {
                    loc = loc + this.errTok.line + "." + this.errTok.column;
                }
                location.set(loc);
            } else if (null != this.script && !loc.contains(":")) {
                location.set(this.script + ":" + loc);
            }
            this.session.put(LOCATION, location.get());
        }
        if (e instanceof EOFError) {
            EOFException eofe = new EOFException(e.getMessage());
            eofe.initCause(e);
            return eofe;
        }
        return e;
    }

    @Override
    public Object execute(CommandSession x, List<Object> values) throws Exception {
        try {
            location.remove();
            this.session.variables.remove(LOCATION);
            return this.execute(values);
        }
        catch (Exception e) {
            throw this.setLocation(e);
        }
    }

    private Object execute(List<Object> values) throws Exception {
        if (null != values) {
            this.parmv = values;
            this.parms = new ArgList(this.parmv);
        } else if (null != this.parent) {
            this.parms = this.parent.parms;
            this.parmv = this.parent.parmv;
        } else {
            Object args = this.session.get("args");
            if (null != args && args instanceof List) {
                this.parmv = (List)args;
                this.parms = new ArgList(this.parmv);
            }
        }
        Pipe last = null;
        Object[] mark = Pipe.mark();
        for (List<List<Token>> pipeline : this.program) {
            ArrayList<Pipe> pipes = new ArrayList<Pipe>();
            for (List<Token> statement : pipeline) {
                Pipe current = new Pipe(this, statement);
                if (pipes.isEmpty()) {
                    if (current.out == null) {
                        current.setIn(this.session.in);
                        current.setOut(this.session.out);
                        current.setErr(this.session.err);
                    }
                } else {
                    Pipe previous = (Pipe)pipes.get(pipes.size() - 1);
                    previous.connect(current);
                }
                pipes.add(current);
            }
            if (pipes.size() == 1) {
                ((Pipe)pipes.get(0)).run();
            } else if (pipes.size() > 1) {
                for (Pipe pipe : pipes) {
                    pipe.start();
                }
                try {
                    for (Pipe pipe : pipes) {
                        pipe.join();
                    }
                }
                catch (InterruptedException e) {
                    for (Pipe pipe : pipes) {
                        pipe.interrupt();
                    }
                    throw e;
                }
            }
            last = (Pipe)pipes.remove(pipes.size() - 1);
            for (Pipe pipe : pipes) {
                if (pipe.exception == null) continue;
                Object oloc = this.session.get(LOCATION);
                String loc = String.valueOf(oloc).contains(":") ? oloc + ": " : "pipe: ";
                this.session.err.println(loc + pipe.exception);
                this.session.put("pipe-exception", pipe.exception);
            }
            if (last.exception == null) continue;
            Pipe.reset(mark);
            throw last.exception;
        }
        Pipe.reset(mark);
        return last == null ? null : last.result;
    }

    private Object eval(Object v) {
        String s = v.toString();
        v = "null".equals(s) ? null : ("false".equals(s) ? Boolean.valueOf(false) : ("true".equals(s) ? Boolean.valueOf(true) : s));
        return v;
    }

    @Override
    public Object eval(Token t) throws Exception {
        Object v = null;
        switch (t.type) {
            case WORD: {
                v = Tokenizer.expand(t, this);
                if (t != v) break;
                v = this.eval(v);
                break;
            }
            case CLOSURE: {
                v = new Closure(this.session, this, t);
                break;
            }
            case EXECUTION: {
                v = new Closure(this.session, this, t).execute(this.session, this.parms);
                break;
            }
            case ARRAY: {
                v = this.array(t);
                break;
            }
            case ASSIGN: {
                v = t.type;
                break;
            }
            default: {
                throw new SyntaxError(t.line, t.column, "unexpected token: " + (Object)((Object)t.type));
            }
        }
        return v;
    }

    public Object executeStatement(List<Token> statement) throws Exception {
        Object echo = this.session.get("echo");
        String xtrace = null;
        if (echo != null && !"false".equals(echo.toString())) {
            StringBuilder buf = new StringBuilder("+");
            for (Token token : statement) {
                buf.append(' ');
                buf.append(token.source());
            }
            xtrace = buf.toString();
            this.session.err.println(xtrace);
        }
        ArrayList<Object> values = new ArrayList<Object>();
        this.errTok = statement.get(0);
        if (statement.size() > 3 && Tokenizer.Type.ASSIGN.equals((Object)statement.get((int)1).type)) {
            this.errTok2 = statement.get(2);
        }
        for (Token t : statement) {
            Object v = this.eval(t);
            if (Tokenizer.Type.EXECUTION == t.type && statement.size() == 1) {
                return v;
            }
            if (this.parms == v && this.parms != null) {
                values.addAll(this.parms);
                continue;
            }
            values.add(v);
        }
        Object cmd = values.remove(0);
        if (cmd == null) {
            if (values.isEmpty()) {
                return null;
            }
            throw new RuntimeException("Command name evaluates to null: " + this.errTok);
        }
        if (cmd instanceof CharSequence && values.size() > 0 && Tokenizer.Type.ASSIGN.equals(values.get(0))) {
            Object value;
            values.remove(0);
            String scmd = cmd.toString();
            if (values.size() == 0) {
                return this.session.variables.remove(scmd);
            }
            if (values.size() == 1) {
                value = values.get(0);
            } else {
                cmd = values.remove(0);
                if (null == cmd) {
                    throw new RuntimeException("Command name evaluates to null: " + this.errTok2);
                }
                this.trace2(xtrace, cmd, values);
                value = this.bareword(statement.get(2)) ? this.executeCmd(cmd.toString(), values) : this.executeMethod(cmd, values);
            }
            return this.assignment(scmd, value);
        }
        this.trace2(xtrace, cmd, values);
        return this.bareword(statement.get(0)) ? this.executeCmd(cmd.toString(), values) : this.executeMethod(cmd, values);
    }

    private void trace2(String trace1, Object cmd, List<Object> values) {
        if ("verbose".equals(this.session.get("echo"))) {
            StringBuilder buf = new StringBuilder("+ " + cmd);
            for (Object value : values) {
                buf.append(' ');
                buf.append(value);
            }
            String trace2 = buf.toString();
            if (!trace2.equals(trace1)) {
                this.session.err.println("+" + trace2);
            }
        }
    }

    private boolean bareword(Token t) throws Exception {
        return t.type == Tokenizer.Type.WORD && t == Tokenizer.expand(t, this) && this.eval((Object)t) instanceof String;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeCmd(String scmd, List<Object> values) throws Exception {
        String scopedFunction = scmd;
        Object x = this.get(scmd);
        if (!(x instanceof Function)) {
            if (scmd.indexOf(58) < 0) {
                scopedFunction = "*:" + scmd;
            }
            if ((x = this.get(scopedFunction)) == null || !(x instanceof Function)) {
                if (this.session.get(DEFAULT_LOCK) == null) {
                    x = this.get("default");
                    if (x == null) {
                        x = this.get("*:default");
                    }
                    if (x instanceof Function) {
                        try {
                            this.session.put(DEFAULT_LOCK, true);
                            values.add(0, scmd);
                            Object object = ((Function)x).execute(this.session, values);
                            return object;
                        }
                        finally {
                            this.session.variables.remove(DEFAULT_LOCK);
                        }
                    }
                }
                throw new CommandNotFoundException(scmd);
            }
        }
        return ((Function)x).execute(this.session, values);
    }

    private Object executeMethod(Object cmd, List<Object> values) throws Exception {
        boolean dot;
        if (values.isEmpty()) {
            return cmd;
        }
        boolean bl = dot = values.size() > 1 && ".".equals(String.valueOf(values.get(0)));
        if (dot) {
            Object target = cmd;
            ArrayList<Object> args = new ArrayList<Object>();
            values.remove(0);
            for (Object arg : values) {
                if (".".equals(arg)) {
                    target = Reflective.method(this.session, target, args.remove(0).toString(), args);
                    args.clear();
                    continue;
                }
                args.add(arg);
            }
            if (args.size() == 0) {
                return target;
            }
            return Reflective.method(this.session, target, args.remove(0).toString(), args);
        }
        if (cmd.getClass().isArray() && values.size() == 1) {
            Object[] cmdv = (Object[])cmd;
            String index = values.get(0).toString();
            return "length".equals(index) ? Integer.valueOf(cmdv.length) : cmdv[Integer.parseInt(index)];
        }
        return Reflective.method(this.session, cmd, values.remove(0).toString(), values);
    }

    private Object assignment(String name, Object value) {
        this.session.variables.put(name, value);
        return value;
    }

    private Object array(Token array) throws Exception {
        ArrayList<Token> list = new ArrayList<Token>();
        LinkedHashMap<Token, Token> map = new LinkedHashMap<Token, Token>();
        new Parser(array).array(list, map);
        if (map.isEmpty()) {
            ArrayList<Object> olist = new ArrayList<Object>();
            for (Token t : list) {
                Object oval = this.eval(t);
                if (oval.getClass().isArray()) {
                    for (Object o : (Object[])oval) {
                        olist.add(o);
                    }
                    continue;
                }
                olist.add(oval);
            }
            return olist;
        }
        LinkedHashMap<Object, Object> omap = new LinkedHashMap<Object, Object>();
        for (Map.Entry e : map.entrySet()) {
            Token key = (Token)e.getKey();
            Object k = this.eval(key);
            if (!(k instanceof String)) {
                throw new SyntaxError(key.line, key.column, "map key null or not String: " + key);
            }
            omap.put(k, this.eval((Token)e.getValue()));
        }
        return omap;
    }

    @Override
    public Object get(String name) {
        if (this.parms != null) {
            int i;
            if ("args".equals(name)) {
                return this.parms;
            }
            if ("argv".equals(name)) {
                return this.parmv;
            }
            if ("it".equals(name)) {
                return this.parms.get(0);
            }
            if (name.length() == 1 && Character.isDigit(name.charAt(0)) && (i = name.charAt(0) - 48) > 0) {
                return this.parms.get(i - 1);
            }
        }
        return this.session.get(name);
    }

    @Override
    public Object put(String key, Object value) {
        return this.session.variables.put(key, value);
    }

    public String toString() {
        return ((Object)this.source).toString().trim().replaceAll("\n+", "\n").replaceAll("([^\\\\{(\\[])\n", "\\1;").replaceAll("[ \\\\\t\n]+", " ");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ArgList
    extends AbstractList<Object> {
        private List<Object> list;

        public ArgList(List<Object> args) {
            this.list = args;
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder();
            for (Object o : this.list) {
                if (buf.length() > 0) {
                    buf.append(' ');
                }
                buf.append(o);
            }
            return buf.toString();
        }

        @Override
        public Object get(int index) {
            return index < this.list.size() ? this.list.get(index) : null;
        }

        @Override
        public Object remove(int index) {
            return this.list.remove(index);
        }

        @Override
        public int size() {
            return this.list.size();
        }
    }
}

