/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resources.admin.cli;

import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.resource.ResourceException;
import org.glassfish.api.I18n;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.resourcebase.resources.admin.cli.ResourceUtil;
import org.glassfish.resourcebase.resources.api.ResourceStatus;
import org.glassfish.resourcebase.resources.util.BindableResourcesHelper;
import org.glassfish.resources.admin.cli.ResourceManager;
import org.glassfish.resources.config.CustomResource;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="custom-resource")
@PerLookup
@I18n(value="create.custom.resource")
public class CustomResourceManager
implements ResourceManager {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CustomResourceManager.class);
    private static final String DESCRIPTION = "description";
    @Inject
    private ResourceUtil resourceUtil;
    @Inject
    private BindableResourcesHelper resourcesHelper;
    private String resType = null;
    private String factoryClass = null;
    private String enabled = null;
    private String enabledValueForTarget = null;
    private String description = null;
    private String jndiName = null;

    @Override
    public String getResourceType() {
        return "custom-resource";
    }

    @Override
    public ResourceStatus create(Resources resources, HashMap attributes, final Properties properties, String target) throws Exception {
        this.setAttributes(attributes, target);
        ResourceStatus validationStatus = this.isValid(resources, true, target);
        if (validationStatus.getStatus() == 1) {
            return validationStatus;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    return CustomResourceManager.this.createResource(param, properties);
                }
            }, (ConfigBeanProxy)resources);
            this.resourceUtil.createResourceRef(this.jndiName, this.enabledValueForTarget, target);
        }
        catch (TransactionFailure tfe) {
            String msg = localStrings.getLocalString("create.custom.resource.fail", "Unable to create custom resource {0}.", new Object[]{this.jndiName}) + " " + tfe.getLocalizedMessage();
            return new ResourceStatus(1, msg, true);
        }
        String msg = localStrings.getLocalString("create.custom.resource.success", "Custom Resource {0} created.", new Object[]{this.jndiName});
        return new ResourceStatus(0, msg, true);
    }

    private ResourceStatus isValid(Resources resources, boolean validateResourceRef, String target) {
        if (this.resType == null) {
            String msg = localStrings.getLocalString("create.custom.resource.noResType", "No type defined for Custom Resource.");
            return new ResourceStatus(1, msg, true);
        }
        if (this.factoryClass == null) {
            String msg = localStrings.getLocalString("create.custom.resource.noFactoryClassName", "No Factory class name defined for Custom Resource.");
            return new ResourceStatus(1, msg, true);
        }
        ResourceStatus status = this.resourcesHelper.validateBindableResourceForDuplicates(resources, this.jndiName, validateResourceRef, target, CustomResource.class);
        if (status.getStatus() == 1) {
            return status;
        }
        return status;
    }

    private void setAttributes(HashMap attributes, String target) {
        this.jndiName = (String)attributes.get("jndi-name");
        this.resType = (String)attributes.get("res-type");
        this.factoryClass = (String)attributes.get("factory-class");
        this.enabled = target != null ? this.resourceUtil.computeEnabledValueForResourceBasedOnTarget((String)attributes.get("enabled"), target) : (String)attributes.get("enabled");
        this.enabledValueForTarget = (String)attributes.get("enabled");
        this.description = (String)attributes.get(DESCRIPTION);
    }

    private Object createResource(Resources param, Properties properties) throws PropertyVetoException, TransactionFailure {
        CustomResource newResource = this.createConfigBean(param, properties);
        param.getResources().add(newResource);
        return newResource;
    }

    private CustomResource createConfigBean(Resources param, Properties properties) throws PropertyVetoException, TransactionFailure {
        CustomResource newResource = (CustomResource)param.createChild(CustomResource.class);
        newResource.setJndiName(this.jndiName);
        newResource.setFactoryClass(this.factoryClass);
        newResource.setResType(this.resType);
        newResource.setEnabled(this.enabled);
        if (this.description != null) {
            newResource.setDescription(this.description);
        }
        if (properties != null) {
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                Property prop = (Property)newResource.createChild(Property.class);
                prop.setName((String)e.getKey());
                prop.setValue((String)e.getValue());
                newResource.getProperty().add(prop);
            }
        }
        return newResource;
    }

    @Override
    public Resource createConfigBean(Resources resources, HashMap attributes, Properties properties, boolean validate) throws Exception {
        this.setAttributes(attributes, null);
        ResourceStatus status = null;
        status = !validate ? new ResourceStatus(0, "") : this.isValid(resources, false, null);
        if (status.getStatus() == 0) {
            return this.createConfigBean(resources, properties);
        }
        throw new ResourceException(status.getMessage());
    }
}

