/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.servlet;

import java.util.EventListener;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.HandlesTypes;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.WebSocketContainer;
import javax.websocket.server.ServerApplicationConfig;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.glassfish.tyrus.core.DebugContext;
import org.glassfish.tyrus.core.TyrusWebSocketEngine;
import org.glassfish.tyrus.core.monitoring.ApplicationEventListener;
import org.glassfish.tyrus.server.TyrusServerConfiguration;
import org.glassfish.tyrus.server.TyrusServerContainer;
import org.glassfish.tyrus.servlet.TyrusServletFilter;
import org.glassfish.tyrus.spi.WebSocketEngine;

@HandlesTypes(value={ServerEndpoint.class, ServerApplicationConfig.class, Endpoint.class})
public class TyrusServletContainerInitializer
implements ServletContainerInitializer {
    private static final Logger LOGGER = Logger.getLogger(TyrusServletContainerInitializer.class.getName());
    private static final Set<Class<?>> FILTERED_CLASSES = new HashSet<Class<?>>(){
        {
            this.add(TyrusServerConfiguration.class);
        }
    };

    public void onStartup(Set<Class<?>> classes, final ServletContext ctx) throws ServletException {
        if (classes == null || classes.isEmpty()) {
            return;
        }
        classes.removeAll(FILTERED_CLASSES);
        final Integer incomingBufferSize = this.getIntContextParam(ctx, "org.glassfish.tyrus.servlet.incoming-buffer-size");
        final Integer maxSessionsPerApp = this.getIntContextParam(ctx, "org.glassfish.tyrus.maxSessionsPerApp");
        final Integer maxSessionsPerRemoteAddr = this.getIntContextParam(ctx, "org.glassfish.tyrus.maxSessionsPerRemoteAddr");
        final Boolean parallelBroadcastEnabled = this.getBooleanContextParam(ctx, "org.glassfish.tyrus.server.parallelBroadcastEnabled");
        final DebugContext.TracingType tracingType = this.getEnumContextParam(ctx, "org.glassfish.tyrus.server.tracingType", DebugContext.TracingType.class, DebugContext.TracingType.OFF);
        final DebugContext.TracingThreshold tracingThreshold = this.getEnumContextParam(ctx, "org.glassfish.tyrus.server.tracingThreshold", DebugContext.TracingThreshold.class, DebugContext.TracingThreshold.TRACE);
        final ApplicationEventListener applicationEventListener = this.createApplicationEventListener(ctx);
        TyrusServerContainer serverContainer = new TyrusServerContainer(classes){
            private final WebSocketEngine engine;
            {
                super(x0);
                this.engine = TyrusWebSocketEngine.builder((WebSocketContainer)this).applicationEventListener(applicationEventListener).incomingBufferSize(incomingBufferSize).maxSessionsPerApp(maxSessionsPerApp).maxSessionsPerRemoteAddr(maxSessionsPerRemoteAddr).parallelBroadcastEnabled(parallelBroadcastEnabled).tracingType(tracingType).tracingThreshold(tracingThreshold).build();
            }

            public void register(Class<?> endpointClass) throws DeploymentException {
                this.engine.register(endpointClass, ctx.getContextPath());
            }

            public void register(ServerEndpointConfig serverEndpointConfig) throws DeploymentException {
                this.engine.register(serverEndpointConfig, ctx.getContextPath());
            }

            public WebSocketEngine getWebSocketEngine() {
                return this.engine;
            }
        };
        ctx.setAttribute(ServerContainer.class.getName(), (Object)serverContainer);
        Boolean wsadlEnabled = this.getBooleanContextParam(ctx, "org.glassfish.tyrus.server.wsadl");
        if (wsadlEnabled == null) {
            wsadlEnabled = false;
        }
        LOGGER.config("WSADL enabled: " + wsadlEnabled);
        TyrusServletFilter filter = new TyrusServletFilter((TyrusWebSocketEngine)serverContainer.getWebSocketEngine(), wsadlEnabled);
        ctx.addListener((EventListener)((Object)filter));
        FilterRegistration.Dynamic reg = ctx.addFilter("WebSocket filter", (Filter)filter);
        reg.setAsyncSupported(true);
        reg.addMappingForUrlPatterns(null, true, new String[]{"/*"});
        LOGGER.info("Registering WebSocket filter for url pattern /*");
        if (applicationEventListener != null) {
            applicationEventListener.onApplicationInitialized(ctx.getContextPath());
        }
    }

    private Integer getIntContextParam(ServletContext ctx, String paramName) {
        String initParameter = ctx.getInitParameter(paramName);
        if (initParameter != null) {
            try {
                return Integer.parseInt(initParameter);
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.CONFIG, "Invalid configuration value [" + paramName + " = " + initParameter + "], " + "integer expected");
            }
        }
        return null;
    }

    private Boolean getBooleanContextParam(ServletContext ctx, String paramName) {
        String initParameter = ctx.getInitParameter(paramName);
        if (initParameter != null) {
            if (initParameter.equalsIgnoreCase("true")) {
                return true;
            }
            if (initParameter.equalsIgnoreCase("false")) {
                return false;
            }
            LOGGER.log(Level.CONFIG, "Invalid configuration value [" + paramName + " = " + initParameter + "], " + "boolean expected");
            return null;
        }
        return null;
    }

    private <T extends Enum<T>> T getEnumContextParam(ServletContext ctx, String paramName, Class<T> type, T defaultValue) {
        String initParameter = ctx.getInitParameter(paramName);
        if (initParameter == null) {
            return defaultValue;
        }
        try {
            return Enum.valueOf(type, initParameter.trim().toUpperCase(Locale.US));
        }
        catch (Exception e) {
            LOGGER.log(Level.CONFIG, "Invalid configuration value [" + paramName + " = " + initParameter + "]");
            return defaultValue;
        }
    }

    private ApplicationEventListener createApplicationEventListener(ServletContext ctx) {
        String listenerClassName = ctx.getInitParameter("org.glassfish.tyrus.core.monitoring.ApplicationEventListener");
        if (listenerClassName == null) {
            return null;
        }
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            Class<?> listenerClass = Class.forName(listenerClassName, true, contextClassLoader);
            Object o = listenerClass.newInstance();
            if (o instanceof ApplicationEventListener) {
                return (ApplicationEventListener)o;
            }
            LOGGER.log(Level.WARNING, "Class " + listenerClassName + " does not implement " + "ApplicationEventListener");
        }
        catch (ClassNotFoundException e) {
            LOGGER.log(Level.WARNING, "ApplicationEventListener implementation " + listenerClassName + " not found", e);
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOGGER.log(Level.WARNING, "ApplicationEventListener implementation " + listenerClassName + " could not " + "have been instantiated", e);
        }
        return null;
    }
}

