/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsft.event;

import com.sun.jsft.event.Command;
import java.util.List;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;

public class ELCommand
extends Command {
    private String resultVar = null;
    private String el = null;
    private transient int hash = -1;
    private static final long serialVersionUID = 6201115935174238909L;

    public ELCommand() {
    }

    public ELCommand(String resultVar, String el, List<Command> childCommands, Command elseCommand) {
        super(childCommands, elseCommand);
        this.resultVar = resultVar;
        this.el = el;
    }

    @Override
    public Object invoke() throws AbortProcessingException {
        FacesContext ctx = FacesContext.getCurrentInstance();
        ELContext elCtx = ctx.getELContext();
        ctx.getExternalContext().getRequestMap().put("jsftCommand", this);
        ExpressionFactory fact = ctx.getApplication().getExpressionFactory();
        ValueExpression ve = null;
        Object result = null;
        if (this.el.length() > 0) {
            ve = fact.createValueExpression(elCtx, "#{" + this.el + "}", Object.class);
            result = ve.getValue(elCtx);
            if (this.resultVar != null) {
                ve = fact.createValueExpression(elCtx, "#{" + this.resultVar + "}", Object.class);
                ve.setValue(elCtx, result);
            }
        } else {
            this.invokeChildCommands();
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(this.el);
        buf.append(super.toString());
        return buf.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ELCommand that = (ELCommand)obj;
        return this.hashCode() == that.hashCode();
    }

    public int hashCode() {
        if (this.hash == -1) {
            StringBuilder builder = new StringBuilder(this.el);
            List<Command> children = this.getChildCommands();
            if (children != null) {
                for (Command command : children) {
                    builder.append(command.toString());
                }
            }
            this.hash = builder.toString().hashCode();
        }
        return this.hash;
    }
}

