/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsft.facelets;

import com.sun.jsft.event.Command;
import com.sun.jsft.event.ELCommand;
import com.sun.jsft.facelets.CommandParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommandReader {
    private static Map<String, String> _reservedMappings = new HashMap<String, String>(16);
    private static final char OPEN_BRACKET = '[';
    private static final char CLOSE_BRACKET = ']';
    private static final char OPEN_PAREN = '(';
    private static final char CLOSE_PAREN = ')';
    private static final String OPEN_CDATA = "<![CDATA[";
    private static final String CLOSE_CDATA = "]]>";
    private CommandParser _parser = null;

    public CommandReader(String str) {
        this(new ByteArrayInputStream(("{" + CommandReader.unwrap(str) + "}").getBytes()));
    }

    protected CommandReader(InputStream stream) {
        this._parser = new CommandParser(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Command> read() throws IOException {
        this._parser.open();
        try {
            List<Command> list = this.readCommandList();
            return list;
        }
        finally {
            this._parser.close();
        }
    }

    private Command readCommand() throws IOException {
        this._parser.skipCommentsAndWhiteSpace(" \t\r\n");
        String commandLine = this._parser.readUntil(new int[]{59, 123, 125}, true);
        int ch = this._parser.nextChar();
        List<Command> commandChildren = null;
        if (ch == 123) {
            commandChildren = this.readCommandList();
        } else if (ch == 125) {
            this._parser.unread(ch);
        }
        String variable = null;
        int idx = this.indexOf((byte)61, commandLine);
        if (idx != -1) {
            variable = commandLine.substring(0, idx).trim();
            commandLine = commandLine.substring(++idx).trim();
        }
        Command elseCommand = null;
        if (commandLine.startsWith("if")) {
            commandLine = "jsft._if" + commandLine.substring(2);
            this._parser.skipCommentsAndWhiteSpace(" \t\r\n");
            int[] next = new int[]{this._parser.nextChar(), this._parser.nextChar(), this._parser.nextChar(), this._parser.nextChar(), this._parser.nextChar()};
            if (next[0] == 101 && next[1] == 108 && next[2] == 115 && next[3] == 101 && Character.isWhitespace((char)next[4])) {
                elseCommand = this.readCommand();
            } else {
                for (idx = 4; idx > -1; --idx) {
                    if (next[idx] == -1) continue;
                    this._parser.unread(next[idx]);
                }
            }
        }
        ELCommand command = null;
        if (commandLine.length() > 0 || commandChildren != null) {
            command = new ELCommand(variable, this.convertKeywords(commandLine), commandChildren, elseCommand);
        }
        return command;
    }

    private String convertKeywords(String exp) {
        if (exp == null) {
            return null;
        }
        String key = exp;
        int paren = exp.indexOf(40);
        if (paren != -1 && (key = exp.substring(0, paren)).indexOf(".") != -1) {
            return exp;
        }
        String value = _reservedMappings.get(key = key.trim());
        if (value != null) {
            exp = value + exp.substring(key.length());
        }
        return exp;
    }

    private int indexOf(byte ch, String str) {
        byte[] bytes = str.getBytes();
        int idx = 0;
        byte insideChar = -1;
        for (byte curr : bytes) {
            if (insideChar == -1) {
                if (ch == curr) break;
                if (39 == curr || 34 == curr) {
                    insideChar = curr;
                } else if (40 == curr) {
                    insideChar = 41;
                } else if (91 == curr) {
                    insideChar = 93;
                }
            } else if (insideChar == curr) {
                insideChar = -1;
            }
            ++idx;
        }
        if (idx >= bytes.length) {
            idx = -1;
        }
        return idx;
    }

    private List<Command> readCommandList() throws IOException {
        int ch = this._parser.nextChar();
        ArrayList<Command> commands = new ArrayList<Command>();
        Command command = null;
        while (ch != 125) {
            if (ch != 123) {
                this._parser.unread(ch);
            }
            if ((command = this.readCommand()) != null) {
                commands.add(command);
            }
            this._parser.skipCommentsAndWhiteSpace(" \t\r\n");
            ch = this._parser.nextChar();
            if (ch != -1) continue;
            throw new IOException("Unexpected end of stream! Expected to find '}'.");
        }
        return commands;
    }

    private static String unwrap(String str) {
        int endingIdx;
        if ((str = str.trim()).startsWith(OPEN_CDATA) && (endingIdx = str.lastIndexOf(CLOSE_CDATA)) != -1) {
            str = str.substring(OPEN_CDATA.length(), endingIdx);
        }
        return str;
    }

    static {
        _reservedMappings.put("foreach", "jsft.foreach");
        _reservedMappings.put("for", "jsft._for");
        _reservedMappings.put("println", "jsft.println");
        _reservedMappings.put("write", "jsft.write");
        _reservedMappings.put("setAttribute", "jsft.setAttribute");
        _reservedMappings.put("responseComplete", "jsft.responseComplete");
        _reservedMappings.put("renderResponse", "jsft.renderResponse");
        _reservedMappings.put("printStackTrace", "jsft.printStackTrace");
        _reservedMappings.put("getNanoTime", "jsft.getNanoTime");
    }
}

