/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.cluster.Strings;
import com.sun.enterprise.admin.cli.cluster.UninstallNodeBaseCommand;
import com.sun.enterprise.util.cluster.windows.io.WindowsRemoteFile;
import com.sun.enterprise.util.cluster.windows.io.WindowsRemoteFileSystem;
import com.sun.enterprise.util.net.NetUtils;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="uninstall-node-dcom")
@PerLookup
public class UninstallNodeDcomCommand
extends UninstallNodeBaseCommand {
    @Param(name="windowsuser", shortName="w", optional=true, defaultValue="${user.name}")
    private String user;
    @Param(name="windowsdomain", shortName="d", optional=true, defaultValue="")
    private String windowsDomain;

    @Override
    protected void validate() throws CommandException {
        super.validate();
        for (String host : this.hosts) {
            if (!NetUtils.isThisHostLocal((String)host)) continue;
            throw new CommandException(Strings.get("install.node.nolocal", host));
        }
    }

    @Override
    final String getRawRemoteUser() {
        return this.user;
    }

    @Override
    final int getRawRemotePort() {
        return 135;
    }

    @Override
    final String getSshKeyFile() {
        return null;
    }

    @Override
    final void deleteFromHosts() throws CommandException {
        for (String host : this.hosts) {
            try {
                String pw = this.getWindowsPassword(host);
                WindowsRemoteFileSystem wrfs = new WindowsRemoteFileSystem(host, this.getRemoteUser(), pw);
                WindowsRemoteFile remoteInstallDir = new WindowsRemoteFile(wrfs, this.getInstallDir());
                if (!remoteInstallDir.exists()) {
                    throw new CommandException(Strings.get("remote.install.dir.already.gone", this.getInstallDir()));
                }
                remoteInstallDir.delete();
                if (!remoteInstallDir.exists()) continue;
                throw new CommandException(Strings.get("remote.install.dir.cant.delete", this.getInstallDir()));
            }
            catch (CommandException ce) {
                throw ce;
            }
            catch (Exception e) {
                throw new CommandException((Throwable)e);
            }
        }
    }
}

