/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgijdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.osgijavaeebase.JarHelper;
import org.glassfish.osgijdbc.JDBCJarManifestProcessor;
import org.osgi.service.url.AbstractURLStreamHandlerService;

public class JDBCDriverURLStreamHandlerService
extends AbstractURLStreamHandlerService {
    private static final Logger logger = Logger.getLogger(JDBCDriverURLStreamHandlerService.class.getPackage().getName());
    private ClassLoader apiClassLoader;

    public JDBCDriverURLStreamHandlerService(ClassLoader apiClassLoader) {
        this.apiClassLoader = apiClassLoader;
    }

    public URLConnection openConnection(URL u) throws IOException {
        assert ("jdbcdriver".equals(u.getProtocol()));
        try {
            this.debug("jdbc driver openConnection()");
            URI embeddedURI = new URI(u.toURI().getSchemeSpecificPart());
            final URL embeddedURL = embeddedURI.toURL();
            final URLConnection con = embeddedURL.openConnection();
            final URLClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

                @Override
                public URLClassLoader run() {
                    return new URLClassLoader(new URL[]{embeddedURL}, JDBCDriverURLStreamHandlerService.this.apiClassLoader);
                }
            });
            return new URLConnection(embeddedURL){
                private Manifest m;

                public void connect() throws IOException {
                    con.connect();
                }

                public InputStream getInputStream() throws IOException {
                    this.connect();
                    this.m = JDBCJarManifestProcessor.processManifest(this.url, cl);
                    final PipedOutputStream pos = new PipedOutputStream();
                    PipedInputStream pis = new PipedInputStream(pos);
                    new Thread(){

                        public void run() {
                            JarHelper.write((URLConnection)con, (OutputStream)pos, (Manifest)m);
                        }
                    }.start();
                    return pis;
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void setURL(URL u, String protocol, String host, int port, String auth, String user, String path, String query, String ref) {
        super.setURL(u, protocol, host, port, auth, user, path, query, ref);
        this.debug("jdbc driver setURL()");
    }

    private void debug(String s) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("[osgi-jdbc] : " + s);
        }
    }
}

