/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.registration.impl;

import com.sun.enterprise.registration.RegistrationException;
import com.sun.enterprise.registration.impl.RegistrationLogger;
import com.sun.enterprise.registration.impl.RepositoryManager;
import com.sun.enterprise.registration.impl.ServiceTag;
import com.sun.enterprise.registration.impl.environment.EnvironmentInformation;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RelayService {
    private static final Logger logger = RegistrationLogger.getLogger();
    private static final String ENV_TOKEN = "@@@ENVIRONMENT@@@";
    private static final String TAG_TOKEN = "@@@SERVICE_TAGS@@@";
    private static final String PRODUCTNAME_TOKEN = "@@@PRODUCTNAME@@@";
    private static final String TEMPLATE_FILE = "com/sun/enterprise/registration/impl/relay-template.html";
    private static final String STRING_TOKEN = "@@@STRING.";
    private static final String END_TOKEN = "@@@";
    private RepositoryManager rm;
    private ResourceBundle bundle;

    public RelayService(File repositoryFile) throws RegistrationException {
        this.rm = new RepositoryManager(repositoryFile);
        this.rm.updateRuntimeValues();
    }

    public RelayService(String repositoryFile) throws RegistrationException {
        this(new File(repositoryFile));
    }

    public void generateRegistrationPage(String outputFile) throws Exception {
        this.generateRegistrationPage(outputFile, Locale.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateRegistrationPage(String outputFile, Locale locale) throws Exception {
        this.bundle = this.getResourceBundle(locale);
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(TEMPLATE_FILE);
        if (is == null) {
            throw new RegistrationException("Template file [com/sun/enterprise/registration/impl/relay-template.html] not found");
        }
        List<ServiceTag> serviceTags = this.rm.getServiceTags();
        StringBuilder productName = new StringBuilder();
        for (ServiceTag tag : serviceTags) {
            if (productName.length() > 0) {
                productName = productName.append(" + ");
            }
            productName = productName.append(tag.getSource());
        }
        String tags = this.getHtml(serviceTags);
        String env = this.getEnvironmentInformation();
        BufferedReader br = null;
        BufferedWriter bw = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(is));
            bw = new BufferedWriter(new FileWriter(outputFile));
            while ((line = br.readLine()) != null) {
                if (line.indexOf(ENV_TOKEN) >= 0) {
                    line = line.replaceAll(ENV_TOKEN, env);
                }
                if (line.indexOf(TAG_TOKEN) >= 0) {
                    line = line.replaceAll(TAG_TOKEN, tags);
                }
                if (line.indexOf(PRODUCTNAME_TOKEN) >= 0) {
                    line = line.replaceAll(PRODUCTNAME_TOKEN, productName.toString());
                }
                line = this.replaceStringTokens(line);
                bw.write(line);
                bw.newLine();
            }
            bw.flush();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String replaceStringTokens(String line) {
        int start = 0;
        int end = 0;
        StringBuffer buf = new StringBuffer("");
        while (start != -1) {
            start = line.indexOf(STRING_TOKEN, end);
            if (start == -1) continue;
            buf.append(line.substring(end, start));
            end = line.indexOf(END_TOKEN, start += STRING_TOKEN.length());
            if (end != -1) {
                try {
                    buf.append(this.bundle.getString(line.substring(start, end)));
                }
                catch (MissingResourceException ex) {
                    buf.append(STRING_TOKEN + line.substring(start, end) + END_TOKEN);
                }
                end += END_TOKEN.length();
                continue;
            }
            buf.append(END_TOKEN);
            end = start;
        }
        buf.append(line.substring(end));
        return buf.toString();
    }

    private ResourceBundle getResourceBundle(Locale locale) {
        return ResourceBundle.getBundle("com.sun.enterprise.registration.impl.LocalStrings", locale);
    }

    private String getHtml(List<ServiceTag> serviceTags) {
        if (serviceTags.isEmpty()) {
            logger.log(Level.WARNING, "No tags found");
            return "";
        }
        StringBuilder tags = new StringBuilder();
        for (ServiceTag serviceTag : serviceTags) {
            tags.append(this.getHtml(serviceTag));
        }
        return tags.toString();
    }

    private String getEnvironmentInformation() throws RegistrationException {
        StringBuilder html = new StringBuilder();
        EnvironmentInformation se = new EnvironmentInformation();
        Formatter fmt = new Formatter(html);
        html.append("<environment>");
        fmt.format("<hostname>%s</hostname>", se.getHostname());
        fmt.format("<hostId>%s</hostId>", se.getHostId());
        fmt.format("<osName>%s</osName>", se.getOsName());
        fmt.format("<osVersion>%s</osVersion>", se.getOsVersion());
        fmt.format("<osArchitecture>%s</osArchitecture>", se.getOsArchitecture());
        fmt.format("<systemModel>%s</systemModel>", se.getSystemModel());
        fmt.format("<systemManufacturer>%s</systemManufacturer>", se.getSystemManufacturer());
        fmt.format("<cpuManufacturer>%s</cpuManufacturer>", se.getCpuManufacturer());
        fmt.format("<serialNumber>%s</serialNumber>", se.getSerialNumber());
        this.addNumericTag(fmt, "physmem", se.getPhysMem());
        html.append("<cpuinfo>");
        this.addNumericTag(fmt, "sockets", se.getSockets());
        this.addNumericTag(fmt, "cores", se.getCores());
        this.addNumericTag(fmt, "virtcpus", se.getVirtCpus());
        fmt.format("<name>%s</name>", se.getCpuName());
        this.addNumericTag(fmt, "clockrate", se.getClockRate());
        html.append("</cpuinfo>");
        html.append("</environment>");
        return html.toString();
    }

    private void addNumericTag(Formatter fmt, String tag, String value) {
        try {
            int i = Integer.valueOf(value);
            fmt.format("<" + tag + ">%s</" + tag + ">", i);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getHtml(ServiceTag tag) {
        StringBuilder html = new StringBuilder();
        Formatter fmt = new Formatter(html);
        fmt.format("<service_tag>", new Object[0]);
        fmt.format("<instance_urn>%s</instance_urn>", tag.getInstanceURN());
        fmt.format("<product_name>%s</product_name>", tag.getProductName());
        fmt.format("<product_version>%s</product_version>", tag.getProductVersion());
        fmt.format("<product_urn>%s</product_urn>", tag.getProductURN());
        fmt.format("<product_parent_urn/>", new Object[0]);
        fmt.format("<product_parent>%s</product_parent>", tag.getProductParent());
        fmt.format("<product_defined_inst_id>%s</product_defined_inst_id>", tag.getProductDefinedInstID());
        fmt.format("<product_vendor>%s</product_vendor>", tag.getProductVendor());
        fmt.format("<platform_arch>%s</platform_arch>", tag.getPlatformArch());
        fmt.format("<timestamp>%s</timestamp>", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z").format(new Date()));
        fmt.format("<container>%s</container>", tag.getContainer());
        fmt.format("<source>%s</source>", tag.getSource());
        fmt.format("<installer_uid>-1</installer_uid>", new Object[0]);
        fmt.format("</service_tag>", new Object[0]);
        return html.toString();
    }
}

