/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.connectors.internal;

import com.sun.appserv.connectors.internal.api.ConnectorConstants;
import com.sun.appserv.connectors.internal.api.ConnectorDescriptorProxy;
import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.logging.LogDomains;
import java.beans.PropertyChangeEvent;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.naming.NamingException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.DelegatingClassLoader;
import org.glassfish.internal.api.InternalSystemAdministrator;
import org.glassfish.resourcebase.resources.api.PoolInfo;
import org.glassfish.resourcebase.resources.listener.ResourceManagerLifecycleListener;
import org.glassfish.resourcebase.resources.util.ResourceUtil;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service
@Singleton
public class ConnectorResourceManagerLifecycleListener
implements ResourceManagerLifecycleListener,
ConfigListener {
    @Inject
    private GlassfishNamingManager namingMgr;
    @Inject
    private Provider<ConnectorDescriptorProxy> connectorDescriptorProxyProvider;
    @Inject
    private Provider<CommandRunner> commandRunnerProvider;
    @Inject
    private Provider<ActionReport> actionReportProvider;
    @Inject
    private Provider<ConnectorRuntime> connectorRuntimeProvider;
    @Inject
    private Domain domain;
    @Inject
    private Applications applications;
    @Inject
    private ServiceLocator connectorRuntimeHabitat;
    private ConnectorRuntime runtime;
    @Inject
    private ClassLoaderHierarchy clh;
    @Inject
    private ServerEnvironment serverEnvironment;
    @Inject
    private InternalSystemAdministrator internalSystemAdministrator;
    private static final Logger logger = LogDomains.getLogger(ConnectorRuntime.class, (String)"LogStrings");

    private void bindConnectorDescriptors() {
        for (String rarName : ConnectorConstants.systemRarNames) {
            this.bindConnectorDescriptorProxies(rarName);
        }
    }

    private void bindConnectorDescriptorProxies(String rarName) {
        String jndiName = ConnectorsUtil.getReservePrefixedJNDINameForDescriptor(rarName);
        ConnectorDescriptorProxy proxy = this.connectorDescriptorProxyProvider.get();
        proxy.setJndiName(jndiName);
        proxy.setRarName(rarName);
        try {
            this.namingMgr.publishObject(jndiName, (Object)proxy, true);
        }
        catch (NamingException e) {
            Object[] params = new Object[]{rarName, e};
            logger.log(Level.WARNING, "resources.resource-manager.connector-descriptor.bind.failure", params);
        }
    }

    private ConnectorRuntime getConnectorRuntime() {
        if (this.runtime == null) {
            this.runtime = this.connectorRuntimeProvider.get();
        }
        return this.runtime;
    }

    public boolean isConnectorRuntimeInitialized() {
        List serviceHandles = this.connectorRuntimeHabitat.getAllServiceHandles(ConnectorRuntime.class, new Annotation[0]);
        Iterator i$ = serviceHandles.iterator();
        if (i$.hasNext()) {
            ServiceHandle inhabitant = (ServiceHandle)i$.next();
            return inhabitant.isActive();
        }
        return true;
    }

    public void resourceManagerLifecycleEvent(ResourceManagerLifecycleListener.EVENT event) {
        if (ResourceManagerLifecycleListener.EVENT.STARTUP.equals((Object)event)) {
            this.resourceManagerStarted();
        } else if (ResourceManagerLifecycleListener.EVENT.SHUTDOWN.equals((Object)event)) {
            this.resourceManagerShutdown();
        }
    }

    public void resourceManagerStarted() {
        this.bindConnectorDescriptors();
    }

    public void resourceManagerShutdown() {
        if (this.isConnectorRuntimeInitialized()) {
            ConnectorRuntime cr = this.getConnectorRuntime();
            if (cr != null) {
                cr.cleanUpResourcesAndShutdownAllActiveRAs();
            }
        } else if (logger.isLoggable(Level.FINEST)) {
            logger.finest("ConnectorRuntime not initialized, hence skipping resource-adapters shutdown, resources, pools cleanup");
        }
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        return ConfigSupport.sortAndDispatch((PropertyChangeEvent[])events, (Changed)new ConfigChangeHandler(), (Logger)logger);
    }

    class ConfigChangeHandler
    implements Changed {
        private ConfigChangeHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type, Class<T> changedType, T changedInstance) {
            NotProcessed np = null;
            if (!(changedInstance instanceof Application)) {
                return np;
            }
            if (!ConnectorResourceManagerLifecycleListener.this.serverEnvironment.isDas()) return np;
            ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
            try {
                DelegatingClassLoader ccl = ConnectorResourceManagerLifecycleListener.this.clh.getConnectorClassLoader(null);
                Thread.currentThread().setContextClassLoader((ClassLoader)ccl);
                switch (type) {
                    case ADD: {
                        np = this.handleAddEvent(changedInstance);
                        return np;
                    }
                }
                return np;
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextCL);
            }
        }

        private <T extends ConfigBeanProxy> NotProcessed handleAddEvent(T instance) {
            NotProcessed np = null;
            if (instance instanceof Application) {
                Resources resources = ((Application)instance).getResources();
                this.pingConnectionPool(resources);
                Application app = (Application)instance;
                List modules = app.getModule();
                if (modules != null) {
                    for (Module module : modules) {
                        if (module.getResources() == null || module.getResources().getResources() == null) continue;
                        this.pingConnectionPool(module.getResources());
                    }
                }
            }
            return np;
        }

        private void pingConnectionPool(Resources resources) {
            if (resources != null && resources.getResources() != null) {
                for (Resource resource : resources.getResources()) {
                    ResourcePool pool;
                    if (!(resource instanceof ResourcePool) || !Boolean.valueOf((pool = (ResourcePool)resource).getPing()).booleanValue()) continue;
                    PoolInfo poolInfo = ResourceUtil.getPoolInfo((ResourcePool)pool);
                    CommandRunner commandRunner = (CommandRunner)ConnectorResourceManagerLifecycleListener.this.commandRunnerProvider.get();
                    ActionReport report = (ActionReport)ConnectorResourceManagerLifecycleListener.this.actionReportProvider.get();
                    CommandRunner.CommandInvocation invocation = commandRunner.getCommandInvocation("ping-connection-pool", report, ConnectorResourceManagerLifecycleListener.this.internalSystemAdministrator.getSubject());
                    ParameterMap params = new ParameterMap();
                    params.add((Object)"appname", (Object)poolInfo.getApplicationName());
                    params.add((Object)"modulename", (Object)poolInfo.getModuleName());
                    params.add((Object)"DEFAULT", (Object)poolInfo.getName());
                    invocation.parameters(params).execute();
                    if (report.getActionExitCode() == ActionReport.ExitCode.SUCCESS) {
                        logger.log(Level.INFO, "app-scoped.ping.connection.pool.success", poolInfo);
                        continue;
                    }
                    Object[] args = new Object[]{poolInfo, report.getFailureCause()};
                    logger.log(Level.WARNING, "app-scoped.ping.connection.pool.failed", args);
                }
            }
        }
    }
}

